/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormLoUtil
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.util.UserIDFolder;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.FileControl;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/**
 * [eBeBE\bhNXB
 * @author T.Nishiki
 */
public class ScormLoUtil {

	/**
	 * XMLo̓vpeB́FGR[hB
	 */
	public static final String PROPERTY_ENCODING = "encoding";

	/**
	 * XMLo̓vpeB́FXML錾vہB
	 */
	public static final String PROPERTY_OMIT_XML_DECLARATION
		= "omit-xml-declaration";

	/**
	 * XMLo̓vpeBFXML錾svB
	 */
	public static final String OMIT_XML_DECLARATION_YES = "yes";

	/**
	 * XMLo̓vpeBFXML錾KvB
	 */
	public static final String OMIT_XML_DECLARATION_NO = "no";

	/**
	 * w肳ꂽL[̒lRs[܂B<br>
	 * nbVe[usrcw肳ꂽL[̒l擾A
	 * nullłȂdestɓ̂̃L[œo^܂B<br>
	 * @param dest Rs[nbVe[uB
	 * @param src Rs[nbVe[uB
	 * @param key Rs[l̃L[́B
	 * @throws NullPointerException destAsrc܂keynull̏ꍇB
	 */
	public static void copyValue(Map dest, Map src, String key) {
		String value = (String)src.get(key);
		// lꍇ̂݁ARs[io^j
		if (value != null) {
			dest.put(key, value);
		}
	}

	/**
	 * w肳ꂽL[̒lRs[܂B<br>
	 * nbVe[usrcw肳ꂽL[̒l擾A
	 * nullłȂdestɓ̂̃L[œo^܂B<br>
	 * @param dest Rs[nbVe[uB
	 * @param src Rs[nbVe[uB
	 * @param keys Rs[l̃L[̂̔zB
	 * @throws NullPointerException destAsrc܂keysnull̏ꍇB
	 */
	public static void copyValues(Map dest, Map src, String[] keys) {
		for (int i = 0; i < keys.length; i++) {
			copyValue(dest, src, keys[i]);
		}
	}

	/**
	 * ft@C擾܂B<br>
	 * 璆ft@C\FileIuWFNg𐶐Ė߂܂B
	 * ̃\bh́AFileIuWFNg߂łA
	 * ft@C݂邱Ƃۏ؂܂B<br>
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param studySession wKZbV񐔁B
	 * @return ft@C\FileIuWFNgB
	 * @throws LOException ݒt@C̓ǂݍ݂ɎsꍇB
	 */
	public static File getResumeFile(
		String userID,
		String loID,
		int studySession)
		throws LOException {
		// ̃\bh̖߂lB
		File resumeFile = null;
		String resumeDirPath = null;
		ScormLoEnv scormEnv = new ScormLoEnv();

		resumeDirPath = scormEnv.getResumeDirPath();
		// ft@CFileIuWFNg𐶐܂B
		// resumeDirPath/[UID/LOID/wKZbV/resume.xml
		resumeFile = getUserIDFolder(resumeDirPath, userID);
		resumeFile = new File(resumeFile, loID);
		resumeFile = new File(resumeFile, Integer.toString(studySession));
		resumeFile = new File(resumeFile, ScormLoConstant.RESUME_FILENAME);

		return resumeFile;
	}

	/**
	 * g[Xt@C擾܂B<br>
	 * g[Xt@C\FileIuWFNg𐶐Ė߂܂B
	 * ̃\bh́AFileIuWFNg߂łA
	 * g[Xt@C݂邱Ƃۏ؂܂B<br>
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param loginSession OCZbV񐔁B
	 * @return g[Xt@C\FileIuWFNgB
	 * @throws LOException ݒt@C̓ǂݍ݂ɎsꍇB
	 */
	public static File getTraceFile(
		String userID,
		String loID,
		int loginSession)
		throws LOException {
		// ̃\bh̖߂lB
		File resumeFile = null;
		String resumeDirPath = null;
		ScormLoEnv scormEnv = new ScormLoEnv();

		resumeDirPath = scormEnv.getTraceDirPath();
		// ft@CFileIuWFNg𐶐܂B
		// resumeDirPath/[UID/LOID/wKZbV/trace.xml
		resumeFile = getUserIDFolder(resumeDirPath, userID);
		resumeFile = new File(resumeFile, loID);
		resumeFile = new File(resumeFile, Integer.toString(loginSession));
		resumeFile = new File(resumeFile, ScormLoConstant.TRACE_FILENAME);

		return resumeFile;
	}

	/**
	 * F؃L[𐶐܂B<br>
	 * w肳ꂽ[UIDALOIDAzXǵAȂтɌݓƂ
	 * F؃L[𐶐܂B
	 *
	 * @param userID [UID
	 * @param loID LOID
	 * @param hostName zXǵB
	 * @return F؃L[B
	 * @throws LOException ݒt@C̓ǂݍ݂ɎsꍇB
	 */
	public static String makeAuthenticKey(
		String userID,
		String loID,
		String hostName)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD makeAuthenticKey("
				+ userID + "," + loID + ","  + hostName + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		String digestKey = null;

		ScormLoEnv scormEnv = new ScormLoEnv();
		int minuteSpan = scormEnv.getAuthenticMinuteSpan();

		// ݓ擾A̎ԕɐ؂̂ĂB
		Calendar calendar = Calendar.getInstance();
		truncateMinute(calendar, minuteSpan);
		// _CWFXgL[ZoB
		digestKey =
			makeAuthenticKey(userID, loID, hostName, calendar.getTime());

		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL makeAuthenticKey("
				+ userID + "," + loID + "," + hostName + ")"
				+ " return " + digestKey,
			DebugLog.ROW);
		return digestKey;
	}

	/**
	 * F؃L[𐶐܂B<br>
	 * w肳ꂽ[UIDALOIDAzXǵAƂ
	 * F؃L[𐶐܂B
	 *
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param hostName zXǵB
	 * @param dateTime B
	 * @return F؃L[B
	 * @throws LOException ݒt@C̓ǂݍ݂ɎsꍇB
	 */
	public static String makeAuthenticKey(
		String userID,
		String loID,
		String hostName,
		Date dateTime)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD makeAuthenticKey("
				+ userID + "," + loID + ","	+ hostName
				+ "," + dateTime + ")",
			DebugLog.ROW);

		// _CWFXgL[̌ƂȂ镽
		String message = null;
		// _CWFXgZop
		MessageDigest messageDigest = null;
		// _CWFXgL[ĩ\bh̖߂lj
		String digestKey = null;
		// _CWFXgL[̃oCg\
		byte[] digestKeyBytes = null;
		// ϊp
		SimpleDateFormat dateFormat = null;
		try {
			// 當𐶐
			dateFormat =
				new SimpleDateFormat(ScormLoConstant.AUTHENT_KEY_TIME_FORMAT);
			message = userID + loID + dateFormat.format(dateTime) + hostName;
			// _CWFXgL[ZoB
			messageDigest =
				MessageDigest.getInstance(
					ScormLoConstant.MESSAGE_DIGEST_ALGORITHM);
			digestKeyBytes = messageDigest.digest(message.getBytes());
			StringBuffer digestKeyBuffer = new StringBuffer();
			for (int i = 0; i < digestKeyBytes.length; i++) {
				digestKeyBuffer.append(
					Integer.toHexString((digestKeyBytes[i] & 0xf0) >> 4));
				digestKeyBuffer.append(
					Integer.toHexString(digestKeyBytes[i] & 0x0f));
			}
			digestKey = digestKeyBuffer.toString();

		}
		catch (NoSuchAlgorithmException e) {
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL makeAuthenticKey("
				+ userID + "," + loID + ","	+ hostName
				+ "," + dateTime + ")"
				+ " return " + digestKey,
			DebugLog.ROW);
		return digestKey;
	}

	/**
	 * ؂̂Ă܂B<br>
	 * nꂽCalendarIuWFNgw肳ꂽPʂŁA؎̂Ă܂B
	 * @param calendar IuWFNgB
	 * @param minuteSpan ؎̂ĕB
	 */
	public static void truncateMinute(Calendar calendar, int minuteSpan) {
		// 
		int minute = calendar.get(Calendar.MINUTE);
		// ؂̂Ăl
		int rest = minute % minuteSpan;
		calendar.add(Calendar.MINUTE, -rest);
	}

	/**
	 * SQL INSERT𐶐܂B<br>
	 * w肳ꂽe[ûȂтɃJ񂩂AINSERT𐶐܂B
	 * eJ̎ʂȂтɎgpf[^x[X̎ʂɉāA
	 * JlijCāAINSERT𐶐܂B
	 * @param tableName e[úB
	 * @param columnInfos J̔zB
	 * @return tableName܂columnInfos狁܂INSERTB
	 * @throws LOException t@Cf[^x[X̎ʂ擾łȂꍇB
	 */

/*
	public static String makeInsertQuery(
		String tableName,
		ScormColumnInfo[] columnInfos) throws LOException {

		// \bhJnO
		DebugLog.write(ScormLoUtil.class,
			"HEAD makeInsertQuery(" + tableName + "," + columnInfos + ")",
			DebugLog.ROW);
		// ̃\bh̖߂l
		String query = null;
		try {
			////////////////////////////////////////////////////////////////////
			// eJ̐AINSERT̖̕El̐
			// =================================================================
			// INSERT̃J̕
			StringBuffer columnNamePart = new StringBuffer();
			// INSERT̒l̕
			StringBuffer columnValuePart = new StringBuffer();
			// f[^x[X̎ʁEGR[h擾
			Environment env = new Environment();
			String dbType = env.getDBType();
			String dbEncode = env.getProperty("db_encode");
			for (int i = 0; i < columnInfos.length; i++) {
				// JP擾AlmFB
				ScormColumnInfo columnInfo = columnInfos[i];
				String columnName  = columnInfo.getColumnName();
				String columnValue = columnInfo.getColumnValue();
				int columnType =  columnInfo.getColumnType();
				int columnSizeMax = columnInfo.getColumnSizeMax();
				int columnSizeUnit = columnInfo.getColumnSizeUnit();
				// null̏ꍇAINSERTɊ܂߂ȂB
				if (columnValue == null) {
					continue;
				}
				// =============================================================
				// Ĵ̘A
				columnNamePart.append("," + columnName);
				// =============================================================
				// Jl̘A(JʁAcaʂɂĘA@ύX)
				// l̏ꍇAliĵ܂
				if (columnType == ScormColumnInfo.COLUMN_TYPE_NUMBER) {
					columnValuePart.append("," + columnValue);
				}
				// ̏ꍇA񒷃`FbN̂Aߕ̓JbgŁA
				// lijVOR[eVň͂
				else if (columnType == ScormColumnInfo.COLUMN_TYPE_STRING) {
					String insertValue = null;
					if (columnSizeMax <= 0) {
						insertValue = columnValue;
					}
					else if (columnSizeUnit
							== ScormLoConstant.COLUMN_SIZE_UNIT_LENGTH) {
						if ( columnValue.length() > columnSizeMax) {
							insertValue =
								columnValue.substring(0, columnSizeMax);
						}
						else {
							insertValue = columnValue;
						}
					}
					else if (columnSizeUnit
							== ScormLoConstant.COLUMN_SIZE_UNIT_BYTE) {
						insertValue = truncateStringByByte(
							columnValue, columnSizeMax, dbEncode);
					}
					columnValuePart.append(",'" + insertValue + "'");
				}
				// ̏ꍇAca̎ʂɂĕύX
				else if (columnType == ScormColumnInfo.COLUMN_TYPE_DATETIME) {
					// OracleTO_DATE֐
					if ( dbType.equals(Environment.DB_ORACLE)) {
						columnValuePart.append(
							",TO_DATE('" + columnValue + "',"
							+ " '" + ScormLoConstant.DB_TODATE_FORMAT + "')");
					}
					// PostgreSQLTO_TIMESTAMP֐
					else if ( dbType.equals(Environment.DB_POSTGRE)) {
						columnValuePart.append(
							",TO_TIMESTAMP('" + columnValue + "',"
							+ " '" + ScormLoConstant.DB_TODATE_FORMAT + "')");
					}
					// ̑iSQL Serverj͕ƂĘA
					else {
						columnValuePart.append(",'" + columnValue + "'");
					}
				}
			}
			////////////////////////////////////////////////////////////////////
			// INSERT̐
			// =================================================================
			StringBuffer queryBuffer = new StringBuffer();
			queryBuffer.append("insert into ");
			// e[u
			queryBuffer.append(tableName);
			queryBuffer.append("(");
			// J̕i擪̃J}͊Oj
			queryBuffer.append(columnNamePart.substring(1));
			queryBuffer.append(") values (");
			// Jli擪̃J}͊Oj
			queryBuffer.append(columnValuePart.substring(1));
			queryBuffer.append(")");
			// INSERT𕶎ƂĎ擾
			query = queryBuffer.toString();
		}
		catch (Exception e) {
			DebugLog.write(ScormLoUtil.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}

		// \bhIO
		DebugLog.write(ScormLoUtil.class,
			"TAIL makeInsertQuery(" + tableName + "," + columnInfos + ")"
			+ " return " + query,
			DebugLog.ROW);
		return query;
	}
*/

	/**
	 * AICCtH[}bg̓͂܂B<br>
	 * œńAȉ̃tH[}bg̏]̂Ƃ܂B<br>
	 * <code>YYYY[-MM[-DD[Thh[:mm[:ss[.s]]]]]]</code><br>
	 * ȗꂽ́A͂PAȉ͂Ow肳ꂽ̂Ƃ܂B<br>
	 *
	 * @param dateString B<br>
	 * @return w肳ꂽϊDateIuWFNgB
	 *          null̏ꍇAN擾łȂꍇAnull߂܂B
	 */
	public static Date convertAiccFormatToDate(String dateString) {
		// ̃\bh̖߂lB
		Date date = null;
		if (dateString != null) {
			////////////////////////////////////////////////////////////////////
			// nꂽ񂩂eڂɕ
			StringTokenizer tokenizer =
				new StringTokenizer(dateString, "- T:.");
			////////////////////////////////////////////////////////////////////
			// eڂ擾
			// =================================================================
			// N
			int year = 0;
			if (tokenizer.hasMoreElements()) {
				String timeToken = tokenizer.nextToken();
				year = Integer.parseInt(timeToken);
				// iȂ΂Pj
				int month = 0;
				if (tokenizer.hasMoreElements()) {
					timeToken = tokenizer.nextToken();
					month = Integer.parseInt(timeToken);
				}
				else {
					month = 1;
				}
				// iȂ΂Pj
				int day = 0;
				if (tokenizer.hasMoreElements()) {
					timeToken = tokenizer.nextToken();
					day = Integer.parseInt(timeToken);
				}
				else {
					day = 1;
				}
				// 
				int hour = 0;
				if (tokenizer.hasMoreElements()) {
					timeToken = tokenizer.nextToken();
					hour = Integer.parseInt(timeToken);
				}
				// 
				int minute = 0;
				if (tokenizer.hasMoreElements()) {
					timeToken = tokenizer.nextToken();
					minute = Integer.parseInt(timeToken);
				}
				// b
				int second = 0;
				if (tokenizer.hasMoreElements()) {
					timeToken = tokenizer.nextToken();
					second = Integer.parseInt(timeToken);
				}
				// ~b
				int milisecond = 0;
				if (tokenizer.hasMoreElements()) {
					timeToken = tokenizer.nextToken();
					milisecond = Integer.parseInt(timeToken);
				}
				////////////////////////////////////////////////////////////////
				// 擾f[^玞ԃIuWFNg𐶐
				Calendar calendar = Calendar.getInstance();
				calendar.set(year, month - 1, day, hour, minute, second);
				calendar.set(Calendar.MILLISECOND, milisecond);
				date = calendar.getTime();
			}
		}
		return date;
	}

	/**
	 * ScormT[oϊ܂B
	 * @param dateString ScormT[oB
	 * @return dateStringϊIuWFNgB
	 * @see ScormLoConstant#SCORM_SERVER_DATETIME_FORMAT
	 */
	public static Date convertScormServerFormatToDate(String dateString) {
		Date date = null;
		try {
			SimpleDateFormat dateFormat =
				new SimpleDateFormat(
					ScormLoConstant.SCORM_SERVER_DATETIME_FORMAT);
			date = dateFormat.parse(dateString);
		}
		catch (Exception e) {
		}
		return date;
	}
	/**
	 * nꂽf[^f[^x[XŎgp邽߂ɕɕϊ܂B
	 * @param date ϊB
	 * @return ϊ̓B
	 */
	public static String convertDateToDbFormat(Date date) {
		SimpleDateFormat dateFormat =
			new SimpleDateFormat(ScormLoConstant.MSSQL_DATETIME_FORMAT);
		String dateString = dateFormat.format(date);
		return dateString;
	}

	/**
	 * t@Cړ܂B<br>
	 *
	 * @param fileFrom ړt@CB
	 * @param fileTo ړt@CB
	 * @throws LOException t@CANZXɎsꍇB
	 */
	public static void moveFile(File fileFrom, File fileTo)
		throws LOException {
		try {
			FileControl.copy(
				fileFrom.getAbsolutePath(),
				fileTo.getAbsolutePath());
			FileControl.delete(fileFrom.getAbsolutePath());
		}
		catch (IOException e) {
			DebugLog.write(ScormLoUtil.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
	}

	/**
	 * Durationbɕϊ܂B<BR>
	 * duration 񂩂tH[}bg𒲂ׂB<BR>
	 *
	 * @param duration Duration`<BR>
	 * @return duration̕b\(~b͏)<BR>
	 */
	public static double parseDuration(String duration) {

		// durationNƎԂɕ
		String strDate = null;
		String strTime = null;
		int posBoundary = duration.indexOf("T");
		if (posBoundary != -1) {
			strDate = duration.substring(0, posBoundary);
			strTime = duration.substring(posBoundary);
		}
		else {
			strDate = duration;
			strTime = "";
		}

		// N擾
		double year = 0.0;
		double month = 0.0;
		double day = 0.0;
		if (strDate.length() > 0) {
			String buf = strDate.substring(1);
			if (buf.indexOf("Y") != -1) {
				String strYear = buf.substring(0, buf.indexOf("Y"));
				year = Long.parseLong(strYear);
				year = year * 365.0 * 24.0;
				year = year * 60.0 * 60.0;
				buf = buf.substring(buf.indexOf("Y") + 1);
			}
			if (buf.indexOf("M") != -1) {
				String strMonth = buf.substring(0, buf.indexOf("M"));
				month = Long.parseLong(strMonth);
				month = month * 31.0 * 24.0;
				month = month * 60.0 * 60.0;
				buf = buf.substring(buf.indexOf("M") + 1);
			}
			if (buf.indexOf("D") != -1) {
				String strDay = "";
				strDay = buf.substring(0, buf.indexOf("D"));
				day = Long.parseLong(strDay);
				day = day * 24.0;
				day = day * 60.0 * 60.0;
			}
		}
		// ԁAAb擾
		double hour = 0.0;
		double min = 0.0;
		double sec = 0.0;
		if (!strTime.equals("")) {
			String buf = strTime.substring(1);
			if (buf.indexOf("H") != -1) {
				String strHour = buf.substring(0, buf.indexOf("H"));
				hour = Long.parseLong(strHour);
				hour = hour * 60.0 * 60.0;
				buf = buf.substring(buf.indexOf("H") + 1);
			}
			if (buf.indexOf("M") != -1) {
				String strMin = buf.substring(0, buf.indexOf("M"));
				min = Long.parseLong(strMin);
				min = min * 60.0;
				buf = buf.substring(buf.indexOf("M") + 1);
			}
			if (buf.indexOf("S") != -1) {
				String strSec = buf.substring(0, buf.indexOf("S"));
				sec = Double.parseDouble(strSec);
			}
		}

		double returnValue = year + month + day + hour + min + sec;

		return returnValue;
	}

	/**
	 * w肵t@CDOMDocumentɕϊ܂B<br>
	 *
	 * @param file DOMDocumentɕϊXMLt@CB
	 * @return file琶ꂽDOMDocumentB
	 * @throws LOException w肵t@Cǂݍ߂ȂA
	 *          ܂́AXMLƂĉ߂łȂȂǗOꍇB
	 */
	public static Document transformXmlFileToDocument(File file)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD transformXmlFileToDocument(" + file + ")",
			DebugLog.ROW);

		// ̃\bh̖߂lB
		Document document = null;

		try {
			DocumentBuilderFactory factory =
				DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();

			// DOM DocumentɕϊB
			document = builder.parse(file);
		}
		// O̓OɎcăX[܂B
		catch (Exception e) {
			DebugLog.write(ScormManifestUtil.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// \bhIO
			DebugLog.write(
				ScormLoUtil.class,
				"TAIL transformXmlFileToDocument(" + file + ")"
					+ " return " + document,
				DebugLog.ROW);
		}
		return document;
	}

	/**
	 * w肵̓Xg[DOMDocumentɕϊ܂B<br>
	 *
	 * @param stream DOMDocument̐ƂȂ̓Xg[B
	 * @return stream琶ꂽDOMDocumentB
	 * @throws LOException w肵Xg[ǂݍ߂ȂA
	 *          ܂́AXMLƂĉ߂łȂȂǗOꍇB
	 */
	public static Document transformXmlStreamToDocument(InputStream stream)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD transformXmlFileToDocument(InputStream " + stream + ")",
			DebugLog.ROW);

		// ̃\bh̖߂lB
		Document document = null;

		try {
			DocumentBuilderFactory factory =
				DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();

			// DOM DocumentɕϊB
			document = builder.parse(stream);
		}
		// O̓OɎcăX[܂B
		catch (Exception e) {
			DebugLog.write(ScormManifestUtil.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL transformXmlFileToDocument(InputStream " + stream + ")"
				+ " return "
				+ document,
			DebugLog.ROW);
		return document;
	}


	/**
	 * w肵XMLDOMDocumentɕϊ܂B<br>
	 *
	 * @param xmlString DOMDocument̐ƂȂXMLB
	 * @return xmlString琶ꂽDOMDocumentB
	 * @throws LOException w肵XMLƂ
	 *          ߂łȂȂǗOꍇB
	 */
	public static Document transformXmlStringToDocument(String xmlString)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD transformXmlStringToDocument(" + xmlString + ")",
			DebugLog.ROW);

		Document document = null;
		try {
			DocumentBuilderFactory factory =
				DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();

			// DOM DocumentɕϊB
			StringReader reader = new StringReader(xmlString);
			InputSource source = new InputSource(reader);
			document = builder.parse(source);
		}
		// O̓OɎcăX[܂B
		catch (Exception e) {
			DebugLog.write(ScormManifestUtil.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL transformXmlStringToDocument(" + xmlString + ")"
				+ " return "
				+ document,
			DebugLog.ROW);
		return document;
	}

	/**
	 * w肵XMLt@C𕶎ƂĎ擾܂B<br>
	 *
	 * @param file 擾ƂȂXMLt@CB
	 * @param outFormat o̓IvVEvpeBB
	 *                   IvVȂꍇnulln܂B
	 * @return w肵XMLt@CɊÂXMLB
	 * @throws LOException ɗOꍇB
	 * @see Transformer#setOutputProperties(Properties)
	 *       o̓IvVEvpeBB
	 */
	public static String transformXmlFileToString(
			File file, Properties outFormat)
			throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD transformXmlFileToString(" + file + "," + outFormat + ")",
			DebugLog.ROW);

		// t@CSource𐶐B
		Source source = new StreamSource(file);
		// ւResult𐶐
		StringWriter writer = new StringWriter();
		Result result = new StreamResult(writer);
		// ϊ
		transformXml(source, result, outFormat);
		// ϊʂ擾
		String xmlString = writer.toString();

		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL transformXmlFileToString(" + file + "," + outFormat + ")"
				+ " return " + xmlString,
			DebugLog.ROW);
		return xmlString;
	}

	/**
	 * w肵XMLt@C𕶎Xg[ɗ܂B<br>
	 *
	 * @param file 擾ƂȂXMLt@CB
	 * @param writer ݐƂȂ镶Xg[B
	 * @param outFormat o̓IvVEvpeBB
	 *                   IvVȂꍇnulln܂B
	 * @throws LOException ɗOꍇB
	 * @see Transformer#setOutputProperties(Properties)
	 *       o̓IvVEvpeBB
	 */
	public static void transformXmlFileToWriter(
			File file, Writer writer, Properties outFormat)
			throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD transformXmlFileToWriter("
				+ file + "," + writer + "," + outFormat + ")",
			DebugLog.ROW);

		// t@CSource𐶐B
		Source source = new StreamSource(file);
		// Xg[ւResult𐶐
		Result result = new StreamResult(writer);
		// ϊ
		transformXml(source, result, outFormat);
		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL transformXmlFileToWriter("
				+ file + "," + writer + "," + outFormat + ")",
			DebugLog.ROW);
	}

	/**
	 * DOM Nodet@Cɕϊ܂B<br>
	 * DOM Nodew肳ꂽt@Cɏo͂܂B
	 *
	 * @param node ƂȂDOM NodeB
	 * @param file ϊʂo͂t@CB
	 * @param outFormat o̓IvVEvpeBB
	 *                   IvVȂꍇnulln܂B
	 * @throws LOException OꍇB
	 * @see Transformer#setOutputProperties(Properties)
	 *       o̓IvVEvpeBB
	 */
	public static void transformNodeToFile(
			Node node, File file, Properties outFormat) throws LOException {

		// \bhJnO
		DebugLog.write( ScormLoUtil.class,
			"HEAD transformNodeToFile("
				+ node + "," + file + "," + outFormat + ")",
			DebugLog.ROW);
		// o͐̃fBNg쐬
		File dirFile = file.getParentFile();
		dirFile.mkdirs();
		// DocumentSource𐶐B
		Source source = new DOMSource(node);
		// ւResult𐶐
		Result result = new StreamResult(file);
		// ϊ
		transformXml(source, result, outFormat);

		// \bhIO
		DebugLog.write( ScormLoUtil.class,
			"TAIL transformNodeToFile("
				+ node + "," + file + "," + outFormat + ")",
			DebugLog.ROW);
	}

	/**
	 * DOM NodeϊăXg[ɏo͂܂B<br>
	 *
	 * @param node ƂȂDOM NodeB
	 * @param stream ϊʂo͂Xg[B
	 * @param outFormat o̓IvVEvpeBB
	 *                   IvVȂꍇnulln܂B
	 * @throws LOException OꍇB
	 * @see Transformer#setOutputProperties(Properties)
	 *       o̓IvVEvpeBB
	 */
	public static void transformNodeToStream(
			Node node, OutputStream stream, Properties outFormat)
			throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD transformNodeToStream("
				+ node + "," + stream + "," + outFormat + ")",
			DebugLog.ROW);

		// DocumentSource𐶐B
		Source source = new DOMSource(node);
		// ւResult𐶐
		Result result = new StreamResult(stream);
		// ϊ
		transformXml(source, result, outFormat);

		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL transformNodeToStream("
				+ node + "," + stream + "," + outFormat + ")",
			DebugLog.ROW);
	}

	/**
	 * DOM NodeXMLɕϊ܂B<br>
	 *
	 * @param node ƂȂDOM NodeB
	 * @param outFormat o̓IvVEvpeBB
	 *                   IvVȂꍇnulln܂B
	 * @return nodeϊċ߂XML߂܂B
	 * @throws LOException ϊOꍇB
	 * @see Transformer#setOutputProperties(Properties)
	 *       o̓IvVEvpeBB
	 */
	public static String transformNodeToString(
		Node node, Properties outFormat)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD transformNodeToString(" + node + "," + outFormat + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		String xmlString = null;
		// DocumentSource𐶐B
		Source source = new DOMSource(node);
		// Result𐶐
		// ɏo͂悤Result𐶐
		StringWriter writer = new StringWriter();
		// Result𐶐
		Result result = new StreamResult(writer);
		// ϊ
		transformXml(source, result, outFormat);
		// ϊʂ當擾
		xmlString = writer.toString();

		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL transformNodeToString(" + node + "," + outFormat + ")"
				+ (" return " + xmlString),
			DebugLog.ROW);
		return xmlString;
	}

	/**
	 * wlkf[^ϊ܂B<br>
	 *
	 * @param source ϊ\[XB
	 * @param result ϊʂi[IuWFNg
	 * @param outFormat o̓IvVEvpeBB
	 *                   IvVȂꍇnulln܂B
	 * @throws LOException ɗOꍇB
	 * @see Transformer#setOutputProperties(Properties)
	 *       o̓IvVEvpeBB
	 */
	public static void transformXml(
			Source source, Result result, Properties outFormat)
			throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormLoUtil.class,
			"HEAD transformXml("
				+ source + "," + result + "," + outFormat + ")",
			DebugLog.ROW);
		try {
			// ϊIuWFNg
			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer transformer = factory.newTransformer();
			// IvVvpeBݒ
			if (outFormat != null) {
				transformer.setOutputProperties(outFormat);
			}
			// ϊ
			transformer.transform(source, result);
		}
		catch (TransformerFactoryConfigurationError e) {
			DebugLog.write(ScormManifestUtil.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		catch (Exception e) {
			DebugLog.write(ScormManifestUtil.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}

		// \bhIO
		DebugLog.write(
			ScormLoUtil.class,
			"TAIL transformXml("
				+ source + "," + result + "," + outFormat + ")",
			DebugLog.ROW);
	}


	/**
	 * w肵m[h̒l擾܂B<br>
	 * XPath𗘗pāAw肵_m[hw肵pXŃm[hA
	 * Čm[h̒l߂܂B<br>
	 * @param originNode _ƂȂm[hB
	 * @param locationPath 邽߃P[VEpXB
	 * @return Ώۂ̃m[hꍇÃm[h̒l߂܂B
	 *          ȂꍇAnull߂܂B
	 * @throws LOException w肵pXP[VEpXĂȂ
	 * @@@@@ɗOꍇB
	 */
	public static String getNodeValue(Node originNode, String locationPath)
			throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
//		DebugLog.write(ScormAttemptDataAccess.class,
//			"HEAD getNodeValue(" + originNode + "," + locationPath + ")",
//			DebugLog.ROW);

		// ̃\bh̖߂l
		String nodeValue = null;
		try {
			Node targetNode = XPathAPI.selectSingleNode(
									originNode, locationPath);
			if ( targetNode != null ) {
				nodeValue = targetNode.getNodeValue();
			}
		}
		catch (Exception e) {
//			DebugLog.write(ScormAttemptDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}

		////////////////////////////////////////////////////////////////////////
		// \bhIO
//		DebugLog.write(ScormAttemptDataAccess.class,
//			"TAIL getNodeValue(" + originNode + "," + locationPath + ")"
//			+ " return " + nodeValue,
//			DebugLog.ROW);
		return nodeValue;
	}

	/**
	 * oCgvZŐ؎̂ď܂B
	 * @param str ؎̂Ăs镶B
	 * @param maxLength ؂̂ĂTCYioCgPʁjB
	 * @param encode oCgϊ邽߂̃GR[hB
	 * @return ؂l߂B
	 */
	public static String truncateStringByByte(
			String str, int maxLength, String encode) {
		// ̃\bh̖߂lvZp
		StringBuffer valueBuffer = new StringBuffer(str.length());
		// oCgvZp
		int byteCount = 0;
		for (int index = 0; index < str.length(); index++) {
			// 1oCgɕϊ܂B
			byte[] bytes = null;
			String s = str.substring(index, index + 1);
			try {
				bytes = s.getBytes(encode);
			}
			catch (Exception e) {
				break;
			}
			// ̂P̃oCg𑫂킹ƋKTCY𒴂ꍇAIB
			if (byteCount + bytes.length > maxLength) {
				break;
			}

			valueBuffer.append(s);
			byteCount += bytes.length;
		}
		return valueBuffer.toString();
	}

	private static File getUserIDFolder(String basePath, String userID) {
		return UserIDFolder.getFile(new File(basePath), userID);
	}
}

