/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
				
// 
//	@\	
//		CMI f[^f@CC^[tF[X NXiCBT NX)
//
//		ύX	
//			2003.12.01 gxl VK쐬
//

package jp.co.ntt.lms.lo.scorm.cbtcom;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Date;


/**
 * CMI f[^f@CC^[tF[X NXiCBT NXj<br>
 * 
 * @author gxl
 */
public class CMICBT extends CMIObjBase {

	/**
	* CMIError IuWFNg
	*/
	private CMIError m_lastError = null;

	/**
	* CMILesson IuWFNg
	*/
	private CMILesson m_lesson = null;

	/**
	* CMILaunch IuWFNg
	*/
	private CMILaunch m_launch = null;

	/**
	* CMIEvaluationData IuWFNg
	*/
	private CMIEvaluationData m_evaluationData = null;
	   
	/**
	* CBT o[W
	*/
	private String m_version;

	/**
	* CMI o[W
	*/
	private String m_cmiversion;

	/**
	* CMIElement IuWFNg
	*/
	private HashMap m_categoryMap = new HashMap();

	/**
	* CMIElement IuWFNg
	*/
	private HashMap m_elementpathMap  = new HashMap();

	/**
    * setValue ̃^[QbgLessonValue łtO(ʏFfalse)
    */
	private boolean m_targetLessonValue;

	/**
	* XVtO
	*/
	private boolean m_bUpdate;

	private final String DEF_MODULE_VERSION = "1.0";
	private final String DEF_MODULE_MODEL = "releaseMinDepedency";

	private final String DEF_ENCODE = "UTF-8";

	/**
	 * CMICBTNX̏<br>
	 */
	public CMICBT() {

		// CMI AICC o[W
		m_cmiversion = CMIElement.DEF_CMI_AICC_VERSION;
		m_lastError = new CMIError();
		m_isOpen = false;
		setCBT(this);
		m_proto	= CMIElementProto.g_cbtProto;
		makeChildren(CMIElementProto.g_cbtProto);

		m_lesson = new CMILesson(this);
		m_launch = new CMILaunch(this);
		m_evaluationData = new CMIEvaluationData(this);
		
		// ftHglZbg
		setDefaultValue();
		m_isOpen	= false;
		m_bUpdate	= false;

		// eXgfobOp
		// setVale ̃^[Qbg؂ւ
		m_targetLessonValue = false;	
		CMIUtil.putLog("CMICBT created");

		CMIUtil.setEncodeString(DEF_ENCODE);
	}

	/**
	 * CMICBTNX̏BGR[h镶w肷<br>
	 */
	public CMICBT( String strEncWord ) {
		// CMI AICC o[W
		m_cmiversion = CMIElement.DEF_CMI_AICC_VERSION;
		m_lastError = new CMIError();
		m_isOpen = false;
		setCBT(this);
		m_proto	= CMIElementProto.g_cbtProto;
		makeChildren(CMIElementProto.g_cbtProto);

		m_lesson = new CMILesson(this);
		m_launch = new CMILaunch(this);
		m_evaluationData = new CMIEvaluationData(this);
		
		// ftHglZbg
		setDefaultValue();
		m_isOpen	= false;
		m_bUpdate	= false;

		// eXgfobOp
		// setVale ̃^[Qbg؂ւ
		m_targetLessonValue = false;	
		CMIUtil.putLog("CMICBT created");

		if ((strEncWord == null) || ("".equals(strEncWord))) {
			CMIUtil.setEncodeString(DEF_ENCODE);
		} else {
			CMIUtil.setEncodeString(strEncWord);
		}
	}
	
	/**			
	 * CMICBTNX̏I<br>		
	 */		
	public void finalize() {
		m_lesson = null;
		m_launch = null;
		m_evaluationData = null;
		m_categoryMap=null;
		m_elementpathMap=null;
		CMIUtil.putLog("CMICBT deleted");
	}
	
	/**
	 * ZbVJnB<br>
	 * @return boolean I[vtO
	 */
	public boolean isOpen() {
		clearError();
		return m_isOpen;
	}
	
	/**
	 * ZbVJnB<br>
	 * @return String CBTNURL
	 */
	public String open() {

		String strCbtUrl = "";
		clearError();
		if (!m_isOpen) {

			if (!checkMandatory()) {
				// ͕K{̃G[
				setError(CMIError.ERR_NOT_INITALIZED);
				setVendorError(getVendorData("CMICBT.open", this));
			} else {
				// ZbVO
				before_initialize();
				// ZbV
				initialize();	
				// CBT URL 𐶐
				strCbtUrl = m_launch.makeCbtURL();	
				// I[vԂɂ
				m_isOpen = true;	
				// Launch ̃I[v
				m_launch.myOpen();	
				// Lesson ̃I[v
				m_lesson.myOpen();
				// evaluationData ̃I[v		
				m_evaluationData.myOpen();	

				// CMIf[^ɍXV񂪂ꍇAIPutParamOo͂j
				writePutParamLog();
			}

		} else {
			setError(CMIError.ERR_IGNORED_OPERATION);
			setVendorError(getVendorData("CMICBT.open", this));
		}
		CMIUtil.putLog("CMICBT.open() retStr[" + strCbtUrl + "]");
		// CBT URL 𐶐
		return strCbtUrl;		
	}
	
	/**
	 * ZbVIB<br>
	 */
	public void close() {

		clearError();
		if (m_isOpen) {
		//iCMIf[^ɍXV񂪂ꍇAIPutParamOo͂j
			writePutParamLog();
			m_lesson.myClose();
			m_launch.myClose();
			m_evaluationData.myClose();
			m_isOpen = false;
		} else {
			setError(CMIError.ERR_IGNORED_OPERATION);
			setVendorError(getVendorData("CMICBT.close", this));
		}
		CMIUtil.putLog("CMICBT.close()");
	}
	
	/**
	 * Mf[^͂AR}hɑΉ鏈sB<br>
	 * @param request String f[^
	 * @return String R}h+J}Zp[^+f[^
	 */
	public String hacp(String request) {		
		clearError();
		String strRes = "";
		StringBuffer response = new StringBuffer();
		
		// fobOOo
		CMIUtil.putLog("CMICBT.hacp request[" + request + "]");
		if (CMIUtil.isDetailLogging()) {
			String data = getDiagnostic(CMIError.VERR_DEBUG_CMIDATA);
			CMIUtil.putLog(data);
		}

		CMIHacpComm commObj = 
								new CMIHacpComm(this, m_lesson, m_evaluationData);
		try {
			if (m_isOpen) {				
				strRes = commObj.doAnalysis(request, response);
				//CMIf[^ɍXV񂪂ꍇAIPutParamOo͂j
				writePutParamLog();
			} else {
				setError(CMIError.ERR_NOT_INITALIZED);
				setVendorError(getVendorData("CMICBT.hacp", this));
				response.setLength(0);
				response.append( 
							commObj.makeResponse("", HACPError.HACP_ERR_CMI ));
			}

			// fobOOo
			CMIUtil.putLog("CMICBT.hacp response[" + response.toString() + "]");
			if (CMIUtil.isDetailLogging()) {
				String data = getDiagnostic(CMIError.VERR_DEBUG_CMIDATA);
				CMIUtil.putLog(data);
			}
			// -----------------------
		}
		catch(Exception e) {
			response.setLength(0);
			response.append( commObj.makeResponse("", HACPError.HACP_ERR_CMI));
		}
		return strRes + "," + response.toString();
	}
	
	/**
	 * (LocalValue)lݒ肷B<br>
	 * @param name String f[^f
	 * @param value String ݒf[^l
	 */
	public void setValue(String name, String value) {

		clearError();
		if ( !m_isOpen ) {
			CMIGlobalCBT pGCBT = CMIGlobalCBT.getGlobalCBT();
			// O[oCBT  ANeBuCBT XV
			pGCBT.setCBT(this);

			// SCORM1.3 pCMIfAICCpiAICC2.0`SCORM1.2j
			// CMIfɕϊ
			String strName = CMIS13ModelUtil.changeAiccModelName(name);

			if ( !m_targetLessonValue ) {
				// fobOOo
				CMIUtil.putLog("CMICBT.setValue name[" + name + "], " +
										"value[" + value + "]");
				if ( CMIUtil.isDetailLogging() ) {
					String strData = getDiagnostic(CMIError.VERR_DEBUG_CMIDATA);
					CMIUtil.putLog(strData);
				}

				// w肳ꂽf[^l[JlƂĐݒ肷
				localSetValue(strName, value);
				CMIUtil.putLog("CMICBT.setValue");
				if ( CMIUtil.isDetailLogging() ) {
					String strData = getDiagnostic(CMIError.VERR_DEBUG_CMIDATA);
					CMIUtil.putLog(strData);
				}
			} else {
				CMIParameterPath param = new CMIParameterPath(strName);
				String theName = param.popFirstElement();
				if (theName.equals( getName() ) ){
					// Ggw肳Ăꍇ
					// LessonValue ɒlZbgB
					setLessonValue(param.getPath(), value);
				} else {
					// Ggw肳ĂȂꍇ
					// G[(CMI) G[(RFpXw肵)
					setError(CMIError.ERR_INVALID_AURGUMENT_ERROR);
					setVendorError(getVendorData("CMICBT.setValue", this));
				}
			}
			// O[oCBT  ANeBuCBT 𖢐ݒɂ
			pGCBT.setCBT(null);
		} else {
			// ZbVJniopen\bhs`close\bhs܂ł̊ԁj
			// ́Al̐ݒ͂łȂB
			setError(CMIError.ERR_IGNORED_OPERATION);
			setVendorError(getVendorData("CMICBT.setValue", this));
		}
	}
	
	/**
	 * f[^l擾B<br>
	 * @param name String L[
	 * @return String f[^l
	 */
	public String getValue(String name) {

		CMIGlobalCBT pGCBT = CMIGlobalCBT.getGlobalCBT();
		clearError();
		String retStr = null;

		// O[oCBT  ANeBuCBT XV
		pGCBT.setCBT(this);

		// fobOOo
		CMIUtil.putLog("CMICBT.getValue name[" + name + "]");
		if (CMIUtil.isDetailLogging()) {
			String data = getDiagnostic(CMIError.VERR_DEBUG_CMIDATA);
			CMIUtil.putLog(data);
		}

		String strName = CMIS13ModelUtil.changeAiccModelName(name);

		retStr = localGetValue(strName);
		// fobOOo
		if ( retStr != null ) {
			CMIUtil.putLog("CMICBT.getValue  retStr[" + retStr + "]");
		} else {
			CMIUtil.putLog("CMICBT.getValue  retStr[null]");
			retStr = "";
		}
		if ( CMIUtil.isDetailLogging() ) {
			String strData = getDiagnostic(CMIError.VERR_DEBUG_CMIDATA);
			CMIUtil.putLog(strData);
		}
		// O[oCBT  ANeBuCBT 𖢐ݒɂ
		pGCBT.setCBT(null);
		return retStr;
	}

	/**
	 *ۑf[^擾B<br>
	 * @return String f[^
	 */
	public String getAllValue() {

		String retStr="";
		clearError();
		StringBuffer outstr = new StringBuffer();
		if ( !m_isOpen ) {
			serialize( outstr );
			retStr = outstr.toString();
		} else {
			setError(CMIError.ERR_IGNORED_OPERATION);
			setVendorError(getVendorData("CMICBT.getAllValue", this));
			retStr="";
		}
		return retStr;
	}

	/**
	 *ۑf[^ݒ肷B<br>		
	 * @param valueStr String f[^Wl
	 * @return Ȃ		
	 */
	public void setAllValue(String valueStr) {
		clearError();
		if ( !m_isOpen ) {
			StringBuffer childrenValues = new StringBuffer();

			int intHead = valueStr.indexOf("=");
			intHead = getNestedValue(valueStr, intHead+1, childrenValues);
			deserialize(childrenValues.toString());
		} else {
			setError(CMIError.ERR_IGNORED_OPERATION);
			setVendorError(getVendorData("CMICBT.setAllValue", this));
		}
	}

	/**
	 *G[R[h擾B<br>
	 * @return int G[R[h
	 */
	public int getLastError() {
		return m_lastError.getErrorNumber();
	}
	
	/**
	 *G[bZ[W擾B<br>
	 * @param errCode int G[R[h
	 * @return String G[bZ[W
	 */
	public String getErrorString(int errCode) {
		return m_lastError.getErrorString(errCode);
	}
	
	/**
	 *x_[擾B<br>
	 * @param errCode int G[R[h
	 * @return String x_[
	 */
	public String getDiagnostic(int errCode) {
		
		int	intLastErrCode;
		StringBuffer sbuff = new StringBuffer();

		SimpleDateFormat sDataFormat = 
							new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
		String DATE_TIME = sDataFormat.format(new Date());

		sbuff.append("Ver.");
		sbuff.append(DEF_MODULE_VERSION);
		sbuff.append(",");
		sbuff.append(DEF_MODULE_MODEL);
		sbuff.append(",").append(DATE_TIME);
		if ( CMIElementProto.IS_GLOBAL_MEM ) {
			sbuff.append("(GLOBAL)");
		} else {
			sbuff.append("(INSTANCE)");
		} 
		sbuff.append("\n");

		// ŐṼG[𐶐B
		if ( errCode < 0 ) {
			intLastErrCode = m_lastError.getErrorNumber();
		} else {
			intLastErrCode = errCode;
		}

		if ( CMIError.VERR_DEBUG_PROTO == errCode ) {
			// fobO𐶐B
			sbuff.append("fobO(vg^Cv)\n");
			String strDebugProto = getDebugProto();
			if (strDebugProto != null) {
				sbuff.append(strDebugProto);
			}
		} else if (CMIError.VERR_DEBUG_CMIDATA == errCode) {
			// fobO𐶐B
			sbuff.append("fobO(CMIf[^)\n");
			String strDeBugCMI = getDebugCMIData();
			if (strDeBugCMI != null) {
				sbuff.append(strDeBugCMI);
			}
		} else if (CMIError.VERR_DEBUG_CHANGE_TARGETVALUE == errCode) {
			// setValue ̃^[QbgVALUE؂ւ(gO)
			sbuff.append("^[QbgVALUEؑ = Now Target Value is ");
			m_targetLessonValue = m_targetLessonValue ? false : true;	// gOؑ
			sbuff.append(m_targetLessonValue ? "Lesson" : "Local");
		} else {
			// errCode ̃G[𐶐B
			sbuff.append(m_lastError.getErrorString(intLastErrCode));
			if (errCode < 0 && CMIError.ERR_NO_ERROR != intLastErrCode) {
				sbuff.append(". ").append(m_lastError.getVendorMessage());
			}
		}
		return sbuff.toString();
	}
	
	/**
 	 * CMI LaunchNX擾B<br>
	 * @return CMILaunch@CX^XꂽIuWFNg
	 */
	public CMILaunch getCmiLaunch() {
		return m_launch;
	}

	/**
	 * CMI LessonNX擾B<br>
	 * @return CMILesson@CX^XꂽIuWFNg
	 */
	public CMILesson getCmiLesson() {
		return m_lesson;
	}

	/**
	 * CMI EvaluationDataNX擾B<br>
	 * @return CMIEvaluationData@CX^XꂽIuWFNg
	 */					
	public CMIEvaluationData getCmiEvaluationData() {
		return m_evaluationData;
	}

	/**
	 *G[R[hZbgB<br>
	 * @param error int G[R[h
	 */
	public void setError(int error) {
		m_lastError.setErrorNumber(error);
	}

	/**
	 *G[R[h擾B<br>
	 * @return int G[R[h
	 */
	public int getError() {
		return m_lastError.getErrorNumber();
	}

	/**
	 *x_[ZbgB<br>
	 * @param msg String bZ[W
	 */
	public void setVendorError(String msg) {
		m_lastError.setVendorMessage(msg);
	}

	/**
	 * CBT o[WZbgB<br>
	 * @param version String o[W
	 */
	public void setVersion(String version) {
		m_version = version;
	}

	/**
	 * CBT o[W擾B<br>
	 * @return String o[W
	 */
	public String getVersionStr() {
		return m_version;
	}

	/**
	 * CBTo[W 3 ȏł邱Ƃ̔B<br>
	 * @return booleantO
	 */
	public boolean isV3Above() {

		boolean blnRet = false;
		String strVer = getVersionStr();
		
		if ( strVer != null ) {
			int intVer = Integer.parseInt(strVer.substring(0, 1));
			//v3.0 or above
			if ( intVer >= 3 ) {
				blnRet = true;
			}
		}
		return blnRet;
	}

	/**
	 * CMI o[W擾B<br>
	 * @return String o[W
	 */
	public String getCmiVersion() {
		return m_cmiversion;
	}

	/**
	 * CMIo[W 3 ȏł邱Ƃ̔B<br>
	 * @return booleantO
	 */
	public boolean isCmiV3Above() {
		boolean blnRet = false;
		String strCMIVer = getCmiVersion();
		
		if ( strCMIVer != null ) {
			int intVer = Integer.parseInt( strCMIVer.substring( 0,  1 ) );
			//v3.0 or above
			if ( intVer >= 3 ) {
				blnRet = true;
			}
		}
		return blnRet;
	}

	/**
	 * L[pXGg擾B<br>
	 * @param key String f[^f̃L[pX
	 * @return CMIElement f[^fGg
	 */				
	public CMIElement getPath2Element(String key) {		
		CMIElement element = null;
		Iterator iterator = m_elementpathMap.keySet().iterator();
		Object value = null;
		while (iterator.hasNext()) {
			value = iterator.next();
			if ( key.equals(value) ) {
				element = (CMIElement)m_elementpathMap.get(value);
				break;
			}
		}
		return element;
	}

	/**
	 *pXɑGgo^B<br>
	 * @param key String f[^f̃L[pX
	 * @param element CMIElement o^GgNX
	 * @return CMIElement f[^fGg
	 */
	public CMIElement addPathElement(String key, CMIElement element) {
		m_elementpathMap.put(key, element);
		return element;
	}

	/**
	 * f[^fɑ΂čXVꍇtrueAXVȂꍇfalse
	 * ݒ肷B<br>
	 * @param bUpdFlag boolean XVtO
	 */
	public void updateFlag(boolean bUpdFlag) {
		m_bUpdate = bUpdFlag;
	}

	/**
	 * CMIf[^fXVĂ邩mFB<br>
	 * @return boolean XVtO
	 */
	public boolean isUpdate() {
		return m_bUpdate;
	}

	/**
	 * G[bZ[W폜B<br>
	 */
	public void clearError() {
		m_lastError.setErrorNumber(CMIError.ERR_NO_ERROR);
	}

	/**
	 * f[^ɍXVꍇAPutParam`̃Oo͂B<br>
	 */
	private void writePutParamLog() {
		if ( isUpdate() ) {		
			// XVĂꍇAēxp[^Ot@Co͂
			// 擾f[^i[p
			StringBuffer strAiccData = new StringBuffer();	
			// PutParam̌ʗp
			StringBuffer resData = new StringBuffer();			
			m_lesson.doGetPutParam(strAiccData);
			m_evaluationData.doPutParam(strAiccData.toString(), resData);
			// Oo͌AXVtOfalseɐݒ肷
			updateFlag(false);
		}
	}

	/**
	 * CBTCOMf[^XML`ŏo͂B<br>
	 * @param outData OutputStream o̓f[^
	 */
	public void getLearninLog(OutputStream outData) {

		StringBuffer sbuff = new StringBuffer();

		sbuff.append("<?xml version=\"1.0\" encoding=\"Windows-31J\"?>" );
		sbuff.append("\r\n");
		serializeXMLLog( sbuff );

		byte[] bData = sbuff.toString().getBytes();
		try {
			outData.write(bData,0,bData.length);
		}
		catch (Exception ex) {
			;
		}
		
	}
}
