/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

// 
//	@\	
//		CMI-CBT communication module     
//
//		ύX	
//			2003.12.01 gxl VK쐬
//

package jp.co.ntt.lms.lo.scorm.cbtcom;

//import java.util.StringTokenizer;
import java.net.URLEncoder;
import java.io.UnsupportedEncodingException;

/**
 * CMI f[^f@lesson NX<br>
 * @author gxl
 */
public class CMILesson extends CMIObjBase {
	
	/**  
	 * CMIError IuWFNg
	 */
	private CMIError m_lastError = null;

	/**  
	 * CMIEvaluationData IuWFNg
	 */
    private CMIEvaluationData m_evaluationData = null;
	
	/**
	 * CMILesson NX̏B<br>
	 */
	public CMILesson() {
		// I[vԃtO(I[v)
		m_isOpen = false;	
		// vg^Cvf[^Zbg
		m_proto	= CMIElementProto.g_lessonProto;
		// qf[^f𐶐
		makeChildren(CMIElementProto.g_lessonProto);		
	}

	/**
	 * CMILesson NX̏B<br>
	 * @param cbt CBTIuWFNg
	 */
	public CMILesson(CMICBT  cbt) {
		// I[vԃtO(I[v)
		m_isOpen = false;	
		// vg^Cvf[^Zbg
		m_proto	= CMIElementProto.g_lessonProto;
		// CBTIuWFNgZbg
		m_CBT = cbt;						
		// ĹAmakeChildren OɃZbgKvB
		
		// qf[^f𐶐
		makeChildren(CMIElementProto.g_lessonProto);	
	}
	
	/**
	 * CMILesson CMILesson NX̏IB<br>
	 */
	public void finalize() {
		m_lastError = null;
		m_evaluationData = null;
	}
	
	/**
	 * ZbVJnB<br>
	 * @return String CBTNURL
	 */
	public String open() {
		// CBTIuWFNg̃I[vR[
		return m_CBT.open();			
	}
	
	/**
	 * ZbVIB<br>
	 */
	public void close() {
		// CBTIuWFNg̃N[YR[
		m_CBT.close();			
	}
	
	/**
	 * Mf[^͂AR}hɑΉ鏈sB<br>
	 * <p>̉responceɕԋpB
	 * ߂lƂăR}h()ԂB
	 * @param request NGXg
	 * @return String HACPR}h()
	 */
	public String hacp(String request) {
		String strRes = "";
		// CBTIuWFNgHACPR[
		strRes = m_CBT.hacp(request);
		// HACPR}hԂ
		return strRes;
	}
	
	/**	
	* (LocalValue)lݒ菈<br>
	* @param name@String GgpX
	* @param value@String l
	*/
	public void setValue(String name, String value) {
		// G[NA
		m_CBT.clearError();
		if (!m_isOpen) {
			// I[vԂȂ΁AwpX̃IuWFNgɒlZbg
			CMIParameterPath param = new CMIParameterPath(name);
			String strDataModelName	= param.popFirstElement();
			String strCategory			= param.getNthElement(1);

			localSetValue(param.getPath(), value);
		} else {
			// I[vԂȂ΁AG[Zbg
			setError(CMIError.ERR_NOT_INITALIZED);
			setVendorError(getVendorData(("CMILesson.setValue"), this));
		}
	}
	
	/**			
	* (LessonValue)l擾<br>		
	* @param name@String GgpX		
	* @return String  p[^̒lij		
	*/
	public String getValue(String name) {
		// G[NA
		m_CBT.clearError();
		// wpX̃IuWFNg̒l擾
		String strRet = null;
		CMIParameterPath param = new CMIParameterPath(name);
		String strDataModelName	= param.popFirstElement();
		String strCategory			= param.getNthElement(1);

		strRet = localGetValue(param.getPath());
		// 擾lԂ
		return strRet;
	}
	
	/**			
	* ۑf[^ݒ菈<br>		
	* @param valueStr String ۑf[^
	*/	
	public void setAllValue(String valueStr) {
		// CBTIuWFNgsetAllValue R[
		m_CBT.setAllValue(valueStr);
	}
	
	/**		
	* ۑf[^擾<br>	
	* @return String  ۑf[^ij	
	*/	
	public String getAllValue() {
		// CBTIuWFNggetAllValue R[
		return m_CBT.getAllValue();
	}
	
	/**			
	* ŌɔG[R[h擾<br>		
	* @return int  G[R[h		
	*/	
	public int getLastError() {
		// CBTIuWFNggetLastError R[
		return m_CBT.getLastError();
	}
	
	/**	
	* G[bZ[W擾<br>
	* @param errcode G[R[h
	* @return String G[bZ[W
	*/
	public String getErrorString(int errcode) {
		// CBTIuWFNggetErrorString R[
		return m_CBT.getErrorString(errcode);
	}
	
	/**		
	* IuWFNg̃I[vs<br>	
	*/	
	public void myOpen() {
		// I[vԃtOI[vς݂ɂ
		m_isOpen = true;	
	}
	
	/**			
	* IuWFNg̃N[Ys<br>		
	*/		
	public void myClose() {
		// I[vԃtO𖢃I[vɂ
		m_isOpen = false;		
	}
	
	/**		
	* CMIEvaluationDataNXݒ菈<br>	
	* @param evalDataObj@CMIEvaluationData	
	*/	
	public void setEvaluationData(CMIEvaluationData evalDataObj) {
		m_evaluationData = evalDataObj;
	}
	
	/**		
	* AICCf[^PutParam ̃f[^Ƃď<br>	
	* @param aiccData@AICC f[^	
	* @param response@X|X(gp)	
	* @return int  G[R[h	
	*/	
	public int doPutParam(String aiccData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strLineDelimiter = CMIUtil.checkLineDelimiter(aiccData);
		CMITokenizer tokenizer = new CMITokenizer(aiccData, strLineDelimiter);
		String strLine = null;
		String strGroupName = null;
		StringBuffer data = new StringBuffer();

		// K{ڃ`FbNtO
		// Core
		boolean blnCore			= false;
		// Core_Lesson
		boolean blnCoreLesson	= false;

		// PutParamM̂ŁAXVtOfalseɐݒ肷
		m_CBT.updateFlag(false);

		// AICCf[^PsAAICCf[^ԌJԂ
		while (tokenizer.hasMoreTokens()){
			// Jgs擾
			strLine = tokenizer.nextToken();
			// JgsRgs  ŏIsłȂ΁A̍s
			if (CMIUtil.isComment(strLine) && tokenizer.hasMoreTokens()) {
				continue;
			}
			// JgsO[v ܂ ŏIsȂ΁Af[^obt@
			if (CMIUtil.isGroup(strLine) || !tokenizer.hasMoreTokens()) {
				// ŏIs  RgsłȂ΁AJgsf[^obt@ɃXgbN
				if (!tokenizer.hasMoreTokens() && !CMIUtil.isComment(strLine)) {
					data.append(STR_CRLF).append(strLine);
				}
				// O[vێĂȂ΁Af[^obt@
				if ( strGroupName != null && !"".equals(strGroupName)) {
					// O[vɕϊ
					String keyWord = strGroupName.toLowerCase();
					// O[vK{ڂȂ΁AmFtOmFς݂ɃZbg
					if ("core".equals(keyWord)) {
						blnCore = true;	
					} else if ("core_lesson".equals(keyWord)) {
						blnCoreLesson = true;	
					}

					// qIuWFNgO[vɊYIuWFNg擾
					CMIElement child = getChildByKeyWord(strGroupName);
					if ( child != null ) {
						// qIuWFNg擾łȂ΁AqIuWFNgputParam R[A
						// f[^
						child.putParam(strGroupName, data.toString());
						//f[^obt@ɂ
						data.setLength(0);
					} else {
						// qIuWFNg擾łȂȂ΁AG[Zbg
						// warning
						if (getError() == CMIError.ERR_NO_ERROR) {
							setError(CMIError.WARNING_INVALID_GROUPNAME);
							setVendorError("Invalid GroupName[" + strGroupName + "]");
						}
						data.setLength(0);
					}
				}
				// JgsO[v擾Aێ
				strGroupName = CMIUtil.getGroupName(strLine);

			// JgsO[v ܂ ŏIsłȂ΁AJgsf[^obt@ɃXgbN
			} else {
				if (data.length() != 0) {
					// f[^obt@łȂ΁AsR[h{Jgsf[^obt@ɘA
					data.append(STR_CRLF).append(strLine);
				} else {
					// f[^obt@Ȃ΁AJgsf[^obt@ɃZbg
					data.append(strLine);
				}
			}
		}
		// K{O[v̍ŏI`FbN
		int intECode = getError();
		if ( intECode == CMIError.ERR_NO_ERROR ) {
			// Core
			if ( !blnCore ) {
				setError(CMIError.WARNING_INSUFFICIENT_GROUPNAME);
				setVendorError("Insufficient GroupName[Core]");
			}
			// Core_Lesson
			else if (!blnCoreLesson) {
				setError(CMIError.WARNING_INSUFFICIENT_GROUPNAME);
				setVendorError("Insufficient GroupName[Core_Lesson]");
			}
		}
		return intErrCode;
	}

	/**	
	* GetParam R}h̏<br>
	* @param aiccData@AICC f[^(gp)
	* @param response@X|X
	* @return int  G[R[h
	*/
	public int doGetParam(String aiccData, StringBuffer response) {
		int intErr = HACPError.HACP_ERR_SUCCESSFUL;
		// qGg̐擾
		int intChildCount = getChildCount();			
		// qIuWFNg̐JԂ
		for ( int i = 0; i < intChildCount; i++ ) {
			// qGg擾
			CMIElement child = getChild(i);		
			if ( child != null ) {
				// qGgp[^擾
				intErr = child.getParam(response);		
				if ( intErr != HACPError.HACP_ERR_SUCCESSFUL) {
					break;
				}
			}
		}
		// G[R[hԂ
		return intErr;					
	}
	
	/**			
	* PutObjectives R}h̏<br>		
	*		
	* @param aiccData@AICC f[^(gp)		
	* @param response@X|X(gp)		
	* @return int  G[R[h		
	*/	
	public int doPutObjectives(String aiccData, StringBuffer response) {
		// G[R[h()Ԃ
		return HACPError.HACP_ERR_SUCCESSFUL;
	}

	/**			
	* ExitAU R}h̏<br>		
	* @param aiccData@AICC f[^(gp)		
	* @param response@X|X(gp)		
	* @return int  G[R[h		
	*/		
	public int doExitAU(String aiccData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strGrpName="core";
		String strSubPath="lesson_status";
		// qIuWFNgO[vɊYIuWFNg擾
		CMIElement child = getChildByKeyWord(strGrpName);
		if ( child != null ) {
			//@[lesson_status]l擾B
			String strValue = child.getLocalValue(strSubPath);
			// version 擾B
			int	intVersion = getVersion();
			// lɓ]
			if ( strValue != null ) {
				strValue = strValue.toLowerCase();
			}
			if ( intVersion>=3500 ) {
				// cmi.core.lesson_status l"" or "not attempted"̏ꍇ
				// "completed"ݒ肷B 
				if ( strValue != null && ("".equals(strValue) || 
											strValue.startsWith("n") )) {
					child.setLessonValue(strSubPath,"completed");
					child.setLocalValue(strSubPath,"completed");
					// bXXe[^XXV̂ŁAXVtO𗧂Ă
					m_CBT.updateFlag(true);
				}
			}
		}
		return intErrCode;	
	}
	
	/**	
	* ExitAU R}h̏<br>
	* @param aiccData@AICC f[^
	* @return int  G[R[h
	*/
	public int doGetPutParam(StringBuffer aiccData) {
		int intErr = HACPError.HACP_ERR_SUCCESSFUL;		
		// qGg̐擾
		int intChildCount = getChildCount();			
		// qIuWFNg̐JԂ
		for ( int i = 0; i< intChildCount; i++ ) {
			// qGg擾
			CMIElement child = getChild(i);		
			if ( child != null ) {
				// qGgp[^擾
				intErr = child.getPutParam(aiccData);		
				if ( intErr != HACPError.HACP_ERR_SUCCESSFUL ) {
					break;
				}
			}
		}
		// G[R[hԂ
		return intErr;					
	}

	/**
	 * GetLmsCommentsR}hs<br>
	 * ֕ێĂComment from LMSf[^HACPtH[}bg
	 * 擾B<br>
	 * @param scoData StringBuffer 擾Comments from LMSf[^
	 * @return @int  HACPG[R[h	
	 */	
	public int doGetLmsComments(String scoData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;

		//	"cmi.comments_from_lms"
		String strSubPath = "comments_from_lms";
		CMINode lms_comments_Node = (CMINode)m_CBT.getChildByKeyWord(strSubPath);

		// Comment from LMSf[^̌擾
		//	"comments_from_lms._count"
		int intNum = lms_comments_Node.getChildCount();

		// ^Cgs쐬
		String strTitleLine = "\"Date\",\"Location\",\"Comment\"\n";
		response.append(strTitleLine);

		// SCORM1.3LmsCommentf[^PsAAICCf[^tH[}bg쐬
		for(int i = 0; i < intNum; i++){

			String strValue = null;

			try {
				// ^CgɑGg̃pX𐶐ÃGg
				// f[^Zbg
				//date_time
				strSubPath = String.valueOf(i) + ".date_time";
				strValue = lms_comments_Node.getLocalValue(strSubPath);
				if (strValue == null) {
					strValue = "";
				}
				// R[hUTF-8ɃGR[h
				strValue = URLEncoder.encode(strValue,"UTF-8");
				response.append("\"" + strValue + "\",");
	
				//location
				strSubPath = String.valueOf(i) + ".location";
				strValue = lms_comments_Node.getLocalValue(strSubPath);
				if (strValue == null) {
					strValue = "";
				}
				// R[hUTF-8ɃGR[h
				strValue = URLEncoder.encode(strValue,"UTF-8");
				response.append("\"" + strValue + "\",");
	
				//comment
				strSubPath = String.valueOf(i) + ".comment";
				strValue = lms_comments_Node.getLocalValue(strSubPath);
				if (strValue == null) {
					strValue = "";
				}
				// R[hUTF-8ɃGR[h
				strValue = URLEncoder.encode(strValue,"UTF-8");
				response.append("\"" + strValue + "\"" + CMIElement.STR_CRLF);

				// 擾f[^ŜGR[h
				strValue = URLEncoder.encode(response.toString(),"UTF-8");
				response.delete(0,response.length());
				response.append(strValue);
			}
			catch(UnsupportedEncodingException ex) {
				intErrCode = HACPError.HACP_ERR_CMI;
				setError(CMIError.ERR_INVALID_AURGUMENT_ERROR);
				setVendorError(getVendorData( new String("CMILesson.getLmsComments"), this));
				break;
			}

		}
		// G[R[h()Ԃ
		return intErrCode;	
	}

	/**
	 * PutParamR}hs<br>
	 * PutParamR}hŎMHACPtH[}bgSCORM1.3f[^
	 * ۊǂBɕۊǌA̕ۊǃf[^oB<br>
	 * @param scoData SCORM1.3 f[^	
	 * @param response f[^igp I/Fʉ̂ߎj
	 * @return @int  HACPG[R[h	
	 */	
	public int doPutParamToS13(String scoData, StringBuffer response) {
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strLineDelimiter = CMIUtil.checkLineDelimiter(scoData);
		CMITokenizer tokenizer = new CMITokenizer(scoData, strLineDelimiter);
		String strLine = null;
		String strGroupName = null;
		StringBuffer data = new StringBuffer();

		// PutParamM̂ŁAXVtOfalseɐݒ肷
		m_CBT.updateFlag(false);

		// AICCf[^PsAAICCf[^ԌJԂ
		while (tokenizer.hasMoreTokens()){
			// Jgs擾
			strLine = tokenizer.nextToken();
			// JgsRgs  ŏIsłȂ΁A̍s
			if (CMIUtil.isComment(strLine) && tokenizer.hasMoreTokens()) {
				continue;
			}
			// JgsO[v ܂ ŏIsȂ΁Af[^obt@
			if (CMIUtil.isGroup(strLine) || !tokenizer.hasMoreTokens()) {
				// ŏIs  RgsłȂ΁AJgsf[^obt@ɃXgbN
				if (!tokenizer.hasMoreTokens() && !CMIUtil.isComment(strLine)) {
					data.append(STR_CRLF).append(strLine);
				}
				// O[vێĂȂ΁Af[^obt@
				if ( strGroupName != null && !"".equals(strGroupName)) {
					// O[vɕϊ
					String keyWord = strGroupName.toLowerCase();

					// qIuWFNgO[vɊYIuWFNg擾
					CMIElement child = getChildByKeyWord(strGroupName);
					if ( child != null ) {
						// qIuWFNg擾łȂ΁AqIuWFNgputParam R[A
						// f[^
						child.putParam(strGroupName, data.toString());
						//f[^obt@ɂ
						data.setLength(0);
					} else {
						// qIuWFNg擾łȂȂ΁AG[Zbg
						// warning
						if (getError() == CMIError.ERR_NO_ERROR) {
							setError(CMIError.WARNING_INVALID_GROUPNAME);
							setVendorError("Invalid GroupName[" + strGroupName + "]");
						}
						data.setLength(0);
					}
				}
				// JgsO[v擾Aێ
				strGroupName = CMIUtil.getGroupName(strLine);

			// JgsO[v ܂ ŏIsłȂ΁AJgsf[^obt@ɃXgbN
			} else {
				if (data.length() != 0) {
					// f[^obt@łȂ΁AsR[h{Jgsf[^obt@ɘA
					data.append(STR_CRLF).append(strLine);
				} else {
					// f[^obt@Ȃ΁AJgsf[^obt@ɃZbg
					data.append(strLine);
				}
			}
		}
		getPutParamToS13(response);
		return intErrCode;
	}

	/**
	 * ֕ێĂPutParamR}hŎMHACP
	 * tH[}bgSCORM1.3f[^擾B<br>
	 * @param scoData String SCORM1.3 f[^
	 * @param response String 擾parameterf[^
	 * @return @int  HACPG[R[h
	 */
	private int getPutParamToS13(StringBuffer response) {

		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;

		/**
		 * p[^̃Tum[h擾
		 */
		// Corem[hicmi.corej擾
		String strValue;
		String strCompStatus;
		String strSuccessStatus;
		String strSubPath = "core";
		CMINode objCore = (CMINode)getNChild(strSubPath);
		response.append("[");
		response.append(objCore.getKeyWord());
		response.append("]");
		response.append(CMIElement.STR_CRLF);

		// Corem[hz̊ep[^擾
		// completion_threshold
		
		strSubPath = "completion_threshold";
		strValue = objCore.getLessonValue(strSubPath);
		if (strValue != null) {
			response.append("Completion_Threshold=");
			response.append(strValue);
			response.append(CMIElement.STR_CRLF);
		} 
		
		strSubPath = "progress_measure";
		strValue = objCore.getLessonValue(strSubPath);
		if (strValue != null) {
			response.append("Progress_Measure=");
			response.append(strValue);
			response.append(CMIElement.STR_CRLF);
		} 

		// Corem[hz̊ep[^擾
		// Lesson_Location
		strSubPath = "lesson_location";
		strValue = objCore.getLessonValue(strSubPath);
		if (strValue != null) {
			response.append("Lesson_Location=");
			response.append(strValue);
			response.append(CMIElement.STR_CRLF);
		}

		// Lesson_Status
		// (cmi.completion_status,cmi.success_status,cmi.entry)
		response.append("Lesson_Status=");

		//	"cmi.success_status"
		strSubPath = "lesson_status";
		strValue = objCore.getLessonValue(strSubPath);
		if (strValue != null) {
			response.append(strValue);
		}
		response.append(",");

		//	"cmi.completion_status"
		strSubPath = "completion_status";
		strValue = objCore.getLessonValue(strSubPath);
		if (strValue != null) {
			response.append(strValue);
		}
		response.append(",");

		//	"cmi.exit"
		strSubPath = "exit";
		strValue = objCore.getLessonValue(strSubPath);
		if (strValue != null) {
			response.append(strValue);
		}
		response.append(CMIElement.STR_CRLF);

		// Score
		// (cmi.score.scaled,cmi.score.raw,cmi.score.max,cmi.score.min)
		//	"cmi.score"
		strSubPath = "score";
		CMINode objScore = (CMINode)objCore.getChild(strSubPath);
		strValue = CMIUtil.getScoreValue(objScore);
		if ((strValue != null) && ("".equals(strValue) != true)) {
			response.append("Score=");
			response.append(strValue);
			response.append(CMIElement.STR_CRLF);
		}

		// Time
		// (cmi.session_time)
		strSubPath = "session_time";
		strValue = objCore.getLessonValue(strSubPath);
		if (strValue != null) {
			response.append("Time=");
			response.append(strValue);
			response.append(CMIElement.STR_CRLF);
		}

		// Core_Lessonicmi.suspend_dataj擾
		strSubPath = "suspend_data";
		CMIElement objCoreLesson = getChild(strSubPath);
		response.append("[");
		response.append(objCoreLesson.getKeyWord());
		response.append("]");
		response.append(CMIElement.STR_CRLF);

		strValue = objCoreLesson.getLessonValue();
		if (strValue != null) {
			response.append(CMIUtil.urlEncode(strValue));
		}
		response.append(CMIElement.STR_CRLF);

		// Objectives_Statusm[hicmi.objectivesj擾
		CMIElement	child = null;
		strSubPath = "objectives";
		CMINode objObjectives = (CMINode)getNChild(strSubPath);
		if (objObjectives != null) {
			response.append("[");
			response.append(objObjectives.getKeyWord());
			response.append("]");
			response.append(CMIElement.STR_CRLF);

			// objectivesz̐ݒ茏擾
			int intCount = objObjectives.getChildCount();
			for ( int i = 0; i < intCount; i++ ) {
				// OłꍇACfbNX0珇Ɏq
				// (objectives.n)̍ڂ擾
				CMINode	child_n = (CMINode)objObjectives.getChild(i);

				// J_ID.n
				// cmi.objectives.n.id
				strSubPath = "id";
				child = child_n.getChild(strSubPath);

				// [Jl擾
				strValue = child.getLocalValue();

				// cmi.objectives.n.idڂ̃f[^NULLlA܂
				// f[^l̏ꍇ́A擾Ώۃf[^Ɋ܂߂A(n+1)
				// ̃f[^擾邽߂continueB
				// inɊY"J_Score"A"J_Status"擾f[^
				// ܂߂Ȃj
				if (strValue == null) {
					continue;
				} else {
					response.append("J_ID.");
					response.append(String.valueOf(i+1));
					response.append("=");
					response.append(strValue);
					response.append(CMIElement.STR_CRLF);
				}

				// J_Score.n
				// (cmi.objectives.n.score.scaled,cmi.objectives.n.score.raw,
				//  cmi.objectives.n.score.max,   cmi.objectives.n.score.min)
				strSubPath = "score";
				child = child_n.getChild(strSubPath);

				// XRAl擾
				strValue = CMIUtil.getScoreValue(child);
				if (strValue != null) {
					response.append("J_Score." + String.valueOf(i+1));
					response.append("=");
					response.append(strValue);
					response.append(CMIElement.STR_CRLF);
				}

				// J_Status.n
				// (cmi.objectives.n.success_status,
				strSubPath = "status";
				child = child_n.getChild(strSubPath);
				strSuccessStatus = child.getLessonValue();

				strSubPath = "completion_status";
				child = child_n.getChild(strSubPath);
				strCompStatus = child.getLessonValue();

				response.append("J_Status." + String.valueOf(i+1));
				response.append("=");
				if (strSuccessStatus != null) {
					response.append(strSuccessStatus);
				}
				if (strCompStatus != null) {
					response.append(",");
					response.append(strCompStatus);
				}
				response.append(CMIElement.STR_CRLF);
			}
		}

		// Student_Datam[hicmi.student_dataj擾
		strSubPath = "student_data";
		CMINode objStudentData = (CMINode)getNChild(strSubPath);
		if (objStudentData != null) {
			response.append("[");
			response.append(objStudentData.getKeyWord());
			response.append("]");
			response.append(CMIElement.STR_CRLF);

			// Mastery_Score
			// (cmi.scaled_passing_score)
			strSubPath = "mastery_score";
			// [Jl擾
			strValue = objStudentData.getLocalValue(strSubPath);
			if (strValue != null) {
				// [JlNULLȊȌꍇAPutParamp̃f[^擾ΏۂƂ
				response.append("Mastery_Score");
				response.append("=");
				response.append(strValue);
				response.append(CMIElement.STR_CRLF);
			}

			// Max_Time_Allowed
			// (cmi.max_time_allowed)
			strSubPath = "max_time_allowed";
			// [Jl擾
			strValue = objStudentData.getLocalValue(strSubPath);
			if (strValue != null) {
				// [JlNULLȊȌꍇAPutParamp̃f[^擾ΏۂƂ
				response.append("Max_Time_Allowed");
				response.append("=");
				response.append(strValue);
				response.append(CMIElement.STR_CRLF);
			}

			// Time_Limit_Action
			// (cmi.time_limit_action)
			strSubPath = "time_limit_action";
			// [Jl擾
			strValue = objStudentData.getLocalValue(strSubPath);
			if (strValue != null) {
				// [JlNULLȊȌꍇAPutParamp̃f[^擾Ώ
				// Ƃ
				response.append("Time_Limit_Action");
				response.append("=");
				response.append(strValue);
				response.append(CMIElement.STR_CRLF);
			}
		}

		// Student_Preferencesm[hicmi.student_preferencesj擾
		strSubPath = "student_preference";
		CMINode objStudentPreference = (CMINode)getNChild(strSubPath);
		if (objStudentPreference != null) {
			response.append("[");
			response.append(objStudentPreference.getKeyWord());
			response.append("]");
			response.append(CMIElement.STR_CRLF);

			// Student_PreferenceO[vɑeڂ̃[Jl擾
			// Audio 擾
			// cmi.learner_preferences.audio
			strSubPath = "audio";
			strValue = objStudentPreference.getLocalValue(strSubPath);
			if (strValue != null) {
				response.append("Audio");
				response.append("=");
				response.append(strValue);
				response.append(CMIElement.STR_CRLF);
			}

			// Language 擾
			// cmi.learner_preferences.language
			strSubPath = "language";
			strValue = objStudentPreference.getLocalValue(strSubPath);
			if (strValue != null) {
				response.append("Language");
				response.append("=");
				response.append(strValue);
				response.append(CMIElement.STR_CRLF);
			}

			// Speed 擾
			// cmi.learner_preferences.speed
			strSubPath = "speed";
			strValue = objStudentPreference.getLocalValue(strSubPath);
			if (strValue != null) {
				response.append("Speed");
				response.append("=");
				response.append(strValue);
				response.append(CMIElement.STR_CRLF);
			}

			// Text 擾
			// cmi.learner_preferences.text
			strSubPath = "text";
			strValue = objStudentPreference.getLocalValue(strSubPath);
			if (strValue != null) {
				response.append("Text");
				response.append("=");
				response.append(CMIUtil.urlEncode(strValue));
				response.append(CMIElement.STR_CRLF);
			}
		}
		return intErrCode;
	}
}