/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	Engine
//	ύX
//		2004.02.01	VK쐬
//      2006.12.15@ύX T.Kiyokawa
//                  IMOXMLeLXg`ɕύXA
//      2007.02.01  g[XO֘AύX T.Sakai
//                   trace.xml navitrace.xml MLΉ
//                   wKI͒fAtrace.xml navitrace.xmlړ
//

package jp.co.ntt.lms.lo.scorm.engine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;

import jp.co.ntt.lms.lo.util.UserIDFolder;
import jp.co.ntt.lms.lo.scorm.cbtcom.CMIUtil;
import jp.co.ntt.lms.lo.scorm.kernel.Activity;
import jp.co.ntt.lms.lo.scorm.kernel.AuxiliaryResource;
import jp.co.ntt.lms.lo.scorm.kernel.Kernel;
import jp.co.ntt.lms.lo.scorm.kernel.SCORMCommunicationModule;
import jp.co.ntt.lms.lo.scorm.kernel.exception.CommunicationModuleWrapperException;
import jp.co.ntt.lms.lo.scorm.kernel.exception.SequencingException;
import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.AICCLogForCSV;
import jp.co.ntt.lms.lo.scorm.util.AICCLogForProperties;
import jp.co.ntt.lms.lo.scorm.util.CachedNode;
import jp.co.ntt.lms.lo.scorm.util.Debug;
import jp.co.ntt.lms.lo.scorm.util.SG;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;
import jp.co.ntt.lms.lo.scorm.util.XPathUtil;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/**
 *	Engine NX<br>
 *	GWNX<br>
 */
public class Engine {
	/** N */
	private Date startDate;

	/** Np[^ */
	private ExecuteParameters executeParameters;

	/** J[l */
	private Kernel kernel;

	/** [gANeBreB */
	private Activity rootActivity;

	/** ŌɔV[PVOO */
	private SequencingException lastSequencingException;

	/**
	 * ftHgRXgN^
	 */
	private Engine() {
	}

	/**
	 * RXgN^
	 *
	 * @param executeParameters	Np[^
	 */
	public Engine(ExecuteParameters executeParameters) {
		startDate = new Date();
		this.executeParameters = executeParameters;
	}

	/**
	 * 
	 *
	 * @param manifest			ލ\ݒ肳ĂDOM Document
	 * @param discontinueInfo	f񂪐ݒ肳ĂDOM DocumentB
	 *							f񂪑݂Ȃꍇnullw肷B
	 */
	public void initialize(Document manifest, Document discontinueInfo) throws SystemException, IOException, ParserConfigurationException, SAXException, TransformerException {

		// ȍ
		kernel = null;
		rootActivity = null;
		lastSequencingException = null;
		alreadyDiscontinued = false;

		// J[l̃CX^X𐶐
		kernel = new Kernel();

		// Activity Tree 쐬
		rootActivity = kernel.makeTree(ManifestFactory.getCachedNode(executeParameters.getManifestID(), manifest.getDocumentElement(), manifest),executeParameters.getUserID());

		// s
		kernel.initialize(
			executeParameters.getUserID(),
			executeParameters.getUserName(),
			SG.get("AICCURL"),
			SG.get("HACPEncoding"),
			(discontinueInfo == null) ? null : new CachedNode(discontinueInfo.getDocumentElement()));
	}

	/**
	 * I<br>
	 */
	public void terminate() throws SystemException {
		executeParameters = null;
		rootActivity = null;

		if (kernel != null) {
			kernel.terminate();
			kernel = null;
		}
	}

	/**
	 * irQ[V<br>
	 *
	 * @param	command		R}h<br>
	 * @param	activityID	ANeBreBID<br>
	 * @return	p\ǂtOBtruȅꍇ\Afalsȅꍇ͕s\<br>
	 */
	public boolean navigate(String command, String activityID) throws SequencingException, SystemException {
		kernel.navigate(command, activityID);
		return !kernel.isEndSequencingSession();
	}

	/**
	 * ɑJڂSCOiASSET́jURL擾<br>
	 *
	 * @param	learningLogFolder	JgANeBreBo͂
	 *								wKȌo̓t@Cw肷
	 * @return	ɑJڂSCOiASSET́jURLԋp
	 */
	public String getURL(String learningLogFolder) throws SystemException, CommunicationModuleWrapperException {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return null;
		}

		if (!currentActivity.isActive()) {
			return null;
		}

		return currentActivity.getURL(learningLogFolder);
	}

	/**
	 *	ڎ擾<br>
	 *
	 * @return	<Contents>^O[gɐݒ肳ĂElement
	 */
	public Element getContentsMenu(Document doc) throws IOException, ParserConfigurationException, SAXException, SystemException {

		// ([g)Gg쐬
		Element element = XMLUtil.createElement(doc, "Contents", (String) null);

		// root activityڎ쐬
		makeContentMenu(doc, element, rootActivity, 0);

		// 쐬łڎԋp
		return element;
	}

	/**
	 *	ڎ쐬<br>
	 *
	 *	@param	doc		"Contents"[g^O݂DOM Documentw肷
	 *	@param	parent	쐬ڎGgǉGgw肷
	 *	@param	activity	ڎ𐶐Activityw肷
	 *	@param	indent	Cfgw肷B[gANeBreB̋iPʂ̓ANeBreBjw肷
	 * @return	ڎ쐬ׂXMLݒ肳ĂDOM Document
	 */
	private void makeContentMenu(Document doc, Element parent, Activity activity, int indent) throws SystemException {

		// objective progress status, objective satisfied status
		boolean objectiveProgressStatus = activity.getObjectiveProgressStatus();
		String objectiveSatisfiedStatus = "";

		if (objectiveProgressStatus) {
			objectiveSatisfiedStatus = Boolean.toString(activity.getObjectiveSatisfiedStatus());
		}

		// objective measure status, objective normalized measure
		boolean objectiveMeasureStatus = activity.getObjectiveMeasureStatus();
		String objectiveNormalizedMeasure = "";

		if (objectiveMeasureStatus) {
			objectiveNormalizedMeasure = activity.getObjectiveNormalizedMeasure().toString();
		}

		// activity progress status,
		// activity absolute duration, activity experienced duration, activity attempt count
		boolean activityProgressStatus = activity.getActivityProgressStatus();
		String activityAbsoluteDuration = "";
		String activityExperiencedDuration = "";
		String activityAttemptCount = "";

		if (activityProgressStatus) {
			activityAbsoluteDuration = Long.toString(activity.getActivityAbsoluteDuration().getMsec());
			activityExperiencedDuration = Long.toString(activity.getActivityExperiencedDuration().getMsec());
			activityAttemptCount = Integer.toString(activity.getActivityAttemptCount());
		}

		// attempt progress status,
		// attempt completion amount, attempt completion status, attempt absolute duration,
		// attempt experienced duration
		boolean attemptProgressStatus = activity.getAttemptProgressStatus();
		String attemptCompletionAmount = "";
		String attemptCompletionStatus = "";
		String attemptAbsoluteDuration = "";
		String attemptExperiencedDuration = "";

		if (attemptProgressStatus) {
			attemptCompletionAmount = activity.getAttemptCompletionAmount().toString();
			attemptCompletionStatus = Boolean.toString(activity.getAttemptCompletionStatus());
			attemptAbsoluteDuration = Long.toString(activity.getAttemptAbsoluteDuration().getMsec());
			attemptExperiencedDuration = Long.toString(activity.getAttemptExperiencedDuration().getMsec());
		}

		// Yactivity̖ڎ쐬
		Element content =
			XMLUtil.insertAttribute(
				doc,
				XMLUtil.append(
					doc,
					parent,
					"Content",
					new Element[] {
						XMLUtil.createElement(doc, "Indent", Integer.toString(indent)),
						XMLUtil.createElement(doc, "Choicable", Boolean.toString(activity.canChoice())),
						XMLUtil.createElement(doc, "Title", activity.getTitle()),
						XMLUtil.createElement(
							doc,
							"ActivityStatus",
							new Element[] {
								XMLUtil.createElement(doc, "Active", Boolean.toString(activity.isActive())),
								XMLUtil.createElement(doc, "Suspended", Boolean.toString(activity.isSuspended())),
								}),
						XMLUtil.createElement(
							doc,
							"TrackingInformation",
							new Element[] {
								XMLUtil.createElement(doc, "ObjectiveProgressStatus", Boolean.toString(objectiveProgressStatus)),
								XMLUtil.createElement(doc, "ObjectiveSatisfiedStatus", objectiveSatisfiedStatus),
								XMLUtil.createElement(doc, "ObjectiveMeasureStatus", Boolean.toString(objectiveMeasureStatus)),
								XMLUtil.createElement(doc, "ObjectiveNormalizedMeasure", objectiveNormalizedMeasure),
								XMLUtil.createElement(doc, "ActivityProgressStatus", Boolean.toString(activityProgressStatus)),
								XMLUtil.createElement(doc, "ActivityAbsoluteDuration", activityAbsoluteDuration),
								XMLUtil.createElement(doc, "ActivityExperiencedDuration", activityExperiencedDuration),
								XMLUtil.createElement(doc, "ActivityAttemptCount", activityAttemptCount),
								XMLUtil.createElement(doc, "AttemptProgressStatus", Boolean.toString(attemptProgressStatus)),
								XMLUtil.createElement(doc, "AttemptCompletionAmount", attemptCompletionAmount),
								XMLUtil.createElement(doc, "AttemptCompletionStatus", attemptCompletionStatus),
								XMLUtil.createElement(doc, "AttemptAbsoluteDuration", attemptAbsoluteDuration),
								XMLUtil.createElement(doc, "AttemptExperiencedDuration", attemptExperiencedDuration),
								}),
						}),
				new Attr[] {
					XMLUtil.createAttribute(doc, "Identifier", activity.getIdentifier()),
					XMLUtil.createAttribute(doc, "Visible", Boolean.toString(activity.getIsVisibleFlag())),
					XMLUtil.createAttribute(
						doc,
						"Current",
						Boolean.toString((kernel.getCurrentActivity() == null) ? false : (kernel.getCurrentActivity().getIdentifier() == activity.getIdentifier()))),
					});

		// activity available children Ăꍇ́A
		// available children ̖ڎ쐬ڎz֒ǉ
		if (activity.hasAvailableChildren()) {
			Activity[] nextTargets = activity.getAvailableChildren();

			for (int i = 0; i < nextTargets.length; i++) {
				makeContentMenu(doc, content, nextTargets[i], indent + 1);
			}
		}
	}

	/**
	 * g[XO擾<br>
	 *
	 * @return	g[XO񂪐ݒ肳ĂDOM Document
	 */
	public Document getTraceLog() throws SystemException {
		return kernel.getTraceLog();
	}

	/**
	 * ŌɔV[PVOO̐ݒ<br>
	 *
	 * @param lastSequencingException	V[PVOO
	 */
	public void setLastSequencingException(SequencingException lastSequencingException) {
		this.lastSequencingException = lastSequencingException;
	}

	/**
	 * ŌɔV[PVOO̎擾<br>
	 *
	 * @return OgetLastSequencingException\bhŐݒ肳ꂽV[PVOOԋp
	 */
	public SequencingException getLastSequencingException() {
		return lastSequencingException;
	}

	/**
	 * JgANeBreB"Previous"\ǂ`FbN
	 *
	 * @return "Previous"\ȏꍇtrueAs\ȏꍇfalseԋp
	 */
	public boolean canPrevious() throws SystemException {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return false;
		}

		return currentActivity.canPrevious();
	}

	/**
	 * JgANeBreB"Continue"\ǂ`FbN
	 *
	 * @return "Continue"\ȏꍇtrueAs\ȏꍇfalseԋp
	 */
	public boolean canContinue() throws SystemException {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return false;
		}

		return currentActivity.canContinue();
	}

	/**
	 * JgANeBreB"Exit"\ǂ`FbN
	 *
	 * @return "Exit"\ȏꍇtrueAs\ȏꍇfalseԋp
	 */
	public boolean canExit() {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return false;
		}

		return currentActivity.canExit();
	}

	/**
	 * JgANeBreB"ExitAll"\ǂ`FbN
	 *
	 * @return "ExitAll"\ȏꍇtrueAs\ȏꍇfalseԋp
	 */
	public boolean canExitAll() {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return false;
		}

		return true;
	}

	/**
	 * JgANeBreB"SuspendAll"\ǂ`FbN
	 *
	 * @return "SuspendAll"\ȏꍇtrueAs\ȏꍇfalseԋp
	 */
	public boolean canSuspendAll() {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return false;
		}

		return true;
	}

	/**
	 * JgANeBreB"Choice"\ǂ`FbN
	 *
	 * @return "Choice"\ȏꍇtrueAs\ȏꍇfalseԋp
	 */
	public boolean canChoice() throws SystemException {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return false;
		}

		return currentActivity.canChoice();
	}

	/**
	 * w肳ꂽURIŎw肳ꂽActivity"Choice"\ǂ`FbN
	 *
	 * @param	activity	ANeBreBw肷Bg܂ގw肳ꂽz
	 *						ANeBreBURIp[^Ŏw肳ꂽANeBr
	 *						eBIDɈvANeBreBcanChoice\bh̎
	 *						sʂԋpBnullw肳ꂽꍇ̓[gANeB
	 *						reB猟sB
	 * @param	URI			ANeBreB肷ׂURI
	 * @return	URIŎw肳ꂽANeBreB݂ȂꍇnullA
	 *			݂ꍇ"Choice"\ȏꍇutruevlAs\ȏꍇ́ufalsev
	 *			lԋp
	 */
	public Boolean canChoice(Activity activity, String URI) throws SystemException {
		if (activity == null) {
			activity = rootActivity;
		}

		if (activity.getIdentifier().equals(URI)) {
			return new Boolean(activity.canChoice());
		}

		Activity[] targets = activity.getAvailableChildren();

		if (targets != null) {
			for (int i = 0; i < targets.length; i++) {
				Boolean result = canChoice(targets[i], URI);

				if (result != null) {
					return result;
				}
			}
		}

		return null;
	}

	// 2010.10.05 taku-harada add >>
	/**
	 * w肳ꂽURIŎw肳ꂽActivity"Jump"\ǂ`FbN
	 *
	 * @param	activity	ANeBreBw肷Bg܂ގw肳ꂽz
	 *						ANeBreBURIp[^Ŏw肳ꂽANeBr
	 *						eBIDɈvANeBreBcanJump\bh̎
	 *						sʂԋpBnullw肳ꂽꍇ̓[gANeB
	 *						reB猟sB
	 * @param	URI			ANeBreB肷ׂURI
	 * @return	URIŎw肳ꂽANeBreB݂ȂꍇnullA
	 *			݂ꍇ"Jump"\ȏꍇutruevlAs\ȏꍇ́ufalsev
	 *			lԋp
	 */
	public Boolean canJump(Activity activity, String URI) throws SystemException {
		if (activity == null) {
			activity = rootActivity;
		}

		if (activity.getIdentifier().equals(URI)) {
			return new Boolean(activity.canJump());
		}

		Activity[] targets = activity.getAvailableChildren();

		if (targets != null) {
			for (int i = 0; i < targets.length; i++) {
				Boolean result = canJump(targets[i], URI);

				if (result != null) {
					return result;
				}
			}
		}

		return null;
	}
	// 2010.10.05 taku-harada add <<

	/**
	 * JgANeBreB̃ANeBreBID擾
	 *
	 * @return JgANeBreB̃ANeBreBIDԋpB
	 * 			JgANeBreB݂ȂꍇnullԋpB
	 */
	public String getActivityID() {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return null;
		}

		return currentActivity.getIdentifier();
	}

	/**
	 * [gANeBreB擾
	 *
	 * @return [gANeBreB
	 */
	public Activity getRootActivity() {
		return rootActivity;
	}

	/**
	 * JgANeBreBAuxiliaryResource擾<br>
	 *
	 * @return	JgANeBreBAuxiliaryResource̔zԋpB<br>
	 *			AuxiliaryResource݂Ȃꍇnullԋp<br>
	 */
	public AuxiliaryResource[] getAuxiliaryResources() throws SystemException {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return null;
		}

		return currentActivity.getAuxiliaryResources();
	}

	/**
	 * ނ̃^Cg擾
	 *
	 * @return	ނ̃^Cgԋp
	 */
	public String getTitle() throws SystemException {
		return kernel.getTitle();
	}

	/**
	 * JgANeBreBSCORMCommunicationModuleNX擾<br>
	 *
	 * @return	JgANeBreBSCORMCommunicationModuleԋpB<br>
	 *			JgANeBreB݂Ȃꍇnullԋp<br>
	 */
	public SCORMCommunicationModule getCommunicationModule() throws SystemException {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return null;
		}

		return currentActivity.getCommunicationModule();
	}

	/**
	 * JgANeBreB擾
	 *
	 * @return	JgANeBreBԋpBJgANeBreB
	 *			݂Ȃꍇnullԋp
	 */
	public Activity getCurrentActivity() {
		return kernel.getCurrentActivity();
	}

	/**
	 * JgANeBreB̋ލ\Ɏw肳ĂAu\Ă͂Ȃv
	 * {^̖̂̈ꗗ擾
	 *
	 * @return	JgANeBreBɁu{^\Ȃvw肪݂
	 *			ꍇtrue𑶍݂Ȃꍇfalseԋp
	 */
	public String[] getHideLMSUI() {
		Activity currentActivity = kernel.getCurrentActivity();

		if (currentActivity == null) {
			return null;
		}

		return currentActivity.getHideLMSUI();
	}

	/** f{ς݃tO */
	private boolean alreadyDiscontinued;

	/**
	 *	FolderFilter NX<br>
	 *	t@C̈ꗗfBNĝ݂𒊏õׂtB^<br>
	 */
	private static class FolderFilter implements FileFilter {
		/**
		 * w肳ꂽۃpXtH_ǂ`FbN
		 *
		 * @param	pathname	ۃpXw肷
		 * @return	pathnametH_̏ꍇtrueAłȂꍇfalseԋp
		 */
		public boolean accept(File pathname) {
			return pathname.isDirectory();
		}
	}

	/** fBNĝ݂tB^ׂ̃tB^ */
	private FolderFilter folderFilter = new FolderFilter();

	/**
	 *	AICCLogFilter NX<br>
	 *	t@C̈ꗗAICCOt@Ĉ݂𒊏õׂtB^<br>
	 */
	private static class AICCLogFilter implements FilenameFilter {
		/** .prm̃t@C */
		private String core;

		/** .int̃t@C */
		private String interaction;

		/** .cmt̃t@C */
		private String comment;

		/**
		 * RXgN^
		 *
		 * @param	activityID	ANeBreBIDw肷
		 */
		public AICCLogFilter(String activityID) {
			core = activityID + ".prm";
			interaction = activityID + ".int";
			comment = activityID + ".cmt";
		}

		/**
		 * .prm̃t@C擾
		 *
		 * @return .prm̃t@Cԋp
		 */
		public String getCoreName() {
			return core;
		}

		/**
		 * .int̃t@C擾
		 *
		 * @return .int̃t@Cԋp
		 */
		public String getInteractionName() {
			return interaction;
		}

		/**
		 * .cmt̃t@C擾
		 *
		 * @return .cmt̃t@Cԋp
		 */
		public String getCommentName() {
			return comment;
		}

		/**
		 * w肳ꂽt@CAICCOt@C .prm, .int, .cmt
		 * ǂ`FbN
		 *
		 * @param	dir		tH_w肷
		 * @param	name	t@Cw肷
		 * @return	AICCOt@C̏ꍇtrueAłȂꍇfalseԋp
		 */
		public boolean accept(File dir, String name) {
			return (name.equals(core) || name.equals(interaction) || name.equals(comment));
		}
	}

	/**
	 * fs<br>
	 * 1.doSuspendAlltOA"SuspendAll"R}hsĂꍇkernelɑ΂"SuspendAll"
	 * R}hsB<br>
	 * 2.AICCOt@CǂݍCSVsB<br>
	 * 3.g[XOXMLt@C쐬B(g͋)<br>
	 * 4.J[l璆f(XML)擾B<br>
	 * 5.EndLearnServletNB<br>
	 * 6.EndLearnServlet牞MB<br>
	 *
	 * @param	result			IRw肷"SUSPEND"̏ꍇ͒fA"EXIT"̏ꍇ͏IB
	 * @param	doSuspendAll	kernelɑ΂A"SuspendAll"R}hs邩ǂtO
	 */
	public void discontinue(String result, boolean doSuspendAll) throws IOException, ParserConfigurationException, SAXException, TransformerException, SequencingException, SystemException {

		// ɒfsς݂ǂ`FbN
		synchronized (this) {
			// ɏς݂̏ꍇ
			if (alreadyDiscontinued) {
				// I
				return;
			}

			// ufς݁vɐݒ肷
			alreadyDiscontinued = true;
		}

		// ----------------------------------------------------------------------
		// 1.doSuspendAlltOA"SuspendAll"R}hsĂꍇkernelɑ΂"SuspendAll"
		//   R}hsB
		// ----------------------------------------------------------------------
		
		// "SuspendAll"R}hsw肪Ăꍇ
		if (doSuspendAll) {

			// J[lĂȂA̓JgANeBreB݂Ȃꍇ
			if ((kernel == null) || (kernel.getCurrentActivity() == null)) {
				// "ABANDON"̉s
				responseAbandon(executeParameters, "ABANDON");

				// Is
				terminate();

				return;
			}
			else {
				// "SuspendAll"R}hs
				navigate("SuspendAll", null);

				// g[XO擾
				Document traceLog = getTraceLog();
				// g[XO݂ꍇ
				if (traceLog != null) {
					// g[XÕtpX쐬
					StringBuffer navtraceLogFile = new StringBuffer();

					navtraceLogFile.append(userIDPath(SG.get("ResumeDataBaseURL"), executeParameters.getUserID()));
					navtraceLogFile.append(File.separator);
					navtraceLogFile.append(executeParameters.getLOID());
					navtraceLogFile.append(File.separator);
					navtraceLogFile.append(executeParameters.getStudySessionCount());
					navtraceLogFile.append(File.separator);
					navtraceLogFile.append(executeParameters.getLaunchCount());
					navtraceLogFile.append(File.separator);
					navtraceLogFile.append("navtrace.xml");

					// g[XOuǉ[hvŃI[v
					BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(navtraceLogFile.toString(), true));

					try {
						// navtrace.xmlɃg[XOǉ
						XMLUtil.output(traceLog.getDocumentElement(), true, SG.get("XMLEncoding"), new StreamResult(bos));
					}
					finally {
						bos.close();
					}
				}
			}
		}

		// fO̊i[tH_쐬
		StringBuffer outputFolder = new StringBuffer();

		outputFolder.append(userIDPath(SG.get("ResumeDataBaseURL"), executeParameters.getUserID()));
		outputFolder.append(File.separator);
		outputFolder.append(executeParameters.getLOID());
		outputFolder.append(File.separator);
		outputFolder.append(executeParameters.getStudySessionCount());
		outputFolder.append(File.separator);
		// 2010.10.07 taku-harada mod >>
		//outputFolder.append(executeParameters.getLaunchCount());
		//outputFolder.append(File.separator);
		// 2010.10.07 taku-harada mod <<

		String outputFolderName = outputFolder.toString();

		// fO̊i[tH_쐬
		new File(outputFolderName).mkdirs();

		// 2010.10.07 taku-harada add >>
		// aiccO̊i[tH_쐬
		StringBuffer outputFolder_aicc = new StringBuffer();

		outputFolder_aicc.append(userIDPath(SG.get("ResumeDataBaseURL"), executeParameters.getUserID()));
		outputFolder_aicc.append(File.separator);
		outputFolder_aicc.append(executeParameters.getLOID());
		outputFolder_aicc.append(File.separator);
		outputFolder_aicc.append(executeParameters.getStudySessionCount());
		outputFolder_aicc.append(File.separator);
		outputFolder_aicc.append(executeParameters.getLaunchCount());
		outputFolder_aicc.append(File.separator);

		String outputFolderName_aicc = outputFolder_aicc.toString();

		// aiccO̊i[tH_쐬
		new File(outputFolderName_aicc).mkdirs();
		
		// 2010.10.07 taku-harada add <<

		String encoding = SG.get("XMLEncoding");

		// ----------------------------------------------------------------------
		// 2.AICCOt@CǂݍCSVsB
		// ----------------------------------------------------------------------
		
		// aicc.csv쐬
		ArrayList aiccCSV = createAICCLog();

		// 2010.10.07 taku-harada mod >>
		// aicc.csvt@C̃tpX쐬
		//String aiccCsvFileName = outputFolderName + "aicc.csv";
		String aiccCsvFileName = outputFolderName_aicc + "aicc.csv";
		// 2010.10.07 taku-harada mod <<
		
		// FileNXݒ
		File aiccCsvFile = new File(aiccCsvFileName) ;
		
		// aicc.csvt@CBufferedOutputStream쐬
		PrintWriter pw = null;
		try {
			pw = new PrintWriter( new BufferedWriter(new FileWriter(aiccCsvFileName)) );
		
			for (int i = 0 ; i < aiccCSV.size() ; i++ )
			{
				pw.println(aiccCSV.get(i));
			}
		}
		finally {
			try {
				if (pw != null) {
					pw.close();
				}
			} catch (Exception e) {}
		}
		
		// ----------------------------------------------------------------------
		// 3.g[XOXMLt@C쐬B
		// ----------------------------------------------------------------------
		
		// FileNXݒ
		File traceLogFile = new File(outputFolderName + "trace.xml") ;		
		// trace.xml쐬
		createTraceLogDocument(outputFolderName , encoding, result);
		
		// ----------------------------------------------------------------------
		// 4.J[l璆f(XML)擾B
		// ----------------------------------------------------------------------

		// <resume>^O쐬
		Document resumeDoc = XMLUtil.createDocument("resume", false);
		kernel.save(resumeDoc);
		
		// resume.xmlt@C̃tpX쐬
		String resumeLogFileName = outputFolderName + "resume.xml";
		
		// 쐬xml"resume.xml"֏o͂
		File resumeXMLFile = new File(resumeLogFileName);

		// resume.xmlt@CBufferedOutputStream쐬
		BufferedOutputStream resumeBos = new BufferedOutputStream(new FileOutputStream(resumeXMLFile));

		try {
			XMLUtil.output(resumeDoc.getDocumentElement(), false, encoding, new StreamResult(resumeBos));
		}
		finally {
			resumeBos.close();
		}
		
		// iԂƊԂ擾
		boolean satisfied = false;

		if (rootActivity.getObjectiveProgressStatus()) {
			satisfied = rootActivity.getObjectiveSatisfiedStatus();
		}

		boolean completion = false;

		if (rootActivity.getAttemptProgressStatus()) {
			completion = rootActivity.getAttemptCompletionStatus();
		}

		// ----------------------------------------------------------------------
		// 5.EndLearnServletNAMB<br>
		// 6.EndLearnServlet牞MB<br>
		// ----------------------------------------------------------------------
		// EndLearnServletւURL쐬
		StringBuffer endLearnServletURL = new StringBuffer();

		endLearnServletURL.append(executeParameters.getEndLearnServletURL());
		endLearnServletURL.append("?");
		endLearnServletURL.append(executeParameters.makeEndLearnServletURLParameters(SG.get("ManagerEncoding")));
		endLearnServletURL.append("&Reason=");
		endLearnServletURL.append(result);
		endLearnServletURL.append("&satisfied=");
		endLearnServletURL.append(satisfied);
		endLearnServletURL.append("&completion=");
		endLearnServletURL.append(completion);

		// EndLearnServlet֐ڑ
		URLConnection uc = new URL(endLearnServletURL.toString()).openConnection();

		// Output:ALbV:ȂAContent-Type: text/plain
		uc.setDoOutput(true);
		uc.setUseCaches(false);
		uc.setRequestProperty("Content-Type", "text/plain");

		// Input:
		uc.setDoInput(true);

		OutputStream os = null;
		InputStream is = null;
		
		// "navtrace.xml"̃t@CCX^X쐬
		File navTraceFile = new File(outputFolderName + "navtrace.xml");

		//
		// 쐬t@CEndLearnServlet֑M
		//
		try {
// g[XO֘AύX ADD from '07/02/01
			// g[XOML擾 
			String TraceSend = null;
			try {
				TraceSend = SG.get("TraceLogSend");
			} catch (Exception e) {
				// 擾G[̓ftHgƂđMݒ
				TraceSend = "1";
			}
// g[XO֘AύX ADD to '07/02/01

			int aiccCount = aiccCSV.size() ;
// g[XO֘AύX MOD from '07/02/01
//			int traceCount = getFileRecordCount(traceLogFile) ;
//			int navtraceCount = getFileRecordCount(navTraceFile) ;
			// g[XO
			int traceCount = 0;
			int navtraceCount = 0 ;

			// g[XOML
			if (!"0".equals(TraceSend)) {
				// Mꍇ
				traceCount = getFileRecordCount(traceLogFile);
				navtraceCount = getFileRecordCount(navTraceFile);
			}
// g[XO֘AύX MOD to '07/02/01
			int resumeCount = getFileRecordCount(resumeXMLFile) ;
			String countString = 
				resumeCount + "," + aiccCount + ","  + traceCount + "," + navtraceCount + "\r\n" ;

			// M̐ݒ
			os = uc.getOutputStream();

			// s𑗐M
			os.write( countString.getBytes() ) ;

			// M͈ȉ̏ɍs
		    // PDf
		    // QDwKO
			// RDg[X
		    // SDnavtrace

			// fO𑗐M
			sendFile(resumeXMLFile, os);
			
			// wKO𑗐M
			sendFile(aiccCsvFile, os);

// g[XO֘AύX MOD from '07/02/01
			// g[XO𑗐M
//			sendFile(traceLogFile, os);
//			sendFile(navTraceFile, os);
			// g[XOML
			if (!"0".equals(TraceSend)) {
				// Mꍇ
				sendFile(traceLogFile, os);
				sendFile(navTraceFile, os);
			}
// g[XO֘AύX MOD to '07/02/01

			// ʂ󂯎ׂInputStream擾
			is = uc.getInputStream();

			// EndLearnServlet珈ʂ擾
			Document endLearnServletResult = XMLUtil.createDocument(is, false);

			// ʕ擾
			Node xmsResult = XPathUtil.selectSingleChildNode(endLearnServletResult.getDocumentElement(), "text()");

			// ʂuvłȂꍇ́ASystemExceptionthrow
			if ((xmsResult == null) || (!xmsResult.getNodeValue().equals("OK"))) {
				StringWriter sw = new StringWriter();

				XMLUtil.output(endLearnServletResult.getDocumentElement(), true, null, new StreamResult(sw));
				throw new SystemException("EndLearnServlet̉sł[" + sw.toString() + "]");
			}
// g[XO֘AύX ADD from '07/02/01
			// ړt@CpX擾
			StringBuffer moveDirPath = new StringBuffer();
			
// 32000 Ή 20071027
			//moveDirPath.append(SG.get("ResumeDataBaseURL"));
			//moveDirPath.append(executeParameters.getUserID());
			moveDirPath.append(userIDPath(SG.get("ResumeDataBaseURL"), executeParameters.getUserID()));
			moveDirPath.append(File.separator);
// 32000 Ή 20071027

			moveDirPath.append(File.separator);
			moveDirPath.append(executeParameters.getLOID());

			// g[XOړ
			moveFIle(moveDirPath.toString(), traceLogFile);
			moveFIle(moveDirPath.toString(), navTraceFile);
// g[XO֘AύX ADD to '07/02/01
		}
		finally {
			// InputStream̃N[Y
			if (is != null) {
				try {
					is.close();
				}
				catch (IOException ex) {
					Debug.write(ex);

					ex.printStackTrace(System.out);
				}
			}

			// OutputStream̃N[Y
			if (os != null) {
				try {
					os.close();
				}
				catch (IOException ex) {
					Debug.write(ex);

					ex.printStackTrace(System.out);
				}
			}

			// GW̏I
			try {
				terminate();
			}
			catch (Exception ex) {
				Debug.write(ex);

				ex.printStackTrace(System.out);
			}
		}
	}

// g[XO֘AύX moveFIle\bh@ADD from '07/02/01
	/**
	 * t@Cړ܂BŎw肳ꂽړt@CړpXֈړ܂B<br>
	 * ړɓt@Cɑ݂ꍇAړt@C폜Aړ܂B
	 * @param moveDirPath ړt@CpX
	 * @param traceLogFile ړt@C
	 */
	private void moveFIle(String moveDirPath, File traceLogFile) {
		// ړt@C擾
		String strFileName = traceLogFile.getName();

		// ړt@C݃`FbN
		File toFile = new File(moveDirPath, strFileName);

		if (toFile.isFile()) {
			// t@C݂ꍇAt@C폜
			if (!toFile.delete()) {
				// ړt@C폜G[ 
				Debug.write("file delete Error(" + moveDirPath + "/" + strFileName + ")");
			}
		}
		// t@Cړ(l[)
		if (!traceLogFile.renameTo(toFile)) {
			// l[G[
			Debug.write("file renameTo Error(" + moveDirPath + "/" + strFileName + ")");
		}
	}

// g[XO֘AύX moveFIle\bh@ADD to '07/02/01
	/**
	 * t@C𑗐M
	 * @param f t@C
	 * @param os o͐
	 * @param buffer obt@
	 * @throws IOException
	 */
	private void sendFile(File f, OutputStream os)
	throws IOException {
		
		BufferedInputStream bis = null ;
		byte[] buffer = new byte[4096];
		
		try
		{
			bis = new BufferedInputStream(new FileInputStream(f));
			while (true) {
				int length = bis.read(buffer);
				if (length == -1) {
					break;
				}
				os.write(buffer, 0, length);
			}
		}
		catch (FileNotFoundException ex)
		{
			// t@CȂꍇ͑MȂiG[Ƃ͂Ȃj
		}
		catch (IOException ex)
		{
			throw ex ;
		}
		finally
		{
			// ̓Xg[
			if ( bis != null )
			{
				try
				{
					bis.close() ;
				}
				finally{}
			}
		}
	}

	/**
	 * t@C̍s擾
	 * @param f t@C
	 * @return s
	 * @throws IOException
	 */
	private static int getFileRecordCount(File f) 
	throws IOException
	{
		int lineCount = 0;

		try {
			// t@Cǂݍ
			BufferedReader reader = new BufferedReader( new FileReader(f) );
			// Ss[v
			while(true) {
				String line = reader.readLine();
				if(line==null) break;
				lineCount++;
			}
			reader.close();
		}
		catch(FileNotFoundException ex){}
		catch(IOException ex) {}
		
		return lineCount ;
	
	}
	
	/**
	 * ނ̋Ns<br>
	 * EndLearnServlet̋NsAXMSUɋNsʒm
	 *
	 * @param executeParameters	Np[^
	 * @param result Rw肷
	 */
	public static void responseAbandon(ExecuteParameters executeParameters, String result) throws UnsupportedEncodingException, IOException, ParserConfigurationException, SAXException {

		// EndLearnServletւURL쐬
		StringBuffer endLearnServletURL = new StringBuffer();

		endLearnServletURL.append(executeParameters.getEndLearnServletURL());
		endLearnServletURL.append("?");
		endLearnServletURL.append(executeParameters.makeEndLearnServletURLParameters(SG.get("ManagerEncoding")));
		endLearnServletURL.append("&Reason=");
		endLearnServletURL.append(result);

		// EndLearnServlet֐ڑ
		URLConnection uc = new URL(endLearnServletURL.toString()).openConnection();

		// Output:ȂALbV:ȂAContent-Type: text/xml
		uc.setDoOutput(false);
		uc.setUseCaches(false);
		uc.setRequestProperty("Content-Type", "text/xml");

		// Input:
		uc.setDoInput(true);

		InputStream is = null;

		try {
			// EndLearnServlet̉M
			is = uc.getInputStream();
			XMLUtil.createDocument(is, false);
		}
		finally {
			// InputStream̃N[Y
			if (is != null) {
				try {
					is.close();
				}
				catch (IOException ex) {
					Debug.write(ex);

					ex.printStackTrace(System.out);
				}
			}
		}
	}

	/**
	 * AICCOXMS֑MCSV쐬
	 *
	 * @return AICCOiCSVj
	 */
	private ArrayList createAICCLog()
		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException {

		// AICCOt@Ci[ĂfBNg̃x[XfBNg쐬
		StringBuffer baseLogFolderName = new StringBuffer();

		baseLogFolderName.append(userIDPath(SG.get("LearningLogBaseURL"), executeParameters.getUserID()));
		baseLogFolderName.append(File.separator);
		baseLogFolderName.append(executeParameters.getLOID());
		baseLogFolderName.append(File.separator);
		baseLogFolderName.append(executeParameters.getStudySessionCount());
		baseLogFolderName.append(File.separator);
		baseLogFolderName.append(executeParameters.getLaunchCount());

		File baseLogFolder = new File(baseLogFolderName.toString());

		// ŏIIɕۑCSVf[^
		ArrayList outputCSV = new ArrayList() ;
		
		// activity id̃tH_ꗗ擾
		File[] activityIDs = baseLogFolder.listFiles(folderFilter);
		for (int i = 0; i < activityIDs.length; i++) {

			// [1]ActivityID
			String activityID = activityIDs[i].getName() ;

			// attempt񐔂̃tH_ꗗ擾
			File[] attempts = activityIDs[i].listFiles(folderFilter);
			for (int j = 0; j < attempts.length; j++) {
				// CSṼXg
				String attemptCSV = null ;
				ArrayList interactionCSV = null ;
				ArrayList learnerCommentCSV = null ;
				ArrayList lmsCommentCSV = null ;
				ArrayList objectivesCSV = null ;

				int _attemptCount = Integer.parseInt(attempts[j].getName());

				// attempt count0(ȉ)̃O͔j
				if (_attemptCount <= 0) {
					continue;
				}

				// [2]attempt
				String attemptCount = Integer.toString(_attemptCount) ;

				// attempt̃tH_ꗗ擾
				File[] attemptDates = attempts[j].listFiles(folderFilter);
				for (int k = 0; k < attemptDates.length; k++) {
					
					// [3]attempt
					String learnDate = attemptDates[k].getName() ;

					AICCLogFilter filter = new AICCLogFilter(activityIDs[i].getName());

					// AICCOt@C̈ꗗ擾
					File[] aiccLogs = attemptDates[k].listFiles(filter);
					for (int l = 0; l < aiccLogs.length; l++) {
						// .prm
						if (filter.getCoreName().equals(aiccLogs[l].getName())) {
							// attempt쐬
							attemptCSV = createAttemptCSV(
									aiccLogs[l], 
									activityID, 
									attemptCount, 
									learnDate);
							// objectives쐬
							objectivesCSV = createObjectiveCSV(
									aiccLogs[l], 
									activityID, 
									attemptCount, 
									learnDate) ;
						}
						
						// .int
						else if (filter.getInteractionName().equals(aiccLogs[l].getName())) {
							// interactions쐬
							interactionCSV = createInteractionCSV(
									aiccLogs[l], 
									activityID, 
									attemptCount, 
									learnDate);
						}
						// .cmt
						else if (filter.getCommentName().equals(aiccLogs[l].getName())) {
							// lmscomments쐬
							learnerCommentCSV = createCommentCSV(
									aiccLogs[l], 
									activityID, 
									attemptCount, 
									learnDate);
						}
					}
				}
				
				// ꂽCSVЂƂɂ܂Ƃ߂ĕۑĂ
				if ( attemptCSV != null )
				{
					outputCSV.add(attemptCSV) ;
				}

				if ( interactionCSV != null )
				{
					for ( int row = 0 ; row < interactionCSV.size() ; row ++ )
					{
						outputCSV.add(interactionCSV.get(row)) ;
					}
				}

				if ( learnerCommentCSV != null )
				{
					for ( int row = 0 ; row < learnerCommentCSV.size() ; row ++ )
					{
						outputCSV.add(learnerCommentCSV.get(row)) ;
					}
				}

				if ( lmsCommentCSV != null )
				{
					for ( int row = 0 ; row < lmsCommentCSV.size() ; row ++ )
					{
						outputCSV.add(lmsCommentCSV.get(row)) ;
					}
				}

				if ( objectivesCSV != null )
				{
					for ( int row = 0 ; row < objectivesCSV.size() ; row ++ )
					{
						outputCSV.add(objectivesCSV.get(row)) ;
					}
				}					
				
			}
		}
		
		return outputCSV ;
	}

	/**
	 * /**
	 * AICCOt@C(.prm)XMS֑MCSV쐬
	 *
	 * @param aiccLog					XMLAICCOt@Cw肷B
	 * @param activityID 				ActivityID
	 * @param attemptCount 				s
	 * @param learnDate 				wK
	 * @param outAttemptRow 		attempts
	 * @param outObjectiveRowList 	objectivessz
	 * @throws UnsupportedEncodingException
	 * @throws FileNotFoundException
	 * @throws SystemException
	 * @throws IOException
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 * @throws TransformerException
	 */
	private String createAttemptCSV(
			File aiccLog, 
			String activityID, 
			String attemptCount, 
			String learnDate)
		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException 
	{

		// CSVi[ϐ
		EndLearnAICCData attemptCSV = 
			new EndLearnAICCData( activityID, attemptCount, learnDate, EndLearnAICCData.TABLE_KIND_ATTEMPT ) ;
		
		String ret = "" ;
		
		HashMap map;
		String value;
		String[] seps;

		// .prmt@CWJ
		AICCLogForProperties coreFile = new AICCLogForProperties();

		coreFile.initialize(aiccLog.getPath());

		// [Core]ZNV擾
		map = coreFile.get("Core");

		// [Core]ZNV݂ꍇ
		if (map != null) {
			
			// CSVۑtB[h̒l
			String compStatus 	= "" ;
			String scoreScaled 	= "" ;
			String scoreRaw 	= "" ;
			String scoreMax		= "" ;
			String scoreMin		= "" ;
			String sessionTime	= "" ;
			String successStatus= "" ;
			String location		= "" ;
			String exit			= "" ;
			
			// Lesson_Status擾
			value = (String)map.get("Lesson_Status");
			if ((value != null) && (value.length() > 0)) {
				seps = value.split(",");

				if (seps.length >= 2) {
					compStatus = seps[1] ;
				}
				
				if (seps.length >= 1) {
					successStatus = seps[0] ;
				}

				if (seps.length >= 3) {
					exit = seps[2] ;
				}
			}

			// Score擾
			value = (String)map.get("Score");
			if ((value != null) && (value.length() > 0)) {

				seps = value.split(",");

				if (seps.length >= 1) {
					scoreScaled = seps[0] ;
				}

				if (seps.length >= 2) {
					scoreRaw = seps[1] ;
				}

				if (seps.length >= 3) {
					scoreMax = seps[2] ;
				}

				if (seps.length >= 4) {
					scoreMin = seps[3] ;
				}
			}

			// Time擾
			value = (String)map.get("Time");
			if (value != null) {
				sessionTime = value ;
			}

			// Lesson_Location擾
			value = (String)map.get("Lesson_Location");
			if (value != null) {
				location = value ;
			}

			// CSVf[^Ƃĕۑ
			// CSVtH[}bgɏ]ďԂɒǉ邱ƁI
			attemptCSV.addFieldData(compStatus) ;
			attemptCSV.addFieldData(scoreScaled) ;
			attemptCSV.addFieldData(scoreRaw) ;
			attemptCSV.addFieldData(scoreMax) ;
			attemptCSV.addFieldData(scoreMin) ;
			attemptCSV.addFieldData(sessionTime) ;
			attemptCSV.addFieldData(successStatus) ;
			attemptCSV.addFieldData(location) ;
			attemptCSV.addFieldData(exit) ;
			
			// ߂lɐݒ
			ret = attemptCSV.getCSVDataRow() ;
		}
		
		return ret ;
	}


	/**
	 * /**
	 * AICCOt@C(.prm)XMS֑MCSV쐬
	 *
	 * @param aiccLog					XMLAICCOt@Cw肷B
	 * @param activityID 				ActivityID
	 * @param attemptCount 				s
	 * @param learnDate 				wK
	 * @param outAttemptRow 		attempts
	 * @param outObjectiveRowList 	objectivessz
	 * @throws UnsupportedEncodingException
	 * @throws FileNotFoundException
	 * @throws SystemException
	 * @throws IOException
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 * @throws TransformerException
	 */
	private ArrayList createObjectiveCSV(
			File aiccLog, 
			String activityID, 
			String attemptCount, 
			String learnDate)
		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException 
	{

		HashMap map;
		String value;
		String[] seps;
		
		// .prmt@CWJ
		AICCLogForProperties coreFile = new AICCLogForProperties();

		coreFile.initialize(aiccLog.getPath());
		
		// [Objectives_Status]ZNV擾
		map = coreFile.get("Objectives_Status");
		
		// Ssi[Xg̏
		ArrayList ret = new ArrayList() ;

		if (map != null) {
			for (int i = 0;; i++) {
				// J_ID.n ݂邩ǂ`FbN
				value = (String)map.get("J_ID." + (i + 1));

				// J_ID.n݂ȂȂ_break
				if (value == null) {
					break;
				}

				// CSVi[ϐ
				String id 				= value ;
				String scoreScaled 		= "" ;
				String scoreRaw 		= "" ;
				String scoreMax			= "" ;
				String scoreMin			= "" ;
				String successStatus	= "" ;
				String completionStatus = "" ;

				// J_Score.n擾
				value = (String)map.get("J_Score." + (i + 1));

				if ((value != null) && (value.length() > 0)) {

					seps = value.split(",");

					if (seps.length >= 1) {
						scoreScaled = seps[0] ;
					}

					if (seps.length >= 2) {
						scoreRaw = seps[1] ;
					}

					if (seps.length >= 3) {
						scoreMax = seps[2] ;
					}

					if (seps.length >= 4) {
						scoreMin = seps[3] ;
					}
				}

				// J_Status.n擾
				value = (String)map.get("J_Status." + (i + 1));
				if ((value != null) && (value.length() > 0)) {
					seps = value.split(",");

					if (seps.length >= 1) {
						successStatus =  seps[0] ;
					}

					if (seps.length >= 2) {
						completionStatus = seps[1];
					}
				}
				
				// CSVf[^Ƃĕۑ
				EndLearnAICCData objectiveCSV = 
					new EndLearnAICCData( activityID, attemptCount, learnDate, EndLearnAICCData.TABLE_KIND_OBJECTIVES ) ;

				// CSVtH[}bgɏ]ďԂɒǉ邱ƁI
				objectiveCSV.addFieldData(id) ;
				objectiveCSV.addFieldData(scoreScaled) ;
				objectiveCSV.addFieldData(scoreRaw) ;
				objectiveCSV.addFieldData(scoreMin) ;
				objectiveCSV.addFieldData(scoreMax) ;
				objectiveCSV.addFieldData(successStatus) ;
				objectiveCSV.addFieldData(completionStatus) ;

				// ߂lɐݒ
				ret.add(objectiveCSV.getCSVDataRow()) ;
			}
		}
		
		return ret;
	}

	/**
	 * AICCOt@C(.int)XMS֑MXML쐬
	 *
	 * @param doc			<aicc>^O[g^ODOM Documentw肷B{
	 *						p[^learnSessionp[^Owner Document
	 *						Ȃ΂ȂȂB<br>
	 * @param learnSession	<learnsession>^Ow肷B
	 * @param aiccLog		XMLAICCOt@Cw肷B
	 */
	private ArrayList createInteractionCSV(
			File aiccLog,
			String activityID, 
			String attemptCount, 
			String learnDate)
		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException {

		// .intt@CWJ
		AICCLogForCSV interactionFile = new AICCLogForCSV();

		interactionFile.initialize(aiccLog.getPath());

		int max = interactionFile.size();

		ArrayList ret = new ArrayList(max) ;

		for (int i = 0; i < max; i++) {

			EndLearnAICCData interactionCSV = 
				new EndLearnAICCData(activityID, attemptCount, learnDate, EndLearnAICCData.TABLE_KIND_INTERACTION) ;

			String[] data = interactionFile.get(i);

			interactionCSV.addFieldData( data[1] ) ; // id
			interactionCSV.addFieldData( data[3] ) ; // type
			interactionCSV.addFieldData( data[2] ) ; // objectiveid
			interactionCSV.addFieldData( data[0] ) ; // timestamp
			
			String[] correctResponses = data[4].split(";");
			for ( int j = 0 ; j < 5 ; j++ )
			{
				if ( j < correctResponses.length )
				{
					interactionCSV.addFieldData(correctResponses[j]) ;	// correctResponses
				}
				else
				{
					interactionCSV.addFieldData("") ;
				}
			}
			
			interactionCSV.addFieldData( data[7] ) ; // weighting
			interactionCSV.addFieldData( data[5] ) ; // learnerresponse
			interactionCSV.addFieldData( data[6] ) ; // result 
			interactionCSV.addFieldData( data[8] ) ; // latency 
			interactionCSV.addFieldData( data[9] ) ; // description
			
			// ߂lɐݒ
			ret.add(interactionCSV.getCSVDataRow()) ;
		}
		
		return ret ;
	}

	/**
	 * AICCOt@C(.cmt)XMS֑MCSV쐬
	 *
	 * @param doc			<aicc>^O[g^ODOM Documentw肷B{
	 *						p[^learnSessionp[^Owner Document
	 *						Ȃ΂ȂȂB<br>
	 * @param learnSession	<learnsession>^Ow肷B
	 * @param aiccLog		XMLAICCOt@Cw肷B
	 */
	private ArrayList createCommentCSV(
			File aiccLog,
			String activityID, 
			String attemptCount, 
			String learnDate)
		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException {

		// .cmtt@CWJ
		AICCLogForCSV commentFile = new AICCLogForCSV();

		commentFile.initialize(aiccLog.getPath());

		int max = commentFile.size();

		ArrayList ret = new ArrayList(max) ;

		for (int i = 0; i < max; i++) {
			// learnercomment쐬
			String[] data = commentFile.get(i);

			EndLearnAICCData commentCSV = 
				new EndLearnAICCData(activityID, attemptCount, learnDate, EndLearnAICCData.TABLE_KIND_LEARNER_COMMENT) ;
			
			commentCSV.addFieldData(data[2]) ;	// comment
			commentCSV.addFieldData(data[1]) ;	// location
			commentCSV.addFieldData(data[0]) ;	// datetime
			
			// ߂lɐݒ
			ret.add(commentCSV.getCSVDataRow()) ;
		}
		
		return ret ;
	}

	// CommentOut Start 2006.11.27 T.Kiyokawa
//	/**
//	 * AICCOXMS֑MXML쐬
//	 *
//	 * @param doc			g[XOǉDOM Documentw肷
//	 * @param parent		<tracelog>^Oݒ肷(e)Ggw肷
//	 */
//	private void createAICCLog(Document doc, Element parent)
//		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException {
//
//		// AICCOt@Ci[ĂfBNg̃x[XfBNg쐬
//		StringBuffer baseLogFolderName = new StringBuffer();
//
//		baseLogFolderName.append(SG.get("LearningLogBaseURL"));
//		baseLogFolderName.append(executeParameters.getUserID());
//		baseLogFolderName.append(File.separator);
//		baseLogFolderName.append(executeParameters.getLOID());
//		baseLogFolderName.append(File.separator);
//		baseLogFolderName.append(executeParameters.getStudySessionCount());
//		baseLogFolderName.append(File.separator);
//		baseLogFolderName.append(executeParameters.getLaunchCount());
//
//		File baseLogFolder = new File(baseLogFolderName.toString());
//
//		// <aicc>^O쐬
//		Element aicc = XMLUtil.append(doc, parent, "aicc");
//
//		// activity id̃tH_ꗗ擾
//		File[] activityIDs = baseLogFolder.listFiles(folderFilter);
//		for (int i = 0; i < activityIDs.length; i++) {
//			// <scoactivitylog>^O쐬
//			Element SCOActivityLog = XMLUtil.appendChild(doc, aicc, XMLUtil.insertAttribute(doc, "scoactivitylog", new Attr[] { XMLUtil.createAttribute(doc, "id", activityIDs[i].getName()), }));
//
//			// attempt񐔂̃tH_ꗗ擾
//			File[] attempts = activityIDs[i].listFiles(folderFilter);
//			for (int j = 0; j < attempts.length; j++) {
//				int _attemptCount = Integer.parseInt(attempts[j].getName());
//
//				// attempt count0(ȉ)̃O͔j
//				if (_attemptCount <= 0) {
//					continue;
//				}
//
//				// <attemptcount>^O쐬
//				Element attemptCount =
//					XMLUtil.appendChild(doc, SCOActivityLog, XMLUtil.insertAttribute(doc, "attemptcount", new Attr[] { XMLUtil.createAttribute(doc, "count", Integer.toString(_attemptCount)), }));
//
//				// attempt̃tH_ꗗ擾
//				File[] attemptDates = attempts[j].listFiles(folderFilter);
//				for (int k = 0; k < attemptDates.length; k++) {
//					// <learnsession>^O쐬
//					Element learnSession =
//						XMLUtil.appendChild(doc, attemptCount, XMLUtil.insertAttribute(doc, "learnsession", new Attr[] { XMLUtil.createAttribute(doc, "date", attemptDates[k].getName()), }));
//
//					AICCLogFilter filter = new AICCLogFilter(activityIDs[i].getName());
//
//					// AICCOt@C̈ꗗ擾
//					File[] aiccLogs = attemptDates[k].listFiles(filter);
//					for (int l = 0; l < aiccLogs.length; l++) {
//						// .prm
//						if (filter.getCoreName().equals(aiccLogs[l].getName())) {
//							// <attempt>^O쐬
//							setCore(doc, learnSession, aiccLogs[l]);
//						}
//						// .int
//						else if (filter.getInteractionName().equals(aiccLogs[l].getName())) {
//							// <interactions>^O쐬
//							setInteraction(doc, learnSession, aiccLogs[l]);
//						}
//						// .cmt
//						else if (filter.getCommentName().equals(aiccLogs[l].getName())) {
//							// <lmscomments>^O쐬
//							setComment(doc, learnSession, aiccLogs[l]);
//						}
//					}
//				}
//			}
//		}
//	}
//
//	/**
//	 * AICCOt@C(.prm)XMS֑MXML쐬
//	 *
//	 * @param doc			<aicc>^O[g^ODOM Documentw肷B{
//	 *						p[^learnSessionp[^Owner Document
//	 *						Ȃ΂ȂȂB<br>
//	 * @param learnSession	<learnsession>^Ow肷B
//	 * @param aiccLog		XMLAICCOt@Cw肷B
//	 */
//	private void setCore(Document doc, Element learnSession, File aiccLog)
//		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException {
//
//		HashMap map;
//		String value;
//		String[] seps;
//
//		// .prmt@CWJ
//		AICCLogForProperties coreFile = new AICCLogForProperties();
//
//		coreFile.initialize(aiccLog.getPath());
//
//		// <attempt>^O쐬
//		Element attempt = XMLUtil.append(doc, learnSession, "attempt");
//
//		// [Core]ZNV擾
//		map = coreFile.get("Core");
//
//		// [Core]ZNV݂ꍇ
//		if (map != null) {
//			// Lesson_Status擾
//			value = (String)map.get("Lesson_Status");
//			if ((value != null) && (value.length() > 0)) {
//				seps = value.split(",");
//
//				if (seps.length >= 1) {
//					XMLUtil.append(doc, attempt, XMLUtil.createElement(doc, "successstatus", seps[0]));
//				}
//
//				if (seps.length >= 2) {
//					XMLUtil.append(doc, attempt, XMLUtil.createElement(doc, "completionstatus", seps[1]));
//				}
//
//				if (seps.length >= 3) {
//					XMLUtil.append(doc, attempt, XMLUtil.createElement(doc, "exit", seps[2]));
//				}
//			}
//
//			// Score擾
//			value = (String)map.get("Score");
//			if ((value != null) && (value.length() > 0)) {
//				Element score = XMLUtil.append(doc, attempt, "score");
//
//				seps = value.split(",");
//
//				if (seps.length >= 1) {
//					XMLUtil.append(doc, score, XMLUtil.createElement(doc, "scaled", seps[0]));
//				}
//
//				if (seps.length >= 2) {
//					XMLUtil.append(doc, score, XMLUtil.createElement(doc, "raw", seps[1]));
//				}
//
//				if (seps.length >= 3) {
//					XMLUtil.append(doc, score, XMLUtil.createElement(doc, "max", seps[2]));
//				}
//
//				if (seps.length >= 4) {
//					XMLUtil.append(doc, score, XMLUtil.createElement(doc, "min", seps[3]));
//				}
//			}
//
//			// Time擾
//			value = (String)map.get("Time");
//			if (value != null) {
//				XMLUtil.append(doc, attempt, XMLUtil.createElement(doc, "sessiontime", value));
//			}
//
//			// Lesson_Location擾
//			value = (String)map.get("Lesson_Location");
//			if (value != null) {
//				XMLUtil.append(doc, attempt, XMLUtil.createElement(doc, "location", value));
//			}
//		}
//
//		// <objectives>^O쐬
//		Element objectives = XMLUtil.append(doc, learnSession, "objectives");
//
//		// [Objectives_Status]ZNV擾
//		map = coreFile.get("Objectives_Status");
//		if (map != null) {
//			for (int i = 0;; i++) {
//				// J_ID.n ݂邩ǂ`FbN
//				value = (String)map.get("J_ID." + (i + 1));
//
//				// J_ID.n݂ȂȂ_break
//				if (value == null) {
//					break;
//				}
//
//				// <objective>^O쐬
//				Element objective = XMLUtil.append(doc, objectives, "objective");
//
//				// <id>^O쐬
//				XMLUtil.append(doc, objective, XMLUtil.createElement(doc, "id", value));
//
//				// J_Score.n擾
//				value = (String)map.get("J_Score." + (i + 1));
//
//				if ((value != null) && (value.length() > 0)) {
//					Element score = XMLUtil.append(doc, objective, "score");
//
//					seps = value.split(",");
//
//					if (seps.length >= 1) {
//						XMLUtil.append(doc, score, XMLUtil.createElement(doc, "scaled", seps[0]));
//					}
//
//					if (seps.length >= 2) {
//						XMLUtil.append(doc, score, XMLUtil.createElement(doc, "raw", seps[1]));
//					}
//
//					if (seps.length >= 3) {
//						XMLUtil.append(doc, score, XMLUtil.createElement(doc, "max", seps[2]));
//					}
//
//					if (seps.length >= 4) {
//						XMLUtil.append(doc, score, XMLUtil.createElement(doc, "min", seps[3]));
//					}
//				}
//
//				// J_Status.n擾
//				value = (String)map.get("J_Status." + (i + 1));
//				if ((value != null) && (value.length() > 0)) {
//					seps = value.split(",");
//
//					if (seps.length >= 1) {
//						XMLUtil.append(doc, objective, XMLUtil.createElement(doc, "successstatus", seps[0]));
//					}
//
//					if (seps.length >= 2) {
//						XMLUtil.append(doc, objective, XMLUtil.createElement(doc, "completionstatus", seps[1]));
//					}
//				}
//			}
//		}
//	}
//
//	/**
//	 * AICCOt@C(.int)XMS֑MXML쐬
//	 *
//	 * @param doc			<aicc>^O[g^ODOM Documentw肷B{
//	 *						p[^learnSessionp[^Owner Document
//	 *						Ȃ΂ȂȂB<br>
//	 * @param learnSession	<learnsession>^Ow肷B
//	 * @param aiccLog		XMLAICCOt@Cw肷B
//	 */
//	private void setInteraction(Document doc, Element learnSession, File aiccLog)
//		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException {
//
//		// .intt@CWJ
//		AICCLogForCSV interactionFile = new AICCLogForCSV();
//
//		interactionFile.initialize(aiccLog.getPath());
//
//		// <interactions>^O쐬
//		Element interactions = XMLUtil.append(doc, learnSession, "interactions");
//
//		int max = interactionFile.size();
//
//		for (int i = 0; i < max; i++) {
//			// <interaction>^O쐬
//			Element interaction = XMLUtil.append(doc, interactions, "interaction");
//
//			String[] data = interactionFile.get(i);
//
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "id", data[1]));
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "type", data[3]));
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "objectiveid", data[2]));
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "timestamp", data[0]));
//
//			Element correctResponses = XMLUtil.append(doc, interaction, "correctresponses");
//
//			String[] seps = data[4].split(";");
//			for (int j = 0;(j < seps.length) && (j < 5); j++) {
//				XMLUtil.append(doc, correctResponses, XMLUtil.createElement(doc, "pattern" + (j + 1), seps[j]));
//			}
//
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "weighting", data[7]));
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "learnerresponse", data[5]));
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "result", data[6]));
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "latency", data[8]));
//			XMLUtil.append(doc, interaction, XMLUtil.createElement(doc, "description", data[9]));
//		}
//	}
//
//	/**
//	 * AICCOt@C(.cmt)XMS֑MXML쐬
//	 *
//	 * @param doc			<aicc>^O[g^ODOM Documentw肷B{
//	 *						p[^learnSessionp[^Owner Document
//	 *						Ȃ΂ȂȂB<br>
//	 * @param learnSession	<learnsession>^Ow肷B
//	 * @param aiccLog		XMLAICCOt@Cw肷B
//	 */
//	private void setComment(Document doc, Element learnSession, File aiccLog)
//		throws UnsupportedEncodingException, FileNotFoundException, SystemException, IOException, ParserConfigurationException, SAXException, TransformerException {
//
//		// .cmtt@CWJ
//		AICCLogForCSV commentFile = new AICCLogForCSV();
//
//		commentFile.initialize(aiccLog.getPath());
//
//		// <lmscomments>^O쐬
//		Element learnerComments = XMLUtil.append(doc, learnSession, "learnercomments");
//
//		int max = commentFile.size();
//
//		for (int i = 0; i < max; i++) {
//			// <lmscomment>^O쐬
//			String[] data = commentFile.get(i);
//
//			XMLUtil.append(
//				doc,
//				learnerComments,
//				"learnercomment",
//				new Element[] { XMLUtil.createElement(doc, "comment", data[2]), XMLUtil.createElement(doc, "location", data[1]), XMLUtil.createElement(doc, "datetime", data[0]), });
//		}
//	}
//
//	/**
//	 * XMS֑Mg[XO(trace.xml)쐬A쐬trace.xmlDOM DocumentԋpB
//	 *
//	 * @param doc			g[XOǉDOM Documentw肷
//	 * @param parent		<tracelog>^Oݒ肷(e)Ggw肷
//	 * @param outputFolder	trace.xmlt@C쐬tH_w肷B<br>
//	 * @param encoding		trace.xml쐬ۂ̕GR[fBOw肷<br>
//	 * @param result		IRw肷"SUSPEND"̏ꍇ͒fA"EXIT"̏ꍇ͏IB
//	 */
//	private void createTraceLogDocument(Document doc, Element parent, String outputFolder, String encoding, String result)
//		throws IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
//
//		// trace.xmlt@C̃tpX쐬
//		String traceLogFileName = outputFolder + "trace.xml";
//
//		// trace.xmlt@CPrintWriter쐬
//		PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(traceLogFileName)), encoding)));
//
//		StreamResult out = new StreamResult(pw);
//
//		Element rootElement;
//
//		try {
//			SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
//
//			// xml錾
//			pw.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
//
//			// DOCTYPE錾 - ENTITYƂ"navtrace"navtrace.xml̓eݒ肷
//			pw.println("<!DOCTYPE tracelog [");
//			pw.println("<!ENTITY navtrace SYSTEM \"" + outputFolder + "navtrace.xml\">");
//			pw.println("]>");
//
//			// <tracelog>[g^O
//			pw.println("<tracelog>");
//
//			int traceLevel = Integer.parseInt(SG.get("TraceLevel"));
//			if (traceLevel > 1) {
//				// <logininformation>^O쐬
//				Document login = XMLUtil.createDocument("logininformation", false);
//				rootElement = login.getDocumentElement();
//
//				XMLUtil.append(login, rootElement, "userid", executeParameters.getUserID());
//				XMLUtil.append(login, rootElement, "username", executeParameters.getUserName());
//				XMLUtil.append(login, rootElement, "loid", executeParameters.getLOID());
//				XMLUtil.append(login, rootElement, "studysession", executeParameters.getStudySessionCount());
//				XMLUtil.append(login, rootElement, "loginsessionid", executeParameters.getLaunchCount());
//				XMLUtil.append(login, rootElement, "manifestid", executeParameters.getManifestID());
//				XMLUtil.append(login, rootElement, "datetime", formatter.format(startDate));
//				XMLUtil.append(login, rootElement, "command", executeParameters.getStartCommand());
//
//				XMLUtil.output(login, true, encoding, out);
//
//				// navtraceGeBeB̎̎Q
//				pw.println("&navtrace;");
//
//				// <logoutinformation>^O쐬
//				Document logout = XMLUtil.createDocument("logoutinformation", false);
//				rootElement = logout.getDocumentElement();
//
//				XMLUtil.append(logout, rootElement, "datetime", formatter.format(new Date()));
//				XMLUtil.append(logout, rootElement, "reason", result);
//
//				XMLUtil.output(logout, true, encoding, out);
//			}
//			
//			// <tracelog>[g^O
//			pw.println("</tracelog>");
//		}
//		finally {
//			pw.close();
//		}
//
//		XMLUtil.output(new File(traceLogFileName), true, null, new DOMResult(parent));
//	}
//
	// CommentOut End
	
	/**
	 * XMS֑Mg[XO(trace.xml)쐬B
	 *
	 * @param outputFolder	trace.xmlt@C쐬tH_w肷B<br>
	 * @param encoding		trace.xml쐬ۂ̕GR[fBOw肷<br>
	 * @param result		IRw肷"SUSPEND"̏ꍇ͒fA"EXIT"̏ꍇ͏IB
	 */
	private void createTraceLogDocument(String outputFolder, String encoding, String result)
		throws IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {

		// trace.xmlt@C̃tpX쐬
		String traceLogFileName = outputFolder + "trace.xml";

		// trace.xmlt@CPrintWriter쐬
		PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(traceLogFileName)), encoding)));

		StreamResult out = new StreamResult(pw);

		Element rootElement;

		try {
			SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");

			// xml錾
			pw.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");

			// DOCTYPE錾 - ENTITYƂ"navtrace"navtrace.xml̓eݒ肷
			pw.println("<!DOCTYPE tracelog [");
			pw.println("<!ENTITY navtrace SYSTEM \"" + "navtrace.xml\">");
			pw.println("]>");

			// <tracelog>[g^O
			pw.println("<tracelog>");

			int traceLevel = Integer.parseInt(SG.get("TraceLevel"));
			if (traceLevel > 1) {
				// <logininformation>^O쐬
				Document login = XMLUtil.createDocument("logininformation", false);
				rootElement = login.getDocumentElement();

				XMLUtil.append(login, rootElement, "userid", executeParameters.getUserID());
				XMLUtil.append(login, rootElement, "username", executeParameters.getUserName());
				XMLUtil.append(login, rootElement, "loid", executeParameters.getLOID());
				XMLUtil.append(login, rootElement, "studysession", executeParameters.getStudySessionCount());
				XMLUtil.append(login, rootElement, "loginsessionid", executeParameters.getLaunchCount());
				XMLUtil.append(login, rootElement, "manifestid", executeParameters.getManifestID());
				XMLUtil.append(login, rootElement, "datetime", formatter.format(startDate));
				XMLUtil.append(login, rootElement, "command", executeParameters.getStartCommand());

				XMLUtil.output(login, true, encoding, out);

				// navtraceGeBeB̎̎Q
				pw.println("&navtrace;");

				// <logoutinformation>^O쐬
				Document logout = XMLUtil.createDocument("logoutinformation", false);
				rootElement = logout.getDocumentElement();

				XMLUtil.append(logout, rootElement, "datetime", formatter.format(new Date()));
				XMLUtil.append(logout, rootElement, "reason", result);

				XMLUtil.output(logout, true, encoding, out);
			}
			
			// <tracelog>[g^O
			pw.println("</tracelog>");
		}
		finally {
			pw.close();
		}
	}

	/**
	 * 
	 * IwK̊i[NX
	 * @author EndLearnAICCData
	 *
	 */
	private static class EndLearnAICCData
	{
		//*********************************
		// Xe[^X
		//*********************************
		private String activityID = null ;
		
		private String attemptCount = null ;
		
		private String learnDate = null ;
		
		private String tableKind = null ;
		
		private ArrayList fieldDataList = null ;
		
		//*********************************
		// e[uʒ萔
		//*********************************

		/**
		 * e[u:"attempt"
		 */
		public static final String TABLE_KIND_ATTEMPT = "attempt";
		
		/**
		 * e[u:"interaction"
		 */
		public static final String TABLE_KIND_INTERACTION = "interaction";
		
		/**
		 * e[u:"learnerComment"
		 */
		public static final String TABLE_KIND_LEARNER_COMMENT = "learnerComment";
		
		/**
		 * e[u:"lmsComment"
		 */
		public static final String TABLE_KIND_LMS_COMMENT = "lmsComment";

		/**
		 * e[u:"objectives"
		 */
		public static final String TABLE_KIND_OBJECTIVES = "objectives";
		
		/**
		 * RXgN^
		 * @param activityID ActivityID
		 * @param attemptCount s
		 * @param learnDate wK
		 * @param tableKind o^e[u
		 */
		public EndLearnAICCData(String activityID, String attemptCount, String learnDate, String tableKind )
		{
			this.activityID = activityID ;
			this.attemptCount = attemptCount ;
			this.learnDate = learnDate ;
			this.tableKind = tableKind ;
			this.fieldDataList = new ArrayList(20) ;	// CSV20񕪂܂ŃmۂĂ
		}

		//*********************************
		// setter/getter
		//*********************************
		/**
		 * @return activityID
		 */
		public String getActivityID() {
			return activityID;
		}

		/**
		 * @param activityID ݒ肷 activityID
		 */
		public void setActivityID(String activityID) {
			this.activityID = activityID;
		}

		/**
		 * @return attemptCount
		 */
		public String getAttemptCount() {
			return attemptCount;
		}

		/**
		 * @param attemptCount ݒ肷 attemptCount
		 */
		public void setAttemptCount(String attemptCount) {
			this.attemptCount = attemptCount;
		}

		/**
		 * @return learnDate
		 */
		public String getLearnDate() {
			return learnDate;
		}

		/**
		 * @param learnDate ݒ肷 learnDate
		 */
		public void setLearnDate(String learnDate) {
			this.learnDate = learnDate;
		}

		/**
		 * @return tableKind
		 */
		public String getTableKind() {
			return tableKind;
		}

		/**
		 * @param tableKind ݒ肷 tableKind
		 */
		public void setTableKind(String tableKind) {
			this.tableKind = tableKind;
		}

		/**
		 * @return fieldDataList
		 */
		public ArrayList getFieldDataList() {
			return fieldDataList;
		}

		/**
		 * @param fieldDataList ݒ肷 fieldDataList
		 */
		public void setFieldDataList(ArrayList fieldDataList) {
			this.fieldDataList = fieldDataList;
		}
		
		/**
		 * @param fieldData ǉ fieldData
		 */
		public void addFieldData(String data) {
			if ( data == null )
			{
				fieldDataList.add("") ;
			}
			else
			{
				fieldDataList.add(data);
			}
		}

		/**
		 * @return fieldData
		 */
		public String getFieldData(int i) {
			return this.fieldDataList.get(i).toString() ;
		}
		
		/**
		 * CSVf[^s擾B
		 * @return CSVf[^s
		 */
		public String getCSVDataRow()
		{
			String ret = "" ;
			
			ret = ret + CMIUtil.urlEncode( this.activityID ) ;
			ret = ret + "," + CMIUtil.urlEncode(this.attemptCount ) ;
			ret = ret + "," + CMIUtil.urlEncode(this.learnDate ) ;
			ret = ret + ","	+ CMIUtil.urlEncode(this.tableKind ) ;
			
			for ( int i = 0 ; i < this.fieldDataList.size() ; i++ )
			{
				ret = ret + "," + CMIUtil.urlEncode( this.fieldDataList.get(i).toString() ) ;
			}
			
			return ret ;
		}
	}

	private static String userIDPath(String strDirPath, String strUserID)
	{
		return UserIDFolder.getPath(strDirPath, strUserID);
	}
}
