/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	NavApiBusinessAction
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.engine;

import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Iterator;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.co.ntt.lms.lo.scorm.kernel.Activity;
import jp.co.ntt.lms.lo.scorm.util.Debug;
import jp.co.ntt.lms.lo.scorm.util.SG;
import jp.co.ntt.lms.xms.framework.XmsBusinessAction;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsRequest;
import jp.co.ntt.lms.xms.framework.XmsResponse;

/**
 *	NavApiBusinessAction NX<br>
 *	GetValue / SetValue v󂯕tNX<br>
 */
public class NavApiBusinessAction extends XmsBusinessAction {
	/**
	 * ftHgRXgN^
	 */
	public NavApiBusinessAction() {}

	/**
	 * 
	 *
	 * @param	xmsRequest	NGXgIuWFNg
	 */
	protected void initProcessRequest(XmsRequest xmsRequest) throws XmsException {}

	/**
	 * GetValue / SetValue vt
	 *
	 * @param	xmsRequest	NGXgIuWFNg
	 * @param	xmsResponse	X|XIuWFNg
	 */
	protected void processRequest(XmsRequest xmsRequest, XmsResponse xmsResponse) throws XmsException {
		HttpServletRequest request = xmsRequest.getRequest();
		HttpSession session = request.getSession();
		ServletContext application = session.getServletContext();

		String errorCode = "0";
		String nextURL = "";
		String result = null;

		// Np[^session擾
		ExecuteParameters executeParameters = (ExecuteParameters)session.getAttribute("SCORM.EXECUTE_PARAMETERS");

		// api adaptersession擾
		SCORMAPIAdapter adapter = (SCORMAPIAdapter)session.getAttribute("SCORM.API_ADAPTER");

		try {
			StringBuffer param = new StringBuffer();
			Iterator iterator = xmsRequest.getParmaterNames().iterator();
			String method = null;
			String dataModelName = null;
			String parameter = null;
			String parameter1 = null;
			String parameter2 = null;
			while (iterator.hasNext()) {
				String key = (String)iterator.next();
				String value = xmsRequest.getParameter(key);
				
				if (key.equalsIgnoreCase("Method")) {
					method = value;
				}else if (key.equalsIgnoreCase("DataModel")) {
					dataModelName = value;
				}else if (key.equalsIgnoreCase("Parameter")) {
					parameter = value;
				}else if (key.equalsIgnoreCase("Parameter1")) {
					parameter1 = value;
				}else if (key.equalsIgnoreCase("Parameter2")) {
					parameter2 = value;
				}
				
			}
			
			// GWapplication擾
			Engine engine = null;

			if (executeParameters != null) {
				String engineKeyName =
					"SCORM." + executeParameters.getUserID() + "." + executeParameters.getLOID() + ".ENGINE";

				engine = (Engine)application.getAttribute(engineKeyName);
			}

			do {
				// "Method"p[^擾

				// "GetValue"̏ꍇ
				if (method.equals("GetValue")) {
					result = "";

					// session timeout Ăꍇ
					if (executeParameters == null) {
						// G[R[hsession timeout
						errorCode = "1001";
						break;
					}

					// f[^f擾

					// f[^f"."ŕ
					String[] splittedDataModel = dataModelName.split("\\.");

					// "."ŕʂ3̕ȉ̏ꍇ
					//  "adl.nav.request_valid.xxxx"̂͂
					if (splittedDataModel.length <= 3) {
						// undefined data model element
						errorCode = "401";
						break;
					}

					// "adl.nav.request_valid.xxxx"łȂꍇ
					if (!splittedDataModel[0].equals("adl")
						|| !splittedDataModel[1].equals("nav")
						|| !splittedDataModel[2].equals("request_valid")) {

						// undefined data model element
						errorCode = "401";
						break;
					}

					// "adl.nav.request_valid.continue"̏ꍇ
					if (splittedDataModel[3].equals("continue")) {

						// "adl.nav.request_valid.continue.xxxxx"̏ꍇ
						if (splittedDataModel.length != 4) {
							// undefined data model element
							errorCode = "401";
							break;
						}

						// continue\ǂݒ肷
						result = Boolean.toString(engine.canContinue());
						break;
					}

					// "adl.nav.request_valid.previous"̏ꍇ
					if (splittedDataModel[3].equals("previous")) {

						// "adl.nav.request_valid.previous.xxxxx"̏ꍇ
						if (splittedDataModel.length != 4) {
							// undefined data model element
							errorCode = "401";
							break;
						}

						// previous\ǂݒ肷
						result = Boolean.toString(engine.canPrevious());
						break;
					}

					// "adl.nav.request_valid.choice.{target=URI}"̏ꍇ
					if (splittedDataModel[3].equals("choice")) {

						// "adl.nav.request_valid.choice.xxxxx"ł͂Ȃꍇ
						if (splittedDataModel.length <= 4) {
							// general get failure
							errorCode = "301";
							break;
						}

						int targetIndex = splittedDataModel[4].indexOf("{target=");
						int choiceIndex = splittedDataModel[4].lastIndexOf("}");

						if ((targetIndex == -1) || (choiceIndex == -1)) {
							// undefined data model element
							errorCode = "401";
							break;
						}

						if ((targetIndex != 0) || ((choiceIndex + "}".length()) != splittedDataModel[4].length())) {
							// undefined data model element
							errorCode = "401";
							break;
						}

						// choice\ǂ擾
						Boolean canChoiceResult =
							engine.canChoice((Activity) null, parameter);

						// w肳ꂽactivity idsȏꍇ
						if (canChoiceResult == null) {
							// general get failure
							errorCode = "301";
							break;
						}

						// choice\ǂݒ肷
						result = canChoiceResult.toString();
						break;
					}
					
					// 2010.10.05 taku-harada add >>
					// "adl.nav.request_valid.jump.{target=URI}"̏ꍇ
					if (splittedDataModel[3].equals("jump")) {

						// "adl.nav.request_valid.jump.xxxxx"ł͂Ȃꍇ
						if (splittedDataModel.length <= 4) {
							// general get failure
							errorCode = "301";
							break;
						}

						int targetIndex = splittedDataModel[4].indexOf("{target=");
						int jumpIndex = splittedDataModel[4].lastIndexOf("}");

						if ((targetIndex == -1) || (jumpIndex == -1)) {
							// undefined data model element
							errorCode = "401";
							break;
						}

						if ((targetIndex != 0) || ((jumpIndex + "}".length()) != splittedDataModel[4].length())) {
							// undefined data model element
							errorCode = "401";
							break;
						}

						// jump\ǂ擾
						Boolean canJumpResult =
							engine.canJump((Activity) null, parameter);

						// w肳ꂽactivity idsȏꍇ
						if (canJumpResult == null) {
							// general get failure
							errorCode = "301";
							break;
						}

						// jump\ǂݒ肷
						result = canJumpResult.toString();
						break;
					}
					// 2010.10.05 taku-harada add <<

					// continue, previous, choicẻłȂꍇ

					// undefined data model element
					errorCode = "401";
					break;
				}
				// "SetValue"̏ꍇ
				else if (method.equals("SetValue")) {

					// session timeout Ăꍇ
					if (executeParameters == null) {
						// G[R[hsession timeout
						errorCode = "1001";
						result = "false";
						break;
					}

					// f[^f擾
					String dataModel = dataModelName;

					// f[^f"adl.nav.request"łȂꍇ
					if (!dataModel.equals("adl.nav.request")) {
						// undefined data model element
						errorCode = "401";
						result = "false";
						break;
					}

					// p[^擾
					parameter = parameter1;

					// "continue"̏ꍇ
					if (parameter.equals("continue")) {
						// JgANeBreB"continue"łȂꍇ
						if (!engine.canContinue()) {
							// general set failure
							errorCode = "351";
							result = "false";
							break;
						}

						// "continue"sirQ[VNGXgURL쐬
						nextURL = SG.get("BaseServletURL") + "?action_id=scorm.navigate&Command=Continue";
						result = "true";
						break;
					}

					// "previous"̏ꍇ
					if (parameter.equals("previous")) {
						// JgANeBreB"previous"łȂꍇ
						if (!engine.canPrevious()) {
							// general set failure
							errorCode = "351";
							result = "false";
							break;
						}

						// "previous"sirQ[VNGXgURL쐬
						nextURL = SG.get("BaseServletURL") + "?action_id=scorm.navigate&Command=Previous";
						result = "true";
						break;
					}

					// "exit"̏ꍇ
					if (parameter.equals("exit")) {
						// JgANeBreB"exit"łȂꍇ
						if (!engine.canExit()) {
							// general set failure
							errorCode = "351";
							result = "false";
							break;
						}

						// "exit"sirQ[VNGXgURL쐬
						nextURL = SG.get("BaseServletURL") + "?action_id=scorm.navigate&Command=Exit";
						result = "true";
						break;
					}

					// "exitAll"̏ꍇ
					if (parameter.equals("exitAll")) {
						// JgANeBreB"exitAll"łȂꍇ
						if (!engine.canExitAll()) {
							// general set failure
							errorCode = "351";
							result = "false";
							break;
						}

						// "exitAll"sirQ[VNGXgURL쐬
						nextURL = SG.get("BaseServletURL") + "?action_id=scorm.navigate&Command=ExitAll";
						result = "true";
						break;
					}

					// "abandon""abandonAll"͖T|[g
					if ((parameter.equals("abandon")) || (parameter.equals("abandonAll"))) {
						// unimplemented data model element
						errorCode = "402";
						result = "false";
						break;
					}

					// "adl.nav.request, {target=URI}choice"̏ꍇ
					int targetIndex = parameter.indexOf("{target=");
					int choiceIndex = parameter.lastIndexOf("}choice");

					if ((targetIndex == -1) || (choiceIndex == -1)) {
						// undefined data model element
						errorCode = "401";
						result = "false";
						break;
					}

					if ((targetIndex != 0) || ((choiceIndex + "}choice".length()) != parameter.length())) {
						// undefined data model element
						errorCode = "401";
						result = "false";
						break;
					}

					// activity id擾
					String activityID = parameter2;

					// 擾activity id̃ANeBreB"choice"\ǂ`FbN
					Boolean canChoiceResult = engine.canChoice((Activity) null, activityID);

					// activity idsA"choice"\łȂꍇ
					if ((canChoiceResult == null) || (!canChoiceResult.booleanValue())) {
						// general set failure
						errorCode = "351";
						result = "false";
						break;
					}

					// "choice"sirQ[VNGXgURL쐬
					nextURL =
						SG.get("BaseServletURL")
							+ "?action_id=scorm.navigate&Command=Choice&ActivityID="
							+ activityID;
					result = "true";
					break;
				}
				// "GetValue", "SetValue"ȊȌꍇ
				else {
					// general exception
					errorCode = "101";
					result = "false";
				}
			}
			while (false);
		}
		catch (Exception ex) {
			Debug.write(ex);

			// general exception
			errorCode = "101";
			result = "false";
			nextURL = "";
		}

		NavApiBusinessBean navApiBusinessBean = new NavApiBusinessBean(executeParameters);

		navApiBusinessBean.setErrorCode(errorCode);
		navApiBusinessBean.setNextURL(nextURL);
		navApiBusinessBean.setResult(result);

		xmsResponse.setBusinessBean(navApiBusinessBean);
	}
}
