//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	Sequencing
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Hashtable;

import jp.co.ntt.lms.lo.scorm.kernel.exception.CommunicationModuleWrapperException;
import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.CachedNode;
import jp.co.ntt.lms.lo.scorm.util.DateUtility;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Sequencing NX<BR>
 * V[PVO\NX<BR>
 */
public class Sequencing {
	/** sequencing node */
	private CachedNode sequencingNode;

	/** progress information */
	private Progress progress;

	/** status information */
	private Status status;

	/** local objective */
	private LocalObjective[] localObjective;

	/** communication module */
	private SCORMCommunicationModule communicationModule;

	/** activity */
	private Activity activity;

	/** IsAttemptedInCurrentAttempt */
	private boolean IsAttemptedInCurrentAttempt;

	/**
	 * RXgN^<BR>
	 *
	 * @param activity Sequencing ANeBreB<BR>
	 * @param manifestNode ލ\m[h<BR>
	 * @param sequencingNode sequencingNode<BR>
	 * @param globalObjectives globalObjective ̔z<BR>
	 */
	public Sequencing(
		Activity activity,
		CachedNode manifestNode,
		CachedNode sequencingNode,
		GlobalObjective[] globalObjectives,
		boolean hasChildren)
		throws SystemException {

		try {
			// ANeBreB̓o^
			this.activity = activity;

			IsAttemptedInCurrentAttempt = false;

			// sequencing̓o^
			this.sequencingNode = sequencingNode;

			// progress̃CX^X
			progress = new Progress(activity, manifestNode);

			// Status̃CX^X
			status = new Status(activity, manifestNode);

			if (!hasChildren) {
				// SCORMCommunicationModulẽCX^X
				communicationModule = new SCORMCommunicationModule(activity);
			}

			CachedNode objectivesNode = null;

			if (sequencingNode != null) {
				objectivesNode = sequencingNode.selectSingleChildNode("objectives");
			}

			if (objectivesNode == null) {
				/*
				 * primary 쐬
				 * objective ID  SCO ID + ID ł
				 */
				localObjective = new LocalObjective[1];
				localObjective[0] = new LocalObjective(activity);
				localObjective[0].setObjectiveID(activity.getIdentifier() + "." + activity.getCourseIdentifier());
				// 20040802 ADD NTTR IDȂObjective̎
				localObjective[0].setHasObjectiveID();
				return;
			}

			/*
			 * primary objective 쐬
			 * id Ȃ SCO ID  ID ō쐬
			 * 
			 */
			CachedNode primaryObjectiveNode = objectivesNode.selectSingleChildNode("primaryObjective");

			LocalObjective primaryObjective =
				new LocalObjective(activity, manifestNode, primaryObjectiveNode, globalObjectives);

			CachedNode idNode = primaryObjectiveNode.selectSingleChildNode("@objectiveID");

			if (idNode != null) {
				primaryObjective.setObjectiveID(idNode.getNodeValue());
			}
			else {
				//IDȂꍇSCOIDƋIDō
				primaryObjective.setObjectiveID(activity.getIdentifier() + "." + activity.getCourseIdentifier());
				// 20040802 ADD NTTR IDȂObjective̎
				primaryObjective.setHasObjectiveID();
			}

			/*
			 * objective̐
			 * objective  node ̕
			 * ̏ꍇA objectiveID Ȃ SCO ID + ID + JEg ō쐬
			 */
			CachedNode[] objectiveNodes = objectivesNode.selectChildNodeList("objective");

			LocalObjective[] objectives = new LocalObjective[objectiveNodes.length];

			for (int i = 0; i < objectiveNodes.length; i++) {
				objectives[i] = new LocalObjective(activity, manifestNode, objectiveNodes[i], globalObjectives);
				objectives[i].setObjectiveID(objectiveNodes[i].selectSingleChildNode("@objectiveID").getNodeValue());
			}

			localObjective = new LocalObjective[objectiveNodes.length + 1];
			localObjective[0] = primaryObjective;
			System.arraycopy(objectives, 0, localObjective, 1, objectives.length);
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("Sequencing failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * f쐬
	 *
	 * @param doc ۑDOM DocumentOwner Documentw肷
	 * @param parent ۑxmlݒ肷(e)̃Gg
	 */
	public void save(Document doc, Element parent, boolean traceLog) throws SystemException {
		try {
			// status ̕ۑ
			status.save(doc, parent, traceLog);

			// localObjective ̕ۑ
			Element objectivesNode = XMLUtil.append(doc, parent, "objectives");

			for (int i = 0; i < localObjective.length; i++) {
				localObjective[i].save(doc, objectivesNode, traceLog);
			}

			// progress ̕ۑ
			progress.save(doc, parent, traceLog);
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("save failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * useCurrentAttempẗׂ̌lXV
	 */
	public void setCandidatePreviousValue() throws SystemException {
		for (int i = 0; i < localObjective.length; i++) {
			localObjective[i].setCandidatePreviousValue();
		}

		progress.setCandidatePreviousValue();
	}

	/**
	 * f𕜋A
	 *
	 * @param parent foׂ(e)̃m[hw肷
	 */
	public void initializeSequencingInformation(CachedNode parent) throws SystemException {
		try {
			// status ̏
			status.initializeStatusInformation(parent);

			// localObjective ̏
			CachedNode objectivesNode;

			if (parent == null) {
				objectivesNode = null;
			}
			else {
				objectivesNode = parent.selectSingleChildNode("objectives");
			}

			for (int i = 0; i < localObjective.length; i++) {
				localObjective[i].initializeLocalObjectiveInformation(objectivesNode);
			}

			// progress ̏
			progress.initializeProgressInformation(parent);
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("initialize failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * s̏<BR>
	 */
	public void initializeAttemptInformation() throws SystemException {
		try {
			// progress ̎s̏
			progress.initializeAttemptInformation();

			// status ̎s̏
			status.initializeAttemptInformation();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("initializeAttempt failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * I<BR>
	 */
	public void terminate() throws SystemException {
		// CachedNode ̃NA
		sequencingNode = null;

		// progress ̏I
		progress.termiante();
		progress = null;

		// status ̏I
		status.terminate();
		status = null;

		// localObjective ̏I
		if (localObjective != null) {
			for (int i = 0; i < localObjective.length; i++) {
				localObjective[i].terminate();
				localObjective[i] = null;
			}
		}

		if (communicationModule != null) {
			// SCORM Communication Module ̏I
			communicationModule.terminate();
			communicationModule = null;
		}

		// activity ̃NA
		activity = null;
	}

	/**
	 * communication module ̏<BR>
	 *
	 * @param userID wKID
	 * @param userName wKҖ
	 * @param URL aiccURL
	 * @param parent 񂪐ݒ肳Ă(e)̃m[hw肷<BR>
	 */
	public void initializeAPIAdapter(String userID, String userName, String URL, String encoding, CachedNode parent)
		throws SystemException {

		try {
			if (communicationModule != null) {
				Hashtable initialParameter = new Hashtable();

				initialParameter.put("userID", userID);
				initialParameter.put("userName", userName);
				initialParameter.put("URL", URL);
				initialParameter.put("encoding", encoding);

				communicationModule.initialize(
					initialParameter,
					(parent == null) ? null : parent.selectSingleChildNode("text()").getNodeValue());
			}
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"initializeAPIAdapter failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * communication module ̏<BR>
	 *
	 * @param userID wKID
	 * @param userName wKҖ
	 * @param URL aiccURL
	 * @param parent 񂪐ݒ肳Ă(e)̃m[hw肷<BR>
	 */
	public void initializeAPIAdapter2(String userID, String userName, String URL, String encoding)
		throws SystemException {

		try {
			if (communicationModule != null) {
				Hashtable initialParameter = new Hashtable();

				initialParameter.put("userID", userID);
				initialParameter.put("userName", userName);
				initialParameter.put("URL", URL);
				initialParameter.put("encoding", encoding);

				communicationModule.initialize2(initialParameter);
			}
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"initializeAPIAdapter failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}
	
	/**
	 * OAPIׂĕۑ<BR>
	 */
	public void saveAPIAdapter(Document doc, Element parent) throws SystemException {
		try {
			if (communicationModule != null) {
				parent.appendChild(XMLUtil.createTextNode(doc, communicationModule.save()));
			}
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("saveAPIAdapter failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * OAPIAdpater̍ĊJs
	 */
	public void resumeAPIAdapter() throws SystemException {
		if (communicationModule != null) {
			communicationModule.resumeAPIAdapter();
		}
	}

	/**
	 * gbLO̓
	 */
	public void synchronizeTrackingModel() throws SystemException {
		try {
			if (communicationModule != null) {
				communicationModule.close();
				communicationModule.synchronizeTrackingModel();
			}

			for (int i = 0; i < localObjective.length; i++) {
				localObjective[i].synchronizeTrackingModel();
			}

		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"synchronizeTrackingModel failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * ɑJڂSCOURL擾
	 * @param learningLogFolder wKȌo͐w肷
	 * @return ɑJڂSCOURL
	 */
	public String getURL(String learningLogFolder) throws CommunicationModuleWrapperException {
		if (communicationModule == null) {
			return null;
		}

		return communicationModule.open(learningLogFolder);
	}

	/**
	 * OAPIA_v^擾
	 * @return APIAdapterWrapper
	 */
	public SCORMCommunicationModule getCommunicationModule() {
		return communicationModule;
	}

	/**
	 * progress information擾
	 * @return Progress ANeBreB progress NX̃IuWFNgԂ<BR>
	 */
	public Progress getProgress() {
		return progress;
	}

	/**
	 * status IuWFNg̎擾<BR>
	 * @return Status ANeBreBStatusNX̃IuWFNgԂ<BR>
	 */
	public Status getStatus() {
		return status;
	}

	/**
	 * <rollupRules>^OCachedNode擾
	 * 
	 * @return <rollupRules>^OCachedNodeԋp 
	 */
	public CachedNode getRollupRules() {
		CachedNode rollupRules = null;

		if (sequencingNode != null) {
			rollupRules = sequencingNode.selectSingleChildNode("rollupRules");
		}

		return rollupRules;
	}

	/**
	 * <sequencingRules>^OCachedNode擾
	 * 
	 * @return <sequencingRules>^OCachedNodeԋp 
	 */
	public CachedNode getSequencingRules() {
		CachedNode sequencingRules = null;

		if (sequencingNode != null) {
			sequencingRules = sequencingNode.selectSingleChildNode("sequencingRules");
		}

		return sequencingRules;
	}

	/**
	 * control modẽtO擾<BR>
	 * @param controlModeType Rg[[h萔<BR>
	 * @return control mode Lۂ<BR>
	 */
	public boolean getControlModeFlag(String controlModeType) throws SystemException {
		try {
			CachedNode controlMode = null;

			if (sequencingNode != null) {
				controlMode = sequencingNode.selectSingleChildNode("controlMode");
			}

			/*
			 * controlMode  node Ȃꍇ̓ftHg擾
			 * ꍇ node 擾
			 * element ȂꍇftHg擾
			 */
			String controlFlag;

			if (controlMode == null) {
				controlFlag = Default.getValue("controlMode/@" + controlModeType);
			}
			else {
				CachedNode controlNode = controlMode.selectSingleChildNode("@" + controlModeType);

				if (controlNode == null) {
					controlFlag = Default.getValue("controlMode/@" + controlModeType);
				}
				else {
					controlFlag = controlNode.getNodeValue();
				}
			}

			return Boolean.valueOf(controlFlag).booleanValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("getControlModeFlag failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * ANeBreBAvailableChildrenɊ܂܂邩ۂ<BR>
	 * @return boolean ܂܂邩ۂ<BR>
	 *     ( true: ܂܂ / false: ܂܂Ȃ )<BR>
	 *      root ̏ꍇ͏ true Ԃ<BR>
	 */
	public boolean isAvailable() {
		/*
		 * root ̏ꍇ true Ԃ
		 */
		if (activity.isRoot()) {
			return true;
		}

		/*
		 * ȊO͐eANeBreB AvailableChildren  thisActivity
		 * 邩ۂ𔻒肷
		 */
		Activity[] availableSibling = activity.getParent().getAvailableChildren();

		if (availableSibling == null) {
			return false;
		}

		for (int i = 0; i < availableSibling.length; i++) {
			if (activity == availableSibling[i]) {
				return true;
			}
		}

		return false;
	}

	/**
	 * attempt limit 擾<BR>
	 * @return Integer wK񐔂̐l<BR>
	 *         null ̏ꍇ͊wKȂ<BR>
	 */
	public Integer getAttemptLimit() throws SystemException {
		try {
			CachedNode limitCondition = null;

			if (sequencingNode != null) {
				limitCondition = sequencingNode.selectSingleChildNode("limitConditions");
			}

			/*
			 * limitConditions  element ȂꍇA
			 * limitConditions  element Ă attemptLimit attributeȂꍇ
			 * ȂƂ
			 */
			if (limitCondition == null) {
				return null;
			}

			CachedNode attemtpCountNode = limitCondition.selectSingleChildNode("@attemptLimit");

			if (attemtpCountNode == null) {
				return null;
			}

			return new Integer(attemtpCountNode.getNodeValue());
		}
		catch (Exception ex) {
			throw new SystemException("getAttemptLimit failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * Duration̐擾<BR>
	 * @param limitType Duration  attribute w肷<BR>
	 * @return attributeɑΉ duration Ԃ<BR>
	 *         Ȃ̏ꍇ null Ԃ<BR>
	 */
	public Duration getDurationLimit(String limitType) throws SystemException {
		try {
			CachedNode limitCondition = null;

			if (sequencingNode != null) {
				limitCondition = sequencingNode.selectSingleChildNode("limitConditions");
			}

			/*
			 * limitConditions  element ȂꍇA
			 * limitConditions  element Ă attemptLimit attributeȂꍇ
			 * ȂƂ
			 */
			if (limitCondition == null) {
				return null;
			}

			CachedNode durationNode = limitCondition.selectSingleChildNode("@" + limitType);

			if (durationNode == null) {
				return null;
			}

			return new Duration(durationNode.getNodeValue());
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("getDurationLimit failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * Ԃ̐擾<BR>
	 * @param dateTimeType beginTimeLimit/endTimeLimit<BR>
	 * @return 擾J_[^ɕϊ<BR>
	 */
	public Calendar getDateTimeLimit(String dateTimeType) throws SystemException {
		try {
			CachedNode limitCondition = null;

			if (sequencingNode != null) {
				limitCondition = sequencingNode.selectSingleChildNode("limitConditions");
			}

			if (limitCondition == null) {
				return null;
			}

			CachedNode dateTimeNode = limitCondition.selectSingleChildNode("@" + dateTimeType);

			if (dateTimeNode == null) {
				return null;
			}

			return DateUtility.toCalendar(dateTimeNode.getNodeValue());
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("getDateTimeLimit failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * auxiliary resource擾<BR>
	 * @return	AuxiliaryResource̔z<BR>
	 * 			auxilairy resource Ȃꍇ́@null Ԃ<BR>
	 */
	public AuxiliaryResource[] getAuxiliaryResources() throws SystemException {

		try {
			if (sequencingNode == null) {
				return null;
			}

			/*
			 * auxiliary resource 擾
			 */
			CachedNode[] auxiliaryResourceNodes =
				sequencingNode.selectSimpleNodeList("auxiliaryResources/auxiliaryResource");

			if ((auxiliaryResourceNodes == null) || (auxiliaryResourceNodes.length <= 0)) {
				return null;
			}

			//zm
			AuxiliaryResource[] auxiliaryResources = new AuxiliaryResource[auxiliaryResourceNodes.length];

			for (int i = 0; i < auxiliaryResourceNodes.length; i++) {
				auxiliaryResources[i] =
					new AuxiliaryResource(
						auxiliaryResourceNodes[i].selectSingleChildNode("@auxiliaryResourceID").getNodeValue(),
						auxiliaryResourceNodes[i].selectSingleChildNode("@purpose").getNodeValue());
			}

			return auxiliaryResources;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAuxiliaryResources failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * randomization controls  selection timing 擾<BR>
	 * @return String selectionTiming̕<BR>
	 */
	public String getSelectionTiming() throws SystemException {
		try {
			CachedNode randomizationControl = null;

			if (sequencingNode != null) {
				randomizationControl = sequencingNode.selectSingleChildNode("randomizationControls");
			}

			/*
			 * randomization control  elementȂꍇA܂
			 * randomization control ĂA selection timing  attribute 
			 * Ȃꍇ̓ftHggBȊOattribute ̒lԂ
			 */
			if (randomizationControl == null) {
				return Default.getValue("randomizationControls/@selectionTiming");
			}

			CachedNode timingNode = randomizationControl.selectSingleChildNode("@selectionTiming");
			if (timingNode == null) {
				return Default.getValue("randomizationControls/@selectionTiming");
			}

			return timingNode.getNodeValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("getSelectionTiming failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * randomization controls  randomization timing 擾
	 * 
	 * @return String randomizationTiming̕
	 */
	public String getRandomizationTiming() throws SystemException {
		try {
			CachedNode randomizationControl = null;

			if (sequencingNode != null) {
				randomizationControl = sequencingNode.selectSingleChildNode("randomizationControls");
			}

			/*
			 * randomization control  element ȂꍇA܂
			 * randomization control  element ĂArandomization timing 
			 * attributeȂꍇ ftHg̒lԂ
			 * ȊÓAattribute ̒lԂ
			 */
			if (randomizationControl == null) {
				return Default.getValue("randomizationControls/@randomizationTiming");
			}

			CachedNode timingNode = randomizationControl.selectSingleChildNode("@randomizationTiming");

			if (timingNode == null) {
				return Default.getValue("randomizationControls/@randomizationTiming");
			}

			return timingNode.getNodeValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getRandomizationTiming failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * randomization controls  randomization timing 擾
	 * @return String randomizationTiming̕
	 */
	public boolean getReorderChildren() throws SystemException {
		try {
			CachedNode randomizationControl = null;

			if (sequencingNode != null) {
				randomizationControl = sequencingNode.selectSingleChildNode("randomizationControls");
			}

			/*
			 * randomization control  element ȂꍇA܂
			 * randomization control  element ĂArandomization timing 
			 * attribute Ȃꍇ̓ftHg̒l
			 * ȊÓAattribute̒lԂ
			 */
			if (randomizationControl == null) {
				return Boolean.valueOf(Default.getValue("randomizationControls/@reorderChildren")).booleanValue();
			}

			CachedNode reOrderNode = randomizationControl.selectSingleChildNode("@reorderChildren");
			if (reOrderNode == null) {
				return Boolean.valueOf(Default.getValue("randomizationControls/@reorderChildren")).booleanValue();
			}

			return Boolean.valueOf(reOrderNode.getNodeValue()).booleanValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("getReorderChildren failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * randomization controls  randomization timing 擾<BR>
	 *
	 * @return randomizationTiming̕Bselect count Ȃꍇ null Ԃ<BR>
	 */
	public Integer getSelectCount() throws SystemException {
		try {
			CachedNode randomizationControl = null;

			if (sequencingNode != null) {
				randomizationControl = sequencingNode.selectSingleChildNode("randomizationControls");
			}

			if (randomizationControl == null) {
				return null;
			}

			CachedNode countNode = randomizationControl.selectSingleChildNode("@selectCount");
			if (countNode == null) {
				return null;
			}

			return new Integer(countNode.getNodeValue());
		}
		catch (Exception ex) {
			throw new SystemException("getSelectCount failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * delivery control  l擾<BR>
	 * @param deliveryAttribute lw肷B
	 * @return  true L<BR>
	 *          false <BR>
	 */
	public boolean getDeliveryControlFlag(String deliveryAttribute) throws SystemException {
		try {
			CachedNode deliveryControl = null;

			if (sequencingNode != null) {
				deliveryControl = this.sequencingNode.selectSingleChildNode("deliveryControls");
			}

			if (deliveryControl == null) {
				return Boolean.valueOf(Default.getValue("deliveryControls/@" + deliveryAttribute)).booleanValue();
			}

			CachedNode node = deliveryControl.selectSingleChildNode("@" + deliveryAttribute);

			if (node == null) {
				return Boolean.valueOf(Default.getValue("deliveryControls/@" + deliveryAttribute)).booleanValue();
			}

			return Boolean.valueOf(node.getNodeValue()).booleanValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getDeliveryControlFlag failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * limit conditions  l擾<BR>
	 * @param limitAttribute limitConditionslw肷B
	 * @return 擾łl𕶎ŕԋpB݂ȂꍇnullԋpB
	 */
	public String getLimitConditionString(String limitAttribute) throws SystemException {
		try {
			CachedNode limitCondition = null;

			if (sequencingNode != null) {
				limitCondition = sequencingNode.selectSingleChildNode("limitConditions");
			}

			if (limitCondition == null) {
				return null;
			}

			CachedNode attribute = limitCondition.selectSingleChildNode("@" + limitAttribute);

			if (attribute == null) {
				return null;
			}

			return attribute.getNodeValue();
		}
		catch (Exception ex) {
			throw new SystemException(
				"getLimitConditionString failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * constrained choice considerations ̑l擾<BR>
	 *
	 * @param attribute constrainedChoiceConsiderationslw肷B
	 * @return truefalseԋp
	 */
	public boolean getConstrainedChoiceConsiderationFlag(String attribute) throws SystemException {
		try {
			CachedNode constrainedChoiceConsiderations = null;

			if (sequencingNode != null) {
				constrainedChoiceConsiderations =
					sequencingNode.selectSingleChildNode("constrainedChoiceConsiderations");
			}

			if (constrainedChoiceConsiderations == null) {
				return Boolean
					.valueOf(Default.getValue("constrainedChoiceConsiderations/@" + attribute))
					.booleanValue();
			}

			CachedNode node = constrainedChoiceConsiderations.selectSingleChildNode("@" + attribute);

			if (node == null) {
				return Boolean
					.valueOf(Default.getValue("constrainedChoiceConsiderations/@" + attribute))
					.booleanValue();
			}

			return Boolean.valueOf(node.getNodeValue()).booleanValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getConstrainedChoiceConsiderationFlag failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * rollup consideration ̑l擾<BR>
	 *
	 * @param attribute rollupConsiderationslw肷B
	 * @return 擾łlԋp
	 */
	public String getRollupConsiderationValue(String attribute) throws SystemException {
		try {
			CachedNode rollupConsiderations = null;

			if (sequencingNode != null) {
				rollupConsiderations = sequencingNode.selectSingleChildNode("rollupConsiderations");
			}

			if (rollupConsiderations == null) {
				return Default.getValue("rollupConsiderations/@" + attribute);
			}

			CachedNode node = rollupConsiderations.selectSingleChildNode("@" + attribute);

			if (node == null) {
				return Default.getValue("rollupConsiderations/@" + attribute);
			}

			return node.getNodeValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getRollupConsiderationValue failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * rollup Ɏg objective 擾<BR>
	 *
	 * @return primary objective ( [AbvɎgIuWFNeBu)<BR>
	 */
	public LocalObjective getObjectiveContributeToRollup() {
		return localObjective[0];
	}

	/**
	 * ANeBreB̃IuWFNeBuԂ<BR>
	 *
	 * @return ANeBreB̃IuWFNeBuԂ<BR>
	 */
	public LocalObjective[] getObjective() {
		return localObjective;
	}

	/**
	 * objective id w肵āA local objective 擾<BR>
	 * @param objectiveID objective id <BR>
	 * @return objective id  local objective<BR>
	 */
	public LocalObjective getObjective(String objectiveID) throws SystemException {
		for (int i = 0; i < localObjective.length; i++) {
			if (objectiveID.equals(localObjective[i].getObjectiveID())) {
				return localObjective[i];
			}
		}

		throw new SystemException(
			"getObjective failed [ActivityID:" + activity.getIdentifier() + "][ObjectiveID:" + objectiveID + "]");
	}

	/**
	 * [AbvɎQ邩ۂ̃tOQƂ<BR>
	 *
	 * @return boolean [AbvɎQ邩ۂ̃tO<BR>
	 *   ( true: [AbvɎQ / false; [AbvɎQȂ )<BR>
	 */
	public boolean getRollupObjectiveSatisfiedFlag() throws SystemException {
		try {
			CachedNode rollupRules = null;

			if (sequencingNode != null) {
				rollupRules = sequencingNode.selectSingleChildNode("rollupRules");
			}

			/*
			 *  rollup rules  node Ȃ΁AftHg擾
			 */
			if (rollupRules == null) {
				return Boolean.valueOf(Default.getValue("rollupRules/@rollupObjectiveSatisfied")).booleanValue();
			}

			/*
			 *  rollup rules  node ĂA attribute Ȃ΁AftHg擾
			 */
			CachedNode satisfiedNode = rollupRules.selectSingleChildNode("@rollupObjectiveSatisfied");
			if (satisfiedNode == null) {
				return Boolean.valueOf(Default.getValue("rollupRules/@rollupObjectiveSatisfied")).booleanValue();
			}

			/*
			 * ȊO attribute 擾
			 */
			return Boolean.valueOf(satisfiedNode.getNodeValue()).booleanValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getRollupObjectiveSatisfiedFlag failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * [AbvɎQ邩ۂ̃tOQƂ<BR>
	 *
	 * @return boolean [AbvɎQ邩ۂ̃tO<BR>
	 *   ( true: [AbvɎQ/ false: [AbvɎQȂ )<BR>
	 */
	public boolean getRollupProgressCompletionFlag() throws SystemException {
		try {
			CachedNode rollupRules = null;

			if (sequencingNode != null) {
				rollupRules = sequencingNode.selectSingleChildNode("rollupRules");
			}

			/*
			 *  rollup Rules  node Ȃ΁AftHg擾
			 */
			if (rollupRules == null) {
				return Boolean.valueOf(Default.getValue("rollupRules/@rollupProgressCompletion")).booleanValue();
			}

			/*
			 *  rollup rules  node ĂA attribute Ȃ΁A
			 *  ftHg擾
			 */
			CachedNode completionNode = rollupRules.selectSingleChildNode("@rollupProgressCompletion");

			if (completionNode == null) {
				return Boolean.valueOf(Default.getValue("rollupRules/@rollupProgressCompletion")).booleanValue();
			}

			/*
			 *  ȊO attribute ̒l擾AԂ
			 */
			return Boolean.valueOf(completionNode.getNodeValue()).booleanValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getRollupProgressCompletionFlag failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * [Abv̏dݕts<BR>
	 * 
	 * @return BigDecimal d݂<BR>
	 */
	public BigDecimal getRollupObjectiveMeasureWeight() throws SystemException {
		try {
			CachedNode rollupRules = null;

			if (sequencingNode != null) {
				rollupRules = sequencingNode.selectSingleChildNode("rollupRules");
			}

			/*
			 *  rollup rules  node Ȃ ftHg擾
			 */
			if (rollupRules == null) {
				return new BigDecimal(Default.getValue("rollupRules/@objectiveMeasureWeight")).setScale(
					4,
					BigDecimal.ROUND_HALF_UP);
			}

			/*
			 *  rollup rules  node Ă, objective measure weight  attribute Ȃ
			 *  ftHg擾
			 */
			CachedNode weightNode = rollupRules.selectSingleChildNode("@objectiveMeasureWeight");

			if (weightNode == null) {
				return new BigDecimal(Default.getValue("rollupRules/@objectiveMeasureWeight")).setScale(
					4,
					BigDecimal.ROUND_HALF_UP);
			}

			/*
			 *  lꍇ͂̒lԂ
			 */
			return new BigDecimal(weightNode.getNodeValue()).setScale(4, BigDecimal.ROUND_HALF_UP);
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getRollupObjectiveMeasureWeight failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * vC}IuWFNeBuObjective Progress Status擾
	 *
	 * @return vC}IuWFNeBuObjective Progress Status
	 */
	public boolean getObjectiveProgressStatus() throws SystemException {
		return getObjectiveContributeToRollup().getObjectiveProgressStatus();
	}

	/**
	 * vC}IuWFNeBuObjective Satisfied Status擾
	 *
	 * @return vC}IuWFNeBuObjective Satisfied Status
	 */
	public boolean getObjectiveSatisfiedStatus() throws SystemException {
		return getObjectiveContributeToRollup().getObjectiveSatisfiedStatus();
	}

	/**
	 * vC}IuWFNeBuObjective Measure Status擾
	 *
	 * @return vC}IuWFNeBuObjective Measure Status
	 */
	public boolean getObjectiveMeasureStatus() throws SystemException {
		return getObjectiveContributeToRollup().getObjectiveMeasureStatus();
	}

	/**
	 * vC}IuWFNeBuObjective Normalized Measure擾
	 *
	 * @return vC}IuWFNeBuObjective Normalized Measure
	 */
	public BigDecimal getObjectiveNormalizedMeasure() throws SystemException {
		return getObjectiveContributeToRollup().getObjectiveNormalizedMeasure();
	}

	/**
	 * Activity Progress Statusݒ肷
	 *
	 * @param status Activity Progress Status
	 */
	public void setActivityProgressStatus(boolean status) {
		progress.setActivityProgressStatus(status);
	}

	/**
	 * Activity Progress Status擾
	 *
	 * @return Activity Progress Status
	 */
	public boolean getActivityProgressStatus() throws SystemException {
		return progress.getActivityProgressStatus();
	}

	/**
	 * Activity Absolute Durationݒ肷
	 *
	 * @param duration Activity Absolute Duration
	 */
	public void setActivityAbsoluteDuration(Duration duration) throws SystemException {
		progress.setActivityAbsoluteDuration(duration);
	}

	/**
	 * Activity Absolute Duration擾
	 *
	 * @return Activity Absolute Duration
	 */
	public Duration getActivityAbsoluteDuration() throws SystemException {
		return progress.getActivityAbsoluteDuration();
	}

	/**
	 * Activity Experienced Durationݒ肷
	 *
	 * @param duration Activity Experienced Duration
	 */
	public void setActivityExperiencedDuration(Duration duration) throws SystemException {
		progress.setActivityExperiencedDuration(duration);
	}

	/**
	 * Activity Experienced Duration擾
	 *
	 * @return Activity Experienced Duration
	 */
	public Duration getActivityExperiencedDuration() throws SystemException {
		return progress.getActivityExperiencedDuration();
	}

	/**
	 * Activity Attempt Countݒ肷
	 *
	 * @param count Activity Attempt Count
	 */
	public void setActivityAttemptCount(int count) {
		progress.setActivityAttemptCount(count);
	}

	/**
	 * Activity Attempt Count擾
	 *
	 * @return Activity Attempt Count
	 */
	public int getActivityAttemptCount() {
		return progress.getActivityAttemptCount();
	}

	/**
	 * Attempt Progress Statusݒ肷
	 *
	 * @param status Attempt Progress Status
	 */
	public void setAttemptProgressStatus(boolean status) throws SystemException {
		progress.setAttemptProgressStatus(status);
	}

	/**
	 * Attempt Progress Status擾
	 *
	 * @return Attempt Progress Status
	 */
	public boolean getAttemptProgressStatus() throws SystemException {
		return progress.getAttemptProgressStatus();
	}

	/**
	 * Attempt Progress Status擾
	 *
	 * @return Attempt Progress Status
	 */
	public boolean getAttemptProgressStatus(boolean isCurrent) throws SystemException {
		return progress.getAttemptProgressStatus(isCurrent);
	}

	/**
	 * Attempt Completion Amountݒ肷
	 *
	 * @param amount Attempt Completion Amount
	 */
	public void setAttemptCompletionAmount(BigDecimal amount) throws SystemException {
		progress.setAttemptCompletionAmount(amount);
	}

	/**
	 * Attempt Completion Amount擾
	 *
	 * @return Attempt Completion Amount
	 */
	public BigDecimal getAttemptCompletionAmount() throws SystemException {
		return progress.getAttemptCompletionAmount();
	}

	/**
	 * Attempt Completion Statusݒ肷
	 *
	 * @param status Attempt Completion Status
	 */
	public void setAttemptCompletionStatus(boolean status) throws SystemException {
		progress.setAttemptCompletionStatus(status);
	}

	/**
	 * Attempt Completion Status擾
	 *
	 * @return Attempt Completion Status
	 */
	public boolean getAttemptCompletionStatus() throws SystemException {
		return progress.getAttemptCompletionStatus();
	}

	/**
	 * Attempt Absolute Durationݒ肷
	 *
	 * @param duration Attempt Absolute Duration
	 */
	public void setAttemptAbsoluteDuration(Duration duration) {
		progress.setAttemptAbsoluteDuration(duration);
	}

	/**
	 * Attempt Absolute Duration擾
	 *
	 * @return Attempt Absolute Duration
	 */
	public Duration getAttemptAbsoluteDuration() {
		return progress.getAttemptAbsoluteDuration();
	}

	/**
	 * Attempt Experienced Durationݒ肷
	 *
	 * @param duration Attempt Experienced Duration
	 */
	public void setAttemptExperiencedDuration(Duration duration) {
		progress.setAttemptExperiencedDuration(duration);
	}

	/**
	 * Attempt Experienced Duration擾
	 *
	 * @return Attempt Experienced Duration
	 */
	public Duration getAttemptExperiencedDuration() {
		return progress.getAttemptExperiencedDuration();
	}

	/**
	 * useCurrentAttempt 擾
	 *
	 * @return IsAttemptedInCurrentAttempt
	 */
	public boolean getUseCurrentAttempt(){
		return IsAttemptedInCurrentAttempt;
	}

	/**
	 * useCurrentAttempt Zbg
	 *
	 * @return Ȃ
	 */
	public void setUseCurrentAttempt(boolean tmpflag){
		IsAttemptedInCurrentAttempt = tmpflag;
	}
}
