/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	XPathUtil
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.util;

import java.util.ArrayList;

import javax.xml.transform.TransformerException;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtil {

	/** ArrayListNode[]ɕϊׂNode[0] */
	private static Node[] _toSingleArray = new Node[0];

	/** ArrayListNode[][]ɕϊׂNode[0][] */
	private static Node[][] _toDoubleArray = new Node[0][];

	/**
	 * w肳ꂽm[h̃m[hvtBbNX폜
	 *
	 * @param node	m[hw肷
	 * @return vtBbNX폜m[hԋp
	 */
	public static String getLocalName(Node node) {
		String nodeName = node.getNodeName();

		if (nodeName == null) {
			return null;
		}

		int positionOfColon = nodeName.indexOf(':');

		if (positionOfColon == -1) {
			return nodeName;
		}

		return nodeName.substring(positionOfColon + 1);
	}

	/**
	 * nodeŎw肳ꂽm[h̒̎q̃m[h1I
	 *
	 * @param	node	Ώۂ̃m[hw肷
	 * @param	xpath	xpathw肷Bɂ͈ȉ̕wł<br>
	 *					text()		ŏɌTextm[hCDATASectionm[hԋpB<br>
	 *					<pre>@[|*]<pre>	Ŏw肳ꂽAttrm[hԋpB*w肳ꂽꍇ
	 *								ŏɌAttrm[hԋpB<br>
	 *								vtBbNX̎w͂łȂB(OԂ͎włȂ)<br>
	 *					..			em[hԋpB<br>
	 *					.			nodeԋpB<br>
	 *					node()		ŏɌqm[hԋpB<br>
	 *					*			ŏɌElementm[hԋpB
	 *								vtBbNX̎w͂łȂB(OԂ͎włȂ)<br>
	 *					m[h	m[hɈvElementm[hԋpB
	 *								vtBbNX̎w͂łȂB(OԂ͎włȂ)<br>
	 * @return m[hԋpBȂꍇnullԋpB
	 */
	public static Node selectSingleChildNode(Node node, String xpath) {
		if (xpath.equals("text()")) {
			NodeList children = node.getChildNodes();

			int numberOfChildren = children.getLength();

			for (int i = 0; i < numberOfChildren; i++) {
				Node n = children.item(i);

				if ((n.getNodeType() == Node.TEXT_NODE) || (n.getNodeType() == Node.CDATA_SECTION_NODE)) {
					return n;
				}
			}

			return null;
		}
		else if (xpath.charAt(0) == '@') {
			String name = xpath.substring(1);

			NamedNodeMap attributes = node.getAttributes();

			if (name.equals("*")) {
				if (attributes.getLength() > 0) {
					return attributes.item(0);
				}

				return null;
			}

			int numberOfAttributes = attributes.getLength();

			for (int i = 0; i < numberOfAttributes; i++) {
				Node n = attributes.item(i);

				if (getLocalName(n).equals(name)) {
					return n;
				}
			}

			return null;
		}
		else if (xpath.equals("..")) {
			return node.getParentNode();
		}
		else if (xpath.equals(".")) {
			return node;
		}
		else if (xpath.equals("node()")) {
			NodeList children = node.getChildNodes();

			if (children.getLength() > 0) {
				return children.item(0);
			}

			return null;
		}
		else if (xpath.equals("*")) {
			NodeList children = node.getChildNodes();

			int numberOfChildren = children.getLength();

			for (int i = 0; i < numberOfChildren; i++) {
				Node n = children.item(i);

				if (n.getNodeType() == Node.ELEMENT_NODE) {
					return n;
				}
			}

			return null;
		}
		else {
			NodeList children = node.getChildNodes();

			int numberOfChildren = children.getLength();

			for (int i = 0; i < numberOfChildren; i++) {
				Node n = children.item(i);

				if (n.getNodeType() == Node.ELEMENT_NODE) {
					if (getLocalName(n).equals(xpath)) {
						return n;
					}
				}
			}

			return null;
		}
	}

	/**
	 * nodeŎw肳ꂽm[h̒̎q̃m[hI
	 *
	 * @param	node	Ώۂ̃m[hw肷
	 * @param	xpath	xpathw肷Bɂ͈ȉ̕wł<br>
	 *					text()		Textm[hCDATASectionm[hSĕԋpB<br>
	 *					<pre>@[|*]<pre>	Ŏw肳ꂽAttrm[hԋpB*w肳ꂽꍇ
	 *								SĂAttrm[hԋpB<br>
	 *								vtBbNX̎w͂łȂB(OԂ͎włȂ)<br>
	 *					..			em[hԋpB<br>
	 *					.			nodeԋpB<br>
	 *					node()		SĂ̎qm[hԋpB<br>
	 *					*			SĂ̌Elementm[hԋpB
	 *								vtBbNX̎w͂łȂB(OԂ͎włȂ)<br>
	 *					m[h	m[hɈvElementm[hԋpB
	 *								vtBbNX̎w͂łȂB(OԂ͎włȂ)<br>
	 * @return m[hNode[]ŕԋpBȂꍇlength0Node[]ԋpB
	 */
	public static Node[] selectChildNodeList(Node node, String xpath) {
		if (xpath.equals("text()")) {
			ArrayList selected = new ArrayList();

			NodeList children = node.getChildNodes();

			int numberOfChildren = children.getLength();

			for (int i = 0; i < numberOfChildren; i++) {
				Node n = children.item(i);

				if ((n.getNodeType() == Node.TEXT_NODE) || (n.getNodeType() == Node.CDATA_SECTION_NODE)) {
					selected.add(n);
				}
			}

			return (Node[])selected.toArray(_toSingleArray);
		}
		else if (xpath.charAt(0) == '@') {
			ArrayList selected = new ArrayList();

			String name = xpath.substring(1);

			NamedNodeMap attributes = node.getAttributes();

			if (name.equals("*")) {
				int numberOfAttributes = attributes.getLength();

				for (int i = 0; i < numberOfAttributes; i++) {
					selected.add(attributes.item(i));
				}
			}
			else {
				int numberOfAttributes = attributes.getLength();

				for (int i = 0; i < numberOfAttributes; i++) {
					Node n = attributes.item(i);

					if (getLocalName(n).equals(name)) {
						selected.add(n);
					}
				}
			}

			return (Node[])selected.toArray(_toSingleArray);
		}
		else if (xpath.equals("..")) {
			return new Node[] { node.getParentNode()};
		}
		else if (xpath.equals(".")) {
			return new Node[] { node };
		}
		else if (xpath.equals("node()")) {
			ArrayList selected = new ArrayList();

			NodeList children = node.getChildNodes();

			int numberOfChildren = children.getLength();

			for (int i = 0; i < numberOfChildren; i++) {
				selected.add(children.item(i));
			}

			return (Node[])selected.toArray(_toSingleArray);
		}
		else if (xpath.equals("*")) {
			ArrayList selected = new ArrayList();

			NodeList children = node.getChildNodes();

			int numberOfChildren = children.getLength();

			for (int i = 0; i < numberOfChildren; i++) {
				Node n = children.item(i);

				if (n.getNodeType() == Node.ELEMENT_NODE) {
					selected.add(n);
				}
			}

			return (Node[])selected.toArray(_toSingleArray);
		}
		else {
			ArrayList selected = new ArrayList();

			NodeList children = node.getChildNodes();

			int numberOfChildren = children.getLength();

			for (int i = 0; i < numberOfChildren; i++) {
				Node n = children.item(i);

				if (n.getNodeType() == Node.ELEMENT_NODE) {
					if (getLocalName(n).equals(xpath)) {
						selected.add(n);
					}
				}
			}

			return (Node[])selected.toArray(_toSingleArray);
		}
	}

	/**
	 * nodeŎw肳ꂽm[h̒̎q̃m[h1IBxpathɂ
	 * ȉ̏̕włB<br>
	 *
	 * 1.̎ẃuattribute::v̏ȗ`łu@v̂ݎwłB<br>
	 * 2.m[heXg͎włȂB<br>
	 * 3.m[hȊOԋpxpath͎włȂB<br>
	 * 4.xpathɎw肷m[hselectSingleChildNode\bhŎwł鎮̂݁B<br>
	 *
	 * @return m[hԋpBȂꍇnullԋpB
	 */
	public static Node selectSimpleSingleNode(Node node, String xpath) {
		if (xpath.charAt(0) == '/') {
			if (node.getNodeType() != Node.DOCUMENT_NODE) {
				node = node.getOwnerDocument();
			}

			xpath = xpath.substring(1);

			if (xpath.length() <= 0) {
				return node;
			}
		}

		String[] nodePath = xpath.split("/");

		Node current = node;

		for (int i = 0; i < nodePath.length; i++) {
			current = selectSingleChildNode(current, nodePath[i]);
			if (current == null) {
				break;
			}
		}

		return current;
	}

	/**
	 * nodeŎw肳ꂽm[h̒̎q̃m[hIBxpathɂ
	 * ȉ̏̕włB<br>
	 *
	 * 1.̎ẃuattribute::v̏ȗ`łu@v̂ݎwłB<br>
	 * 2.m[heXg͎włȂB<br>
	 * 3.m[hȊOԋpxpath͎włȂB<br>
	 * 4.xpathɎw肷m[hselectChildNodeList\bhŎwł鎮̂݁B<br>
	 *
	 * @return m[hNode[]ŕԋpBȂꍇlength0Node[]ԋpB
	 */
	public static Node[] selectSimpleNodeList(Node node, String xpath) {
		if (xpath.charAt(0) == '/') {
			if (node.getNodeType() != Node.DOCUMENT_NODE) {
				node = node.getOwnerDocument();
			}

			xpath = xpath.substring(1);

			if (xpath.length() <= 0) {
				return new Node[] { node };
			}
		}

		String[] nodePath = xpath.split("/");

		Node[][] current = { { node }, };

		ArrayList selected = new ArrayList();

		for (int i = 0; i < nodePath.length; i++) {
			for (int j = 0; j < current.length; j++) {
				for (int k = 0; k < current[j].length; k++) {
					selected.add(selectChildNodeList(current[j][k], nodePath[i]));
				}
			}

			current = (Node[][])selected.toArray(_toDoubleArray);
			selected.clear();
		}

		for (int i = 0; i < current.length; i++) {
			for (int j = 0; j < current[i].length; j++) {
				selected.add(current[i][j]);
			}
		}

		return (Node[])selected.toArray(_toSingleArray);
	}

	/**
	 * XPathAPI#selectSingleNodegpAm[ȟs
	 *
	 * @param node	m[hw肷
	 * @param xpath	XPathw肷
	 * @return XPathAPI#selectSingleNodeł̌
	 */
	public static Node selectSingleNode(Node node, String xpath) throws TransformerException {
		synchronized (XPathAPI.class) {
			return XPathAPI.selectSingleNode(node, xpath);
		}
	}

	/**
	 * XPathAPI#selectNodeListgpAm[ȟs
	 *
	 * @param node	m[hw肷
	 * @param xpath	XPathw肷
	 * @return XPathAPI#selectNodeListł̌
	 */
	public static Node[] selectNodeList(Node node, String xpath) throws TransformerException {
		synchronized (XPathAPI.class) {
			NodeList nodeList = XPathAPI.selectNodeList(node, xpath);

			if (nodeList == null) {
				return null;
			}

			Node[] nodes = new Node[nodeList.getLength()];

			for (int i = 0; i < nodes.length; i++) {
				nodes[i] = nodeList.item(i);
			}

			return nodes;
		}
	}
}
