/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.core;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;
import jp.co.ntt.lms.installer.util.XmlUtil;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * CXg[ʃf[^EIuWFNgB
 * [U͂f[^ݒt@C̒lꌳǗ邽߂̃NXB<br>
 *
 * @author T.Nishiki
 */
public class InstallerValues {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB<br>
	 * Oo̓IuWFNg擾܂B
	 */
	static {
		_logger = LoggerUtil.getLogger(InstallerControl.class);
	}

	/**
	 * CXg[EvpeBwlkDOM DocumentB
	 */
	private Document _propertiesDoc;

	/**
	 * bZ[WwlkDOM DocumentB
	 */
	private Document _messagesDoc;

	/**
	 * eANVŐݒ肷lێtB[hB
	 */
	private Map _actionValueMap;

	/**
	 * vWFNg̃x[XƂȂfBNgB
	 */
	private File _projectBaseDir;

	/**
	 * CXg[݂fBNgB
	 */
	private File _installerDir;

	/**
	 * CXg[̈ꎞt@CۑfBNgB
	 */
	private File _installerTempDir;

	/**
	 * \[X̊_ƂȂpXB
	 */
	private String _resourceBasePath;

	/**
	 * CXg[ō쐬fBNgEXgB
	 */
	private List _madeDirectoriesList;

	/**
	 * ILȎIԁB<br>
	 * uLOʂL[̕vL[ƂA
	 * uLOIꍇtrueAIȂꍇfalseƂboolean
	 * bvBooleanIuWFNgvlƂ܂B<br>
	 * ܂AMapɓo^ĂȂLÓAIƂ܂B<br>
	 */
	private Map _optionLOSelcted;

	/**
	 * f[^x[XʁB<br>
	 */
	private String _dbCategory;

	/**
	 * RXgN^B
	 * @param document CXg[EvpeBwlkDOM DocumentB
	 * @throws InstallerException documentnull̏ꍇA
	 *          bZ[W\[X擾łȂꍇB
	 */
	InstallerValues(Document document)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger, "InstallerValues(" + document + ")");

		try {
			_propertiesDoc = document;
			_actionValueMap = Collections.synchronizedMap(new HashMap());
			// =================================================================
			// bZ[WvpeBXML̎擾
			String messagesXmlURI = getProperty("resource.messages");
			// URI̎w肪Ȃꍇ̓CXg[EvpeBC
			if (StringUtil.isEmpty(messagesXmlURI)) {
				_messagesDoc = _propertiesDoc;
			}
			// URI̎w肪ꍇADOM Document
			else {
				_messagesDoc
					= XmlUtil.convertXmlResourceToDocument(
						messagesXmlURI);
			}
			// =================================================================
			// CXg[fBNg
			String userDir = System.getProperty("user.dir");
			_installerDir = new File(userDir);
			// =================================================================
			// vWFNg̃x[XfBNg
			String projectPath = getProperty("path.project");
			_projectBaseDir
				= new File(_installerDir, projectPath).getCanonicalFile();
			// =================================================================
			// CXg[̈ꎞt@CۑfBNg
			String tempPath = getProperty("path.dir.installer.temp");
			_installerTempDir
				= new File(_installerDir, tempPath).getCanonicalFile();
			// =================================================================
			// CXg[̈ꎞt@CۑfBNg
			_resourceBasePath = getProperty("path.dir.resources");
			// =================================================================
			// CXg[ō쐬fBNgEXg
			_madeDirectoriesList = new ArrayList();
			// =================================================================
			// IvVLOI
			_optionLOSelcted = new HashMap();
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger, "InstallerValues(" + document + ")");
	}

	/**
	 * eANVœo^l擾܂B
	 * @param name o^Ƃ̖́B
	 * @return nameɑΉlo^Ă΂̒l߂܂B
	 *          o^ĂȂnull߂܂B
	 */
	public InstallerActionValue getActionValue(String name) {
		return (InstallerActionValue)_actionValueMap.get(name);
	}

	/**
	 * eANVlo^܂B
	 * @param action actionValue𐶐NXB
	 * @param actionValue o^lB
	 */
	void setActionValue(InstallerAction action,
			InstallerActionValue actionValue) {
		_logger.info("setActionValue(" + action + "," + actionValue + ")");
		_actionValueMap.put(action.getClass().getName(), actionValue);
	}

	/**
	 * ݒt@C̓eɊÂANVNXzŎ擾܂B
	 * @return sƂȂANVNX̔zB
	 * @throws InstallerException 擾ɃG[ꍇB
	 */
	public InstallerAction[] getActions()
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger, "getActions()");
		InstallerAction[] actions = getActions("actions");
		// \bhIO
		LoggerUtil.methodTail(_logger, "getActions()", actions);
		return actions;
	}

	/**
	 * ݒt@C̓eɊÂpANVNXzŎ擾܂B
	 * @return sƂȂANVNX̔zB
	 * @throws InstallerException 擾ɃG[ꍇB
	 */
	public InstallerAction[] getRestreActions()
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger, "getRestreActions()");
		InstallerAction[] actions = getActions("restoreActions");
		// \bhIO
		LoggerUtil.methodTail(_logger, "getRestreActions()", actions);
		return actions;
	}


	/**
	 * ݒt@C̓eɊÂANVNXzŎ擾܂B
	 * @param actionsTagName 擾ANV`ĂvfB
	 * @return sƂȂANVNX̔zB
	 * @throws InstallerException 擾ɃG[ꍇB
	 */
	private InstallerAction[] getActions(String actionsTagName)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger, "getActions(" + actionsTagName + ")");

		InstallerAction[] actions = null;
		try {
			List list = new ArrayList();
			// ANV`Ăm[hXg̎擾
			NodeList actionClassNodes = XPathAPI.selectNodeList(
				_propertiesDoc,
				"/installer/" + actionsTagName + "/action/@name" );
			// ANV̎擾
			int nodeLength = actionClassNodes.getLength();
			if (_logger.isLoggable(Level.INFO)) {
				_logger.log(Level.INFO,
					"Number of action classes:" + nodeLength);
			}
			// Sm[hɂāA`ĂNX[h
			for (int i = 0; i < nodeLength; i++) {
				Node actionClassNode = actionClassNodes.item(i);
				String actionClassName = actionClassNode.getNodeValue();
				if (_logger.isLoggable(Level.INFO)) {
					_logger.log(Level.INFO,
						"actionClassName[" + i + "]:" + actionClassName);
				}
				Class actionClass = Class.forName(actionClassName);
				InstallerAction action =
					(InstallerAction)actionClass.newInstance();
				list.add(action);
			}
			// Xgz
			actions = new InstallerAction[list.size()];
			list.toArray(actions);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getActions(" + actionsTagName + ")", actions);
		return actions;
	}

	/**
	 * bZ[W擾܂B<br>
	 * @param messageKey bZ[W擾邽߂̃L[B
	 * @return messageKeyɑΉ郁bZ[WB擾łȂꍇ͋󕶎B
	 */
	public String getMessage(String messageKey) {
		// \bhJnO
		LoggerUtil.methodHead(_logger, "getMessage(" + messageKey + ")");
		String message = getMessage(messageKey, null);
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getMessage(" + messageKey + ")", message);
		return message;
	}

	/**
	 * bZ[W擾܂B<br>
	 * bZ[Wݒt@CAL[ɑΉ郁bZ[W擾A
	 * 擾łꍇ́AMessageFormatƓnꂽuz𗘗pāA
	 * bZ[W𐶐Ė߂܂B
	 * @param messageKey bZ[W擾邽߂̃L[B
	 * @param params uzB
	 * @return messageKeyɑΉ郁bZ[WB擾łȂꍇ͋󕶎B
	 * @see java.text.MessageFormat
	 */
	public String getMessage(String messageKey, Object[] params) {
		// \bhJnO
		String logMessage = null;
		if (LoggerUtil.isLoggableMethod(_logger)) {
			logMessage = "getMessage(" + messageKey
				+ "," + StringUtil.toString(params) + ")";
			LoggerUtil.methodHead(_logger, logMessage);
		}

		// ̃\bh̖߂l
		String message = null;
		try {
			// ݒt@C烁bZ[W擾܂B
			String messagePath =
				"/installer/messages/message[@id=\""
					+  messageKey + "\"]/text()";
			String messageProperty
				= XmlUtil.getNodeValue( _messagesDoc, messagePath );
			if (StringUtil.isEmpty(messageProperty)) {
				message = "";
			}
			else if (params == null) {
				message = messageProperty;
			}
			// 擾łAAuz擾łꍇA`܂B
			else {
				message = MessageFormat.format(messageProperty, params);
			}
		}
		catch (Exception e) {
		}
		// NULL͕ԋpȂB
		if (message == null) {
			message = "";
		}
		// \bhIO
		if (LoggerUtil.isLoggableMethod(_logger)) {
			LoggerUtil.methodTail(_logger, logMessage, message);
		}
		return message;
	}

	/**
	 * vWFNg̃x[XƂȂfBNg擾܂B<br>
	 * @return vWFNg̃x[XƂȂfBNg\FileIuWFNgB
	 * @throws InstallerException 擾ɎsꍇB
	 */
	public File getProjectBaseDir() throws InstallerException {
		return _projectBaseDir;
	}

	/**
	 * CXg[݂fBNg擾܂B<br>
	 * @return CXg[݂fBNg\FileIuWFNgB
	 * @throws InstallerException 擾ɎsꍇB
	 */
	public File getInstallerDir() throws InstallerException {
		return _installerDir;
	}

	/**
	 * CXg[̈ꎞt@CۑfBNg擾܂B<br>
	 * @return CXg[̈ꎞt@CۑfBNg\FileIuWFNgB
	 * @throws InstallerException 擾ɎsꍇB
	 */
	public File getInstallerTempDir() throws InstallerException {
		return _installerTempDir;
	}


	/**
	 * ꎞIɃRs[t@C擾܂B<br>
	 * ꎞIɃRs[t@CA
	 * vWFNg̃x[X_ƂpXƁA
	 * CXg[̈ꎞt@CۑfBNg_ƂpXƂ̑gŖ߂܂B
	 * @return ȉ̌`Filez̔zB
	 * <table border="1">
	 * 	<tr>
	 * 		<td>CfbNX</td>
	 * 		<td>e</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>0</td>
	 * 		<td>vWFNg̃x[X_ƂpX</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>1</td>
	 * 		<td>CXg[̈ꎞt@CۑfBNg_ƂpX</td>
	 * 	</tr>
	 * </table>
	 * @throws InstallerException 擾ɎsꍇB
	 */
	public File[][] getCopiedFiles()
			throws InstallerException {
		// \bhIO
		LoggerUtil.methodHead(_logger, "getCopiedFiles()");
		// \bh̖߂l
		File[][] returnFiles = null;
		try {
			String[] filePathes = XmlUtil.getNodeValues(
				_propertiesDoc, "/installer/files/file/@path");
			List list = new ArrayList();
			for (int i = 0; i < filePathes.length; i++) {
				File fileOnBase	= new File(
					_projectBaseDir, filePathes[i]).getCanonicalFile();
				File fileOnTemp = new File(
					_installerTempDir, filePathes[i]).getCanonicalFile();
				File[] files = new File[] {
					fileOnBase, fileOnTemp
				};
				list.add(files);
			}
			returnFiles = new File[list.size()][];
			list.toArray(returnFiles);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger, "getCopiedFiles()", returnFiles);
		return returnFiles;
	}

	/**
	 * VXeɑ݂Ăw肳ꂽt@C擾܂B<br>
	 * @param fileKey t@C擾邽߂̃L[B
	 * @return vWFNg̃x[X_ƂāA
	 *          fileKey΃pXŎ擾t@CB
	 * @throws InstallerException t@C̎擾ɎsꍇB
	 */
	public File getFileOnSystem(String fileKey) throws InstallerException {
		// \bhIO
		LoggerUtil.methodHead(_logger,
			"getFileOnSystem(" + fileKey + ")");
		// \bh̖߂l
		File file = null;
		try {
			String filePath = XmlUtil.getNodeValue(
				_propertiesDoc,
				"/installer/files/file[@name=\"" + fileKey + "\"]/@path");
			file = new File(
				_projectBaseDir, filePath).getCanonicalFile();
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getFileOnSystem(" + fileKey + ")", file);
		return file;
	}

	/**
	 * VXeURL擾܂B<br>
	 * @param hostName zXǵB
	 * @return w肳ꂽzXgɊÂAVXeURLB
	 */
	public String getSystemURL(String hostName) {
		String systemURL = null;
		String property = getProperty("systemurl");
		systemURL = MessageFormat.format(property, new Object[] {hostName});
		return systemURL;
	}

	/**
	 * CXg[ō쐬fBNg̈ꗗǉ܂B<br>
	 * @param directory ǉfBNgB
	 */
	public void addMadeDirectory(File directory) {
		if (directory != null) {
			_madeDirectoriesList.add(directory);
		}
	}

	/**
	 * CXg[ō쐬fBNg̈ꗗ擾܂B<br>
	 * @return CXg[ō쐬fBNg\FileIuWFNg̔zB
	 */
	public File[] getMadeDirectories() {
		File[] madeDirectories = new File[ _madeDirectoriesList.size() ];
		_madeDirectoriesList.toArray(madeDirectories);
		return madeDirectories;
	}

	/**
	 * w肳ꂽ\[XL[̓̓Xg[擾܂B<br>
	 * @param resourceKey 擾郊\[Ẍʒu擾邽߂̃L[B
	 * @return resourceKeywpX̃\[X̓̓Xg[B
	 *          擾łȂꍇ́Anull߂܂B
	 * @throws InstallerException \[X擾ɎsꍇB
	 */
	public InputStream getResourceKeyStream(String resourceKey)
			throws InstallerException {
		// \bhIO
		LoggerUtil.methodHead(_logger,
			"getResourceKeyStream(" + resourceKey + ")");
		// \bh̖߂l
		InputStream resourceStream = null;
		try {
			// \[X̃pX擾
			String resourcePath = getResourcePath(resourceKey);
			resourceStream = getResourcePathStream(resourcePath);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getResourceKeyStream(" + resourceKey + ")", resourceStream);
		return resourceStream;
	}

	/**
	 * w肳ꂽ\[XEpX̓̓Xg[擾܂B<br>
	 * @param resourcePath 擾郊\[X̃pXB
	 * @return resourcePath\[X̓̓Xg[B
	 *          擾łȂꍇ́Anull߂܂B
	 * @throws InstallerException \[X擾ɎsꍇB
	 */
	public InputStream getResourcePathStream(String resourcePath)
			throws InstallerException {
		// \bhIO
		LoggerUtil.methodHead(_logger,
			"getResourcePathStream(" + resourcePath + ")");
		// \bh̖߂l
		InputStream resourceStream = null;
		try {
			// NXE[_ăXg[擾
			ClassLoader loader = ClassLoader.getSystemClassLoader();
			resourceStream = loader.getResourceAsStream(resourcePath);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getResourcePathStream(" + resourcePath + ")", resourceStream);
		return resourceStream;
	}

	/**
	 * w肳ꂽ\[X̕R[h擾܂B<br>
	 * @param resourceKey 擾郊\[Ẍʒu擾邽߂̃L[B
	 * @return resourceKeyŎ擾\[Xencode߂܂B
	 *          擾łȂꍇUTF-8߂܂B
	 * @throws InstallerException 擾ɎsꍇB
	 */
	public String getResourceKeyEncode(String resourceKey)
			throws InstallerException {
		// \bhIO
		LoggerUtil.methodHead(_logger,
			"getResourceKeyEncode(" + resourceKey + ")");
		// \bh̖߂l
		String encode = null;
		try {
			// ΃pX擾
			encode = XmlUtil.getNodeValue( _propertiesDoc,
					"/installer/files/file"
					+ "[@name=\"" + resourceKey + "\"]/@encode");
			// 擾łȂꍇ̓pXݒ
			if (StringUtil.isEmpty(encode) == true) {
				encode = "UTF-8";
			}
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			encode = "UTF-8";
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getResourceKeyEncode(" + resourceKey + ")", encode);
		return encode;
	}


	/**
	 * w肳ꂽ\[X̃pX擾܂B<br>
	 * @param resourceKey 擾郊\[Ẍʒu擾邽߂̃L[B
	 * @return resourceKeyŎ擾΃pXɁA_pXtpXB
	 *          擾łȂꍇnull߂܂B
	 * @throws InstallerException 擾ɎsꍇB
	 */
	private String getResourcePath(String resourceKey)
			throws InstallerException {
		// \bhIO
		LoggerUtil.methodHead(_logger,
			"getResourcePath(" + resourceKey + ")");
		// \bh̖߂l
		String resourcePath = null;
		try {
			// ΃pX擾
			String resourceRelativePath
				= XmlUtil.getNodeValue( _propertiesDoc,
					"/installer/files/file"
					+ "[@name=\"" + resourceKey + "\"]/@path");
			// 擾łȂꍇ̓pXݒ
			if (StringUtil.isEmpty(resourceRelativePath) == false) {
				resourcePath = _resourceBasePath;
				if (resourcePath.charAt(resourcePath.length() - 1) != '/') {
					resourcePath += "/";
				}
				resourcePath += resourceRelativePath;
			}
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getResourcePath(" + resourceKey + ")", resourcePath);
		return resourcePath;
	}

	/**
	 * w肵̂ɑΉvpeB擾B<br>
	 * @param propertyName 擾vpeB̖́B
	 * @return propertyNameɑΉvpeBlB
	 *          擾łȂꍇ͋󕶎߂܂B
	 */
	public String getProperty(String propertyName) {
		String propertyValue = null;
		try {
			propertyValue = XmlUtil.getNodeValue(
				_propertiesDoc,
				"/installer/properties/property"
				 + "[@name=\"" + propertyName + "\"]/@value");
		}
		catch (Exception e) {
			propertyValue = "";
		}
		return propertyValue;
	}

	/**
	 * LOIΏۂLOʂ邽߂̃L[擾B
	 * @return LOʂ邽߂̃L[̔zB
	 */
	public String[] getOptionLOKeys() {
		String[] optionLOKeys = null;
		try {
			optionLOKeys = XmlUtil.getNodeValues(
				_propertiesDoc,
				"/installer/optionLOs/optionLO/@name");
		}
		catch (Exception e) {
			optionLOKeys = new String[0];
		}
		return optionLOKeys;
	}

	/**
	 * f[^x[X֘AvpeB擾܂B
	 * @param propertyName vpeBB
	 * @return propertyNameɑΉvpeBlB
	 *          擾łȂꍇ͋󕶎߂܂B
	 */
	public String getDbProperty(String propertyName) {
		String propertyValue = getDbProperty(propertyName, _dbCategory);
		return propertyValue;
	}

	/**
	 * f[^x[X֘AvpeB擾܂B
	 * @param propertyName vpeBB
	 * @param dbCategory f[^x[X̎ʁB
	 * @return propertyNameɑΉvpeBlB
	 *          擾łȂꍇ͋󕶎߂܂B
	 */
	public String getDbProperty(String propertyName, String dbCategory) {
		String propertyValue = null;
		try {
			propertyValue = XmlUtil.getNodeValue(
				_propertiesDoc,
				"/installer/dbscripts/database"
				 + "[@category=\"" + dbCategory + "\"]"
				 + "/property[@name=\"" + propertyName + "\"]"
				 + "/@value");
		}
		catch (Exception e) {
			propertyValue = "";
		}
		return propertyValue;
	}

	/**
	 * LȎIo^܂B<br>
	 * @param loKey LOʂ邽߂̃L[B
	 * @param selected IꍇtrueAȈꍇfalseB
	 */
	public void setOptionLOSelected(String loKey, boolean selected) {
		if (loKey != null) {
			_optionLOSelcted.put(loKey, Boolean.valueOf(selected));
		}
	}

	/**
	 * LȎI擾܂B<br>
	 * @param loKey LOʂ邽߂̃L[B
	 * @return IĂꍇtrueAȈꍇfalseB
	 */
	public boolean getOptionLOSelected(String loKey) {
		// ̃\bh̖߂l
		boolean selected = false;

		// L[̎w肪ȂꍇAI
		if (loKey == null) {
			selected = false;
		}
		else {
			Boolean selectedBoolean = (Boolean)_optionLOSelcted.get(loKey);
			// o^ȂꍇAI
			if (selectedBoolean == null) {
				selected = true;
			}
			// o^ꍇAo^eɊÂ
			else {
				selected = selectedBoolean.booleanValue();
			}
		}
		return selected;
	}

	////////////////////////////////////////////////////////////////////////////
	// f[^x[X֘A\bh
	/**
	 * f[^x[Xʂ擾܂B
	 * @return f[^x[Xʂ߂܂B
	 */
	public String getDbCategory() {
		return _dbCategory;
	}

	/**
	 * f[^x[Xʂݒ肵܂B
	 * @param dbCategory ݒ肷f[^x[XʁB
	 */
	public void setDbCategory(String dbCategory) {
		_dbCategory = dbCategory;
	}

	/**
	 * f[^x[XƎ̃vpeB̂擾܂B
	 * @return f[^x[XƎ̃vpeB̂̔z߂܂B
	 *          ݒ肪Ȃꍇ͋󕶎߂܂B
	 */
	public String[] getDbExtendPropetyName() {
		String[] propertyNames = null;
		try {
			String path = "/installer/dbscripts"
				+ "/database[@category=\"" + getDbCategory() + "\"]"
				+ "/extendProperties/extendProperty/@name";
			propertyNames = XmlUtil.getNodeValues(_propertiesDoc, path);
		}
		catch (Exception e) {
			propertyNames = new String[0];
		}
		return propertyNames;
	}

	/**
	 * NG[擾邽߂̏擾܂B<br>
	 * @param queryType 擾NG̃^Cv̎ʎqB
	 * @return ȉ̍\̕z̔z߂܂B
	 * 擾łȂꍇ͗vfO̔z߂܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>Y</th>
	 * 		<th>e</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>0</td>
	 * 		<td>NG[郊\[X̃pX</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>1</td>
	 * 		<td>\[X̃GR[h</td>
	 * 	</tr>
	 * </table>
	 * @throws InstallerException 擾ɃG[ꍇB
	 */
	public String[][] getQueryResources(String queryType)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger, "getQueryResources(" + queryType + ")");
		List queryResourcesList = new ArrayList();
		try {
			// <queries>vf擾
			String queriesPath = "/installer/dbscripts"
				+ "/database[@category=\"" + getDbCategory() + "\"]"
				+ "/queries[@type=\"" + queryType + "\"]";
			_logger.info("queriesPath=" + queriesPath);
			Element queriesElement = (Element)XPathAPI.selectSingleNode(
					_propertiesDoc, queriesPath);
			if (queriesElement != null) {
				String commonEncode = queriesElement.getAttribute("encode");
				// <query>vf̃Xg擾
				NodeList queryElements
					= XPathAPI.selectNodeList(queriesElement, "./query");
				// eNG̃\[XƃGR[h擾āAXg
				for (int i = 0; i < queryElements.getLength(); i++) {
					Element queryElement = (Element)queryElements.item(i);
					String resourcePath
						= queryElement.getAttribute("resourcePath");
					String encode = queryElement.getAttribute("encode");
					if (StringUtil.isEmpty(encode)) {
						encode = commonEncode;
					}
					String[] queryResource = new String[] {
						resourcePath, encode
					};
					queryResourcesList.add(queryResource);
				}
			}
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
		}
		// \bh̖߂l
		String[][] queryResources = null;
		queryResources = new String[queryResourcesList.size()][];
		queryResourcesList.toArray(queryResources);
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getQueryResources(" + queryType + ")", queryResources);
		return queryResources;
	}
}
