/*
 * wKJnNX
 * 
 * 쐬: 2006/10/23
 */

package jp.co.ntt.lms.imode.lo.scorm.engine;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.co.ntt.lms.imode.common.MobConst;
import jp.co.ntt.lms.imode.common.MobileUtl;
import jp.co.ntt.lms.imode.extension.PageSequence;
import jp.co.ntt.lms.lo.util.UserIDFolder;
import jp.co.ntt.lms.lo.scorm.engine.Engine;
import jp.co.ntt.lms.lo.scorm.engine.ExecuteParameters;
import jp.co.ntt.lms.lo.scorm.engine.SCORMAPIAdapter;
import jp.co.ntt.lms.lo.scorm.engine.TimeoutWatcher;
import jp.co.ntt.lms.lo.scorm.util.Authentication;
import jp.co.ntt.lms.lo.scorm.util.Debug;
import jp.co.ntt.lms.lo.scorm.util.SG;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;
import jp.co.ntt.lms.lo.scorm.util.XPathUtil;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsRequest;
import jp.co.ntt.lms.xms.framework.XmsSystemException;

import org.w3c.dom.Document;


/**
 * wKJnNX
 * 
 * @author ntc-sakai
 */
public class StartEngine {

	/** s */
	private boolean status;

	/** QdN */
	private boolean isDuplication = false;

	/** SEQG[ */
	private boolean isPageSeq = false;

	/**
	 * wKJns
	 * 
	 * @param xmsRequest xmsRequestNX
	 * @throws XmsException
	 * 
	 */
	public void request(XmsRequest xmsRequest) throws XmsException {
		// knfo	
		DebugLog.write(getClass(), "[request]HEAD", DebugLog.ROW);

		HttpServletRequest request = xmsRequest.getRequest();
		HttpSession session = request.getSession();
		ServletContext application = session.getServletContext();

		try {
			// ̓p[^擾i^[URLj
			String returnURL = request.getParameter("returnURL");

			if (MobileUtl.isEmpty(returnURL)) {
				// ߂URLp[^
				DebugLog.write(getClass(), "[request]returnURL not found ", DebugLog.HIGHT );
				// wKJnԂG[ɐݒ肷
				status = false;
				return;
			}

			// Np[^쐬
			ExecuteParameters executeParameters = new ExecuteParameters();

			executeParameters.initialize(xmsRequest);

			// -----------------------
			// `FbN
			// -----------------------

			// F؂s
			if (!Authentication
				.authenticate(
					executeParameters.getUserID(),
					executeParameters.getLOID(),
					xmsRequest.getParameter("AuthKey"))) {
				// F؃G[
				DebugLog.write(getClass(), "[request]AuthenticationError UserId = "
						+ executeParameters.getUserID() + " LOID = "
						+ executeParameters.getLOID(), DebugLog.HIGHT );
				// wKJnԂG[ɐݒ肷
				status = false;
				return;
			}

			// GWapplicationɑ݂邩ǂ`FbN
			String engineKeyName =
				"SCORM." + executeParameters.getUserID() + "." + executeParameters.getLOID() + ".ENGINE";

			// GWapplicationɑ݂ꍇ
			if (application.getAttribute(engineKeyName) != null) {
				// ZbVłrdpǗNX擾
				PageSequence pageSeq = (PageSequence) session.getAttribute(MobConst.S_PAGE_SEQ);
				if (pageSeq == null) {
					// ZbVɕłrdpǗNX݂ȂꍇAQdNG[
					// I
					ForceSuspendLearn fsl = new ForceSuspendLearn(engineKeyName);
					fsl.request(xmsRequest);
					if (!fsl.isStatus()) {
						// IG[
						DebugLog.write(getClass(), "[request]LearningLogSendError engineKey = "
								+ engineKeyName, DebugLog.HIGHT );
					}
					// ߂tqksessonɐݒ肷
					session.setAttribute("MOBILE.RETURN_URL", returnURL);
					isDuplication = true;
					isPageSeq = false;
				} else {
					// ZbVɕłrdpǗNX݂ꍇAłrdpG[
					isDuplication = false;
					isPageSeq = true;
				}
				// wKJnԂG[ɐݒ肷
				status = false;
				return;
			}

			// e`FbN펞
			// f + ލ\XMSUM
			StringBuffer studyInfoURL = new StringBuffer();

			studyInfoURL.append(executeParameters.getStudyInfoURL());
			studyInfoURL.append("?USERID=");
			studyInfoURL.append(executeParameters.getUserID());
			studyInfoURL.append("&LOID=");
			studyInfoURL.append(executeParameters.getLOID());
			studyInfoURL.append("&StudySession=");
			studyInfoURL.append(executeParameters.getStudySessionCount());
			studyInfoURL.append("&COMD=");
			studyInfoURL.append(executeParameters.getStartCommand());
			studyInfoURL.append("&AuthKey=");
			studyInfoURL.append(
				Authentication.createKey(
					null,
					executeParameters.getUserID(),
					executeParameters.getLOID(),
					SG.get("ManagerName")));

			// f + ލ\Document
			Document doc;

			try {
				doc = XMLUtil.newDocumentBuilder(false).parse(studyInfoURL.toString());
			}
			catch (Exception ex) {
				DebugLog.write(getClass(), "[request]Manifest File parse error", DebugLog.HIGHT);
				Debug.write(ex);
				status = false;
				return;
			}

			// 擾ʂ`FbN
			String studyInfoStatus;
			studyInfoStatus = XPathUtil.selectSimpleSingleNode(doc.getDocumentElement(), "status/text()").getNodeValue();

			// f + ލ\擾G[ꍇ
			if (!studyInfoStatus.equals("0")) {
				DebugLog.write(getClass(), "[request]Manifest File parse error(status = "
						+ studyInfoStatus + ")", DebugLog.HIGHT);
				status = false;
				return;
			}
			// ލ\DOM Documentɂ
			Document manifest =
				XMLUtil.createDocument(XPathUtil.selectSingleChildNode(doc.getDocumentElement(), "manifest"), false);

			// fDOM Documentɂ
			Document resume = null;

			// ĊĴݒf擾
			if (executeParameters.getStartCommand().equals("CONT")) {
				// fDOM Documentɂ
				resume =
					XMLUtil.createDocument(
						XPathUtil.selectSingleChildNode(doc.getDocumentElement(), "resume"),
						false);
			}

			// GW쐬
			Engine engine = new Engine(executeParameters);

			// GW
			try {
				engine.initialize(manifest, resume);
			} catch (Exception e) {
				DebugLog.write(getClass(), "[request]engine initialize error", DebugLog.HIGHT);
				Debug.write(e);
				status = false;
				return;
			}

			// navtrace.xml̃t@C쐬Axml錾ǉ
			StringBuffer navtraceLogFile = new StringBuffer();

			navtraceLogFile.append(userIDPath(SG.get("ResumeDataBaseURL"), executeParameters.getUserID()));
			navtraceLogFile.append(File.separator);
			navtraceLogFile.append(executeParameters.getLOID());
			navtraceLogFile.append(File.separator);
			navtraceLogFile.append(executeParameters.getStudySessionCount());
			navtraceLogFile.append(File.separator);
			navtraceLogFile.append(executeParameters.getLaunchCount());
			navtraceLogFile.append(File.separator);

			// navtrace.xmli[tH_݂Ȃꍇ͍쐬
			File file = new File(navtraceLogFile.toString());

			if (!file.exists()) {
				file.mkdirs();
			}

			navtraceLogFile.append("navtrace.xml");

			PrintWriter pw = new PrintWriter(new FileWriter(navtraceLogFile.toString()));

			try {
				pw.println("<?xml version=\"1.0\" encoding=\"" + SG.get("XMLEncoding") + "\"?>");
			}
			finally {
				pw.close();
			}

			// SEQNX
			PageSequence pageSeq = new PageSequence();
			// gтrbnqlaNX
			MobSCORMBean scormbean = new MobSCORMBean(executeParameters.getManifestID());
			// ^CAEgĎNXANp[^Aapi adaptersessionɐݒ肷
			session.setAttribute("SCORM.TIMEOUT_WATCHER", new TimeoutWatcher(executeParameters));
			session.setAttribute("SCORM.EXECUTE_PARAMETERS", executeParameters);
			session.setAttribute("SCORM.API_ADAPTER", new SCORMAPIAdapter(executeParameters));

			// ߂tqksessonɐݒ肷
			session.setAttribute("MOBILE.RETURN_URL", returnURL);
			// SEQNXsessionɐݒ肷
			session.setAttribute(MobConst.S_PAGE_SEQ, pageSeq);
			// gтrbnqlasessionɐݒ肷B
			session.setAttribute(MobConst.S_SCORM_BEAN, scormbean);
			// GWapplicationɐݒ肷
			application.setAttribute(engineKeyName, engine);
			// wKJnԂɐݒ肷
			status = true;

			// knfo
			DebugLog.write(getClass(), "[request]TAIL", DebugLog.ROW);

		} catch (Exception e) {
			// knfo
			DebugLog.write(getClass(), "[request]Exception error", DebugLog.ROW);
			Debug.write(e);
			throw new XmsSystemException(e);
		}

		
	}

	/**
	 * GWJnsʂ߂܂B
	 * @return status  ̏ꍇtrue G[̏ꍇfalse
	 */
	public boolean isStatus() {
		return status;
	}

	/**
	 * QdN̗L߂܂B
	 * 
	 * @return isDuplication QdN̏ꍇtrue ̏ꍇfalse
	 */
	public boolean isDuplication() {
		return isDuplication;
	}

	/**
	 * SEQG[Ԃ߂܂B
	 * 
	 * @return isPageSeq G[̏ꍇtrue ̏ꍇfalse
	 */
	public boolean isPageSeq() {
		return isPageSeq;
	}

	private static String userIDPath(String strDirPath, String strUserID)
	{
		return UserIDFolder.getPath(strDirPath, strUserID);
	}
}
