//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	Activity
//
//	ύX
//		2002.12.25  VK쐬

package jp.co.ntt.lms.lo.scorm.kernel;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import javax.xml.transform.TransformerException;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.CachedNode;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
* ANeBreBNX<BR>
* ANeBreB\NX<BR>
*/
public class Activity {
	/** item node */
	private CachedNode itemNode;

	/** ID */
	private String courseIdentifier;

	/** SCO ID */
	private String identifier;

	/** child activity set */
	private Activity[] children;

	/** parent activity */
	private Activity parentActivity;

	/** sequencing */
	private Sequencing sequencing;

	/** resource */
	private Resource resource;

	/**
	 * RXgN^ <BR>
	 * 
	 * @param manifestNode ލ\`̃ANeBreB̃m[h <BR>
	 * @param itemNode ActivityΏitemm[h
	 * @param globalObjectives O[oIuWFNeBu̔z <BR>
	 * @param courseID ID <BR>
	 */
	public Activity(
		CachedNode manifestNode,
		CachedNode itemNode,
		GlobalObjective[] globalObjectives,
		String courseID)
		throws SystemException {

		try {
			this.itemNode = itemNode;

			/*
			 *  activity id ̎擾
			 *  Ȃ exception
			 */
			CachedNode identifierNode = itemNode.selectSingleChildNode("@identifier");
			if (identifierNode == null) {
				throw new SystemException("ANeBreBID܂B(no activity identifier)");
			}

			identifier = identifierNode.getNodeValue();

			/*
			 *  course id 擾
			 */
			courseIdentifier = courseID;

			/*
			 *  sequencing node 擾
			 *  ȂĂAnull ̂܂ܓn
			 */
			CachedNode sequencingNode = itemNode.selectSingleChildNode("sequencing");

			//̎qitemnode listŎ擾
			CachedNode[] childItemNodes = itemNode.selectChildNodeList("item");

			boolean hasChildren = ((childItemNodes != null) && (childItemNodes.length > 0));

			sequencing = new Sequencing(this, manifestNode, sequencingNode, globalObjectives, hasChildren);

			// 擾m[h݂ΎqANeBreB̂ōċA
			if (hasChildren) {
				//qANeBreBvpeBɃZbg
				children = new Activity[childItemNodes.length];

				//q̐ċA
				for (int i = 0; i < children.length; i++) {
					children[i] = new Activity(manifestNode, childItemNodes[i], globalObjectives, courseID);
					//eƂĎZbg
					children[i].setParent(this);
				}
			}
			else {
				// identifierRe
				CachedNode identifierRefNode = itemNode.selectSingleChildNode("@identifierref");

				// \[X̐
				if (identifierRefNode != null) {
					// hLg擾āA\[X̃RXgN^ɓn
					resource =
						new Resource(
							identifierRefNode.getNodeValue(),
							manifestNode.selectSingleChildNode("resources"));
				}
			}
		}
		catch (Exception ex) {
			throw new SystemException(
				"ANeBreB̍쐬Ɏs܂B( activity constractor failed ) " + "[" + this.identifier + "]",
				ex);
		}
	}

	/**
	 * f擾 <BR>
	 *
	 * @param doc	<trackinginformation>^O[g^ODOM Documentw肷
	 * @param parentNode 쐬fǉׂ(e)Ggm[hw肷B
	 * @param deep	qANeBreB̒f擾邩ǂw肷<br>
	 *				truew肵ꍇ͎擾Afalsew肵ꍇ͎擾Ȃ
	 * @param traceLog	g[XpEfpU蕪tO<br>
	 */
	public void save(Document doc, Element parentNode, boolean deep, boolean traceLog) throws SystemException {
		Element activity =
			XMLUtil.insertAttribute(doc, XMLUtil.append(doc, parentNode, "activity"), "id", identifier);

		sequencing.save(doc, activity, traceLog);

		if (deep) {
			if (children != null) {
				for (int i = 0; i < children.length; i++) {
					children[i].save(doc, activity, true, traceLog);
				}
			}
		}
	}

	/*
	 * useCurrentAttempẗׂ̌lXV
	 */
	public void setCandidatePreviousValue() throws SystemException {
		sequencing.setCandidatePreviousValue();
	}

	/**
	 * ANeBreB̒f߂ <BR>
	 *
	 * @param parentNode f(<activity>^O)擾(e)Ggm[hw肷B
	 */
	public void initializeActivityInformation(CachedNode parentNode) throws SystemException {
		try {
			CachedNode activityNode;

			if (parentNode == null) {
				activityNode = null;
			}
			else {
				activityNode = parentNode.selectSingleNodeWithNodeTest("activity", "@id", identifier);
			}

			sequencing.initializeSequencingInformation(activityNode);

			//qꍇ͎qփZbg
			if (children != null) {
				//q̐JԂ
				for (int i = 0; i < children.length; i++) {
					children[i].initializeActivityInformation(activityNode);
				}
			}
		}
		catch (Exception ex) {
			throw new SystemException(
				"f̐ݒɎs܂B( setActivityInformation failed ) " + "[" + this.identifier + "]",
				ex);
		}
	}

	/**
	 * s̏<BR>
	 */
	public void initializeAttemptInformation() throws SystemException {
		// sequencing ̎s̏
		sequencing.initializeAttemptInformation();
	}

	/**
	 * I<BR>
	 */
	public void terminate() throws SystemException {

		try {
			itemNode = null;

			if (children != null) {
				for (int i = 0; i < children.length; i++) {
					children[i].terminate();
					children[i] = null;
				}
			}

			parentActivity = null;

			sequencing.terminate();
			sequencing = null;

			if (resource != null) {
				resource.terminate();
				resource = null;
			}
		}
		catch (SystemException e) {
			throw e;
		}
	}

	/**
	 * CBTCOM
	 * @param userID
	 * @param userName
	 * @param URL
	 * @param parentNode
	 * @param deep
	 */
	public void initializeAPIAdapter(
		String userID,
		String userName,
		String URL,
		String encoding,
		CachedNode parentNode,
		boolean deep)
		throws SystemException, TransformerException {

		if ((parentNode != null) && (children == null)) {
			CachedNode activityNode = parentNode.selectSingleNodeWithNodeTest("activity", "@id", identifier);
			sequencing.initializeAPIAdapter(userID, userName, URL, encoding, activityNode);
		}
		else if (children == null) {
			sequencing.initializeAPIAdapter(userID, userName, URL, encoding, null);
		}

		if (deep) {
			//ċAĂяoŎqANeBreB֐ݒ
			if (children != null) {
				for (int i = 0; i < children.length; i++) {
					children[i].initializeAPIAdapter(userID, userName, URL, encoding, parentNode, true);
				}
			}
		}
	}

	/**
	 * CBTCOM
	 * @param userID
	 * @param userName
	 * @param URL
	 * @param parentNode
	 * @param deep
	 */
	public void initializeAPIAdapter2(
		String userID,
		String userName,
		String URL,
		String encoding)
		throws SystemException, TransformerException {

		if (children == null) {
			sequencing.initializeAPIAdapter2(userID, userName, URL, encoding);
		}
	}
	
	/**
	 * OAPIAdapter璆f擾 <BR>
	 *
	 * @param doc	<communicationmodule>^O[g^ODOM Documentw肷
	 * @param parentNode	f(<activity>^O)ǉ(e)Ggw肷
	 */
	public void saveAPIAdapter(Document doc, Element parentNode) throws SystemException {
		if (children == null) {
			Element activity =
				XMLUtil.insertAttribute(doc, XMLUtil.append(doc, parentNode, "activity"), "id", identifier);

			sequencing.saveAPIAdapter(doc, activity);
		}

		//qANeBreBΎqANeBreBɍċA
		if (children != null) {
			for (int i = 0; i < children.length; i++) {
				children[i].saveAPIAdapter(doc, parentNode);
			}
		}
	}

	/**
	 * OAPIAdpater̍ĊJs
	 */
	public void resumeAPIAdapter() throws SystemException {
		sequencing.resumeAPIAdapter();
	}

	/**
	 * gbLO̓
	 */
	public void synchronizeTrackingModel() throws SystemException {
		sequencing.synchronizeTrackingModel();
	}

	/**
	 * Sequencing̃CX^X̎擾
	 *
	 * @return SequencingNX̃CX^X̎Q <BR>
	 */
	public Sequencing getSequencing() {
		return sequencing;
	}

	/**
	* eZbg
	* @param parent eANeBreBƂăZbgANeBreB <BR>
	*/
	public void setParent(Activity parent) {
		this.parentActivity = parent;
	}

	/**
	* eANeBreBԂB
	*
	* @return eANeBreBԂ
	*/
	public Activity getParent() {
		return parentActivity;
	}

	/**
	* ANeBreBID擾
	* @return String ANeBreBIDԂ
	*/
	public String getIdentifier() {
		return identifier;
	}

	/** 
	* ANeBreB̎SqANeBreB擾
	* 
	* @return Activity[] SqANeBreB̔z
	*/
	public Activity[] getChildren() {
		return children;
	}

	/**
	*  p\ȃANeBreB̎擾 <BR>
	*
	* @return Activity[] p\ȎqANeBreB̔z
	*/
	public Activity[] getAvailableChildren() {
		return sequencing.getStatus().getAvailableChildren();
	}

	/**
	*  p\ȃANeBreB̐ݒ <BR>
	*
	* @param availablechildren p\ȎqANeBreB̔z
	*/
	public void setAvailableChildren(Activity[] availablechildren) {
		sequencing.getStatus().setAvailableChildren(availablechildren);
	}

	/**
	*  p\ȃANeBreB̍폜 <BR>
	*/
	public void removeAvailableChildren() {
		sequencing.getStatus().setAvailableChildren(null);
		// qANeBreBO
		if ((this.children != null) && (children.length > 0)) {
			for (int i = 0; i < children.length; i++) {
				children[i].removeAvailableChildren();
			}
		}
	}

	/**
	* ANeBreBAvailableChildrenɊ܂܂邩ۂ<BR>
	* @return boolean ܂܂邩ۂ<BR>
	*     ( true: ܂܂ / false: ܂܂Ȃ )<BR>
	*/
	public boolean isAvailable() {
		return sequencing.isAvailable();
	}

	/**
	* Xe[^X̃IuWFNg擾<BR>
	* @return Status ANeBreB̃Xe[^X<BR>
	*/
	public Status getStatus() {
		return sequencing.getStatus();
	}

	/**
	 * ANeBreBc[\Ō̃ANeBreB肷<BR>
	 * @return 茋
	 */
	public boolean canAvailableForward() {

		if (this.hasAvailableChildren()) {
			return true;
		}
		else {
			if (this.isAvailableLast()) {
				if (this.isRoot()) {
					return false;
				}
				return this.parentActivity.canParentAvailableForward();
			}
			else {
				return true;
			}
		}
	}

	/**
	 * ANeBreBc[\Ō̃ANeBreB肷<BR>
	 * eANeBreBċAp<BR>
	 * @return 茋
	 */
	private boolean canParentAvailableForward() {

		if (this.isRoot()) {
			return false;
		}
		if (this.isAvailableLast()) {
			return this.parentActivity.canParentAvailableForward();
		}
		else {
			return true;
		}
	}

	/**
	 * ANeBreBc[\ŏ̃ANeBreB肷<BR>
	 * @return 茋
	 */
	public boolean canAvailableBackward() {
		if (this.isAvailableFirst()) {
			if (this.isRoot()) {
				return false;
			}
			return this.parentActivity.canParentAvailableBackward();
		}
		else {
			return true;
		}
	}

	/**
	 * ANeBreBc[\ŏ̃ANeBreB肷<BR>
	 * eANeBreBċAp<BR>
	 * @return 茋
	 */
	private boolean canParentAvailableBackward() {

		if (this.isRoot()) {
			return false;
		}
		if (this.isAvailableFirst()) {
			return this.parentActivity.canParentAvailableBackward();
		}
		else {
			return true;
		}
	}

	/**
	*	Available Children ̍ŏۂ<BR>
	*
	*  @return boolean ŏۂ<BR>
	*    true:    Available Children̍ŏ̃ANeBreBł<BR>
	*    false:   Available Children̍ŏ̃ANeBreBł͂Ȃ<BR>
	*/
	public boolean isAvailableFirst() {
		if (this.isRoot()) {
			return true;
		}

		return parentActivity.getAvailableChildren()[0].getIdentifier().equals(identifier);
	}

	/**
	* NX^ abailable children ̍Ō̃ANeBreB<BR>
	* ǂ̃`FbN<BR>
	* 
	* @return Ō̃ANeBreBǂ<BR>
	* ( true: Ō̃ANeBreB / false: Ō̃ANeBreBłȂ )<BR>
	*/
	public boolean isAvailableLast() {
		if (this.isRoot()) {
			return true;
		}

		Activity[] availableSibling = parentActivity.getAvailableChildren();

		return availableSibling[availableSibling.length - 1].getIdentifier().equals(identifier);
	}

	/**
	*	q̔<BR>
	* 
	* @return qANeBreBǂ <BR>
	* ( true: qANeBreB / false: qANeBreBȂ)<BR>
	*/
	public boolean hasChildren() {
		if ((this.children == null) || (children.length <= 0)) {
			return false;
		}

		return true;
	}

	/**
	 *  available children Ă邩ۂ̔<BR>
	 *  ( wK\ȎqANeBreB)
	 *  @return true   available children Ă<BR>
	 *               false available children ĂȂ<BR>
	 */
	public boolean hasAvailableChildren() {
		Activity[] availableChildren = this.getStatus().getAvailableChildren();

		if ((availableChildren == null) || (availableChildren.length <= 0)) {
			return false;
		}

		return true;
	}

	/**
	*  ̔z̎qANeBreBANeBreBIDw <BR>
	*  ANeBreB擾
	* 
	* @param activityIdentifier 擾ANeBreBID <BR>
	* @return IDw̃ANeBreB <BR>
	* ANeBreBȂꍇnullԂ 
	*/
	public Activity getActivity(String activityIdentifier) {
		// IDȂthisԂ
		if (this.identifier.equals(activityIdentifier)) {
			return this;
		}

		// łȂꍇ͎qɒTĂ炤
		if (children != null) {
			for (int i = 0; i < children.length; i++) {
				Activity target = children[i].getActivity(activityIdentifier);
				if (target != null) {
					return target;
				}
			}
		}

		return null;
	}

	/**
	* ANeBreBލ\c[̃[gANeBreB <BR>
	* ǂ`FbN
	* 
	* @return ANeBreBc[̃[gANeBreBǂ<BR>
	* B( true: [g̃ANeBreBł / false: [g̃ANeBreBłȂ )<BR>
	*/
	public boolean isRoot() {
		return (this.parentActivity == null);
	}

	/**
	* ލ\c[̃[g̃ANeBreBԂ <BR>
	* 
	* @return [g̃ANeBreBԂ
	* ( ȂꍇnullԂ)
	*/
	public Activity getRoot() {
		Activity root = this.getParent();

		// ԂlnullȂe͂Ȃ̂ŎԂ
		if (root == null) {
			return this;
		}

		//łȂ΁AgetParentJԂ
		while (root.getParent() != null) {
			root = root.getParent();
		}

		return root;
	}

	/**
	*	NX^̎qANeBreBɂ鏇Ԃ擾
	*
	* @return NX^ł̏
	*/
	public int getOrder() throws SystemException {
		// root̏ꍇOrder0Ƃ
		if (this.isRoot()) {
			return 0;
		}

		// łȂꍇAêŁAq̒T
		Activity[] set = this.getParent().getChildren();

		// children̒猟
		for (int i = 0; i < set.length; i++) {
			if (this.identifier.equals(set[i].getIdentifier())) {
				return i; //ԂԂ
			}
		}

		throw new SystemException("ΏۃANeBreB܂ (getOrder failed) [" + this.identifier + "]");
	}

	/**
	*	NX^̎qANeBreBɂ鏇Ԃ擾<BR>
	*
	* @return NX^ł̏<BR>
	*              root ̏ꍇ 0 Ԃ<BR>
	*/
	public int getAvailableOrder() throws SystemException {
		// root̏ꍇOrder0Ƃ
		if (this.isRoot()) {
			return 0;
		}

		// łȂꍇAêŁAq̒T
		Activity[] set = this.getParent().getAvailableChildren();

		// children̒猟
		for (int i = 0; i < set.length; i++) {
			if (this.identifier.equals(set[i].getIdentifier())) {
				return i; //ԂԂ
			}
		}

		throw new SystemException("ΏۃANeBreB܂B(getAvailableOrder failed) [" + this.identifier + "]");
	}

	/**
	*  ID擾<BR>
	*
	* @return ID
	*/
	public String getCourseIdentifier() {
		return courseIdentifier;
	}

	/**
	* isVisiblẽtOԂ <BR>
	* (ڎŃ^Cg\邩ۂ̃tO) <BR>
	* 
	* @return ڎ̕\̉ۂ <BR>
	*  ( true: \ / false: \Ȃ ) <BR>
	*/
	public boolean getIsVisibleFlag() {
		CachedNode isVisibleNode = itemNode.selectSingleChildNode("@isvisible");

		if (isVisibleNode == null) {
			return true;
		}

		return Boolean.valueOf(isVisibleNode.getNodeValue()).booleanValue();
	}

	/**
	* ^CgԂ <BR>
	* @return ^Cg<BR>
	*/
	public String getTitle() {
		CachedNode titleNode = itemNode.selectSimpleSingleNode("title/text()");

		if (titleNode == null) {
			return null;
		}

		return titleNode.getNodeValue();
	}

	/**
	* \[X̎擾 <BR>
	*
	* @return \[XIuWFNg<BR>
	*/
	public Resource getResource() {
		return resource;
	}

	/**
	* choice Rg[[h̃tO <BR>
	* qANeBreBɑ΂choicẽirQ[VNGXg <BR>
	* 邩ۂ̃tO <BR>
	*
	* @return choiceirQ[VNGXg̉ <BR>
	* ( true: I\ / false: Is ) <BR>
	*/
	public boolean getChoiceFlag() throws SystemException {
		return sequencing.getControlModeFlag("choice");
	}

	/**
	* choiceExit Rg[[h̃tO<BR>
	* NX^̃ANeBreBchoiceɂāẢۂ̃tO <BR>
	*
	* @return choiceirQ[VCxg̉<BR>
	* ( true: choiceŊ\ / false: choiceŊs) <BR>
	*/
	public boolean getChoiceExitFlag() throws SystemException {
		return sequencing.getControlModeFlag("choiceExit");
	}
	
	// 2010.10.05 taku-harada add >>
	/**
	* jump Rg[[h̃tO <BR>
	* qANeBreBɑ΂jump̃irQ[VNGXg <BR>
	* 邩ۂ̃tO <BR>
	*
	* @return jumpirQ[VNGXg̉ <BR>
	* ( true: I\ / false: Is ) <BR>
	*/
	public boolean getJumpFlag() throws SystemException {
		return sequencing.getControlModeFlag("jump");
	}
	// 2010.10.05 taku-harada add <<

	/**
	* flow Rg[[h̃tO <BR>
	* NX^̃ANeBreBɑ΂ <BR>
	* continue/previousirQ[VNGXg邩ۂ̃tO <BR>
	* 
	* @return boolean continue/previousirQ[VNGXg̉ۂ <BR>
	* ( true: continue/previous\ / /false: continue/previous͕s) <BR>
	*/
	public boolean getFlowFlag() throws SystemException {
		return sequencing.getControlModeFlag("flow");
	}

	/**
	* forward only Rg[[h̃tO<BR>
	* NX^̃ANeBreBflowɂāAiނƂ̂ł𐧌tO<BR>
	* 
	* @return 𐧌邩ۂ <BR>
	*  true: NX^̑Jڕ݂̂ɐ <BR>
	*  false: NX^̑Jڕ𐧌Ȃ <BR>
	*/
	public boolean getForwardOnlyFlag() throws SystemException {
		return sequencing.getControlModeFlag("forwardOnly");
	}

	/**
	* ⏕\[XԂ<BR>
	*
	* @return ⏕\[X̔zԂ <BR>
	*/
	public AuxiliaryResource[] getAuxiliaryResources() throws SystemException {
		return sequencing.getAuxiliaryResources();
	}

	/**
	* ANeBreBProgressԂ <BR>
	*
	* @return ANeBreBProgressԂ <BR>
	* 
	*/
	public Progress getProgress() {
		return sequencing.getProgress();
	}

	/**
	* ANeBreBɊ֘ASObjectiveԂ<BR>
	* 
	* @return ANeBreBɊ֘ASObjectiveԂ <BR>
	*/
	public LocalObjective[] getObjective() throws SystemException {
		return sequencing.getObjective();
	}

	/**
	* ANeBreBɊ֘AObjective̓Aw肵ObjectiveԂ<BR>
	* @param ObjectiveID
	* @return w肵Objectiveԋp <BR>
	*/
	public LocalObjective getObjective(String ObjectiveID) throws SystemException {
		return sequencing.getObjective(ObjectiveID);
	}

	/**
	* [AbvɗpObjectiveԂ <BR>
	*
	* @return [AbvɊ֘AObjectiveԂ <BR>
	*/
	public LocalObjective getObjectiveContributeToRollup() {
		return sequencing.getObjectiveContributeToRollup();
	}
	/**
	* OA_v^擾<BR>
	*
	* @return OA_v^<BR>
	*/
	public SCORMCommunicationModule getCommunicationModule() throws SystemException {
		return sequencing.getCommunicationModule();
	}

	/**
	 * dataFromLMSl̎擾s
	 *
	 * @return data From LMS
	 */
	public String getDataFromLMS() {
		CachedNode dataFromLMSNode = itemNode.selectSimpleSingleNode("dataFromLMS/text()");

		if (dataFromLMSNode != null) {
			return dataFromLMSNode.getNodeValue();
		}else{
			dataFromLMSNode = itemNode.selectSimpleSingleNode("datafromlms/text()");
			if (dataFromLMSNode != null){
				return dataFromLMSNode.getNodeValue();
			}
		}
		return null;
	}

	/**
	 * CompletionThresholdl̎擾s
	 *
	 * @return CompletionThreshold
	 */
	public String getCompletionThreshold() {
		// 2011.09.02 taku-harada mod >>
		// 2010.10.01 taku-harada mod >>
		CachedNode completionThreshold = itemNode.selectSimpleSingleNode("completionThreshold/text()");

		if (completionThreshold != null) {
			return completionThreshold.getNodeValue();
		}
//		CachedNode completionThreshold = itemNode.selectSimpleSingleNode("completionThreshold");
//		if (completionThreshold != null) {
//			CachedNode minProgressMeasure = completionThreshold.selectSingleChildNode("@minProgressMeasure");
//			if (minProgressMeasure != null) {
//				return minProgressMeasure.getNodeValue();
//			}
//		}
		// 2010.10.01 taku-harada mod <<
		// 2011.09.02 taku-harada mod >>
		
		return null;
	}

	// 2011.09.09 taku-harada add >>
	/**
	 * ProgressMeasurel̎擾s
	 *
	 * @return  ProgressMeasure
	 */
	public String getProgressMeasure() {
		CachedNode progressMeasure = itemNode.selectSimpleSingleNode("progressMeasure/text()");

		if (progressMeasure != null) {
			return progressMeasure.getNodeValue();
		}
		
		return null;
	}
	// 2011.09.09 taku-harada add <<

	/**
	 * datal̎擾s
	 *
	 * @return datam[h̎qm[hXg
	 */
	public Vector<Map<String, String>> getData() {
		CachedNode completionThreshold = itemNode.selectSimpleSingleNode("data");
		
		if (completionThreshold != null) {
			CachedNode[] mapNodes = completionThreshold.selectChildNodeList("map");

			Vector<Map<String, String>> vec = new Vector<Map<String, String>>();

			for (int i = 0; i < mapNodes.length; i++) {
				Map<String, String> map = new HashMap<String, String>();

				String targetID = "";
				String writeSharedData = "";
				String readSharedData = "";
				
				CachedNode targetID_ch = mapNodes[i].selectSingleChildNode("@targetID");
				CachedNode writeSharedData_ch = mapNodes[i].selectSingleChildNode("@writeSharedData");
				CachedNode readSharedData_ch = mapNodes[i].selectSingleChildNode("@readSharedData");
				
				if(targetID_ch != null)targetID = targetID_ch.getNodeValue();
				if(writeSharedData_ch != null)writeSharedData = writeSharedData_ch.getNodeValue();
				if(readSharedData_ch != null)readSharedData = readSharedData_ch.getNodeValue();
				
				map.put("targetID", targetID);
				map.put("writeSharedData", writeSharedData);
				map.put("readSharedData", readSharedData);
				
				vec.add(map);
			}
			
			return vec;

		}
		
		return null;
	}

	/**
	 * hideLMSUIl̎擾s
	 *
	 * @return hide LMSUI
	 */
	public String[] getHideLMSUI() {
		CachedNode[] hideLMSUINodes =
			itemNode.selectSimpleNodeList("presentation/navigationInterface/hideLMSUI/text()");

		if (hideLMSUINodes == null) {
			return null;
		}

		String[] hideLMSUI = new String[hideLMSUINodes.length];

		for (int i = 0; i < hideLMSUI.length; i++) {
			hideLMSUI[i] = hideLMSUINodes[i].getNodeValue();
		}

		return hideLMSUI;
	}

	/**
	 * persistStatel̎擾s
	 *
	 * @return persistStatel
	 */
	public boolean getPersistState() {
		CachedNode persistStateNode = itemNode.selectSimpleSingleNode("persistState/text()");

		if (persistStateNode == null) {
			return false;
		}

		return Boolean.valueOf(persistStateNode.getNodeValue()).booleanValue();
	}

	/**
	 * timeLimitActionl̎擾s
	 *
	 * @return timeLimitActionl
	 */
	public String getTimeLimitAction() {
		CachedNode timeLimitActionNode = itemNode.selectSimpleSingleNode("timeLimitAction/text()");

		if (timeLimitActionNode != null) {
			return timeLimitActionNode.getNodeValue();
		}else{
			timeLimitActionNode = itemNode.selectSimpleSingleNode("timelimitaction/text()");
			if (timeLimitActionNode != null){
				return timeLimitActionNode.getNodeValue();
			}
		}

		return null;
	}

	/**
	 * parametersl̎擾s
	 *
	 * @return parametersl
	 */
	public String getParameters() {
		CachedNode parametersNode = itemNode.selectSimpleSingleNode("@parameters");

		if (parametersNode != null) {
			return parametersNode.getNodeValue();
		}

		return null;
	}

	/**
	 * @param learningLogFolder	wKȌo͐w肷B
	 *
	 * @return ()SCOւURLԋpB
	 */
	public String getURL(String learningLogFolder) throws SystemException {
		return sequencing.getURL(learningLogFolder);
	}

	/**
	 * Activity is ActivẽtOQƂ <BR>
	 *
	 * @return ANeBreB̏Ԃ( true:wK / false:wK ) <BR>
	 */
	public boolean isActive() {
		return sequencing.getStatus().getActivityIsActive();
	}

	/**
	 * Activity is Suspended̃tOݒ肷
	 *
	 * @param status Ԃw肷B(true:, false:)
	 */
	public void setActive(boolean status) {
		sequencing.getStatus().setActivityIsActive(status);
	}

	/**
	 * Activity is Suspended̃tOQƂ
	 *
	 * @return boolean ANeBreB̒fԂ(trueFf /false:͖wK) <BR>
	 */
	public boolean isSuspended() {
		return sequencing.getStatus().getActivityIsSuspended();
	}

	/**
	 * Activity is Suspended̃tOݒ肷
	 *
	 * @param status Ԃw肷B(true:f, false:f)
	 */
	public void setSuspended(boolean status) {
		sequencing.getStatus().setActivityIsSuspended(status);
	}

	/**
	 * vC}IuWFNeBuObjective Progress Status擾
	 *
	 * @return vC}IuWFNeBuObjective Progress Status
	 */
	public boolean getObjectiveProgressStatus() throws SystemException {
		return sequencing.getObjectiveContributeToRollup().getObjectiveProgressStatus();
	}

	public boolean getObjectiveLocalProgressStatus() throws SystemException {
		return sequencing.getObjectiveContributeToRollup().getObjectiveLocalProgressStatus();
	}
	/**
	 * vC}IuWFNeBuObjective Satisfied Status擾
	 *
	 * @return vC}IuWFNeBuObjective Satisfied Status
	 */
	public boolean getObjectiveSatisfiedStatus() throws SystemException {
		return sequencing.getObjectiveContributeToRollup().getObjectiveSatisfiedStatus();
	}

	/**
	 * vC}IuWFNeBuObjective Measure Status擾
	 *
	 * @return vC}IuWFNeBuObjective Measure Status
	 */
	public boolean getObjectiveMeasureStatus() throws SystemException {
		return sequencing.getObjectiveMeasureStatus();
	}

	/**
	 * vC}IuWFNeBuObjective Normalized Measure擾
	 *
	 * @return vC}IuWFNeBuObjective Normalized Measure
	 */
	public BigDecimal getObjectiveNormalizedMeasure() throws SystemException {
		return sequencing.getObjectiveNormalizedMeasure();
	}

	/**
	 * Activity Progress Statusݒ肷
	 *
	 * @param status Activity Progress Status
	 */
	public void setActivityProgressStatus(boolean status) {
		sequencing.setActivityProgressStatus(status);
	}

	/**
	 * Activity Progress Status擾
	 *
	 * @return Activity Progress Status
	 */
	public boolean getActivityProgressStatus() throws SystemException {
		try {
			return sequencing.getActivityProgressStatus();
		}
		catch (SystemException e) {
			throw e;
		}
	}

	/**
	 * Activity Absolute Durationݒ肷
	 *
	 * @param duration Activity Absolute Duration
	 */
	public void setActivityAbsoluteDuration(Duration duration) throws SystemException {
		sequencing.setActivityAbsoluteDuration(duration);
	}

	/**
	 * Activity Absolute Duration擾
	 *
	 * @return Activity Absolute Duration
	 */
	public Duration getActivityAbsoluteDuration() throws SystemException {
		return sequencing.getActivityAbsoluteDuration();
	}

	/**
	 * Activity Experienced Durationݒ肷
	 *
	 * @param duration Activity Experienced Duration
	 */
	public void setActivityExperiencedDuration(Duration duration) throws SystemException {
		sequencing.setActivityExperiencedDuration(duration);
	}

	/**
	 * Activity Experienced Duration擾
	 *
	 * @return Activity Experienced Duration
	 */
	public Duration getActivityExperiencedDuration() throws SystemException {
		return sequencing.getActivityExperiencedDuration();
	}

	/**
	 * Activity Attempt Count擾
	 *
	 * @param count Activity Attempt Count
	 */
	public void setActivityAttemptCount(int count) {
		sequencing.setActivityAttemptCount(count);
	}

	/**
	 * Activity Attempt Count擾
	 *
	 * @return Activity Attempt Count
	 */
	public int getActivityAttemptCount() {
		return sequencing.getActivityAttemptCount();
	}

	/**
	 * Attempt Progress Statusݒ肷
	 *
	 * @param status Attempt Progress Status
	 */
	public void setAttemptProgressStatus(boolean status) throws SystemException {
		sequencing.setAttemptProgressStatus(status);
	}

	/**
	 * Attempt Progress Status擾
	 *
	 * @return Attempt Progress Status
	 */
	public boolean getAttemptProgressStatus() throws SystemException {
		return sequencing.getAttemptProgressStatus();
	}

	public boolean getAttemptProgressStatus(boolean isCurrent) throws SystemException {
		return sequencing.getAttemptProgressStatus(isCurrent);
	}
	/**
	 * Attempt Completion Amountݒ肷
	 *
	 * @param amount Attempt Completion Amount
	 */
	public void setAttemptCompletionAmount(BigDecimal amount) throws SystemException {
		sequencing.setAttemptCompletionAmount(amount);
	}

	/**
	 * Attempt Completion Amount擾
	 *
	 * @return Attempt Completion Amount
	 */
	public BigDecimal getAttemptCompletionAmount() throws SystemException {
		return sequencing.getAttemptCompletionAmount();
	}

	/**
	 * Attempt Completion Statusݒ肷
	 *
	 * @param status Attempt Completion Status
	 */
	public void setAttemptCompletionStatus(boolean status) throws SystemException {
		sequencing.setAttemptCompletionStatus(status);
	}

	/**
	 * Attempt Completion Status擾
	 *
	 * @return Attempt Completion Status
	 */
	public boolean getAttemptCompletionStatus() throws SystemException {
		return sequencing.getAttemptCompletionStatus();
	}

	/**
	 * Attempt Absolute Durationݒ肷
	 *
	 * @param duration Attempt Absolute Duration
	 */
	public void setAttemptAbsoluteDuration(Duration duration) {
		sequencing.setAttemptAbsoluteDuration(duration);
	}

	/**
	 * Attempt Absolute Duration擾
	 *
	 * @return JgANeBreBAttempt Absolute Duration
	 */
	public Duration getAttemptAbsoluteDuration() {
		return sequencing.getAttemptAbsoluteDuration();
	}

	/**
	 * Attempt Experienced Durationݒ肷
	 *
	 * @param duration Attempt Experienced Duration
	 */
	public void setAttemptExperiencedDuration(Duration duration) {
		sequencing.setAttemptExperiencedDuration(duration);
	}

	/**
	 * Attempt Experienced Duration擾
	 *
	 * @return Attempt Experienced Duration
	 */
	public Duration getAttemptExperiencedDuration() {
		return sequencing.getAttemptExperiencedDuration();
	}

	/**
	 * JgANeBreBPrevious\ǂ擾
	 *
	 * @return Previous\ȏꍇtrueAȊȌꍇfalseԋp
	 */
	public boolean canPrevious() throws SystemException {
		boolean result = false;

		if (parentActivity == null) {
			result = false;
		}
		else if (parentActivity.getFlowFlag()) {
			result = !parentActivity.getForwardOnlyFlag();
		}

		if (result) {
			result = canAvailableBackward();
		}

		return result;
	}

	/**
	 * JgANeBreBContinue\ǂ擾
	 *
	 * @return Continue\ȏꍇtrueAȊȌꍇfalseԋp
	 */
	public boolean canContinue() throws SystemException {
		boolean result = false;

		if (parentActivity == null) {
			result = false;
		}
		else {
			result = parentActivity.getFlowFlag();
		}

		if (result) {
			result = canAvailableForward();
		}

		return result;
	}

	/**
	 * JgANeBreBExit\ǂ擾
	 *
	 * @return Exit\ȏꍇtrueAȊȌꍇfalseԋp
	 */
	public boolean canExit() {
		return isActive();
	}

	/**
	 * JgANeBreBChoice\ǂ擾
	 *
	 * @return Choice\ȏꍇtrueAȊȌꍇfalseԋp
	 */
	public boolean canChoice() throws SystemException {
		if (parentActivity == null) {
			return true;
		}
		return parentActivity.getChoiceFlag();
	}

	// 2010.10.05 taku-harada add >>
	/**
	 * JgANeBreBJump\ǂ擾
	 *
	 * @return Jump\ȏꍇtrueAȊȌꍇfalseԋp
	 */
	public boolean canJump() throws SystemException {
		if (parentActivity == null) {
			return true;
		}
		return parentActivity.getJumpFlag();
	}
	// 2010.10.05 taku-harada add <<

	public boolean getUseCurrentAttempt(){
		return sequencing.getUseCurrentAttempt();
	}

	public void setUseCurrentAttempt(boolean tmpflag){
		sequencing.setUseCurrentAttempt(tmpflag);
	}
}
