//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	SCORMCommunicationModule
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.io.File;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

import jp.co.ntt.lms.lo.scorm.cbtcom.CMICBT;
import jp.co.ntt.lms.lo.scorm.cbtcom.CMIElement;
import jp.co.ntt.lms.lo.scorm.cbtcom.CMIS13ModelUtil;
import jp.co.ntt.lms.lo.scorm.cbtcom.S13LogFormatException;
import jp.co.ntt.lms.lo.scorm.kernel.Resource;
import jp.co.ntt.lms.lo.scorm.kernel.exception.CommunicationModuleWrapperException;

/**
*  SCORM Communication Module NX<BR>
*  OA_v^NX<BR>
*/
public class SCORMCommunicationModule extends CommunicationModuleWrapper {
	/** cbtcom */
	private CMICBT cbtcom;

	/** objective id - cmi.objectives.[n] }bsO */
	private Hashtable objectiveIDToNumber;

	/** */
	private boolean noCBTURL;

	/**
	 * ftHgRXgN^ <BR>
	 */
	public SCORMCommunicationModule() {}

	/**
	 * RXgN^
	 *
	 * @param activity ANeBreB
	 */
	public SCORMCommunicationModule(Activity activity) {
		super(activity);
	}

	/**
	 * <BR>
	 *
	 * @param	initialParameter		p[^BHashtable̒lɂ͈ȉ̃L[Kv<BR>
	 *						userID 		[UID<BR>
	 *						userName	[U<BR>
	 *						URL			AICCւURL<BR>
	 *
	 * @param	savedValue	ۑꂽf[^Bۑf[^݂Ȃꍇnullw肷<BR>
	 */
	public void initialize(Hashtable initialParameter, String savedValue)
		throws CommunicationModuleWrapperException {

		try {
			// [tłȂ
			if (activity.hasChildren()) {
				throw new CommunicationModuleWrapperException("SCORMCommunicationModulȅɎs܂B");
			}

			// resource̓ǂݍ
			Resource resource = activity.getResource();
			String href = "";

			if (resource != null) {
				href = resource.getHref();
				if (href == null) {
					href = "";
				}
			}

			noCBTURL = href.equals("");

			String userID = (String)initialParameter.get("userID");
			String userName = (String)initialParameter.get("userName");
			String URL = (String)initialParameter.get("URL");
			String encoding = (String)initialParameter.get("encoding");

			cbtcom = new CMICBT(encoding);

			/**
			 *  f񂪂Ȃꍇ CBTCOM ̏s
			 *  ꍇ͒f̃Zbgs
			 */
			cbtcom.setValue("cmi.completion_status", "unknown");
			cbtcom.setValue("cmi.credit", "credit");
			cbtcom.setValue("cmi.entry", "ab-initio");
			cbtcom.setValue("cmi.launch_data", activity.getDataFromLMS());
			cbtcom.setValue("cmi.completion_threshold", activity.getCompletionThreshold());
			// 2011.09.09 taku-harada mod >>
			//cbtcom.setValue("cmi.progress_measure", null); // lnull
			cbtcom.setValue("cmi.progress_measure", activity.getProgressMeasure());
			// 2011.09.09 taku-harada mod <<
			cbtcom.setValue("cmi.learner_id", userID);
			cbtcom.setValue("cmi.learner_name", userName);

			String value;

			value = activity.getSequencing().getLimitConditionString("attemptAbsoluteDurationLimit");
			if (value != null) {
				cbtcom.setValue("cmi.max_time_allowed", value);
			}

			cbtcom.setValue("cmi.mode", "normal");

			LocalObjective[] localObjective = activity.getSequencing().getObjective();
			objectiveIDToNumber = new Hashtable();

			int j = 0;
			for (int i = 0; i < localObjective.length; i++) {
				// 20040801 MOD NTTR
				// ID̔ǉ
				if(localObjective[i].getHasObjectiveID() == false){
					//ȂɂȂ
				//}
					objectiveIDToNumber.put(localObjective[i].getObjectiveID(), Integer.toString(i));

					cbtcom.setValue("cmi.objectives." + j + ".id", localObjective[i].getObjectiveID());
					cbtcom.setValue("cmi.objectives." + j + ".score.scaled", "");
					cbtcom.setValue("cmi.objectives." + j + ".score.raw", "");
					cbtcom.setValue("cmi.objectives." + j + ".score.min", "");
					cbtcom.setValue("cmi.objectives." + j + ".score.max", "");
					cbtcom.setValue("cmi.objectives." + j + ".success_status", "unknown");
					cbtcom.setValue("cmi.objectives." + j + ".completion_status", "unknown");
					j++;
				}
			}

			BigDecimal scaledPassingScore =
				activity.getSequencing().getObjectiveContributeToRollup().getMinNormalizedMeasure(false);
			if (scaledPassingScore != null) {
				cbtcom.setValue("cmi.scaled_passing_score", scaledPassingScore.toString());
			}

			cbtcom.setValue("cmi.score.scaled", "");
			cbtcom.setValue("cmi.score.raw", "");
			cbtcom.setValue("cmi.score.min", "");
			cbtcom.setValue("cmi.score.max", "");

			cbtcom.setValue("cmi.success_status", "unknown");

			value = activity.getTimeLimitAction();
			if (value != null) {
				cbtcom.setValue("cmi.time_limit_action", value);
			}

			cbtcom.setValue("cmi.launch.aicc_url", URL);
			cbtcom.setValue("cmi.launch.aicc_sid_seed", "SID_SEED");

			cbtcom.setValue("cmi.launch.cbt_url", href);

			value = activity.getParameters();

			cbtcom.setValue("cmi.launch.launch_params", (value == null) ? "" : value);
			cbtcom.setValue("cmi.location", null);

			if (savedValue != null) {
				cbtcom.setAllValue(savedValue);
			}
			
//			// 2010.10.04 taku-harada add >>
//			Vector<Map<String, String>> vec = activity.getData();
//			
//			for(int i=0; i<vec.size(); i++){
//				Map<String, String> map = vec.get(i);
//				cbtcom.setValue("adl.data." + i + ".id", map.get("targetID"));
//			}
//			// 2010.10.04 taku-harada add <<
			
			
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * <BR>
	 *
	 * @param	initialParameter		p[^BHashtable̒lɂ͈ȉ̃L[Kv<BR>
	 *						userID 		[UID<BR>
	 *						userName	[U<BR>
	 *						URL			AICCւURL<BR>
	 *
	 * @param	savedValue	ۑꂽf[^Bۑf[^݂Ȃꍇnullw肷<BR>
	 */
	public void initialize2(Hashtable initialParameter)
		throws CommunicationModuleWrapperException {

	    try {
			cbtcom.setAllValue(cbtcom.getAllValue());
			//cbtcom.setValue("cmi.completion_status", "unknown");
			cbtcom.setValue("cmi.entry", "");
			LocalObjective[] localObjective = activity.getSequencing().getObjective();
			objectiveIDToNumber = new Hashtable();

			int j = 0;
			for (int i = 0; i < localObjective.length; i++) {
				// 20040801 MOD NTTR
				// ID̔ǉ
				if(localObjective[i].getHasObjectiveID() == false){
					//ȂɂȂ
				//}
					objectiveIDToNumber.put(localObjective[i].getObjectiveID(), Integer.toString(i));

					cbtcom.setValue("cmi.objectives." + j + ".id", localObjective[i].getObjectiveID());
					cbtcom.setValue("cmi.objectives." + j + ".score.scaled", "");
					cbtcom.setValue("cmi.objectives." + j + ".score.raw", "");
					cbtcom.setValue("cmi.objectives." + j + ".score.min", "");
					cbtcom.setValue("cmi.objectives." + j + ".score.max", "");
					cbtcom.setValue("cmi.objectives." + j + ".success_status", "unknown");
					cbtcom.setValue("cmi.objectives." + j + ".completion_status", "unknown");
					j++;
				}
			}

			BigDecimal scaledPassingScore =
				activity.getSequencing().getObjectiveContributeToRollup().getMinNormalizedMeasure(false);
			if (scaledPassingScore != null) {
				cbtcom.setValue("cmi.scaled_passing_score", scaledPassingScore.toString());
			}

			//cbtcom.setValue("cmi.score.scaled", "");
			//cbtcom.setValue("cmi.score.raw", "");
			//cbtcom.setValue("cmi.score.min", "");
			//cbtcom.setValue("cmi.score.max", "");

			//cbtcom.setValue("cmi.success_status", "unknown");
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * f擾<BR>
	 *
	 * @return   ۑf[^<BR>
	 */
	public String save() throws CommunicationModuleWrapperException {
		try {
			if (cbtcom != null) {
				
				// 2011.01.12 taku-harada add >>
				setTotal_time();
				// 2011.01.12 taku-harada add <<
				
				close();
				return cbtcom.getAllValue();
			}

			return null;
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * I<BR>
	 */
	public void terminate() throws CommunicationModuleWrapperException {
		try {
			close();
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * CBTCOMI[v
	 *
	 * @param learningLogFolder
	 * @return ʂւURL
	 */
	public String open(String learningLogFolder) throws CommunicationModuleWrapperException {
		try {
			new File(learningLogFolder).mkdirs();

			cbtcom.setValue("cmi.evaluation.course_id", activity.getCourseIdentifier());
			cbtcom.setValue("cmi.evaluation.lesson_id", activity.getIdentifier());
			cbtcom.setValue("cmi.evaluation.parameter", learningLogFolder + activity.getIdentifier() + ".prm");
			cbtcom.setValue("cmi.evaluation.comments", learningLogFolder + activity.getIdentifier() + ".cmt");
			cbtcom.setValue("cmi.evaluation.interactions", learningLogFolder + activity.getIdentifier() + ".int");

			String nextURL = cbtcom.open();

			if (noCBTURL) {
				return null;
			}

			Resource resource = activity.getResource();

			if (resource == null) {
				return null;
			}
			StringBuffer retUrl = new StringBuffer("");
			retUrl.append(resource.getBaseURL());
			retUrl.append(nextURL);
			//@20040603 DEL NTTR
			//if (resource.getScormType().equals("asset")) {
			//	return resource.getHref();
			//}
			//@20040603 END

			return retUrl.toString();
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * CBTCOMN[Y
	 *
	 */
	public void close() throws CommunicationModuleWrapperException {
		try {
			if (cbtcom != null) {
				if (cbtcom.isOpen()) {
					cbtcom.close();
				}
			}
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * CBTCOMɑ΂hacps
	 *
	 * @return NCAg֕ԋpׂ"text/plain"
	 */
	public String hacp(String param) throws CommunicationModuleWrapperException {
		try {
			return cbtcom.hacp(param);
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * CBTCOMɑ΂setValues
	 *
	 */
	public void setValue(String key, String value) {
		cbtcom.setValue(key, value);
	}

	/**
	 * CBTCOMɑ΂getValues
	 *
	 * @return 擾łl
	 */
	public String getValue(String key) {
		return cbtcom.getValue(key);
	}

	/**
	 * OAPIAdpater̍ĊJs
	 */
	public void resumeAPIAdapter() throws CommunicationModuleWrapperException {
		try {
			cbtcom.setAllValue(cbtcom.getAllValue());
			cbtcom.setValue("cmi.entry", "resume");
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * gbLO̓
	 */
	public void synchronizeTrackingModel() throws CommunicationModuleWrapperException {
		try {
			String value = cbtcom.getValue("cmi.exit");

			if ((value != null) && (value.equals("suspend"))) {
				cbtcom.setValue("cmi.entry", "resume");
				activity.setSuspended(true);
			}
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKڕWBԂLɂ<BR>
	 * @param objectiveID wKڕWID<BR>
	 * @param status true   L<BR>
	 *               false  <BR>
	 */
	public void setObjectiveProgressStatus(String objectiveID, boolean status)
		throws CommunicationModuleWrapperException {

		try {
			LocalObjective primary = activity.getObjectiveContributeToRollup();

			if (objectiveID.equals(primary.getObjectiveID())) {
				if (status) {
					// true ̏ꍇ͐ݒ肵ȂB
				}
				else {
			//		cbtcom.setValue("cmi.success_status", "unknown");
				}
			}
			
			if (primary.getHasObjectiveID() == false){
				String n = (String)objectiveIDToNumber.get(objectiveID);

			
				if (n == null) {
					throw new CommunicationModuleWrapperException(objectiveID + ", " + activity.getIdentifier());
				}

				if (status) {
					// true ̏ꍇ͐ݒ肵ȂB
				}
				else {
			//		cbtcom.setValue("cmi.objectives." + n + ".success_status", "unknown");
				}
			}
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKڕWBԂ̗LAtO擾<BR>
	 * 
	 * @param    objectiveID    wKڕWID<BR>
	 * @return   LۂBoolean<BR>
	 */
	public Boolean getObjectiveProgressStatus(String objectiveID) throws CommunicationModuleWrapperException {
		try {
			/*
			 *  objectiveID  objective肵Ēl CBTCOM 擾
			 *  
			 */
			String value;

			LocalObjective primary = activity.getObjectiveContributeToRollup();

			if (objectiveID.equals(primary.getObjectiveID())) {
				value = cbtcom.getValue("cmi.success_status");

				if (!value.equals("unknown")) {
					return Boolean.TRUE;
				}
			}

			if (primary.getHasObjectiveID() == false){
				String n = (String)objectiveIDToNumber.get(objectiveID);

				if (n == null) {
					throw new CommunicationModuleWrapperException(objectiveID + ", " + activity.getIdentifier());
				}

				value = cbtcom.getValue("cmi.objectives." + n + ".success_status");

				return value.equals("unknown") ? Boolean.FALSE : Boolean.TRUE;
			}else{
				return Boolean.FALSE;
			}
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKڕWBԂݒ肷<BR>
	 *
	 * @param    objectiveID wKڕWID <BR>
	 * @param    status iԂw肷(true: / false:)<BR>
	 */
	public void setObjectiveSatisfiedStatus(String objectiveID, boolean status)
		throws CommunicationModuleWrapperException {

		try {
			LocalObjective primary = activity.getObjectiveContributeToRollup();

			if (objectiveID.equals(primary.getObjectiveID())) {
				if (status) {
					cbtcom.setValue("cmi.success_status", "passed");
				}
				else {
					cbtcom.setValue("cmi.success_status", "failed");
				}
			}

			if (primary.getHasObjectiveID() == false){
				String n = (String)objectiveIDToNumber.get(objectiveID);

				if (n == null) {
					throw new CommunicationModuleWrapperException(objectiveID + ", " + activity.getIdentifier());
				}

				if (status) {
					cbtcom.setValue("cmi.objectives." + n + ".success_status", "passed");
				}else{
					cbtcom.setValue("cmi.objectives." + n + ".success_status", "failed");
				}
			}
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKڕWBԂ擾<BR>
	 *
	 * @param   objectiveID    wKڕWID <BR>
	 * @return  ݂̐iԂԋpB
	 *			(vC}IuWFNeBu)AIuWFNeBu̐iԂ"unknown"̏ꍇnullԋp<BR>
	 */
	public Boolean getObjectiveSatisfiedStatus(String objectiveID) throws CommunicationModuleWrapperException {
		try {
			/**
			 *  objectiveID  objective肵Ēl CBTCOM 擾
			 *  
			 */
			String value = "";

			LocalObjective primary = activity.getObjectiveContributeToRollup();

			if (objectiveID.equals(primary.getObjectiveID())) {
				value = cbtcom.getValue("cmi.success_status");

				if (value.equals("passed")) {
					return Boolean.TRUE;
				}
				else if (value.equals("failed")) {
					return Boolean.FALSE;
				}
				else if (value.equals("unknown")) {
					return null;
				}
				else if (!value.equals("unknown")) {
					throw new CommunicationModuleWrapperException(
						"cmi.success_status {Lus[" + value + "][" + objectiveID + "]");
				}
			}

			if (primary.getHasObjectiveID() == false){
				String n = (String)objectiveIDToNumber.get(objectiveID);

				if (n == null) {
					throw new CommunicationModuleWrapperException("v Objective ID [" + objectiveID + "]");
				}

				value = cbtcom.getValue("cmi.objectives." + n + ".success_status");

				if (value.equals("passed")) {
					return Boolean.TRUE;
				}
				else if (value.equals("failed")) {
					return Boolean.FALSE;
				}
				else if (value.equals("unknown")) {
					return null;
				}
			}else{
				return null;
			}
			throw new CommunicationModuleWrapperException(
				value + ", " + objectiveID + ", " + activity.getIdentifier());
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKڕWBlL^tO̐ݒ<BR>
	 * @param objectiveID wKڕWID<BR>
	 * @param status     true L<BR>
	 *                   false <BR>
	 */
	public void setObjectiveMeasureStatus(String objectiveID, boolean status)
		throws CommunicationModuleWrapperException {

		try {
			LocalObjective primary = activity.getObjectiveContributeToRollup();

			if (objectiveID.equals(primary.getObjectiveID())) {
				if (status) {
					// true ̏ꍇ͐ݒ肵ȂB
				}
				else {
					cbtcom.setValue("cmi.score.scaled", "");
				}
			}

			if (primary.getHasObjectiveID() == false){
				String n = (String)objectiveIDToNumber.get(objectiveID);

				if (n == null) {
					throw new CommunicationModuleWrapperException(objectiveID + ", " + activity.getIdentifier());
				}

				if (status) {
					// true ̏ꍇ͐ݒ肵ȂB
				}
				else {
					cbtcom.setValue("cmi.objectives." + n + ".score.scaled", "");
				}
			}
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKڕWBl(K)Lۂ<BR>
	 *
	 * @param objectiveID   wKڕWID<BR>
	 * @return Lۂ<BR>
	 */
	public Boolean getObjectiveMeasureStatus(String objectiveID) throws CommunicationModuleWrapperException {
		try {
			String score = "";

			LocalObjective primary = activity.getObjectiveContributeToRollup();

			if (objectiveID.equals(primary.getObjectiveID())) {
				score = cbtcom.getValue("cmi.score.scaled");
				if (!score.equals("")) {
					return Boolean.TRUE;
				}
			}
			if (primary.getHasObjectiveID() == false){
				String n = (String)objectiveIDToNumber.get(objectiveID);

				if (n == null) {
					throw new CommunicationModuleWrapperException(objectiveID + ", " + activity.getIdentifier());
				}

				score = cbtcom.getValue("cmi.objectives." + n + ".score.scaled");

				return score.equals("") ? Boolean.FALSE : Boolean.TRUE;
			}else{
				return Boolean.FALSE;
			}
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKڕWBl(K)ݒ肷<BR>
	 *
	 * @param   objectiveID	wKڕWID <BR>
	 * @param	value		wKڕWBl9.9999`(-1`1)BigDecimalŎw肷<BR>
	 */
	public void setObjectiveNormalizedMeasure(String objectiveID, BigDecimal value)
		throws CommunicationModuleWrapperException {

		try {
			LocalObjective primary = activity.getObjectiveContributeToRollup();

			if (objectiveID.equals(primary.getObjectiveID())) {
				cbtcom.setValue("cmi.score.scaled", value.toString());
			}

			if (primary.getHasObjectiveID() == false){
				String n = (String)objectiveIDToNumber.get(objectiveID);

				if (n == null) {
					throw new CommunicationModuleWrapperException(objectiveID + ", " + activity.getIdentifier());
				}

				cbtcom.setValue("cmi.objectives." + n + ".score.scaled", value.toString());
			}
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKڕWBl(K)擾<BR>
	 *
	 * @param   objectiveID wKڕWID<BR>
	 * @return  ݂̊wKڕWBl擾B(vC}IuWFNeBu)IuWFNeBu<BR>
	 * 			wKڕWBlݒ肳ĂȂꍇnullԋp
	 */
	public BigDecimal getObjectiveNormalizedMeasure(String objectiveID) throws CommunicationModuleWrapperException {

		try {
			String value = "";

			LocalObjective primary = activity.getObjectiveContributeToRollup();

			if (objectiveID.equals(primary.getObjectiveID())) {
				value = cbtcom.getValue("cmi.score.scaled");
				if (!value.equals("")) {
					return new BigDecimal(value).setScale(4, BigDecimal.ROUND_HALF_UP);
				}
			}
			
			if (primary.getHasObjectiveID() == false){
				String n = (String)objectiveIDToNumber.get(objectiveID);

				if (n == null) {
					throw new CommunicationModuleWrapperException(objectiveID + ", " + activity.getIdentifier());
				}

				value = cbtcom.getValue("cmi.objectives." + n + ".score.scaled");
				if (!value.equals("")) {
					return new BigDecimal(value).setScale(4, BigDecimal.ROUND_HALF_UP);
				}
			}
			return null;
		}
		catch (CommunicationModuleWrapperException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 *   wKԗL^tO̐ݒ<BR>
	 *
	 *   @param status    true L<BR>
	 *                    false <BR>
	 */
	public void setAttemptProgressStatus(boolean status) throws CommunicationModuleWrapperException {
		try {
			if (status) {
				// true ̏ꍇ͐ݒ肵ȂB
			}
			else {
				cbtcom.setValue("cmi.completion_status", "unknown");
			}
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 *   wKԗL^tO̎擾<BR>
	 *   @return    true     wKԂ͗L<BR>
	 *               false    wKԂ͖<BR>
	 *
	 */
	public Boolean getAttemptProgressStatus() throws CommunicationModuleWrapperException {
		try {
			String value = cbtcom.getValue("cmi.completion_status");

			return value.equals("unknown") ? Boolean.FALSE : Boolean.TRUE;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 * wKԂݒ肷<BR>
	 *
	 * @param	value	Ԃw肷(1.0`.0.0̊Ŏ)<BR>
	 */
	public void setAttemptCompletionAmount(BigDecimal value) {}

	/**
	 *    wKԂ擾<BR>
	 *
	 *    @return     value  Ԃ(1.0`.0.0̊Ŏ)<BR>
	 */
	public BigDecimal getAttemptCompletionAmount() throws CommunicationModuleWrapperException {
		try {
			if (!cbtcom.getValue("cmi.completion_status").equals("completed")) {
				return new BigDecimal("0.0").setScale(4, BigDecimal.ROUND_HALF_UP);
			}

			return new BigDecimal("1.0").setScale(4, BigDecimal.ROUND_HALF_UP);
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 *    wKԂݒ肷<BR>
	 *
	 *    @param     status Ԃw肷(true: / false:)<BR>
	 */
	public void setAttemptCompletionStatus(boolean status) throws CommunicationModuleWrapperException {
		try {
			if (status) {
				cbtcom.setValue("cmi.completion_status", "completed");
			}
			else {
				cbtcom.setValue("cmi.completion_status", "incomplete");
			}
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}

	/**
	 *    wKԂݒ肷<BR>
	 *
	 *    @return	<BR>
	 */
	public Boolean getAttemptCompletionStatus() throws CommunicationModuleWrapperException {
		try {
			String value = cbtcom.getValue("cmi.completion_status");

			if (value.equals("completed")) {
				return Boolean.TRUE;
			}
			else if (value.equals("incomplete")) {
				return Boolean.FALSE;
			}

			return null;
		}
		catch (Exception ex) {
			throw new CommunicationModuleWrapperException(activity.getIdentifier(), ex);
		}
	}
	
	// 2011.01.12 taku-harada add >>
	/**
	 * 		resume̎ total_timeݒ肷<BR>
	 * 		
	 * 		@throws S13LogFormatException <BR>
	 */
	private void setTotal_time() throws S13LogFormatException {

		double dTotalSec = 0;
		
		CMIElement cmielement = cbtcom.getNChild("core.session_time");
		String strValue = cmielement.getLessonValue();
		if(strValue != null && "".equals(strValue) != true){
			dTotalSec = CMIS13ModelUtil.parseTimeintervalToLong(strValue);
		}
		
		CMIElement cmielement_total = cbtcom.getNChild("core.total_time");
		String strValue_total = cmielement_total.getLocalValue();
		if(strValue_total != null && "".equals(strValue_total) != true){
			dTotalSec = dTotalSec + CMIS13ModelUtil.parseTimeintervalToLong(strValue_total);
		}

		String strTime;
		strTime = CMIS13ModelUtil.formatS13Timespan((long)dTotalSec);
		cmielement_total.setLocalValue(strTime);

	}
	// 2011.01.12 taku-harada add <<
}
