/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.scorm;

import java.io.File;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.core.util.InstallerXmlUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;
import jp.co.ntt.lms.installer.util.XmlUtil;

import org.w3c.dom.Document;

/**
 * SCORM Engineݒɂē͂ANVENXB
 * @author T.Nishiki
 */
public class ScormEngineInputAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(ScormEngineInputAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * XLbvȂ̂false߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return false߂܂B
	 */
	public boolean isSkipped(InstallerValues values) {
		return false;
	}

	/**
	 * SCORM EngineݒɂḗEmF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ScormEngineInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see ScormEngineInputValue
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");

		// ̓f[^
		ScormEngineInputValue inputValue = null;
		try {
			// ̓f[^iftHgf[^ƂĎgpj
			ScormEngineInputValue defaultValue = getDefaultValue(values);
			// ^Cg\
			InstallerUiUtil.outputMessageAsTitle(
				values, "ScormEngineInputAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values, defaultValue);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * SCORM Engineݒ̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param defaultValue ftHglB
	 * @return ͂ꂽeScormEngineInputValueƂĖ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private ScormEngineInputValue readInputValue(
			InstallerValues values, ScormEngineInputValue defaultValue)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues)");

		ScormEngineInputValue inputValue = null;
		try {
			inputValue = new ScormEngineInputValue();
			// =================================================================
			// SCORMT[o
			String scormServerName = null;
			while (true) {
				scormServerName = InstallerUiUtil.askUserInput(values,
						"ScormEngineInputAction.prompt.scormServerName",
						defaultValue.getScormServerName());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
						scormServerName, values,
						"ScormEngineInputAction.error.scormServerName.empty")) {
					continue;
				}
				break;
			}
			inputValue.setScormServerName(scormServerName);
			// =================================================================
			// SCORM|[gԍ
			String scormServerPort = null;
			while (true) {
				scormServerPort = InstallerUiUtil.askUserInput(values,
						"ScormEngineInputAction.prompt.scormServerPort",
						defaultValue.getScormServerPort());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
						scormServerPort, values,
						"ScormEngineInputAction.error.scormServerPort.empty")) {
					continue;
				}
				break;
			}
			inputValue.setScormServerPort(scormServerPort);
			// =================================================================
			// AvP[VEx[XURI
			String applicationBaseURI = null;
			while (true) {
				applicationBaseURI = InstallerUiUtil.askUserInput(values,
						"ScormEngineInputAction.prompt.applicationBaseURI",
						defaultValue.getApplicationBaseURI());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
					applicationBaseURI, values,
					"ScormEngineInputAction.error.applicationBaseURI.empty")) {
					continue;
				}
				break;
			}
			inputValue.setApplicationBaseURI(applicationBaseURI);
			// =================================================================
			// ނi[x[XfBNgEpX
			String contentsBaseURL = null;
			while (true) {
				contentsBaseURL = InstallerUiUtil.askUserInput(values,
						"ScormEngineInputAction.prompt.contentsBaseURL",
						defaultValue.getContentsBaseURL());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
					contentsBaseURL, values,
					"ScormEngineInputAction.error.contentsBaseURL.empty")) {
					continue;
				}
				break;
			}
			inputValue.setContentsBaseURL(contentsBaseURL);
			// =================================================================
			// wKOo̓fBNgEpX
			String learningLogBaseURL = null;
			while (true) {
				learningLogBaseURL = InstallerUiUtil.askUserInput(values,
						"ScormEngineInputAction.prompt.learningLogBaseURL",
						defaultValue.getLearningLogBaseURL());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
					learningLogBaseURL, values,
					"ScormEngineInputAction.error.learningLogBaseURL.empty")) {
					continue;
				}
				break;
			}
			inputValue.setLearningLogBaseURL(learningLogBaseURL);
			// =================================================================
			// fo̓fBNgEpX
			String resumeDataBaseURL = null;
			while (true) {
				resumeDataBaseURL = InstallerUiUtil.askUserInput(values,
						"ScormEngineInputAction.prompt.resumeDataBaseURL",
						defaultValue.getResumeDataBaseURL());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
					resumeDataBaseURL, values,
					"ScormEngineInputAction.error.resumeDataBaseURL.empty")) {
					continue;
				}
				break;
			}
			inputValue.setResumeDataBaseURL(resumeDataBaseURL);
			// =================================================================
			// fobOOo̓fBNgEpX
			String debugLogPath = null;
			while (true) {
				debugLogPath = InstallerUiUtil.askUserInput(values,
						"ScormEngineInputAction.prompt.debugLogPath",
						defaultValue.getDebugLogPath());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
					debugLogPath, values,
					"ScormEngineInputAction.error.debugLogPath.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDebugLogPath(debugLogPath);
			// =================================================================
			// }l[WEzXg
			String managerHost = null;
			while (true) {
				managerHost = InstallerUiUtil.askUserInput(values,
						"ScormEngineInputAction.prompt.managerHost",
						defaultValue.getManagerHost());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
					managerHost, values,
					"ScormEngineInputAction.error.managerHost.empty")) {
					continue;
				}
				break;
			}
			inputValue.setManagerHost(managerHost);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, ScormEngineInputValue inputValue)
			throws InstallerException {

		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, ScormEngineInputValue)");
		boolean confirm = false;
		try {
			InstallerUiUtil.outputConfirmTitle(values,
				"ScormEngineInputAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// SCORMT[o
			InstallerUiUtil.outputConfirm(values,
				"ScormEngineInputAction.confirm.scormServerName",
				inputValue.getScormServerName());
			// =================================================================
			// SCORM|[gԍ
			InstallerUiUtil.outputConfirm(values,
				"ScormEngineInputAction.confirm.scormServerPort",
				inputValue.getScormServerPort());
			// =================================================================
			// AvP[Vx[XURI
			InstallerUiUtil.outputConfirm(values,
				"ScormEngineInputAction.confirm.applicationBaseURI",
				inputValue.getApplicationBaseURI());
			// =================================================================
			// ފi[x[XEfBNg
			InstallerUiUtil.outputConfirm(values,
				"ScormEngineInputAction.confirm.contentsBaseURL",
				inputValue.getContentsBaseURL());
			// =================================================================
			// wKOt@CEfBNg
			InstallerUiUtil.outputConfirm(values,
				"ScormEngineInputAction.confirm.learningLogBaseURL",
				inputValue.getLearningLogBaseURL());
			// =================================================================
			// ft@CEfBNg
			InstallerUiUtil.outputConfirm(values,
				"ScormEngineInputAction.confirm.resumeDataBaseURL",
				inputValue.getResumeDataBaseURL());
			// =================================================================
			// fobOOt@CEfBNg
			InstallerUiUtil.outputConfirm(values,
				"ScormEngineInputAction.confirm.debugLogPath",
				inputValue.getDebugLogPath());
			// =================================================================
			// }l[WEzXg
			InstallerUiUtil.outputConfirm(values,
				"ScormEngineInputAction.confirm.managerHost",
				inputValue.getManagerHost());
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "ScormEngineInputAction.confirm" );
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, ScormEngineInputValue)",
			confirm);
		return confirm;
	}

	/**
	 * ̃f[^A͍ڂ̃ftHgl擾܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ftHglScormEngineInputValuě`Ŗ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private ScormEngineInputValue getDefaultValue(InstallerValues values)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getDefaultValue(InstallerValues)");

		ScormEngineInputValue defaultValue = null;
		try {
			defaultValue = new ScormEngineInputValue();
			////////////////////////////////////////////////////////////////////
			// vpeB̎擾
			// =================================================================
			// ̓e
			File existFile = values.getFileOnSystem(
					defaultValue.getTargetFileKey());
			Document existDoc = null;
			if (existFile != null) {
				existDoc = XmlUtil.convertXmlFileToDocument(existFile);
			}
			// =================================================================
			// \[Xi{j̓e
			Document resourceDoc
				= InstallerXmlUtil.load(
					values, defaultValue.getTargetFileKey());
			////////////////////////////////////////////////////////////////////
			// ftHgl̐ݒ
			defaultValue = new ScormEngineInputValue();
			// =================================================================
			// T[ubgx[XURL擾āA
			// zXgA|[gԍAAvP[VpX𒊏oE擾܂B
			String servletBaseURL
				= InstallerXmlUtil.determineInitialNodeValue(
					existDoc, resourceDoc,
					ScormEngineInputValue.XPATH_BASE_SERVLET_URL);
			String serverName = "";
			String serverPort = "";
			String applicationBaseURI = "";
			// ốAt@Cƃ\[XɍقƂ̂
			if (StringUtil.isEmpty(servletBaseURL) == false) {
				try {
					// vgȐ
					int protocolPos = servletBaseURL.indexOf(
						ScormEngineInputValue.PROTOCOL_HTTP);
					if (protocolPos >= 0) {
						servletBaseURL = servletBaseURL.substring(
							protocolPos
							+ ScormEngineInputValue.PROTOCOL_HTTP.length());
					}
					// zXg^|[gԍƃpX𕪂
					int firstSlashPos = servletBaseURL.indexOf("/");
					String serverHostAndPort
						= servletBaseURL.substring(0, firstSlashPos);
					String path = servletBaseURL.substring(firstSlashPos);
					// zXgƃ|[gԍ𕪂
					int colonPos = serverHostAndPort.indexOf(":");
					if (colonPos < 0) {
						serverName = serverHostAndPort;
						serverPort = ScormEngineInputValue.DEFAULT_PORT_HTTP;
					}
					else {
						serverName = serverHostAndPort.substring(0, colonPos);
						serverPort = serverHostAndPort.substring(colonPos + 1);
					}
					// pX̒AvP[Vx[XpX𒊏o
					int servletNamePos = path.indexOf(
							ScormEngineInputValue.PATH_SERVLET);
					if (servletNamePos < 0) {
						applicationBaseURI = path;
					}
					else {
						applicationBaseURI = path.substring(0, servletNamePos);
					}
				}
				catch (Exception e) {
					serverName = "";
					serverPort = "";
					applicationBaseURI = "";
				}
			}
			defaultValue.setScormServerName(serverName);
			defaultValue.setScormServerPort(serverPort);
			defaultValue.setApplicationBaseURI(applicationBaseURI);
			// =================================================================
			// ނi[x[XfBNgEpX
			String contentsBaseURL
				= InstallerXmlUtil.determineInitialNodeValue(
					existDoc, resourceDoc,
					ScormEngineInputValue.XPATH_CONTENTS_BASE_URL);
			defaultValue.setContentsBaseURL(contentsBaseURL);
			// =================================================================
			// wKOo̓fBNgEpX
			String learningLogBaseURL
				= InstallerXmlUtil.determineInitialNodeValue(
					existDoc, resourceDoc,
					ScormEngineInputValue.XPATH_LEARNING_LOG_BASE_URL);
			defaultValue.setLearningLogBaseURL(learningLogBaseURL);
			// =================================================================
			// fo̓fBNgEpX
			String resumeDataBaseURL
				= InstallerXmlUtil.determineInitialNodeValue(
					existDoc, resourceDoc,
					ScormEngineInputValue.XPATH_RESUME_DATA_BASE_URL);
			defaultValue.setResumeDataBaseURL(resumeDataBaseURL);
			// =================================================================
			// fobOOo̓fBNgEpX
			String debugLogPath
				= InstallerXmlUtil.determineInitialNodeValue(
					existDoc, resourceDoc,
					ScormEngineInputValue.XPATH_DEBUG_LOG_PATH);
			defaultValue.setDebugLogPath(debugLogPath);
			// =================================================================
			// }l[WzXg
			String managerHost
				= InstallerXmlUtil.determineInitialNodeValue(
					existDoc, resourceDoc,
					ScormEngineInputValue.XPATH_MANAGER_NAME);
			defaultValue.setManagerHost(managerHost);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getDefaultValue(InstallerValues)", defaultValue);
		return defaultValue;
	}
}
