/*********************************************************************
USB HID monitor for PIC18F2550 main.c

	setting USB, other PORT Input

 ********************************************************************/

#include <p18cxxx.h>
#include "typedefs.h"
#include "usb.h"
#include "io_cfg.h"
#include "monit.h"
#include "timer2.h"
#include "config.h"
//#include "BootPIC18NonJ.h"

/** C O N F I G U R A T I O N ************************************************/

#if defined(__18F2550) || defined(__18F2553)	//PIC18F4550_PICDEM_FS_USB modified.
	#pragma config PLLDIV   = 5         // (20 MHz crystal on PICDEM FS USB board)
	#pragma config CPUDIV   = OSC1_PLL2	
	#pragma config USBDIV   = 2         // Clock source from 96MHz PLL/2
	#pragma config FOSC     = HSPLL_HS
	#pragma config FCMEN    = OFF
	#pragma config IESO     = OFF
	#pragma config PWRT     = OFF
	#pragma config BOR      = ON
	#pragma config BORV     = 3
	#pragma config VREGEN   = ON		//USB Voltage Regulator
	#pragma config WDT      = OFF
	#pragma config WDTPS    = 32768
	#pragma config MCLRE    = ON
	#pragma config LPT1OSC  = OFF
	#pragma config PBADEN   = OFF
//	#pragma config CCP2MX   = ON
	#pragma config STVREN   = ON
	#pragma config LVP      = OFF
//	#pragma config ICPRT    = OFF       // Dedicated In-Circuit Debug/Programming
	#pragma config XINST    = OFF       // Extended Instruction Set
	#pragma config CP0      = OFF
	#pragma config CP1      = OFF
//	#pragma config CP2      = OFF
//	#pragma config CP3      = OFF
	#pragma config CPB      = OFF
//	#pragma config CPD      = OFF
	#pragma config WRT0     = OFF
	#pragma config WRT1     = OFF
//	#pragma config WRT2     = OFF
//	#pragma config WRT3     = OFF
	#pragma config WRTB     = OFF       // Boot Block Write Protection
	#pragma config WRTC     = OFF
//	#pragma config WRTD     = OFF
	#pragma config EBTR0    = OFF
	#pragma config EBTR1    = OFF
//	#pragma config EBTR2    = OFF
//	#pragma config EBTR3    = OFF
	#pragma config EBTRB    = OFF
#else
	#error Not a supported board (yet), make sure the proper board is selected in usbcfg.h, and if so, set configuration bits in __FILE__, line __LINE__
#endif	//18F2550 and 18F2553

//	IXCb`.
//---------------------------------------------------------------------
#define	TIMER2_INTERRUPT	1		// ^C}[Q荞݂gp.
#define	TIMER2_INT_BLINK	0		// ^C}[Q荞݂LEDuN.
//---------------------------------------------------------------------

/** V A R I A B L E S ********************************************************/
//#pragma udata

/** P R I V A T E  P R O T O T Y P E S ***************************************/
static void InitializeSystem(void);
void USBTasks(void);
void BlinkUSBStatus(void);
void YourHighPriorityISRCode();
void YourLowPriorityISRCode();
void timer2_int_handler(void);

/** V E C T O R  R E M A P P I N G *******************************************/
#define	REMAPPED_RESET_VECTOR_ADDRESS			0x800
#define	REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS	0x808
#define	REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS	0x818

extern void	_startup (void);		// See c018i.c in your C18 compiler	dir
#pragma	code REMAPPED_RESET_VECTOR = REMAPPED_RESET_VECTOR_ADDRESS
void _reset	(void)
{
	_asm goto _startup _endasm
}

#pragma	code REMAPPED_HIGH_INTERRUPT_VECTOR	= REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS
void Remapped_High_ISR (void)
{
	 _asm goto YourHighPriorityISRCode _endasm
}

#pragma	code REMAPPED_LOW_INTERRUPT_VECTOR = REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS
void Remapped_Low_ISR (void)
{
	 _asm goto YourLowPriorityISRCode _endasm
}

/********************************************************************
 *	0x008`̃WvxN^[ݒ肷.
 ********************************************************************
 *	0x008 goto 0x808
 *	0x018 goto 0x818
 */
#pragma	code HIGH_INTERRUPT_VECTOR = 0x08
void High_ISR (void)
{
	 _asm goto REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS _endasm
}

#pragma	code LOW_INTERRUPT_VECTOR =	0x18
void Low_ISR (void)
{
	 _asm goto REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS _endasm
}

#pragma	code
/********************************************************************
 *	High荞ݏ֐.
 ********************************************************************
 */
#pragma	interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode()
{
	#if	defined(USB_INTERRUPT)
		USBDeviceTasks();
	#endif
}	//This return will be a	"retfie fast", since this is in	a #pragma interrupt	section

/********************************************************************
 *	Low	荞ݏ֐.
 ********************************************************************
 */
#pragma	interruptlow YourLowPriorityISRCode nosave=TBLPTR,TBLPTRU,TABLAT,PCLATH,PCLATU,PROD,section("MATH_DATA")
void YourLowPriorityISRCode()
{
	//Check	which interrupt	flag caused	the	interrupt.
	//Service the interrupt
	//Clear	the	interrupt flag
	//Etc.
	#if	TIMER2_INTERRUPT
		timer2_int_handler();
	#endif
}	//This return will be a	"retfie", since	this is	in a #pragma interruptlow section

#pragma	code
/**********************************************************************
 *	timer : 荞݃nh[.
 *********************************************************************/
extern void tmr2monit(void);
void timer2_int_handler(void)
{
    if(	PIR1bits.TMR2IF){		// ^C}2荞݁H
#if	TIMER2_INT_BLINK			// ^C}[Q荞݂LEDuN.
		static ushort cnt=0;
		cnt++;
		if(cnt >= 1000) {
			cnt = 0;
			mLED_1 = !mLED_1;	// LED𔽓].
		}
#endif
		tmr2monit();
        PIR1bits.TMR2IF=0;		// ^C}2荞݃tO0ɂ
	}
}

/**********************************************************************
 *	LED2 blink ()
 **********************************************************************
 */
void LED2_blink(void)
{
	static	ushort cnt=0;
	cnt++;
	if(cnt & 0x8000) mLED_2 = 1;
	else             mLED_2 = 0;
}

/** D E C L A R A T I O N S **************************************************/
#pragma code
/******************************************************************************
 * Function:        void main(void)
 *****************************************************************************/
void main(void)
{
    InitializeSystem();
    while(1)
    {
	    USBTasks();				// Need to call USBTasks() periodically
		LED2_blink();
    }//end while
}//end main

/******************************************************************************
 * Function:        static void InitializeSystem(void)
 *****************************************************************************/
static void InitializeSystem(void)
{
#if RAM_SERIAL
	extern void set_serial_number(void);

	set_serial_number();
#endif

    ADCON1 = 0x0F;			//Need to make sure RB4 can be used as a digital input pin

	// HIDaspx , PICwriterp portb,portcS͂ɂ.
	TRISB = 0xFF;
	TRISC = 0xFF;

#if defined(USE_USB_BUS_SENSE_IO)
    tris_usb_bus_sense = INPUT_PIN; // See io_cfg.h
#endif

#if defined(USE_SELF_POWER_SENSE_IO)
    tris_self_power = INPUT_PIN;
#endif
    
    mInitializeUSBDriver();         // See usbdrv.h
    UserInit();                     // See user.c & .h

#if	TIMER2_INTERRUPT
//	timer2_init(0x80 |(15<<3)| 2,255);	// 荞ON,postscale 1/16,prescale 1/16,1/256 = 183.10 H
//	timer2_init(0x80 |(14<<3)| 2,249);	// 荞ON,postscale 1/15,prescale 1/16,1/250 = 200Hz
//	timer2_init(0x80 |(14<<3)| 2, 49);	// 荞ON,postscale 1/15,prescale 1/16,1/50 = 1000Hz
	timer2_init(0x80 |(14<<3)| 2,  4);	// 荞ON,postscale 1/15,prescale 1/16,1/5  =  10kHz

	// 荞݋.
	InitTimer2InterruptLow();			// Timer2荞݂ low Priorityɐݒ肷.
#else
	INTCONbits.GIEL = 0; 		// Low  Priority 荞݂֎~.
	INTCONbits.GIEH = 0; 		// High Priority 荞݂֎~.
#endif

}//end InitializeSystem

/******************************************************************************
 * Function:        void USBTasks(void)
 *****************************************************************************/
void USBTasks(void)
{
    /* Servicing Hardware */
    USBCheckBusStatus();                    // Must use polling method
    USBDriverService();              	    // Interrupt or polling method

	if((usb_device_state ==	CONFIGURED_STATE) && (UCONbits.SUSPND != 1)) {
		ProcessIO();
	}
}// end USBTasks

/** EOF main.c ***************************************************************/
