/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @file bidiEntry.h
 * @brief Type definitions for Entry object.
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 * @version $Revision: 3 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#ifndef BIDI_ENTRY_H
#define BIDI_ENTRY_H

#include <libxml/xmlreader.h>

#include <bidiTypes.h>
#include <entryPrtLocalization.h>
#include <entryPrtMarkerSupplies.h>
#include <entryPrtAlert.h>

#ifdef __cplusplus
extern "C" {
#endif

  /**
   * The top structure containing the parsed printer status.
   *
   * @struct Entry.
   */
  typedef struct {
    EntryPrtLocalization *EntryPrtLocalizationPtr;     /**< Pointer to EntryPrtLocalization. */
    EntryPrtMarkerSupplies *EntryPrtMarkerSuppliesPtr; /**< Pointer to EntryPrtMarkerSupplies. */
    EntryPrtAlert *EntryPrtAlertPtr;                   /**< Pointer to EntryPrtAlert. */
  } Entry;

  typedef struct {
    int value;        
    const char *name; 
  } enumList;         
  
  Entry *newEntry(void);
  void deleteEntry(Entry*);
  char *getEnumName(const enumList*,const int);
  char *getIndexName(enumPrtMarkSupIndex);
  
#ifdef __cplusplus
}
#endif

#endif
