/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @file bidiTypes.h
 * @brief Type definitions of the valiable used by Printer-MIB.
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 * @version $Revision: 3 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#ifndef BIDI_TYPES_H
#define BIDI_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif
  
  /**
   * Type definitions of the valiable used by Printer-MIB
   *  Refer to RFC for the following definition
   *  RFC 1759( PrinterMIB )
   *  RFC 2578( Structure of Management Information Version 2 (SMIv2) )
   */
  
  typedef long INT32; /**< Integer32. */
  typedef unsigned char OSTRING; /**< OCTET STRING.*/
  typedef int CCHARSET; /**< CodedCharset. */
  typedef char SUBUNITSTATUS; /**< SubUnitStatus. */

#ifdef __cplusplus
}
#endif

#endif
