/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @ingroup bidiformat
 * @file parserPrtMarkerSupplies.c
 * @brief parse PrtMarkerSuppliesEntry.
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 * @version $Revision: 3 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#include <libxml/xmlreader.h>
#include "bidiParser.h"

void parseNodePrtMarkerSupplies(Parser*,Entry*);

/**
  * parse XML data and set data to Entry object especially PrtMarkerSuppliesEntry. 
  *
  * @param parser Pointer to Parser object.
  * @param entry Pointer to Entry object.
  * @return None.
  */
void parseNodePrtMarkerSupplies(Parser *parser,Entry *entry)
{
  xmlElementType node_type;
  xmlNodePtr cur_node;
  xmlChar *element_name;
  xmlChar *data;
  
  node_type = xmlTextReaderNodeType(parser->reader);
  element_name = xmlTextReaderName(parser->reader);
  
  if (node_type == XML_READER_TYPE_ELEMENT) { /* in case start of tag */
    switch(parser->state){
    case STATE_START:
      //    case STATE_PRINTER_MIB:
      if (xmlStrcmp(element_name, "PrtMarkerSuppliesTable") == 0) {
	parser->state = STATE_MRKSUP_TABLE;
      }
      break;
    case STATE_MRKSUP_TABLE:
      if (xmlStrcmp(element_name, "PrtMarkerSuppliesEntry") == 0) {
	parser->state = STATE_MRKSUP_ENTRY;
	entry->EntryPrtMarkerSuppliesPtr = addEntryPrtMarkSupp(entry->EntryPrtMarkerSuppliesPtr);
      }
      break;
    case STATE_MRKSUP_ENTRY:
      if (xmlStrcmp(element_name, "PrtMarkerSuppliesIndex") == 0) {
	parser->state = STATE_MRKSUP_INDEX;
      } else if (xmlStrcmp(element_name, "PrtMarkerSuppliesType") == 0) {
	parser->state = STATE_MRKSUP_TYPE;
      } else if (xmlStrcmp(element_name, "PrtMarkerSuppliesDescription") == 0) {
	parser->state = STATE_MRKSUP_DESCRIPTION;
      } else if (xmlStrcmp(element_name, "PrtMarkerSuppliesSupplyUnit") == 0) {
	parser->state = STATE_MRKSUP_SUPPLYUNIT;
      } else if (xmlStrcmp(element_name, "PrtMarkerSuppliesMaxCapacity") == 0) {
	parser->state = STATE_MRKSUP_MAXCAPACITY;
      } else if (xmlStrcmp(element_name, "PrtMarkerSuppliesLevel") == 0) {
	parser->state = STATE_MRKSUP_LEVEL;
      }
      break;
    }
  } else if (node_type == XML_READER_TYPE_END_ELEMENT){ /* in case end of tag */
    switch(parser->state){
    case STATE_MRKSUP_TABLE:
      parser->state = STATE_START;
      //    parser->state = STATE_PRINTER_MIB:
      break;
    case STATE_MRKSUP_ENTRY:
      parser->state = STATE_MRKSUP_TABLE;
      break;
    case STATE_MRKSUP_INDEX:
    case STATE_MRKSUP_TYPE:
    case STATE_MRKSUP_DESCRIPTION:
    case STATE_MRKSUP_SUPPLYUNIT:
    case STATE_MRKSUP_MAXCAPACITY:
    case STATE_MRKSUP_LEVEL:
      parser->state = STATE_MRKSUP_ENTRY;
      break;
    }
  } else if (node_type == XML_READER_TYPE_TEXT){ /* in case text value */
    switch(parser->state){
    case STATE_MRKSUP_INDEX:
    case STATE_MRKSUP_TYPE:
    case STATE_MRKSUP_DESCRIPTION:
    case STATE_MRKSUP_SUPPLYUNIT:
    case STATE_MRKSUP_MAXCAPACITY:
    case STATE_MRKSUP_LEVEL:
      cur_node = xmlTextReaderCurrentNode(parser->reader);
      data = xmlTextReaderValue(parser->reader);
      setEntryPrtMarkSupp(entry->EntryPrtMarkerSuppliesPtr,cur_node->parent->name,data);
      break;
    }
  }
}
