/** @ingroup testmodule
 * @file  testformat.c
 * @brief test program to check bidiformat.
 *
 * Usage: testformat [XML file]
 *
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 *
 * Copyright (C) 2004 by Turbolinux,Inc.
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <string.h>
#include "bidiEntry.h"
#include "bidiParser.h"

void showLocalization(EntryPrtLocalization *entLoc)
{
	if(entLoc){
		fprintf(stderr,"PrtLocalizationTable\n");
		fprintf(stderr," PrtLocalizationLanguage=%s\n",entLoc->PrtLocLang);
		fprintf(stderr," PrtLocalizationCharacterSet=%d\n",entLoc->PrtLocCharSet);
		fprintf(stderr,"\n");
	}else{
		fprintf(stderr,"no PrtLocalization Entry\n");
	}
}

void showMarkerSupplies(EntryPrtMarkerSupplies *entMrk)
{
	int mnum=1;
	if(entMrk){ 
		while(entMrk){
			fprintf(stderr,"PrtMarkerSuppliesEntry[%d]\n",mnum);
			fprintf(stderr," PrtMarkerSuppliesIndex=%d\n",entMrk->PrtMarkSupIndex);
			fprintf(stderr," PrtMarkerSuppliesType=%d\n",entMrk->PrtMarkSupType);
			fprintf(stderr," PrtMarkerSuppliesDescription=%s\n",entMrk->PrtMarkSupDesc);
			fprintf(stderr," PrtMarkerSuppliesSupplyUnit=%d\n",entMrk->PrtMarkSupSupUnit);
			fprintf(stderr," PrtMarkerSuppliesMaxCapacity=%d\n",entMrk->PrtMarkSupMaxCap);
			fprintf(stderr," PrtMarkerSuppliesLevel=%d\n",entMrk->PrtMarkSupLevel);
			fprintf(stderr,"\n");
			entMrk = entMrk->next;
			mnum++;
		}
	}else{
		fprintf(stderr,"no PrtMarkerSupplies Entry\n");
	}
}

void showAlert(EntryPrtAlert *entAlt)
{
	int anum=1;
	if(entAlt){
		while(entAlt){
			fprintf(stderr,"PrtAlertEntry[%d]\n",anum);
			fprintf(stderr," PrtAlertSeverityLevel=%d\n",entAlt->PrtAltSevLevel);
			fprintf(stderr," PrtAlertGroup=%d\n",entAlt->PrtAltGrp);
			fprintf(stderr," PrtAlertGroupIndex=%d\n",entAlt->PrtAltGrpIndex);
			fprintf(stderr," PrtAlertCode=%d\n",entAlt->PrtAltCode);
			fprintf(stderr," PrtAlertDescription=%s\n",entAlt->PrtAltDesc);
			fprintf(stderr,"\n");
			entAlt = entAlt->next;
			anum++;
		}
	}else{
		fprintf(stderr,"no PrtAlert Entry\n");
	}
}

#if 0
void showPrinterStatus(EntryPrtStatus *entStat)
{
	int snum=1;
	if(entStat){
		while(entStat){
			fprintf(stderr,"PrtStatusEntry[%d]\n",snum);
			fprintf(stderr," PrtStatusIndex=%d\n",entStat->PrtStatIndex);
			fprintf(stderr," PrtStatusType=%d\n",entStat->PrtStatType);
			fprintf(stderr," PrtStatusDescription=%s\n",entStat->PrtStatDesc);
			entStat = entStat->next;
			snum++;
		}
	}else{
		fprintf(stderr,"no PrinterStatus Entry\n");
	}
}
# endif

void showEntry(Entry *entry)
{
	showLocalization(entry->EntryPrtLocalizationPtr);
	showMarkerSupplies(entry->EntryPrtMarkerSuppliesPtr);
	showAlert(entry->EntryPrtAlertPtr);
	//	showPrinterStatus(entry->EntryPrtStatusPtr);
}

int main(int argc, char **argv)
{
	char *input_uri;
	Parser *parser;
	Entry *entry;
	int ret;

	if (argc != 2) {
		fprintf(stderr,"You must specifiy XML file\n");
		exit(-1);
	}
	input_uri = strdup(argv[1]);

	parser = newParser();
	if ( (ret = parseParserFromFile(parser, input_uri)) < 0 ){
		fprintf(stderr,"Failed to parse %s:%d\n", input_uri,ret);
	}

	entry = fetchEntryFromParser(parser);
	if(!entry){
		fprintf(stderr,"no Entry\n");
	} else {
		fprintf(stderr,"read Entry success\n");
		showEntry(entry);
	}
	deleteEntry(entry);
	deleteParser(parser);
	exit(0);
}
