﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using OPMLEditor.Forms;


namespace OPMLEditor.Structure
{
    class StructurePanel
    {
        private TextBox nodeTitle;
        private CheckBox chkVisible;
        private Button btnSetNote;
        private Panel pnlNode;
        private StructureNode spirit;
        private CheckBox chkChecked;

        #region getter/setter
        public TextBox NodeTitle { get{return nodeTitle;} set{nodeTitle = value;} }
        public CheckBox ChkVisible { get { return chkVisible; } set { chkVisible = value; } }
        public Button BtnSetNote { get { return btnSetNote; } set { btnSetNote = value; } }
        public Panel PnlNode { get { return pnlNode; } set { pnlNode = value; } }
        public CheckBox ChkChecked { get { return chkChecked; } set { chkChecked = value; } }

        #endregion
        #region Constructor
        public StructurePanel(StructureNode spirit)
        {
            this.spirit = spirit;
            pnlNode = new Panel();

            nodeTitle = new TextBox();
            chkVisible = new CheckBox();
            btnSetNote = new Button();
            chkChecked = new CheckBox();
            // 
            // NodeTitle
            // 
            this.nodeTitle.Font = new System.Drawing.Font("MS UI Gothic", 13F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            this.nodeTitle.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) |  System.Windows.Forms.AnchorStyles.Right)));
            this.nodeTitle.Location = new System.Drawing.Point(20, 0);
            this.nodeTitle.Size = new System.Drawing.Size(900, 20);
            this.nodeTitle.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;

            // 
            // chkVisible
            // 
            this.chkVisible.AutoSize = true;
            this.chkVisible.Location = new System.Drawing.Point(3, 6);
            this.chkVisible.Size = new System.Drawing.Size(15, 14);
            this.chkVisible.TabStop = false;
            this.chkVisible.UseVisualStyleBackColor = true;
            this.chkVisible.Visible = false;

            // 
            // btnSetNote
            // 
            this.btnSetNote.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSetNote.Font = new System.Drawing.Font("MS UI Gothic", 9F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            this.btnSetNote.Location = new System.Drawing.Point(945, 3);
            this.btnSetNote.Size = new System.Drawing.Size(30, 20);
            this.btnSetNote.TabStop = false;
            if (spirit.Note == null || spirit.Note == string.Empty )
            {
                this.btnSetNote.Text = "－";
            }
            else
            {
                this.btnSetNote.Text = "≡";
            }
            this.btnSetNote.UseVisualStyleBackColor = true;
            //
            // chkChecked
            //
            this.chkChecked.AutoSize = true;
            this.chkChecked.Location = new System.Drawing.Point(925, 6);
            this.chkChecked.Size = new System.Drawing.Size(15, 14);
            this.chkChecked.TabStop = false;
            this.chkChecked.UseVisualStyleBackColor = true;
            this.chkChecked.Visible = true;

            // 
            // panel1
            // 
            this.pnlNode.Anchor = ((System.Windows.Forms.AnchorStyles)(System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left));
            this.pnlNode.Size = new System.Drawing.Size(980, 25);
            
            this.pnlNode.Controls.Add(this.chkVisible);
            this.pnlNode.Controls.Add(this.NodeTitle);
            this.pnlNode.Controls.Add(this.btnSetNote);
            this.pnlNode.Controls.Add(this.chkChecked);
            //Event Handler
            this.nodeTitle.KeyPress += new KeyPressEventHandler(this.nodeTitle_KeyPress);
            this.nodeTitle.PreviewKeyDown += new System.Windows.Forms.PreviewKeyDownEventHandler(this.nodeTitle_Keydown);
            this.nodeTitle.GotFocus += new EventHandler(nodeTitle_GotFocus);
            this.nodeTitle.TextChanged += new EventHandler(nodeTitle_TextChanged);
            this.nodeTitle.LostFocus += new EventHandler(nodeTitle_LostFocus);
            this.btnSetNote.Click += new EventHandler(btnSetNote_Enter);
            this.chkChecked.CheckedChanged += new EventHandler(chkChecked_CheckedChanged);
            nodeTitle.Text = spirit.TitleText;
            chkVisible.Checked = spirit.IsOpen;
            
            setIndentVisual();
        }
        #endregion
        #region EventHandler
        void chkChecked_CheckedChanged(object sender, EventArgs e)
        {
            checkedStateColorControll(false);
            spirit.IsChecked = this.chkChecked.Checked;
        }


        private void btnSetNote_Enter(object sender, EventArgs e)
        {
            invokeNoteWindow();
        }
        private void nodeTitle_GotFocus(object sender, EventArgs e)
        {
            nodeTitle.Select(nodeTitle.Text.Length, 0);

            checkedStateColorControll(true);
            spirit.MyPartCall();
            
        }
        private void nodeTitle_LostFocus(object sender, EventArgs e)
        {
            checkedStateColorControll(false);
        }

        private void nodeTitle_TextChanged(object sender, EventArgs e)
        {
            spirit.TitleText = nodeTitle.Text;
        }
        private void btnDelete_Enter(object sender, EventArgs e)
        {
            spirit.catchDelete();
        }
        private void nodeTitle_KeyPress(object sender, KeyPressEventArgs e)
        {
            //EnterやEscapeキーでビープ音が鳴らないようにする
            if (e.KeyChar == (char)Keys.Enter || e.KeyChar == (char)Keys.Escape)
            {
                e.Handled = true;
            }
            else if (e.KeyChar == '\n')
            {
                e.Handled = true;
            }

        }
        //PreviewKeyDownイベントハンドラ
        private void nodeTitle_Keydown(object sender,
            PreviewKeyDownEventArgs e)
        {

            switch (e.KeyCode)
            {
                case Keys.Enter:
                    if (e.Control)
                    {
                        spirit.catchCtrlEnter();
                    }
                    else
                    {
                        spirit.catchEnter();
                    }
                    break;
                case Keys.Down:
                    if (!e.Control)
                    {
                        spirit.catchDown();
                    }
                    break;
                case Keys.Up:
                    if (!e.Control)
                    {
                        spirit.catchUp();
                    }
                    break;
            }
        }

        #endregion
        public void invokeNoteWindow()
        {
            FrmNote frmNote = new FrmNote(this.spirit.Note);
            frmNote.Owner = FrmBase.ActiveForm;

            DialogResult res = frmNote.ShowDialog();
            if (res == DialogResult.OK)
            {
                this.spirit.Note = ((FrmBase)frmNote.Owner).TmpNote;
            }
            changeButton();
        }

        public void changeButton()
        {
            if (this.spirit.Note == string.Empty)
            {
                this.btnSetNote.Text = "－";
            }
            else
            {
                this.btnSetNote.Text = "≡";
            }
        }

        private void setIndentVisual()
        {
            this.nodeTitle.Left = 20 + (spirit.Indent * 15);
            this.nodeTitle.Size = new System.Drawing.Size(900 - (spirit.Indent * 15), 20);
            this.chkVisible.Left = 3 + (spirit.Indent * 15);
        }

        public void reRendaring()
        {
            setIndentVisual();
        }
        private void checkedStateColorControll(bool isFocused)
        {
            //パネル全体の色をフォーカスとステータス、検索結果で変更する
            if (isFocused)
            {
                this.pnlNode.BackColor = System.Drawing.Color.AliceBlue;
            }
            else if (spirit.IsSearchResult)
            {
                this.pnlNode.BackColor = System.Drawing.Color.Yellow;
            }
            else if (this.chkChecked.Checked)
            {
                this.pnlNode.BackColor = System.Drawing.Color.LightGray;
            }
            else
            {
                this.pnlNode.BackColor = System.Drawing.Color.Transparent;
            }
            //テキストボックスの色は分けて処理する
            if (this.chkChecked.Checked)
            {
                this.nodeTitle.BackColor = System.Drawing.Color.WhiteSmoke;
            }
            else
            {
                this.nodeTitle.BackColor = System.Drawing.Color.White;
            }

        }
        public void becomeSearchResult()
        {
            checkedStateColorControll(false);
        }

    }
}
