﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OPMLEditor.opml;
using OPMLEditor.Controller;
using System.IO;

namespace OPMLEditor.export
{
    class ExportController
    {
        public void export(ExportIF exporter)
        {
            string fileName = exporter.showFileNameDialog();

            if (fileName == null || fileName == string.Empty) { return; }
            
            exporter.DataSource = 
                OpmlParser.Parser.createOpmlData(
                fileName, NodeController.getNodeController().ParentList);

            try
            {
                using (StreamWriter sw = new StreamWriter(fileName))
                {

                    List<string> arrangedList = exporter.arrangeData();

                    foreach (string text in arrangedList)
                    {
                        sw.WriteLine(text);
                    }
                }

            }
            catch (Exception ex)
            {
                OpmlApplicationExceptionControl.ErrorDialog("エクスポートに失敗しました。");
            }
        }
    }
}
