﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OPMLEditor.opml;
using System.Windows.Forms;

namespace OPMLEditor.export
{
    class TabTextExporter:abTextExporter,ExportIF
    {
        private Opml dataSource;
        public override Opml DataSource
        {
            set { this.dataSource = value; }
        }

        public override List<string> arrangeData()
        {
            List<string> retData = new List<string>();
            
            foreach(Outline node in dataSource.body.outline)
            {
                retData.Add(node.text);
                if (node.note != null && node.note != string.Empty)
                {
                    string noteText = node.note;

                    retData.Add("\t" + noteText.Replace("\n", "\n\t"));
                }
                recursiveArrangeData(node.outline,retData, 1);
            }
            return retData;
        }

        private void recursiveArrangeData(List<Outline> list,List<string> retData, int p)
        {
            string tabSeparater = string.Empty;
            for (int i = 0; i < p; i++)
            {
                tabSeparater += "\t";
            }

            foreach (Outline childNode in list)
            {
                retData.Add(tabSeparater + childNode.text);
                if (childNode.note != null && childNode.note != string.Empty)
                {
                    string noteText = childNode.note;

                    retData.Add(tabSeparater + "\t" + noteText.Replace("\n", "\n\t"+tabSeparater));
                }
                recursiveArrangeData(childNode.outline, retData, p+1);
            }
        }

    }
}
