﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using OPMLEditor.Controller;
using OPMLEditor.Structure;

namespace OPMLEditor.opml
{
    class OpmlParser
    {
        private int allNodeCount;
        private string expansionState;

        public static OpmlParser Parser
        {
            get
            {
                if (singleton == null)
                {
                    singleton = new OpmlParser();
                }
                return singleton;
            }
            
        }
        private static OpmlParser singleton;
        private OpmlParser()
        {
        }

        #region Serialize/Deserialize
        private Opml Deserialize(string fileName)
        {
            //XmlSerializerオブジェクトを作成
            XmlRootAttribute xRoot = new XmlRootAttribute();
            xRoot.ElementName = "opml";
            xRoot.IsNullable = true;

            //シリアライザ起動
            System.Xml.Serialization.XmlSerializer serializer =
                new System.Xml.Serialization.XmlSerializer(typeof(Opml), xRoot);

            System.IO.FileStream fs;
            try
            {
                //読み込むファイルを開く
                fs = new System.IO.FileStream(fileName, System.IO.FileMode.Open);

                //XMLファイルから読み込み、逆シリアル化する
                Opml obj = (Opml)serializer.Deserialize(fs);
                //ファイルを閉じる
                fs.Close();
                return obj;

            }
            catch (Exception e)
            {
                
                OpmlApplicationExceptionControl.ErrorDialog(e.Message);

                return null;
            }
        }
        private void Serialize(Opml opml, String filePath)
        {
            //XmlSerializerオブジェクトを作成
            //オブジェクトの型を指定する
            XmlSerializerNamespaces ns = new XmlSerializerNamespaces();
            ns.Add("", "");

            XmlRootAttribute xRoot = new XmlRootAttribute();
            xRoot.ElementName = "opml";
            xRoot.IsNullable = true;

            XmlSerializer serializer = new XmlSerializer(typeof(Opml), xRoot);
            try
            {

                //書き込むファイルを開く
                System.IO.FileStream fs = new System.IO.FileStream(filePath, System.IO.FileMode.OpenOrCreate);
                //シリアル化し、XMLファイルに保存する
                serializer.Serialize(fs, opml, ns);
                //ファイルを閉じる
                fs.Close();
            }
            catch (Exception e)
            {
                OpmlApplicationExceptionControl.ErrorDialog(e.Message);
            }
        }
        #endregion

        /// <summary>
        /// ファイル読み込み処理
        /// </summary>
        /// <param name="fileName"></param>
        /// <param name="ctrl"></param>
        /// <returns></returns>
        public void LoadFile(string fileName,NodeController ctrl)
        {
            try
            {
                Opml opml = Deserialize(fileName);


                List<StructureNode> retData = new List<StructureNode>();

                foreach (Outline outline in opml.body.outline)
                {

                    StructureNode baseData = new StructureNode(ctrl, outline.text, outline.note
                        , (outline._status == "checked"));
                    baseData.ParentNode = null;
                    addStructuredChild(baseData, outline, ctrl);
                    retData.Add(baseData);
                }
                ctrl.ParentList = retData;
            }
            catch (Exception ex)
            {
                OpmlApplicationExceptionControl.ErrorDialog("読み込みエラーが発生いたしました。");
            }
        }

        public void SaveFile(string fileName, NodeController ctrl)
        {
            List<StructureNode> currentList = ctrl.ParentList;
            try
            {
                Serialize(createOpmlData(fileName, currentList), fileName);
            }
            catch (Exception ex)
            {
                OpmlApplicationExceptionControl.ErrorDialog("書き込みエラーが発生いたしました。");
            }
        }

        public Opml createOpmlData(string fileName,List<StructureNode> parentList)
        {
            allNodeCount = 0;
            expansionState = string.Empty;

            Opml saveData = new Opml();
            saveData.head = new Head();
            saveData.body = new Body();
            saveData.body.outline = new List<Outline>();

            foreach (StructureNode data in parentList)
            {

                Outline outlineInner = new Outline();
                outlineInner.text = data.TitleText;
                outlineInner.note = data.Note;
                if (data.IsChecked)
                {
                    outlineInner._status = "checked";
                }
                addOpmlChild(outlineInner, data);
                saveData.body.outline.Add(outlineInner);
                allNodeCount++;

            }

            saveData.head.expansionState = expansionState;
            string[] aryFilePath = fileName.Split('\\');
            string titleName = aryFilePath[aryFilePath.Length - 1];

            saveData.head.title = titleName.Replace(".opml", "");
            
            return saveData;
        }
        /// <summary>
        /// 再帰的に子ノード情報を取得する(OPMLバージョン)
        /// </summary>
        /// <param name="parentOutline"></param>
        /// <param name="data"></param>
        private void addOpmlChild(Outline parentOutline, StructureNode data)
        {
            //子ノードがある場合はexpansionStateに追加
            if (data.getAllChildlen().Count > 0)
            {
                if (expansionState == string.Empty)
                {
                    expansionState = allNodeCount.ToString();
                }
                else
                {
                    expansionState += "," + allNodeCount.ToString();
                }
            }
            foreach (StructureNode childData in data.getAllChildlen())
            {
                Outline childOutline = new Outline();
                childOutline.text = childData.TitleText;
                childOutline.note = childData.Note;
                if (childData.IsChecked)
                {
                    childOutline._status = "checked";
                }
                parentOutline.outline.Add(childOutline);
                allNodeCount++;
                addOpmlChild(childOutline, childData);
            }
        }

        /// <summary>
        /// 再帰的に子ノード情報を取得する(StruvtureBaseバージョン)
        /// </summary>
        /// <param name="data"></param>
        /// <param name="parentOutline"></param>
        /// <param name="ctrl"></param>
        private void addStructuredChild(StructureNode data, Outline parentOutline,NodeController ctrl)
        {
            foreach (Outline childOutline in parentOutline.outline)
            {
                StructureNode childData = new StructureNode(ctrl, childOutline.text,
                    childOutline.note,(childOutline._status == "checked"));
                childData.ParentNode = data;
                data.addChild(childData);
                addStructuredChild(childData, childOutline, ctrl);
            }
        }
    }
}
