/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.axis.NumberAxis;
import jp.sf.orangesignal.chart.axis.StepAxis;
import jp.sf.orangesignal.chart.data.StepChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.ChartScreenType;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.UpDownColorType;
import jp.sf.orangesignal.chart.ui.canvas.AbstractChartCanvas;
import jp.sf.orangesignal.chart.ui.screen.ChartScreen;
import jp.sf.orangesignal.chart.util.DrawUtils;

public class StepChartCanvas
extends AbstractChartCanvas {
    private static final long serialVersionUID = -2000292684241868524L;
    private ChartScreenType screenType;
    private final NumberAxis priceAxis = new NumberAxis();
    private final StepAxis stepAxis = new StepAxis();
    private Rectangle2D chartArea = null;
    private Point mousePosition = null;
    private int position = -1;
    private final ChartScreen parent;
    private StepChartDataset dataset = null;
    private int start;
    private int period;
    private ChartSettings settings;
    private double periodWidth;
    private static final int MARGIN = 6;
    private Image screenCache = null;

    public StepChartCanvas(Icons icons, ChartScreen parent, ChartScreenType screenType) {
        this.screenType = screenType;
        this.parent = parent;
        this.priceAxis.setRangeType(NumberAxis.RangeType.POSITIVE);
        this.priceAxis.setLowerPadding(0.05);
        this.priceAxis.setUpperPadding(0.05);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                StepChartCanvas.this.processPosition(null);
                StepChartCanvas.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                StepChartCanvas.this.processPosition(new Point(e.getX(), e.getY()));
                StepChartCanvas.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StepChartCanvas.this.processLayout();
            }
        });
    }

    private void processPosition(Point point) {
        if (this.chartArea != null && point != null && this.chartArea.contains(point)) {
            this.mousePosition = point;
            this.position = this.start + Math.min((int)Math.floor(((double)this.mousePosition.x - this.chartArea.getMinX()) / this.periodWidth), this.period - 1);
        } else {
            this.mousePosition = null;
            this.position = this.start + this.period - 1;
        }
        this.parent.sendPositionChanged(new ChartScreenEvent(this, this.mousePosition, this.start, this.period, this.position));
    }

    @Override
    public void switchDataset(ChartEvent e) {
        this.dataset = (StepChartDataset)e.getDataset();
        if (!e.isIgnoreStart()) {
            this.start = e.getStart();
        }
        this.period = e.getPeriod();
        this.settings = e.getSettings();
        boolean fixed = false;
        if (this.screenType == ChartScreenType.POINT_AND_FIGURE) {
            fixed = this.settings.pf.fixed;
        } else if (this.screenType == ChartScreenType.KAGI) {
            fixed = this.settings.kagi.fixed;
        } else if (this.screenType == ChartScreenType.RENKOH) {
            fixed = this.settings.renkoh.fixed;
        } else if (this.screenType == ChartScreenType.SHINNE) {
            fixed = this.settings.shinne.fixed;
        } else {
            throw new RuntimeException();
        }
        if (fixed) {
            this.priceAxis.setFixedLower(new Double(0.0));
        } else {
            this.priceAxis.setFixedLower(null);
        }
        if (this.dataset != null) {
            this.priceAxis.prepare(new Number[][]{this.dataset.high, this.dataset.low}, this.screenType == ChartScreenType.POINT_AND_FIGURE ? this.dataset.point : 0.0);
        }
        this.adjustTicks();
        this.processPosition(null);
        this.processLayout();
        this.update();
    }

    private void adjustTicks() {
        if (this.dataset != null) {
            this.priceAxis.autoAdjustRange(this.start, this.period);
        }
        this.priceAxis.refreshTicks();
    }

    @Override
    public void setStart(int start) {
        this.start = start;
        this.update();
    }

    private void update() {
        this.adjustTicks();
        this.processPosition(null);
        this.screenCache = null;
        this.repaint();
    }

    private void processLayout() {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        int axisWidth = this.priceAxis.getSpace(g2);
        int axisHeight = this.stepAxis.getSpace(g2);
        int x = 6 + axisWidth;
        int w = this.getWidth() - x - 6;
        int h = this.getHeight() - axisHeight;
        FontMetrics fm = g2.getFontMetrics(NumberAxis.FONT);
        double plotMarginHeight = (double)fm.getAscent() * 0.5 + (double)fm.getDescent();
        this.chartArea = new Rectangle2D.Double(x, plotMarginHeight, w, (double)h - plotMarginHeight);
        this.priceAxis.refreshTicks(g2, this.chartArea);
        this.periodWidth = (this.chartArea.getWidth() - 1.0) / (double)this.period;
        this.screenCache = null;
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.screenCache == null) {
            this.screenCache = this.createImage();
        }
        g2.drawImage(this.screenCache, 0, 0, this);
        if (this.settings.trace) {
            this.drawAxisTrace(g2);
        }
    }

    private Image createImage() {
        Image image = this.createImage(this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        super.setRenderingHints(g2);
        this.priceAxis.draw(g2, this.chartArea);
        this.stepAxis.draw(g2, this.chartArea);
        if (this.dataset != null) {
            this.drawChart(g2);
        }
        g2.dispose();
        return image;
    }

    private void drawAxisTrace(Graphics2D g2) {
        if (this.mousePosition != null) {
            double x = this.chartArea.getMinX() + (double)(this.position - this.start) * this.periodWidth + this.periodWidth * 0.5;
            this.stepAxis.drawAxisTrace(g2, this.chartArea, x);
            this.priceAxis.drawAxisTrace(g2, this.chartArea, this.mousePosition.y, 2);
        }
    }

    private void drawChart(Graphics2D g2) {
        Shape saved = g2.getClip();
        g2.setClip(this.chartArea);
        if (this.dataset.getCount() > 0) {
            if (this.screenType == ChartScreenType.POINT_AND_FIGURE) {
                this.drawPointFigure(g2);
            } else if (this.screenType == ChartScreenType.KAGI) {
                this.drawKagi(g2);
            } else if (this.screenType == ChartScreenType.RENKOH) {
                this.drawRenkoh(g2);
            } else if (this.screenType == ChartScreenType.SHINNE) {
                this.drawShinne(g2);
            }
        }
        DrawUtils.drawDescription(g2, this.chartArea, this.screenType.toString());
        g2.setClip(saved);
    }

    private void drawPointFigure(Graphics2D g2) {
        UpDownColorType colors = this.settings.updownLineColors;
        int count = this.dataset.getCount();
        double point = this.dataset.point;
        Object originalStrokeControl = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (int i = 0; i < this.period; ++i) {
            double y2;
            double y1;
            double value;
            int n = this.start + i;
            if (n < 0 || n >= count) continue;
            double high = this.dataset.high[n].doubleValue();
            double low = this.dataset.low[n].doubleValue();
            double x1 = this.chartArea.getMinX() + (double)i * this.periodWidth;
            double x2 = x1 + this.periodWidth;
            if (this.dataset.lowDate[n].compareTo(this.dataset.highDate[n]) < 0) {
                g2.setColor(colors.getUpLineColor());
                for (value = low - low % point + point; value <= high; value += point) {
                    y1 = this.priceAxis.valueToJava2D(value, this.chartArea);
                    y2 = this.priceAxis.valueToJava2D(value + point, this.chartArea);
                    g2.draw(new Line2D.Double(x1, y1, x2, y2));
                    g2.draw(new Line2D.Double(x1, y2, x2, y1));
                }
                continue;
            }
            g2.setColor(colors.getDownLineColor());
            for (value = high - high % point - point; value > low - point; value -= point) {
                y1 = this.priceAxis.valueToJava2D(value + point, this.chartArea);
                y2 = this.priceAxis.valueToJava2D(value, this.chartArea);
                g2.drawOval((int)x1, (int)y1, (int)this.periodWidth, (int)(y2 - y1));
            }
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, originalStrokeControl);
    }

    private void drawKagi(Graphics2D g2) {
        UpDownColorType colors = this.settings.updownLineColors;
        int count = this.dataset.getCount();
        boolean up = this.dataset.start[0].doubleValue() < this.dataset.high[0].doubleValue();
        g2.setColor(up ? colors.getUpLineColor() : colors.getDownLineColor());
        for (int i = 0; i < this.period + 1; ++i) {
            double prevLow;
            int n = this.start + i;
            if (n < 0 || n >= count) continue;
            double high = this.dataset.high[n].doubleValue();
            double low = this.dataset.low[n].doubleValue();
            double x = this.chartArea.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5;
            double y1 = this.priceAxis.valueToJava2D(high, this.chartArea);
            double y2 = this.priceAxis.valueToJava2D(low, this.chartArea);
            g2.draw(new Line2D.Double(x, y1, x, y2));
            if (this.dataset.start[n].doubleValue() < high) {
                double prevHigh;
                g2.draw(new Line2D.Double(x - this.periodWidth, y2, x, y2));
                if (up || n <= 0 || !(high > (prevHigh = this.dataset.high[n - 1].doubleValue()))) continue;
                g2.setColor(colors.getUpLineColor());
                g2.draw(new Line2D.Double(x, y1, x, this.priceAxis.valueToJava2D(prevHigh, this.chartArea)));
                up = true;
                continue;
            }
            g2.draw(new Line2D.Double(x - this.periodWidth, y1, x, y1));
            if (!up || n <= 0 || !(low < (prevLow = this.dataset.low[n - 1].doubleValue()))) continue;
            g2.setColor(colors.getDownLineColor());
            g2.draw(new Line2D.Double(x, this.priceAxis.valueToJava2D(prevLow, this.chartArea), x, y2));
            up = false;
        }
    }

    private void drawRenkoh(Graphics2D g2) {
        UpDownColorType colors = this.settings.updownBarColors;
        int count = this.dataset.getCount();
        for (int i = 0; i < this.period; ++i) {
            double closeY;
            int n = this.start + i;
            if (n < 0 || n >= count || this.dataset.start[n] == null) continue;
            double open = this.dataset.start[n].doubleValue();
            boolean up = open < this.dataset.end[n].doubleValue();
            double openY = this.priceAxis.valueToJava2D(open, this.chartArea);
            if (up) {
                double high = this.dataset.high[n].doubleValue();
                closeY = this.priceAxis.valueToJava2D(high, this.chartArea);
            } else {
                double low = this.dataset.low[n].doubleValue();
                closeY = this.priceAxis.valueToJava2D(low, this.chartArea);
            }
            double y1 = Math.min(openY, closeY);
            double y2 = Math.max(openY, closeY);
            double x1 = this.chartArea.getMinX() + (double)i * this.periodWidth;
            double x2 = x1 + this.periodWidth;
            if (up) {
                g2.setPaint(new GradientPaint((float)x1, (float)y1, colors.getUpColor1(), (float)x2, (float)y2, colors.getUpColor2()));
            } else {
                g2.setPaint(new GradientPaint((float)x1, (float)y1, colors.getDownColor1(), (float)x2, (float)y2, colors.getDownColor2()));
            }
            Rectangle2D.Double body = new Rectangle2D.Double(x1, y1, this.periodWidth, y2 - y1);
            g2.fill(body);
            g2.setColor(up ? colors.getUpLineColor() : colors.getDownLineColor());
            g2.draw(body);
        }
    }

    private void drawShinne(Graphics2D g2) {
        UpDownColorType colors = this.settings.updownBarColors;
        int count = this.dataset.getCount();
        for (int i = 0; i < this.period; ++i) {
            double closeY;
            int n = this.start + i;
            if (n < 0 || n >= count) continue;
            double open = this.dataset.start[n].doubleValue();
            boolean up = open < this.dataset.end[n].doubleValue();
            double openY = this.priceAxis.valueToJava2D(open, this.chartArea);
            if (up) {
                double high = this.dataset.high[n].doubleValue();
                closeY = this.priceAxis.valueToJava2D(high, this.chartArea);
            } else {
                double low = this.dataset.low[n].doubleValue();
                closeY = this.priceAxis.valueToJava2D(low, this.chartArea);
            }
            double y1 = Math.min(openY, closeY);
            double y2 = Math.max(openY, closeY);
            double x1 = this.chartArea.getMinX() + (double)i * this.periodWidth;
            double x2 = x1 + this.periodWidth;
            if (up) {
                g2.setPaint(new GradientPaint((float)x1, (float)y1, colors.getUpColor1(), (float)x2, (float)y2, colors.getUpColor2()));
            } else {
                g2.setPaint(new GradientPaint((float)x1, (float)y1, colors.getDownColor1(), (float)x2, (float)y2, colors.getDownColor2()));
            }
            Rectangle2D.Double body = new Rectangle2D.Double(x1, y1, this.periodWidth, y2 - y1);
            g2.fill(body);
            g2.setColor(up ? colors.getUpLineColor() : colors.getDownLineColor());
            g2.draw(body);
        }
    }
}

