/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.screen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import jp.sf.orangesignal.chart.data.AntiWatchChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.canvas.AntiWatchCanvas;
import jp.sf.orangesignal.chart.ui.screen.ChartScreen;

public class AntiWatchScreen
extends ChartScreen
implements AdjustmentListener {
    private static final long serialVersionUID = -5765368008796724675L;
    private final AntiWatchCanvas canvas;
    private JScrollBar scrollbar = new JScrollBar(0, 0, 0, 0, 0);

    public AntiWatchScreen(Icons icons) {
        this.canvas = new AntiWatchCanvas(icons, this);
        this.scrollbar.addAdjustmentListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.add((Component)this.scrollbar, "South");
    }

    @Override
    public void datasetSwitch(ChartEvent e) {
        this.processChartEvent(e);
    }

    @Override
    public void periodSwitch(ChartEvent e) {
        this.processChartEvent(e);
    }

    @Override
    public void settingChanged(ChartEvent e) {
        this.processChartEvent(e);
    }

    private void processChartEvent(ChartEvent e) {
        if (!e.isIgnoreStart()) {
            AntiWatchChartDataset dataset = (AntiWatchChartDataset)e.getDataset();
            if (dataset == null) {
                this.scrollbar.setMaximum(0);
                this.scrollbar.setVisibleAmount(0);
                this.scrollbar.setValue(0);
                this.scrollbar.setBlockIncrement(0);
                this.scrollbar.setEnabled(false);
            } else {
                this.scrollbar.setValue(0);
                this.scrollbar.setMaximum(dataset.getCount());
                this.scrollbar.setVisibleAmount(e.getPeriod());
                this.scrollbar.setValue(e.getStart());
                this.scrollbar.setBlockIncrement(e.getPeriod() / 2);
                this.scrollbar.setEnabled(true);
            }
        }
        this.canvas.switchDataset(e);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.canvas.setStart(e.getValue());
    }
}

