/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.screen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.canvas.IndexCanvas;
import jp.sf.orangesignal.chart.ui.screen.SideScreen;
import jp.sf.orangesignal.chart.util.StringManager;

public class PointFigureSideScreen
extends SideScreen {
    private static final long serialVersionUID = 1793099655525350911L;
    private final IndexCanvas canvas;
    private final JCheckBox fixed = new JCheckBox(StringManager.getString("fixed", new Object[0]));
    private JSpinner point = new JSpinner(new SpinnerNumberModel(3, 1, 100, 1));
    private JSpinner reversal = new JSpinner(new SpinnerNumberModel(3, 1, 100, 1));

    public PointFigureSideScreen(Icons icons) {
        this.canvas = new IndexCanvas(icons);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        int y = 0;
        this.addCanvas(layout, c, y++, this.canvas);
        this.addCheckBox(layout, c, y++, this.fixed);
        this.addSeparator(layout, c, y++);
        this.addPanel(layout, c, y, this.createParamPanel());
    }

    private JPanel createParamPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(layout);
        int y = 0;
        this.addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("point", new Object[0])), this.point);
        this.addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("reversal", new Object[0])), this.reversal);
        return panel;
    }

    @Override
    public void load(ChartSettings settings) {
        this.setVisibleAdvancedOptions(settings.advancedOptions);
        ChartSettings.PointFigureSettings s = settings.pf;
        this.fixed.setSelected(s.fixed);
        this.point.setValue(s.point);
        this.reversal.setValue(s.reversal);
    }

    @Override
    public void save(ChartSettings settings) {
        ChartSettings.PointFigureSettings s = settings.pf;
        s.fixed = this.fixed.isSelected();
        s.point = (Integer)this.point.getValue();
        s.reversal = (Integer)this.reversal.getValue();
    }

    public boolean isIgnoreStart(ChartSettings settings) {
        ChartSettings.PointFigureSettings s = settings.pf;
        return s.fixed != this.fixed.isSelected();
    }

    @Override
    public void datasetSwitch(ChartEvent e) {
        this.notify = false;
        boolean enabled = e.getDataset() != null;
        this.fixed.setEnabled(enabled);
        this.point.setEnabled(enabled);
        this.reversal.setEnabled(enabled);
        if (enabled) {
            this.load(e.getSettings());
        }
        this.canvas.switchDataset(e);
        this.notify = true;
    }

    @Override
    public void periodSwitch(ChartEvent e) {
        this.canvas.switchDataset(e);
    }

    @Override
    public void settingChanged(ChartEvent e) {
        this.canvas.switchDataset(e);
    }

    @Override
    public void positionChanged(ChartScreenEvent e) {
        this.canvas.setup(e);
    }

    @Override
    public void setVisibleAdvancedOptions(boolean visible) {
        this.fixed.setVisible(visible);
    }
}

