package jp.sourceforge.orangesignal.ta;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import jp.sourceforge.orangesignal.ta.candle.Candlestick;

import org.junit.Test;

public class ArrayDataUtilsTest {

	// ---------------------------------------------------- subarray

	@Test
	public void subarray_数値配列() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Number[] o = ArrayDataUtils.subarray(i, 0);
		assertEquals(o.length, i.length);
		assertEquals(o[0], i[0]);
		assertEquals(o[1], i[1]);
		assertEquals(o[2], i[2]);
	}

	@Test
	public void subarray_数値配列・開始位置() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Number[] o = ArrayDataUtils.subarray(i, 1);
		assertEquals(o.length, i.length - 1);
		assertEquals(o[0], i[1]);
		assertEquals(o[1], i[2]);
	}

	@Test
	public void subarray_数値配列・null() {
		final Number[] i = null;
		assertNull(ArrayDataUtils.subarray(i, 0));
	}

	@SuppressWarnings("deprecation")
	@Test
	public void subarray_日付配列() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		final Date[] o = ArrayDataUtils.subarray(i, 0);
		assertEquals(o.length, i.length);
		assertEquals(o[0], i[0]);
		assertEquals(o[1], i[1]);
		assertEquals(o[2], i[2]);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void subarray_日付配列・開始位置() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		final Date[] o = ArrayDataUtils.subarray(i, 1);
		assertEquals(o.length, i.length - 1);
		assertEquals(o[0], i[1]);
		assertEquals(o[1], i[2]);
	}

	@Test
	public void subarray_日付配列・null() {
		final Date[] i = null;
		assertNull(ArrayDataUtils.subarray(i, 0));
	}

	@Test
	public void subarray_ローソク足配列() {
		final Candlestick[] i = new Candlestick[]{};
		final Candlestick[] o = ArrayDataUtils.subarray(i, 0);
		assertEquals(o.length, i.length);
	}

	@Test
	public void subarray_ローソク足配列・null() {
		final Candlestick[] i = null;
		assertNull(ArrayDataUtils.subarray(i, 0));
	}

	@Test
	public void subarray_オブジェクト配列() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Object[] o = ArrayDataUtils.subarray((Object[]) i, 0);
		assertEquals(o.length, i.length);
		assertEquals(o[0], i[0]);
		assertEquals(o[1], i[1]);
		assertEquals(o[2], i[2]);
	}

	@Test
	public void subarray_オブジェクト配列・開始位置() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Object[] o = ArrayDataUtils.subarray((Object[]) i, 1);
		assertEquals(o.length, i.length - 1);
		assertEquals(o[0], i[1]);
		assertEquals(o[1], i[2]);
	}

	@Test
	public void subarray_オブジェクト配列・null() {
		final Number[] i = null;
		assertNull(ArrayDataUtils.subarray((Object[]) i, 0));
	}

	// ---------------------------------------------------- extend

	@Test
	public void extend_数値配列・null() {
		final Number[] i = null;
		assertNull(ArrayDataUtils.extend(i, 0));
	}

	@Test
	public void extend_数値配列・正数() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Number[] o = ArrayDataUtils.extend(i, 1);
		assertEquals(o.length, i.length + 1);
		assertEquals(o[0], i[0]);
		assertEquals(o[1], i[1]);
		assertEquals(o[2], i[2]);
		assertNull(o[3]);
	}

	@Test
	public void extend_数値配列・負数() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Number[] o = ArrayDataUtils.extend(i, -1);
		assertEquals(o.length, i.length + 1);
		assertNull(o[0]);
		assertEquals(o[1], i[0]);
		assertEquals(o[2], i[1]);
		assertEquals(o[3], i[2]);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void extend_数値配列・0() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Number[] o = ArrayDataUtils.extend(i, 0);
		assertEquals(o, i);
	}

	@Test
	public void extend_日付配列・null() {
		final Date[] i = null;
		assertNull(ArrayDataUtils.extend(i, 0));
	}

	@SuppressWarnings("deprecation")
	@Test
	public void extend_日付配列・正数() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		final Date[] o = ArrayDataUtils.extend(i, 1);
		assertEquals(o.length, i.length + 1);
		assertEquals(o[0], i[0]);
		assertEquals(o[1], i[1]);
		assertEquals(o[2], i[2]);
		assertNull(o[3]);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void extend_日付配列・負数() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		final Date[] o = ArrayDataUtils.extend(i, -1);
		assertEquals(o.length, i.length + 1);
		assertNull(o[0]);
		assertEquals(o[1], i[0]);
		assertEquals(o[2], i[1]);
		assertEquals(o[3], i[2]);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void extend_日付配列・0() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		final Date[] o = ArrayDataUtils.extend(i, 0);
		assertEquals(o, i);
	}

	@Test
	public void extend_ローソク足配列・null() {
		final Candlestick[] i = null;
		assertNull(ArrayDataUtils.extend(i, 0));
	}

	@Test
	public void extend_ローソク足配列・正数() {
		final Candlestick[] i = new Candlestick[]{};
		final Candlestick[] o = ArrayDataUtils.extend(i, 1);
		assertEquals(o.length, i.length + 1);
		assertNull(o[o.length - 1]);
	}

	@Test
	public void extend_ローソク足配列・負数() {
		final Candlestick[] i = new Candlestick[]{};
		final Candlestick[] o = ArrayDataUtils.extend(i, -1);
		assertEquals(o.length, i.length + 1);
		assertNull(o[0]);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void extend_ローソク足配列・0() {
		final Candlestick[] i = new Candlestick[]{};
		final Candlestick[] o = ArrayDataUtils.extend(i, 0);
		assertEquals(o, i);
	}

	@Test
	public void extend_オブジェクト配列・null() {
		final Number[] i = null;
		assertNull(ArrayDataUtils.extend((Object[]) i, 0));
	}

	@Test
	public void extend_オブジェクト配列・正数() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Object[] o = ArrayDataUtils.extend((Object[]) i, 1);
		assertEquals(o.length, i.length + 1);
		assertEquals(o[0], i[0]);
		assertEquals(o[1], i[1]);
		assertEquals(o[2], i[2]);
		assertNull(o[3]);
	}

	@Test
	public void extend_オブジェクト配列・負数() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Object[] o = ArrayDataUtils.extend((Object[]) i, -1);
		assertEquals(o.length, i.length + 1);
		assertNull(o[0]);
		assertEquals(o[1], i[0]);
		assertEquals(o[2], i[1]);
		assertEquals(o[3], i[2]);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void extend_オブジェクト配列・0() {
		final Number[] i = new Number[]{ 1, 2, 3 };
		final Object[] o = ArrayDataUtils.extend((Object[]) i, 0);
		assertEquals(o, i);
	}

	// ---------------------------------------------------- isSameLength

	@Test
	public void isSameLength_true() {
		final Object[] i1 = new Object[]{ 1, 2, 3 };
		final Object[] i2 = new Object[]{ 4, 5, 6 };
		assertTrue(ArrayDataUtils.isSameLength(i1, i2));
	}

	@Test
	public void isSameLength_false() {
		final Object[] i1 = new Object[]{ 1, 2, 3 };
		final Object[] i2 = new Object[]{ 4, 5 };
		assertFalse(ArrayDataUtils.isSameLength(i1, i2));
	}

	// ---------------------------------------------------- getMinLength

	@Test
	public void getMinLength() {
		final Object[] i1 = new Object[]{ 1, 2, 3 };
		final Object[] i2 = new Object[]{ 4, 5 };
		final Object[] i3 = new Object[]{ 6, 7, 8, 9 };
		assertEquals(ArrayDataUtils.getMinLength(i1, i2, i3), i2.length);
	}

	// ---------------------------------------------------- getMaxLength

	@Test
	public void getMaxLength() {
		final Object[] i1 = new Object[]{ 1, 2, 3 };
		final Object[] i2 = new Object[]{ 4, 5 };
		final Object[] i3 = new Object[]{ 6, 7, 8, 9 };
		final Object[] i4 = new Object[]{ 10 };
		assertEquals(ArrayDataUtils.getMaxLength(i1, i2, i3, i4), i3.length);
	}

	// ---------------------------------------------------- indexOf

	@Test
	public void indexOf・null日付配列() {
		final Date[] i = null;
		assertEquals(ArrayDataUtils.indexOf(i, new Date()), -1);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void indexOf・null() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), null, new Date(2000, 1, 3) };
		assertEquals(ArrayDataUtils.indexOf(i, null), 1);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void indexOf() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		assertEquals(ArrayDataUtils.indexOf(i, new Date(2000, 1, 2)), 1);
	}

	@Test
	public void indexOf・null日付配列・開始位置() {
		final Date[] i = null;
		assertEquals(ArrayDataUtils.indexOf(i, new Date(), 1), -1);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void indexOf・null・開始位置() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), null, new Date(2000, 1, 3) };
		assertEquals(ArrayDataUtils.indexOf(i, null, 0), 1);
		assertEquals(ArrayDataUtils.indexOf(i, null, 1), 1);
		assertEquals(ArrayDataUtils.indexOf(i, null, 2), -1);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void indexOf・開始位置() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		assertEquals(ArrayDataUtils.indexOf(i, new Date(2000, 1, 2), 0), 1);
		assertEquals(ArrayDataUtils.indexOf(i, new Date(2000, 1, 2), 1), 1);
		assertEquals(ArrayDataUtils.indexOf(i, new Date(2000, 1, 2), 2), 2);
	}

	// ---------------------------------------------------- lastIndexOf

	@Test
	public void lastIndexOf・null日付配列() {
		final Date[] i = null;
		assertEquals(ArrayDataUtils.lastIndexOf(i, new Date()), -1);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void lastIndexOf・null() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), null, new Date(2000, 1, 3) };
		assertEquals(ArrayDataUtils.lastIndexOf(i, null), 1);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void lastIndexOf() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		assertEquals(ArrayDataUtils.lastIndexOf(i, new Date(2000, 1, 2)), 1);
	}

	@Test
	public void lastIndexOf・null日付配列・開始位置() {
		final Date[] i = null;
		assertEquals(ArrayDataUtils.lastIndexOf(i, new Date(), 1), -1);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void lastIndexOf・null・開始位置() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), null, new Date(2000, 1, 3) };
		assertEquals(ArrayDataUtils.lastIndexOf(i, null, 0), -1);
		assertEquals(ArrayDataUtils.lastIndexOf(i, null, 1), 1);
		assertEquals(ArrayDataUtils.lastIndexOf(i, null, 2), 1);
	}

	@SuppressWarnings("deprecation")
	@Test
	public void lastIndexOf・開始位置() {
		final Date[] i = new Date[]{ new Date(2000, 1, 1), new Date(2000, 1, 2), new Date(2000, 1, 3) };
		assertEquals(ArrayDataUtils.lastIndexOf(i, new Date(2000, 1, 2), 0), 0);
		assertEquals(ArrayDataUtils.lastIndexOf(i, new Date(2000, 1, 2), 1), 1);
		assertEquals(ArrayDataUtils.lastIndexOf(i, new Date(2000, 1, 2), 2), 1);
	}

	@Test
	public void isEmpty_true() {
		final Object[] i = new Object[]{};
		assertTrue(ArrayDataUtils.isEmpty(i));
	}

	@Test
	public void isEmpty_false() {
		final Object[] i = new Object[]{ 1, 2, 3 };
		assertFalse(ArrayDataUtils.isEmpty(i));
	}

}
