package jp.sourceforge.orangesignal.ta;

import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNot.not;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import jp.sourceforge.orangesignal.ta.dataset.StandardDataset;
import jp.sourceforge.orangesignal.ta.dataset.loader.DbDatasetLoader;
import jp.sourceforge.orangesignal.ta.result.Aroon;
import jp.sourceforge.orangesignal.ta.result.Bands2;
import jp.sourceforge.orangesignal.ta.result.Bands5;
import jp.sourceforge.orangesignal.ta.result.Bands7;
import jp.sourceforge.orangesignal.ta.result.DMI;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.ta.result.Histogram;
import jp.sourceforge.orangesignal.ta.result.Ichimoku;
import jp.sourceforge.orangesignal.ta.result.MESA;
import jp.sourceforge.orangesignal.ta.result.Shinohara;
import jp.sourceforge.orangesignal.ta.result.Step;
import jp.sourceforge.orangesignal.ta.result.Stochastics;

import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.runner.RunWith;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@RunWith(Theories.class)
public class TechnicalAnalysisTest {

	private static StandardDataset dataset;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		final DbDatasetLoader loader = new DbDatasetLoader();
		loader.setDataSource((DataSource) new ClassPathXmlApplicationContext("datasource-context.xml").getBean("dataSource", DataSource.class));
		loader.setSql("SELECT date, open, high, low, close, volume FROM price WHERE id = ? ORDER BY date");
		loader.setSymbol("n225");
		dataset = new StandardDataset(loader.load(), false);
		assertNotNull(dataset);
		assertTrue(dataset.getLength() > 0);
	}

	@Test
	public void testTechnicalAnalysis() {
		new TechnicalAnalysis();
		assertTrue(true);
	}

	@Test()
	public void testAddNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.add(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAddNumberArrayNumber() {
		final Number[] results = TechnicalAnalysis.add(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testSubNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.sub(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testSubNumberArrayNumber() {
		final Number[] results = TechnicalAnalysis.sub(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMultNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.mult(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMultNumberArrayNumber() {
		final Number[] results = TechnicalAnalysis.mult(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testDivNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.div(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testDivNumberArrayNumber() {
		final Number[] results = TechnicalAnalysis.div(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAvgNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.avg(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAvgNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.avg(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAvgNumberArrayNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.avg(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testSin() {
		final Number[] results = TechnicalAnalysis.sin(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCos() {
		final Number[] results = TechnicalAnalysis.cos(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTan() {
		final Number[] results = TechnicalAnalysis.tan(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAsin() {
		final Number[] results = TechnicalAnalysis.asin(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAcos() {
		final Number[] results = TechnicalAnalysis.acos(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAtan() {
		final Number[] results = TechnicalAnalysis.atan(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testExp() {
		final Number[] results = TechnicalAnalysis.exp(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testLog() {
		final Number[] results = TechnicalAnalysis.log(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testLog10() {
		final Number[] results = TechnicalAnalysis.log10(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testSqrt() {
		final Number[] results = TechnicalAnalysis.sqrt(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCeil() {
		final Number[] results = TechnicalAnalysis.ceil(TechnicalAnalysis.div(dataset.getTechnicalClose(), 2));
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testFloor() {
		final Number[] results = TechnicalAnalysis.floor(TechnicalAnalysis.div(dataset.getTechnicalClose(), 2));
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRound() {
		final Number[] results = TechnicalAnalysis.round(TechnicalAnalysis.div(dataset.getTechnicalClose(), 2));
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test
	public void testAbs() {
		final Number[] results1 = TechnicalAnalysis.abs(dataset.getTechnicalClose());
		assertNotNull(results1);
		assertThat(results1.length, is(dataset.getLength()));

		final Number[] results2 = TechnicalAnalysis.abs(TechnicalAnalysis.mult(dataset.getTechnicalClose(), -1));
		assertNotNull(results2);
		assertThat(results2.length, is(dataset.getLength()));
	}

	@Test()
	public void testMax() {
		final Number[] results = TechnicalAnalysis.max(dataset.getTechnicalOpen(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMin() {
		final Number[] results = TechnicalAnalysis.min(dataset.getTechnicalOpen(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testSinh() {
		final Number[] results = TechnicalAnalysis.sinh(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCosh() {
		final Number[] results = TechnicalAnalysis.cosh(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTanh() {
		final Number[] results = TechnicalAnalysis.tanh(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testSum() {
		final Number[] results = TechnicalAnalysis.sum(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testHighest() {
		final Number[] results = TechnicalAnalysis.highest(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testLowest() {
		final Number[] results = TechnicalAnalysis.lowest(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPeriodsSinceHighest() {
		final Number[] results = TechnicalAnalysis.periodsSinceHighest(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPeriodsSinceLowest() {
		final Number[] results = TechnicalAnalysis.periodsSinceLowest(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMidpoint() {
		final Number[] results = TechnicalAnalysis.midpoint(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMidprice() {
		final Number[] results = TechnicalAnalysis.midprice(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test
	public void testVarNumberArrayIntBoolean() {
		final Number[] results1 = TechnicalAnalysis.var(dataset.getTechnicalClose(), 5, false);
		assertNotNull(results1);
		assertThat(results1.length, is(dataset.getLength()));

		final Number[] results2 = TechnicalAnalysis.var(dataset.getTechnicalClose(), 5, true);
		assertNotNull(results2);
		assertThat(results2.length, is(dataset.getLength()));
	}

	@Test()
	public void testVarNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.var(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testVarp() {
		final Number[] results = TechnicalAnalysis.varp(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testStddev() {
		final Number[] results = TechnicalAnalysis.stddev(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testStddevp() {
		final Number[] results = TechnicalAnalysis.stddevp(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test
	public void testCovarNumberArrayNumberArrayIntBoolean() {
		final Number[] results1 = TechnicalAnalysis.covar(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5, true);
		assertNotNull(results1);
		assertThat(results1.length, is(dataset.getLength()));

		final Number[] results2 = TechnicalAnalysis.covar(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5, false);
		assertNotNull(results2);
		assertThat(results1.length, is(dataset.getLength()));
	}

	@Test()
	public void testCovarNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.covar(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCovarn() {
		final Number[] results = TechnicalAnalysis.covarn(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test
	public void testCorrelNumberArrayNumberArrayIntBoolean() {
		final Number[] results1 = TechnicalAnalysis.correl(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5, true);
		assertNotNull(results1);
		assertThat(results1.length, is(dataset.getLength()));

		final Number[] results2 = TechnicalAnalysis.correl(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5, false);
		assertNotNull(results2);
		assertThat(results2.length, is(dataset.getLength()));
	}

	@Test()
	public void testCorrelNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.correl(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPearson() {
		final Number[] results = TechnicalAnalysis.pearson(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testLr() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testBetaNumberArrayNumberArrayIntBoolean() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testBetaNumberArrayNumberArrayInt() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testBeta2() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testAvgprice() {
		final Number[] results = TechnicalAnalysis.avgprice(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testHeikin() {
		final Map<FourPrice, Number[]> results = TechnicalAnalysis.heikin(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
	}

	@Test()
	public void testMp() {
		final Number[] results = TechnicalAnalysis.mp(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTp() {
		final Number[] results = TechnicalAnalysis.tp(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testWtcl() {
		final Number[] results = TechnicalAnalysis.wtcl(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTh() {
		final Number[] results = TechnicalAnalysis.th(dataset.getTechnicalHigh(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTl() {
		final Number[] results = TechnicalAnalysis.th(dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTr() {
		final Number[] results = TechnicalAnalysis.tr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test
	public void testMa() {
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.SMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.SMMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.GMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.RMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.WWMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.WMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.HMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.TMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.EMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.DEMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.TEMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.ZLEMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.EPMA);
		assertTrue(true);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.T3);
		assertTrue(true);
	}

	@Test()
	public void testDoubleSmoothNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.doubleSmooth(dataset.getTechnicalClose(), 5, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testDoubleSmoothNumberArrayIntMovingAverageIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.doubleSmooth(dataset.getTechnicalClose(), 5, MovingAverage.EMA, 5, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTripleSmoothNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.tripleSmooth(dataset.getTechnicalClose(), 5, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTripleSmoothNumberArrayIntMovingAverageIntMovingAverageIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.tripleSmooth(dataset.getTechnicalClose(), 5, MovingAverage.EMA, 5, MovingAverage.EMA, 5, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testDmaNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.dma(dataset.getTechnicalClose(), 5, 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testDmaNumberArrayIntMovingAverageInt() {
		final Number[] results = TechnicalAnalysis.dma(dataset.getTechnicalClose(), 5, MovingAverage.SMA, 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testSma() {
		final Number[] results = TechnicalAnalysis.sma(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testSmma() {
		final Number[] results = TechnicalAnalysis.smma(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test
	public void testGma() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testRma() {
		final Number[] results = TechnicalAnalysis.rma(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testWwma() {
		final Number[] results = TechnicalAnalysis.wwma(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testWma() {
		final Number[] results = TechnicalAnalysis.wma(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testHma() {
		final Number[] results = TechnicalAnalysis.hma(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTma() {
		final Number[] results = TechnicalAnalysis.tma(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testEma() {
		final Number[] results = TechnicalAnalysis.ema(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testDema() {
		final Number[] results = TechnicalAnalysis.dema(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTema() {
		final Number[] results = TechnicalAnalysis.tema(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testZlema() {
		final Number[] results = TechnicalAnalysis.zlema(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testEpma() {
		final Number[] results = TechnicalAnalysis.epma(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testT3NumberArrayInt() {
		final Number[] results = TechnicalAnalysis.t3(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testT3NumberArrayIntDouble() {
		final Number[] results = TechnicalAnalysis.t3(dataset.getTechnicalClose(), 5, 1.2);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMamaNumberArray() {
		final Map<MESA, Number[]> results = TechnicalAnalysis.mama(dataset.getTechnicalClose());
		assertNotNull(results);
	}

	@Test()
	public void testMamaNumberArrayDoubleDouble() {
		final Map<MESA, Number[]> results = TechnicalAnalysis.mama(dataset.getTechnicalClose(), 0.5, 0.05);
		assertNotNull(results);
	}

	@Test()
	public void testVwma() {
		final Number[] results = TechnicalAnalysis.vwma(dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCrossNumberArrayNumberArray() {
		final CrossSignal[] results = TechnicalAnalysis.cross(TechnicalAnalysis.sma(dataset.getTechnicalClose(), 5), TechnicalAnalysis.sma(dataset.getTechnicalClose(), 25));
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCrossNumberArrayDouble() {
		final CrossSignal[] results = TechnicalAnalysis.cross(TechnicalAnalysis.sma(dataset.getTechnicalClose(), 5), 10000);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testGc() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testDc() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testZigzag() {
		final Number[] results = TechnicalAnalysis.zigzag(dataset.getTechnicalClose(), 5);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testBbandsNumberArrayNumberArrayNumberArrayIntDouble() {
		final Map<Bands5, Number[]> results = TechnicalAnalysis.bbands(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 5, 0.2);
		assertNotNull(results);
	}

	@Test()
	public void testBbandsNumberArrayIntDouble() {
		final Map<Bands5, Number[]> results = TechnicalAnalysis.bbands(TechnicalAnalysis.tp(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose()), 5, 0.2);
		assertNotNull(results);
	}

	@Test()
	public void testEnvelopeNumberArrayIntMovingAverageDouble() {
		final Map<Bands5, Number[]> results = TechnicalAnalysis.envelope(dataset.getTechnicalClose(), 25, MovingAverage.SMA, 5.0D);
		assertNotNull(results);
	}

	@Test()
	public void testEnvelopeNumberArrayDouble() {
		final Number[] results = TechnicalAnalysis.envelope(TechnicalAnalysis.sma(dataset.getTechnicalClose(), 5), 5.0D);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testIchimoku() {
		final Map<Ichimoku, Number[]> results = TechnicalAnalysis.ichimoku(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 26, 9, 26);
		assertNotNull(results);
	}

	@Test()
	public void testDisplace() {
		final Number[] results = TechnicalAnalysis.displace(dataset.getTechnicalClose(), 26);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPivot() {
		final Map<Bands7, Number[]> results = TechnicalAnalysis.pivot(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
	}

	@Test()
	public void testSar() {
		final Number[] results = TechnicalAnalysis.sar(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 0.02D);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testVolatility() {
		final Map<Bands2, Number[]> results = TechnicalAnalysis.volatility(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 5, 2.0D);
		assertNotNull(results);
	}

	@Test()
	public void testAtr() {
		final Number[] results = TechnicalAnalysis.atr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testChvNumberArrayNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.chv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 10, 10);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testChvNumberArrayNumberArrayIntIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.chv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 10, 10, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testHv() {
		final Number[] results = TechnicalAnalysis.hv(dataset.getTechnicalClose(), 20, dataset.getInterval().getMaxPeriod());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testNatrNumberArrayNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.natr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testNatrNumberArrayNumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.natr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	/* ---------------------------------------------------------------------- */
	/* モメンタム指標 */

	@Test()
	public void testApoNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.apo(dataset.getTechnicalClose(), 10, 30);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testApoNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.apo(dataset.getTechnicalClose(), 10, 30, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testAsi() {
	}

	@Test()
	public void testAroonNumberArrayInt() {
		final Map<Aroon, Number[]> results = TechnicalAnalysis.aroon(dataset.getTechnicalClose(), 14);
		assertNotNull(results);
	}

	@Test()
	public void testAroonNumberArrayIntPercentageScale() {
		final Map<Aroon, Number[]> results = TechnicalAnalysis.aroon(dataset.getTechnicalClose(), 14, PercentageScale.PERCENT);
		assertNotNull(results);
	}

	@Test()
	public void testBmpNumberArrayNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.bmp(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testBmpNumberArrayNumberArrayNumberArrayNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.bmp(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testBopNumberArrayNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.bop(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testBopNumberArrayNumberArrayNumberArrayNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.bop(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCci() {
		final Number[] results = TechnicalAnalysis.cci(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 20);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testChg() {
		final Number[] results = TechnicalAnalysis.chg(dataset.getClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testChgcnt() {
	}

	@Test()
	public void testCmf() {
		final Number[] results = TechnicalAnalysis.cmf(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 21);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCmoNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.cmo(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 25);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCmoNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.cmo(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 25, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCoppockNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.coppock(dataset.getTechnicalClose(), 12, 10, MovingAverage.WMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCoppockNumberArray() {
		final Number[] results = TechnicalAnalysis.coppock(dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testCoppockNumberArrayIntIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.coppock(dataset.getTechnicalClose(), 11, 14, 10, MovingAverage.WMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCrsiNumberArrayIntInt() {
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCrsiNumberArrayIntIntInt() {
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCrsiNumberArrayIntIntIntPercentageScale() {
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCsi() {
	}

	@Test()
	public void testDmiNumberArrayNumberArrayNumberArrayIntInt() {
		final Map<DMI, Number[]> results = TechnicalAnalysis.dmi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14, 9);
		assertNotNull(results);
	}

	@Test()
	public void testDmiNumberArrayNumberArrayNumberArrayIntIntPercentageScale() {
		final Map<DMI, Number[]> results = TechnicalAnalysis.dmi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14, 9, PercentageScale.PERCENT);
		assertNotNull(results);
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testDmiNumberArray() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testDmiNumberArrayIntIntMovingAverageIntDoubleDoublePercentageScale() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testDpoNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.dpo(dataset.getTechnicalClose(), 10);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testDpoNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.dpo(dataset.getTechnicalClose(), 10, MovingAverage.SMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testEmv() {
		final Number[] results = TechnicalAnalysis.emv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalVolume(), 1);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testKairiNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.kairi(dataset.getTechnicalClose(), TechnicalAnalysis.ma(dataset.getTechnicalClose(), 25, MovingAverage.SMA));
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testKairiNumberArrayNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.kairi(dataset.getTechnicalClose(), TechnicalAnalysis.ma(dataset.getTechnicalClose(), 25, MovingAverage.SMA), PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMacdNumberArrayIntIntInt() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.macd(dataset.getTechnicalClose(), 25, 75, 9);
		assertNotNull(results);
	}

	@Test()
	public void testMacdNumberArrayIntIntIntMovingAverage() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.macd(dataset.getTechnicalClose(), 25, 75, 9, MovingAverage.SMA);
		assertNotNull(results);
	}

	@Test()
	public void testMacdNumberArrayIntMovingAverageIntMovingAverageIntMovingAverage() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.macd(dataset.getTechnicalClose(), 25, MovingAverage.EMA, 75, MovingAverage.EMA, 9, MovingAverage.SMA);
		assertNotNull(results);
	}

	@Test()
	public void testMfi() {
		final Number[] results = TechnicalAnalysis.mfi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 14);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMiNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.mi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 25);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMiNumberArrayNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.mi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 25, 9, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testMom() {
		final Number[] results = TechnicalAnalysis.mom(dataset.getTechnicalClose(), 25);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPain() {
		final Number[] results = TechnicalAnalysis.pain(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPchgNumberArray() {
		final Number[] results = TechnicalAnalysis.pchg(dataset.getClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPchgNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.pchg(dataset.getClose(), PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPcrNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.pcr(dataset.getTechnicalClose(), 9);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPcrNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.pcr(dataset.getTechnicalClose(), 9, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testPerformanceNumberArrayInt() {
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testPerformanceNumberArrayIntPercentageScale() {
	}

	@Test()
	public void testPpoNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.ppo(dataset.getTechnicalClose(), 10, 30);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPpoNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.ppo(dataset.getTechnicalClose(), 10, 30, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPpoNumberArrayIntIntMovingAveragePercentageScale() {
		final Number[] results = TechnicalAnalysis.ppo(dataset.getTechnicalClose(), 10, 30, MovingAverage.EMA, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPsyNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.psy(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 12);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPsyNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.psy(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 12, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testQstickNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.qstick(dataset.getTechnicalOpen(), dataset.getTechnicalClose(), 8);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testQstickNumberArrayNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.qstick(dataset.getTechnicalOpen(), dataset.getTechnicalClose(), 8, MovingAverage.SMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRciNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.rci(dataset.getTechnicalClose(), 9);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRciNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.rci(dataset.getTechnicalClose(), 9, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRocNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.roc(dataset.getTechnicalClose(), 25);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRocNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.roc(dataset.getTechnicalClose(), 25, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRsiNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.rsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 14);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRsiNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.rsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 14, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRviNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.rvi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 14);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testRviNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.rvi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 14, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testShinoharaNumberArrayNumberArrayNumberArrayNumberArrayInt() {
		final Map<Shinohara, Number[]> results = TechnicalAnalysis.shinohara(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 26);
		assertNotNull(results);
	}

	@Test()
	public void testShinoharaNumberArrayNumberArrayNumberArrayNumberArrayIntPercentageScale() {
		final Map<Shinohara, Number[]> results = TechnicalAnalysis.shinohara(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 26, PercentageScale.PERCENT);
		assertNotNull(results);
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCratio() {
	}

	@Test()
	public void testSrvNumberArrayNumberArrayNumberArrayIntInt() {
		final Map<Stochastics, Number[]> results = TechnicalAnalysis.srv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 9, 9);
		assertNotNull(results);
	}

	@Test()
	public void testSrvNumberArrayNumberArrayNumberArrayIntIntPercentageScale() {
		final Map<Stochastics, Number[]> results = TechnicalAnalysis.srv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 9, 9, PercentageScale.PERCENT);
		assertNotNull(results);
	}

	@Test()
	public void testSrvNumberArrayNumberArrayNumberArrayIntIntMovingAveragePercentageScale() {
		final Map<Stochastics, Number[]> results = TechnicalAnalysis.srv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 9, 9, MovingAverage.SMA, PercentageScale.PERCENT);
		assertNotNull(results);
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testSrvrsi() {
	}

	@Test()
	public void testTiiNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.tii(dataset.getTechnicalClose(), 30);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTiiNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.tii(dataset.getTechnicalClose(), 30, MovingAverage.SMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTiiNumberArrayIntMovingAveragePercentageScale() {
		final Number[] results = TechnicalAnalysis.tii(dataset.getTechnicalClose(), 30, MovingAverage.SMA, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testTrix() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.trix(dataset.getTechnicalClose(), 25, 9, MovingAverage.SMA);
		assertNotNull(results);
	}

	@Test()
	public void testTsiNumberArrayIntIntIntMovingAverage() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.tsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 13, 25, 7, MovingAverage.SMA);
		assertNotNull(results);
	}

	@Test()
	public void testTsiNumberArrayIntIntMovingAverageIntMovingAverage() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.tsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 13, 25, MovingAverage.EMA, 7, MovingAverage.SMA);
		assertNotNull(results);
	}

	@Test()
	public void testTsiNumberArrayIntMovingAverageIntMovingAverageIntMovingAveragePercentageScale() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.tsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 13, MovingAverage.EMA, 25, MovingAverage.EMA, 7, MovingAverage.SMA, PercentageScale.PERCENT);
		assertNotNull(results);
	}

	@Test()
	public void testUltimateNumberArrayNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.ultimate(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 7);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testUltimateNumberArrayNumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.ultimate(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 7, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testVidyaNumberArrayInt() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testVidyaNumberArrayIntInt() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testWad() {
		final Number[] results = TechnicalAnalysis.wad(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testWrNumberArrayNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.wr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 20);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testWrNumberArrayNumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.wr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 20, PercentageScale.REVERSE_PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	/* ---------------------------------------------------------------------- */
	/* 出来高指標 */

	@Test()
	public void testAd() {
		final Number[] results = TechnicalAnalysis.ad(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testClv() {
		final Number[] results = TechnicalAnalysis.clv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testChoNumberArrayNumberArrayNumberArrayNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.cho(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 3, 10);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testChoNumberArrayNumberArrayNumberArrayNumberArrayIntMovingAverageIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.cho(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 3, MovingAverage.EMA, 10, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAvoNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.avo(dataset.getTechnicalVolume(), 10, 30);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testAvoNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.avo(dataset.getTechnicalVolume(), 10, 30, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testBwmfiNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.bwmfi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalVolume());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testBwmfiNumberArrayNumberArrayNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.bwmfi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalVolume(), PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPvoNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.pvo(dataset.getTechnicalVolume(), 10, 30);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPvoNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.pvo(dataset.getTechnicalVolume(), 10, 30, MovingAverage.EMA);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPvoNumberArrayIntIntMovingAveragePercentageScale() {
		final Number[] results = TechnicalAnalysis.pvo(dataset.getTechnicalVolume(), 10, 30, MovingAverage.EMA, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPvt() {
		final Number[] results = TechnicalAnalysis.pvt(dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testVao() {
		final Number[] results = TechnicalAnalysis.vao(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testVr1NumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.vr1(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 25);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testVr1NumberArrayNumberArrayIntDoubleDouble() {
		final Number[] results = TechnicalAnalysis.vr1(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 25, 450, 70);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testVr2NumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.vr2(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 14);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testVr2NumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.vr2(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 14, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testWvrNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.wvr(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 25);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testWvrNumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.wvr(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 25, PercentageScale.PERCENT);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testPvi() {
		final Number[] results = TechnicalAnalysis.pvi(dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testNvi() {
		final Number[] results = TechnicalAnalysis.nvi(dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	@Test()
	public void testObv() {
		final Number[] results = TechnicalAnalysis.obv(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 75);
		assertNotNull(results);
		assertThat(results.length, is(dataset.getLength()));
	}

	/* ---------------------------------------------------------------------- */
	/* 時系列 */

	@Ignore("過去散々テストしてから変更がないためテスト対象外とする")
	@Test()
	public void testSplit() {
		fail("まだ実装されていません");
	}

	/* ---------------------------------------------------------------------- */
	/* 非時系列 */

	@Test()
	public void testPf() {
		final List<Step> results = TechnicalAnalysis.pf(dataset.getDate(), dataset.getClose(), 2.0D, 3);
		assertNotNull(results);
		assertThat(results.size(), is(not(0)));
	}

	@Test()
	public void testKagi() {
		final List<Step> results = TechnicalAnalysis.kagi(dataset.getDate(), dataset.getClose(), 3.0D);
		assertNotNull(results);
		assertThat(results.size(), is(not(0)));
	}

	@Test()
	public void testRenkoh() {
		final List<Step> results = TechnicalAnalysis.renkoh(dataset.getDate(), dataset.getClose(), 3.0D);
		assertNotNull(results);
		assertThat(results.size(), is(not(0)));
	}

	@Test()
	public void testShinne() {
		final List<Step> results = TechnicalAnalysis.shinne(dataset.getDate(), dataset.getClose(), 3);
		assertNotNull(results);
		assertThat(results.size(), is(not(0)));
	}

}
