package jp.sourceforge.orangesignal.ta.candle.generator;

import static jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.DOJI;
import static jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.FAR;
import static jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.LONG_BODY;
import static jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.LONG_SHADOW;
import static jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.NEAR;
import static jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.NO_SHADOW;
import static jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.SAME;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import java.util.EnumMap;
import java.util.Map;

import jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSetting.Range;

import org.junit.Test;

public class DefaultCandlestickGeneratorSettingsTest {

	private static final Map<CandlestickGeneratorSettingType, CandlestickGeneratorSetting> settings = new EnumMap<CandlestickGeneratorSettingType, CandlestickGeneratorSetting>(CandlestickGeneratorSettingType.class);
	static {
		settings.put(LONG_BODY, new CandlestickGeneratorSetting(Range.BODY, 1.0));
		settings.put(DOJI, new CandlestickGeneratorSetting(Range.BODY, 0.1));
		settings.put(LONG_SHADOW, new CandlestickGeneratorSetting(Range.BODY, 1.0));
		settings.put(NO_SHADOW, new CandlestickGeneratorSetting(Range.CANDLE, 0.1));
		settings.put(SAME, new CandlestickGeneratorSetting(Range.CANDLE, 0.05));
		settings.put(NEAR, new CandlestickGeneratorSetting(Range.CANDLE, 0.2));
		settings.put(FAR, new CandlestickGeneratorSetting(Range.CANDLE, 0.6));
	}

	@Test
	public void インスタンス化成功() {
		final DefaultCandlestickGeneratorSettings o = new DefaultCandlestickGeneratorSettings(settings, 10, 5);
		assertThat(o.getSettings(), is(settings));
	}

	@Test(expected = NullPointerException.class)
	public void コンストラクタ_settings_null() {
		new DefaultCandlestickGeneratorSettings(null, 10, 5);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_lengthPeriod_不正1() {
		new DefaultCandlestickGeneratorSettings(settings, 0, 5);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_lengthPeriod_不正2() {
		new DefaultCandlestickGeneratorSettings(settings, -1, 5);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_distancePeriod_不正1() {
		new DefaultCandlestickGeneratorSettings(settings, 10, 0);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_distancePeriod_不正2() {
		new DefaultCandlestickGeneratorSettings(settings, 10, -1);
	}

}
