/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading;

/**
 * トレードの種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum TradeType {

	/**
	 * 買い注文と買い注文の決済が可能である事を表します。
	 */
	LONG {
		@Override public boolean isLong() { return true; }
		@Override public boolean isShort() { return false; }
		@Override public boolean isReverse() { return false; }
	},

	/**
	 * 売り注文と売り注文の決済が可能である事を表します。
	 */
	SHORT {
		@Override public boolean isLong() { return false; }
		@Override public boolean isShort() { return true; }
		@Override public boolean isReverse() { return false; }
	},

	/**
	 * 買い注文と売り注文及び途転(ドテン)を含めない決済が可能である事を表します。
	 */
	LONG_AND_SHORT {
		@Override public boolean isLong() { return true; }
		@Override public boolean isShort() { return true; }
		@Override public boolean isReverse() { return false; }
	},

	/**
	 * 買い注文と売り注文及び途転(ドテン)を含めた決済が可能である事を表します。
	 */
	LONG_AND_SHORT_AND_REVERSE {
		@Override public boolean isLong() { return true; }
		@Override public boolean isShort() { return true; }
		@Override public boolean isReverse() { return true; }
	};

	/**
	 * この列挙型が買い注文可能であるかどうかを返します。
	 * 
	 * @return 買い注文が可能である場合は <code>true</code> それ以外の場合は <code>false</code>
	 */
	public abstract boolean isLong();

	/**
	 * この列挙型が売り注文可能であるかどうかを返します。
	 * 
	 * @return 売り注文が可能である場合は <code>true</code> それ以外の場合は <code>false</code>
	 */
	public abstract boolean isShort();

	/**
	 * この列挙型が途転(ドテン)可能であるかどうかを返します。
	 * 
	 * @return 途転(ドテン)が可能である場合は <code>true</code> それ以外の場合は <code>false</code>
	 */
	public abstract boolean isReverse();

}
