/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.commission;

/**
 * 手数料情報のインタフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface Commission {

	/**
	 * 指定された価格と数量から手数料を計算して返します。
	 * 
	 * @param price 価格
	 * @param quantity 数量
	 * @return 手数料
	 */
	public double calcCommission(double price, int quantity);

}
