/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

import java.util.List;

import jp.sourceforge.orangesignal.ta.candle.TrendType;
import jp.sourceforge.orangesignal.ta.result.Step;


/**
 * ポイント＆フィギュアデータからトレンド情報を処理するトレンドプロセッサークラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public final class PointFigureTrendProcessor extends StepTrendProcessor {

	/**
	 * コンストラクタです。
	 * 
	 * @param pf ポイント＆フィギュアデータ
	 */
	public PointFigureTrendProcessor(final List<Step> pf) {
		super(pf);
	}

	@Override
	protected TrendType getTrend(final Step pf) {
		if (pf.lowDate.compareTo(pf.highDate) < 0)
			return TrendType.UP;	// × 上昇トレンド
		return TrendType.DOWN;	// ○ 下降トレンド
	}

}
