/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.dataset.loader;

import java.util.EventObject;

import jp.sourceforge.orangesignal.ta.dataset.TimeSeriesDataset;


/**
 * データセットがロードされた事を表すイベント情報を提供します。
 * 
 * @author 杉澤 浩二
 * @since 1.1
 */
public final class DatasetLoadEvent extends EventObject {

	private static final long serialVersionUID = 1L;

	/**
	 * データセットを保持します。
	 */
	private transient TimeSeriesDataset dataset;

	/**
	 * コンストラクタです。
	 * 
	 * @param source イベントの発生元のオブジェクト
	 * @param dataset データセット
	 */
	public DatasetLoadEvent(final Object source, final TimeSeriesDataset dataset) {
		super(source);
		this.dataset = dataset;
	}

	/**
	 * データセットを返します。
	 * 
	 * @return データセット
	 */
	public TimeSeriesDataset getDataset() { return dataset; }

}
