package jp.sourceforge.orangesignal.ta;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class ArrayDataConverterTest {

	@Test
	public void toPrice_int配列指定() {
		final int[] price = new int[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1);
		assertEquals(results[1], 2);
		assertEquals(results[2], 3);
		assertNull(results[3]);
		assertEquals(results[4], 4);
		assertEquals(results[5], 5);
	}

	@Test
	public void toPrice_long配列指定() {
		final long[] price = new long[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1L);
		assertEquals(results[1], 2L);
		assertEquals(results[2], 3L);
		assertNull(results[3]);
		assertEquals(results[4], 4L);
		assertEquals(results[5], 5L);
	}

	@Test
	public void toPrice_float配列指定() {
		final float[] price = new float[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1F);
		assertEquals(results[1], 2F);
		assertEquals(results[2], 3F);
		assertNull(results[3]);
		assertEquals(results[4], 4F);
		assertEquals(results[5], 5F);
	}

	@Test
	public void toPrice_double配列指定() {
		final double[] price = new double[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1D);
		assertEquals(results[1], 2D);
		assertEquals(results[2], 3D);
		assertNull(results[3]);
		assertEquals(results[4], 4D);
		assertEquals(results[5], 5D);
	}

	@Test
	public void toTechnicalPrice_int配列指定() {
		final int[] price = new int[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toTechnicalPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1);
		assertEquals(results[1], 2);
		assertEquals(results[2], 3);
		assertEquals(results[3], 3);
		assertEquals(results[4], 4);
		assertEquals(results[5], 5);
	}

	@Test
	public void toTechnicalPrice_long配列指定() {
		final long[] price = new long[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toTechnicalPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1L);
		assertEquals(results[1], 2L);
		assertEquals(results[2], 3L);
		assertEquals(results[3], 3L);
		assertEquals(results[4], 4L);
		assertEquals(results[5], 5L);
	}

	@Test
	public void toTechnicalPrice_float配列指定() {
		final float[] price = new float[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toTechnicalPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1F);
		assertEquals(results[1], 2F);
		assertEquals(results[2], 3F);
		assertEquals(results[3], 3F);
		assertEquals(results[4], 4F);
		assertEquals(results[5], 5F);
	}

	@Test
	public void toTechnicalPrice_double配列指定() {
		final double[] price = new double[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toTechnicalPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1D);
		assertEquals(results[1], 2D);
		assertEquals(results[2], 3D);
		assertEquals(results[3], 3D);
		assertEquals(results[4], 4D);
		assertEquals(results[5], 5D);
	}

	@Test
	public void toTechnicalPrice_Number配列指定() {
		final Number[] price = new Number[]{ 1D,2D,3D,null,4D,5D };
		final Number[] results = ArrayDataConverter.toTechnicalPrice(price);
		assertEquals(results.length, price.length);
		assertEquals(results[0], 1D);
		assertEquals(results[1], 2D);
		assertEquals(results[2], 3D);
		assertEquals(results[3], 3D);
		assertEquals(results[4], 4D);
		assertEquals(results[5], 5D);
	}

	@Test
	public void toTechnicalVolume_int配列指定() {
		final int[] volume = new int[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toTechnicalVolume(volume);
		assertEquals(results.length, volume.length);
		assertEquals(results[0], 1);
		assertEquals(results[1], 2);
		assertEquals(results[2], 3);
		assertEquals(results[3], 0);
		assertEquals(results[4], 4);
		assertEquals(results[5], 5);
	}

	@Test
	public void toTechnicalVolume_long配列指定() {
		final long[] volume = new long[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toTechnicalVolume(volume);
		assertEquals(results.length, volume.length);
		assertEquals(results[0], 1L);
		assertEquals(results[1], 2L);
		assertEquals(results[2], 3L);
		assertEquals(results[3], 0L);
		assertEquals(results[4], 4L);
		assertEquals(results[5], 5L);
	}

	@Test
	public void toTechnicalVolume_float配列指定() {
		final float[] volume = new float[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toTechnicalVolume(volume);
		assertEquals(results.length, volume.length);
		assertEquals(results[0], 1F);
		assertEquals(results[1], 2F);
		assertEquals(results[2], 3F);
		assertEquals(results[3], 0F);
		assertEquals(results[4], 4F);
		assertEquals(results[5], 5F);
	}

	@Test
	public void toTechnicalVolume_double配列指定() {
		final double[] volume = new double[]{ 1,2,3,0,4,5 };
		final Number[] results = ArrayDataConverter.toTechnicalVolume(volume);
		assertEquals(results.length, volume.length);
		assertEquals(results[0], 1D);
		assertEquals(results[1], 2D);
		assertEquals(results[2], 3D);
		assertEquals(results[3], 0D);
		assertEquals(results[4], 4D);
		assertEquals(results[5], 5D);
	}

	@Test
	public void toTechnicalVolume_Number配列指定() {
		final Number[] volume = new Number[]{ 1D,2D,3D,null,4D,5D };
		final Number[] results = ArrayDataConverter.toTechnicalVolume(volume);
		assertEquals(results.length, volume.length);
		assertEquals(results[0], 1D);
		assertEquals(results[1], 2D);
		assertEquals(results[2], 3D);
		assertEquals(results[3], 0);
		assertEquals(results[4], 4D);
		assertEquals(results[5], 5D);
	}

}
