package jp.sourceforge.orangesignal.ta.candle.generator;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;
import jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSetting.Range;

import org.junit.Test;

public class CandlestickGeneratorSettingTest {

	@Test
	public void コンストラクタ() {
		final CandlestickGeneratorSetting s = new CandlestickGeneratorSetting(Range.BODY, 1.1D);
		assertEquals(s.range, Range.BODY);
		assertThat(s.factor, is(1.1D));
	}

	@Test(expected = NullPointerException.class)
	public void コンストラクタ_nullRange() {
		new CandlestickGeneratorSetting(null, 1.0);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_factor不正() {
		new CandlestickGeneratorSetting(Range.BODY, -1.0);
	}

}
