/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.order;

import java.util.Date;

/**
 * 翌日に指値注文する注文情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public final class NextLimitOrder extends AbstractOrder implements LimitOrder {

	private static final long serialVersionUID = -8174223420737843070L;

	/**
	 * コンストラクタです。
	 * 
	 * @param symbol シンボル
	 * @param label ラベル
	 * @param date 注文日時
	 * @param limit 指値
	 * @param quantity 数量
	 * @param findId 決済注文ID
	 * @param findLabel 決済注文ラベル
	 * @throws NullPointerException パラメーターに <code>null</code> を指定した場合
	 * @throws IllegalArgumentException 指値に <code>0</code> 以下の値を指定した場合
	 */
	public NextLimitOrder(
			final String symbol,
			final String label,
			final Date date,
			final double limit,
			final int quantity,
			final Integer findId,
			final String findLabel)
	{
		super(symbol, label, date, quantity, findId, findLabel);

		if (limit <= 0)
			throw new IllegalArgumentException();
		this.limitPrice = limit;
	}

	/**
	 * 実装は必ず {@link OrderType#LIMIT} を返します。
	 */
	@Override public final OrderType getOrderType() { return OrderType.LIMIT; }

	/**
	 * この実装は必ず <code>1</code> を返します。
	 */
	@Override public int getPeriod() { return 1; }

	/**
	 * 指値を保持します。
	 */
	private double limitPrice;

	@Override public double getLimitPrice() { return limitPrice; }

}
