/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.trading.strategy.StrategyStatus.NEXT;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;

/**
 * 価格と短期移動平均、中期移動平均、長期移動平均の交差で買いポジションを建てるストラテジーを提供します。
 */
public class MovingAverage3LineCrossLongEntry extends MovingAverage3LineCross {

	@Override
	public StrategyStatus process() {
		final int i = getCurrentDataIndex();
		if (condition(i) && !condition(i - 1))
			buy(getStrategyName());
		return NEXT;
	}

	protected boolean condition(int i) {
		if (prices[i] != null && ma_fast[i] != null && ma_mid[i] != null && ma_slow[i] != null) {
			final double price = prices[i].doubleValue();
			final double fast  = ma_fast[i].doubleValue();
			final double mid   = ma_mid[i].doubleValue();
			final double slow  = ma_slow[i].doubleValue();
			return (price > fast && fast > mid && mid > slow);			
		}
		return false;
	}

}
