package jp.sourceforge.orangesignal.trading.order;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.apache.commons.lang.SerializationUtils;
import org.junit.Test;

public class NextLimitOrderTest {

	@Test
	public void testNextLimitOrder() {
		new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		assertTrue(true);
	}

	@Test(expected = NullPointerException.class)
	public void testNextLimitOrderNullPointerException() {
		new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", null, 10000, 100, null, null);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNextLimitOrderIllegalArgumentException() {
		new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 0, 100, null, null);
	}

	@Test
	public void testGetPeriod() {
		final Order order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		assertEquals(order.getPeriod(), 1);
	}

	@Test
	public void testGetLimitPrice() {
		final LimitOrder order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		assertTrue(order.getLimitPrice() == 10000D);
	}

	@Test
	public void testGetOrderType() {
		final Order order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		assertEquals(order.getOrderType(), OrderType.LIMIT);
	}

	@Test
	public void testGetSymbol() {
		final Order order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		assertEquals(order.getSymbol(), "n225");
	}

	@Test
	public void testGetLabel() {
		final Order order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		assertEquals(order.getLabel(), "MovingAverage2LineCrossLongEntry");
	}

	@Test
	public void testGetDate() {
		final Date now = new Date();
		final Order order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", now, 10000, 100, null, null);
		assertEquals(order.getDate(), now);
	}

	@Test
	public void testGetQuantity() {
		final Order order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		assertEquals(order.getQuantity(), 100);
	}

	@Test
	public void testGetFindId() {
		final Order order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, 12, null);
		assertEquals(order.getFindId(), Integer.valueOf(12));
	}

	@Test
	public void testSetFindId() {
		final NextLimitOrder order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		order.setFindId(50);
		assertEquals(order.getFindId(), Integer.valueOf(50));
	}

	@Test
	public void testGetFindLabel() {
		final Order order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, "L1");
		assertEquals(order.getFindLabel(), "L1");
	}

	@Test
	public void testSetFindLabel() {
		final NextLimitOrder order = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null);
		order.setFindLabel("L1");
		assertEquals(order.getFindLabel(), "L1");
	}

	@SuppressWarnings("deprecation")
	@Test
	public void testCompareTo() {
		final Order order1 = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(2009, 6, 10), 10000, 100, null, null);
		final Order order2 = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(2009, 6, 11), 10000, 100, null, null);
		final Order order3 = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(2009, 6, 9), 10000, 100, null, null);
		final Order order4 = new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(2009, 6, 10), 10000, 100, null, null);
		assertTrue(order1.compareTo(order2) < 0);
		assertTrue(order1.compareTo(order3) > 0);
		assertTrue(order1.compareTo(order4) == 0);
	}

	@Test
	public void testSerialization() {
		final byte[] bytes = SerializationUtils.serialize(new NextLimitOrder("n225", "MovingAverage2LineCrossLongEntry", new Date(), 10000, 100, null, null));
		assertTrue(true);
		final Object obj = SerializationUtils.deserialize(bytes);
		assertTrue(obj instanceof NextLimitOrder);
	}

}
