/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.dataset;

import java.util.Date;

/**
 * 信用取引データのインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface MarginData {

	/**
	 * <p>日時を返します。</p>
	 * 
	 * @return 日時
	 */
	public Date getDate();

	/**
	 * 信用売残を返します。信用売残がない場合は <code>null</code> を返します。
	 * 
	 * @return 信用売残。または <code>null</code>
	 */
	public Number getSold();

	/**
	 * 信用買残を返します。信用買残がない場合は <code>null</code> を返します。
	 * 
	 * @return 信用買残。または <code>null</code>
	 */
	public Number getBought();

}
