/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.order;

import java.util.Date;

import jp.sourceforge.orangesignal.ta.result.FourPrice;

/**
 * <p>当日の終値で成行注文する注文情報を提供します。</p>
 * 
 * @author 杉澤 浩二
 */
public final class CurrentCloseOrder extends AbstractMarketOrder {

	private static final long serialVersionUID = 3180812283682520806L;

	/**
	 * コンストラクタです。
	 * 
	 * @param symbol シンボル
	 * @param label ラベル
	 * @param date 注文日時
	 * @param quantity 数量
	 * @param findId 決済注文ID
	 * @param findLabel 決済注文ラベル
	 * @throws NullPointerException パラメーターに <code>null</code> を指定した場合
	 */
	public CurrentCloseOrder(
			final String symbol,
			final String label,
			final Date date,
			final int quantity,
			final Integer findId,
			final String findLabel)
	{
		super(symbol, label, date, quantity, findId, findLabel);
	}

	/**
	 * この実装は必ず <code>0</code> を返します。
	 */
	@Override public int getPeriod() { return 0; }

	/**
	 * この実装は必ず {@link FourPrice#CLOSE} を返します。
	 */
	@Override public FourPrice getPriceType() { return FourPrice.CLOSE; }

}
