/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.trading.order.OrderTiming.NEXT_STOP;

public class MomentumLongEntry extends Momentum {

	protected Number[] high;

	@Override
	public void prepare() {
		super.prepare();
		this.high = getDataset().getHigh();
	}

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (high[i] != null && mom1[i] != null && mom2[i] != null && mom1[i].doubleValue() > 0 && mom2[i].doubleValue() > 0)
			buy(getStrategyName(), NEXT_STOP, high[i].doubleValue() + 1);
		return false;
	}

	@Override
	public void close() {
		this.high = null;
		super.close();
	}

}
