/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.trading.order.OrderTiming.NEXT_STOP;

public class MomentumShortEntry extends Momentum {

	protected Number[] low;

	@Override
	public void prepare() {
		super.prepare();
		this.low = getDataset().getLow();
	}

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (low[i] != null && mom1[i] != null && mom2[i] != null && mom1[i].doubleValue() < 0 && mom2[i].doubleValue() < 0)
			sellShort(getStrategyName(), NEXT_STOP, low[i].doubleValue() - 1);
		return false;
	}

	@Override
	public void close() {
		this.low = null;
		super.close();
	}

}
