/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.CrossSignal.DEAD_CROSS;

/**
 * 価格と移動平均のデッドクロスで売りポジションを建てるストラテジーを提供します。
 */
public class MovingAverageCrossShortEntry extends MovingAverageCross {

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (cross[i] != null && cross[i] == DEAD_CROSS)
			sellShort(getStrategyName());
		return false;
	}

}
