<#setting locale="ja_JP">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Language" content="ja" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="imagetoolbar" content="no" />
<title>${symbol} ${symbolName}: トレードリスト</title>
<link rel="stylesheet" type="text/css" href="style.css" />
</head>
<body>
<div>

<div id="header">
<h1><a href="index.html">Strategy Performance Report</a></h1>
<h2>OrangeSignal.com Backtester</h2>
</div> 

<div class="right">
<h2>${symbol} ${symbolName}</h2>
<table>
<tbody>
<col align="left"><col align="right">
<tr><td>範囲</td><td><#if stats.startDate?exists>${stats.startDate?string("yyyy/MM/dd")}</#if> - <#if stats.endDate?exists>${stats.endDate?string("yyyy/MM/dd")}</#if></td></tr>
<tr><td>期間</td><td>${stats.period?string("0")}</td></tr>
<tr><td>初期資金</td><td>${stats.initialCapital?string("#,##0")}</td></tr>
<tr><td>最終資金</td><td>${stats.endingCapital?string("#,##0")}</td></tr>
</tbody>
</table>

<h2>トレードリスト</h2>
<table>
<thead>
<tr><th>トレード</th><th>オーダー</th><th>種類</th><th>ラベル</th><th>日時</th><th>価格</th><th>数量</th><th>手数料</th><th>保有期間</th><th colspan="2">損益</th><th colspan="2">累計損益</th><th colspan="2">ドローダウン</th><th>残高</th></tr>
</thead>
<tbody>
<col align="center"><col align="center"><col align="center"><col align="left"><col align="center"><col align="right"><col align="right"><col align="right"><col align="center"><col align="right"><col align="right"><col align="right"><col align="right"><col align="right"><col align="right"><col align="right">
<#list trade_list as t>
<tr><td rowspan="2">${t_index + 1}</td><td>${t_index * 2 + 1}</td><td rowspan="2">${t.type}</td><td>${t.entryLabel}</td><td>${t.entryDate?string("yyyy/MM/dd")}</td><td>${t.entryPrice?string("#,##0")}</td><td>${t.entryQuantity?string("#,##0")}</td><td>${t.entryCommission?string("#,##0.00")}</td><td rowspan="2">${t.hold}</td>
<td rowspan="2"><#if t.netProfit < 0><span class="loss"><#else><span></#if>${t.netProfit?string("#,##0.00")}</span></td>
<td rowspan="2"><#if t.percentNetProfit < 0><span class="loss"><#else><span></#if>(${t.percentNetProfit?string("0.00%")})</span></td>
<td rowspan="2"><#if t.cumNetProfit < 0><span class="loss"><#else><span></#if>${t.cumNetProfit?string("#,##0.00")}</span></td>
<td rowspan="2"><#if t.percentCumNetProfit < 0><span class="loss"><#else><span></#if>(${t.percentCumNetProfit?string("0.00%")})</span></td>
<td rowspan="2"><#if t.drawdown < 0><span class="loss"><#else><span></#if>${t.drawdown?string("#,##0.00")}</span></td>
<td rowspan="2"><#if t.percentDrawdown < 0><span class="loss"><#else><span></#if>(${t.percentDrawdown?string("0.00%")})</span></td>
<td rowspan="2"><#if t.equity < 0><span class="loss"><#else><span></#if>${t.equity?string("#,##0")}<span></td></tr>
<tr><td>${t_index * 2 + 2}</td><td>${t.exitLabel}</td><td>${t.exitDate?string("yyyy/MM/dd")}</td><td>${t.exitPrice?string("#,##0")}</td><td>${t.exitQuantity?string("#,##0")}</td><td>${t.exitCommission?string("#,##0.00")}</td></tr>
</#list>
</tbody>
</table>
</div>

<div style="clear: both;"> </div>
</div>

<div class="footer">
作成日時: ${timestamp?string("yyyy/MM/dd HH:mm:ss")}<br />
&copy; 2006-2009 <a href="http://www.orangesignal.com/">OrangeSignal.com</a>
</div>
</body>
</html>