package jp.sourceforge.orangesignal.trading;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.apache.commons.lang.SerializationUtils;
import org.junit.Test;

public class VirtualAccountTest {

	@Test
	public void testVirtualAccount() {
		new VirtualAccount();
		assertTrue(true);
	}

	@Test
	public void testVirtualAccountDouble() {
		final VirtualAccount account = new VirtualAccount(1000000D);
		assertTrue(account.getCash() == 1000000D);
	}

	@Test
	public void testVirtualAccountDoubleBoolean() {
		final VirtualAccount account1 = new VirtualAccount(1000000D, true);
		assertTrue(account1.getCash() == 1000000D);
		assertTrue(account1.isUnlimited());

		final VirtualAccount account2 = new VirtualAccount(10000000D, false);
		assertTrue(account2.getCash() == 10000000D);
		assertFalse(account2.isUnlimited());
	}

	@Test
	public void testGetCash() {
		final VirtualAccount account = new VirtualAccount();
		assertTrue(account.getCash() == 0);
	}

	@Test
	public void testSetCash() {
		final VirtualAccount account = new VirtualAccount();
		account.setCash(23456);
		assertTrue(account.getCash() == 23456);
	}

	@Test
	public void testGetInterestRate() {
		final VirtualAccount account = new VirtualAccount();
		assertTrue(account.getInterestRate() == 0);
	}

	@Test
	public void testIsUnlimited() {
		final VirtualAccount account = new VirtualAccount();
		assertTrue(account.isUnlimited());
	}

	@Test
	public void testDeposit() {
		final VirtualAccount account = new VirtualAccount(12345D);
		account.deposit(67890D);
		assertTrue(account.getCash() == (12345D + 67890D));
	}

	@Test(expected = IllegalArgumentException.class)
	public void testDepositIllegalArgumentException() {
		final VirtualAccount account = new VirtualAccount();
		account.deposit(-10000);
	}

	@Test
	public void testWithdraw() {
		final VirtualAccount account1 = new VirtualAccount(5000D);
		final boolean b1 = account1.withdraw(10000D);
		assertTrue(b1);
		assertTrue(account1.getCash() == -5000D);

		final VirtualAccount account2 = new VirtualAccount(5000D, false);
		final boolean b2 = account2.withdraw(10000D);
		assertFalse(b2);
		assertTrue(account2.getCash() == 5000D);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testWithdrawIllegalArgumentException() {
		final VirtualAccount account = new VirtualAccount();
		account.withdraw(-10000);
	}

	@Test
	public void testSerialization() {
		final byte[] bytes = SerializationUtils.serialize(new VirtualAccount());
		assertTrue(true);
		final Object obj = SerializationUtils.deserialize(bytes);
		assertTrue(obj instanceof VirtualAccount);
	}

}
