/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart;

import java.awt.Color;

/**
 * 色の定数定義クラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public class ChartColor extends Color {

	private static final long serialVersionUID = 6102508388709941196L;

	//-------------------------------------------------------------------------
	// グレイ(灰)

	/**
	 * ベリーライトグレイを表します。
	 */
	public static final Color VERY_LIGHT_GRAY		= new Color(0xE0, 0xE0, 0xE0);

	//-------------------------------------------------------------------------
	// 赤

	/**
	 * 薄い赤を表します。
	 */
	public static final Color VERY_VERY_LIGHT_RED	= new Color(0xFF, 0xE0, 0xE0);

	/**
	 * 極明るい赤を表します。
	 */
	public static final Color VERY_LIGHT_RED		= new Color(0xFF, 0x80, 0x80);

	/**
	 * 明るい赤を表します。
	 */
	public static final Color LIGHT_RED				= new Color(0xFF, 0x40, 0x40);

	/**
	 * 暗い赤を表します。
	 */
	public static final Color DARK_RED				= new Color(0xc0, 0x00, 0x00);

	/**
	 * 極暗い赤を表します。
	 */
	public static final Color VERY_DARK_RED			= new Color(0x80, 0x00, 0x00);

	//-------------------------------------------------------------------------
	// 黄

	/**
	 * 極明るい黄を表します。
	 */
	public static final Color VERY_LIGHT_YELLOW		= new Color(0xFF, 0xFF, 0x80);

	/**
	 * 明るい黄を表します。
	 */
	public static final Color LIGHT_YELLOW			= new Color(0xFF, 0xFF, 0x40);

	/**
	 * 暗い黄を表します。
	 */
	public static final Color DARK_YELLOW			= new Color(0xC0, 0xC0, 0x00);

	/**
	 * 極暗い黄を表します。
	 */
	public static final Color VERY_DARK_YELLOW		= new Color(0x80, 0x80, 0x00);

	//-------------------------------------------------------------------------
	// 緑

	/**
	 * 極明るい緑を表します。
	 */
	public static final Color VERY_LIGHT_GREEN		= new Color(0x80, 0xFF, 0x80);

	/**
	 * 明るい緑を表します。
	 */
	public static final Color LIGHT_GREEN			= new Color(0x40, 0xFF, 0x40);

	/**
	 * 暗い緑を表します。
	 */
	public static final Color DARK_GREEN			= new Color(0x00, 0xC0, 0x00);

	/**
	 * 極暗い緑を表します。
	 */
	public static final Color VERY_DARK_GREEN		= new Color(0x00, 0x80, 0x00);

	//-------------------------------------------------------------------------
	// マゼンタ

	/**
	 * 極明るいマゼンタを表します。
	 */
	public static final Color VERY_LIGHT_MAGENTA	= new Color(0xFF, 0x80, 0xFF);

	/**
	 * 明るいマゼンタを表します。
	 */
	public static final Color LIGHT_MAGENTA			= new Color(0xFF, 0x40, 0xFF);

	/**
	 * 暗いマゼンタを表します。
	 */
	public static final Color DARK_MAGENTA			= new Color(0xC0, 0x00, 0xC0);

	/**
	 * 極暗いマゼンタを表します。
	 */
	public static final Color VERY_DARK_MAGENTA		= new Color(0x80, 0x00, 0x80);

	//-------------------------------------------------------------------------
	// シアン

	/**
	 * 極明るいシアンを表します。
	 */
	public static final Color VERY_LIGHT_CYAN		= new Color(0x80, 0xFF, 0xFF);

	/**
	 * 明るいシアンを表します。
	 */
	public static final Color LIGHT_CYAN			= new Color(0x40, 0xFF, 0xFF);

	/**
	 * 暗いシアンを表します。
	 */
	public static final Color DARK_CYAN				= new Color(0x00, 0xC0, 0xC0);

	/**
	 * 極暗いシアンを表します。
	 */
	public static final Color VERY_DARK_CYAN		= new Color(0x00, 0x80, 0x80);

	//-------------------------------------------------------------------------
	// 青

	/**
	 * 薄い青を表します。
	 */
	public static final Color VERY_VERY_LIGHT_BLUE	= new Color(0xE0, 0xE0, 0xFF);

	/**
	 * 極明るい青を表します。
	 */
	public static final Color VERY_LIGHT_BLUE		= new Color(0x80, 0x80, 0xFF);

	/**
	 * 明るい青を表します。
	 */
	public static final Color LIGHT_BLUE			= new Color(0x40, 0x40, 0xFF);

	/**
	 * 暗い青を表します。
	 */
	public static final Color DARK_BLUE				= new Color(0x00, 0x00, 0xC0);

	/**
	 * 極暗い青を表します。
	 */
	public static final Color VERY_DARK_BLUE		= new Color(0x00, 0x00, 0x80);

	//-------------------------------------------------------------------------
	// その他

	/**
	 * スカイブルーを表します。
	 */
	public static final Color SKY_BLUE				= new Color(0x66, 0x99, 0xFF);

	/**
	 * 暗いオレンジを表します。
	 */
	public static final Color DARK_ORANGE			= new Color(0xFF, 0x99, 0x00);

	//-------------------------------------------------------------------------
	// コンストラクタ

	/**
	 * 範囲 (0 ～ 255) の指定された赤、緑、青の値を使って、不透明な sRGB カラーを生成します。
	 * 
	 * @param r 赤色成分
	 * @param g 緑色成分
	 * @param b 青色成分
	 */
	public ChartColor(final int r, final int g, final int b) {
		super(r, g, b);
	}

}
