/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart;

/**
 * なんらかの入出力例外の発生を通知するシグナルを発生させます。
 * このクラスは、入出力処理の失敗、または割り込みの発生によって生成される例外の汎用クラスです。
 * 
 * @author 杉澤 浩二
 * @since 2.2
 */
public class RuntimeIOException extends RuntimeException {

	private static final long serialVersionUID = -2124610306176474403L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public RuntimeIOException() {
		super();
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 */
	public RuntimeIOException(final String message) {
		super(message);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 * @param cause 原因
	 */
	public RuntimeIOException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param cause 原因
	 */
	public RuntimeIOException(final Throwable cause) {
		super(cause);
	}

}
