/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.axis;

import jp.sf.orangesignal.chart.util.StringManager;
import jp.sf.orangesignal.ta.util.Assert;

/**
 * 数値の目盛り単位情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class NumberTickUnit implements Comparable<NumberTickUnit> {

	/**
	 * サイズを保持します。
	 */
	private double size;

	/**
	 * コンストラクタです。
	 * 
	 * @param size サイズ
	 */
	public NumberTickUnit(final double size) {
		this.size = size;
	}

	/**
	 * サイズを返します。
	 * 
	 * @return サイズ
	 */
	public double getSize() { return size; }

	/**
	 * 値に対する文字列表現を返します。
	 * 
	 * @param value 値
	 * @return 文字列
	 */
	public String valueToString(final double value) {
		return String.format(StringManager.getString("format.number", 0), value);
	}

	@Override
	public int compareTo(final NumberTickUnit o) {
		Assert.notNull(o, "NumberTickUnit must not be null");
		if (this.size > o.size)
			return 1;
		if (this.size < o.size)
			return -1;
		return 0;
	}

}
