/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.axis;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import org.junit.Test;

/**
 * {@link Range} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class RangeTest {

	@Test
	public void testRange() {
		new Range();
	}

	@Test
	public void testRangeDoubleDouble() {
		new Range(1D, 5D);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testRangeDoubleDoubleIllegalArgumentException() {
		new Range(2D, 1D);
	}

	@Test
	public void testGetLower() {
		final Range range = new Range(1D, 5D);
		assertThat(range.getLower(), is(1D));
	}

	@Test
	public void testGetUpper() {
		final Range range = new Range(1D, 5D);
		assertThat(range.getUpper(), is(5D));
	}

	@Test
	public void testGetLength() {
		final Range range = new Range(1D, 5D);
		assertThat(range.getLength(), is(4D));
	}

}
