/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

/**
 * データの変換に失敗した場合にスローする例外クラスを提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.1
 */
public class DataConvertException extends RuntimeException {

	private static final long serialVersionUID = 1821753102281486995L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public DataConvertException() {
		super();
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 */
	public DataConvertException(final String message) {
		super(message);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 * @param cause 原因
	 */
	public DataConvertException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param cause 原因
	 */
	public DataConvertException(final Throwable cause) {
		super(cause);
	}

}
