/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta;

import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;

import java.util.Date;

import org.junit.Test;

/**
 * {@link Step} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class StepTest {

	@Test
	public void testStep() {
		final Step step = new Step();
		// assert
		assertThat(step.openDate, nullValue());
		assertThat(step.highDate, nullValue());
		assertThat(step.lowDate, nullValue());
		assertThat(step.closeDate, nullValue());
		assertThat(step.open, is(0D));
		assertThat(step.high, is(0D));
		assertThat(step.low, is(0D));
		assertThat(step.close, is(0D));
		assertThat(step.period, is(0));
	}

	@Test
	public void testStepDateDouble() {
		final Date now = new Date();
		final double price = 100D;
		final Step step = new Step(now, price);
		// assert
		assertThat(step.openDate, is(now));
		assertThat(step.highDate, is(now));
		assertThat(step.lowDate, is(now));
		assertThat(step.closeDate, is(now));
		assertThat(step.open, is(price));
		assertThat(step.high, is(price));
		assertThat(step.low, is(price));
		assertThat(step.close, is(price));
		assertThat(step.period, is(1));
	}

	@Test
	public void testStepDateDoubleInt() {
		final Date now = new Date();
		final double price = 100D;
		final int period = 5;
		final Step step = new Step(now, price, period);
		// assert
		assertThat(step.openDate, is(now));
		assertThat(step.highDate, is(now));
		assertThat(step.lowDate, is(now));
		assertThat(step.closeDate, is(now));
		assertThat(step.open, is(price));
		assertThat(step.high, is(price));
		assertThat(step.low, is(price));
		assertThat(step.close, is(price));
		assertThat(step.period, is(period));
	}

}
