/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.candle.generator;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;

import java.util.List;

import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.ta.data.CsvPriceLoader;
import jp.sf.orangesignal.ta.data.model.Price;

import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * {@link AnnotationCandlestickGenerator} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class AnnotationCandlestickGeneratorTest {

	private static List<Price> prices;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		final CsvPriceLoader loader = (CsvPriceLoader) new ClassPathXmlApplicationContext("applicationContext.xml").getBean("loader", CsvPriceLoader.class);
		prices = loader.load("n225");
	}

	@Test
	public void testAnnotationCandlestickGenerator() {
		new AnnotationCandlestickGenerator();
	}

	@Test
	public void testAnnotationCandlestickGeneratorCandlestickGeneratorSettings() {
		final CandlestickGeneratorSettings settings = new DefaultCandlestickGeneratorSettings();
		new AnnotationCandlestickGenerator(settings);
	}

	@Test
	public void testGenerateObject() {
	}

	@Test
	public void testGenerateObjectTrendProcessor() {
	}

	@Test
	public void testGenerateObjectTrendProcessorCandlestickGeneratorSettings() {
	}

	@Test
	public void testGenerateCollection() {
		final Candlestick[] candlestick = new AnnotationCandlestickGenerator().generate(prices, "date", AnnotationCandlestickGenerator.DEFAULT_PRICE_NAME_MAP);
		assertNotNull(candlestick);
		assertThat(candlestick.length, is(prices.size()));
	}

	@Test
	public void testGenerateCollectionTrendProcessor() {
	}

	@Test
	public void testGenerateCollectionTrendProcessorCandlestickGeneratorSettings() {
	}

	@Test
	public void testGenerateObjectArray() {
	}

	@Test
	public void testGenerateObjectArrayTrendProcessor() {
	}

	@Test
	public void testGenerateObjectArrayTrendProcessorCandlestickGeneratorSettings() {
	}

}
